Roue = {};

function Roue.prerequisitesPresent(specializations)
	return true;
end;

function Roue:load(xmlFile)
	self.changeSteer = SpecializationUtil.callSpecializationsFunction("changeSteer");
	self.changeWheel =0;
	self.lastValidChangeWheel = 0;
	self.init = false;
end;

function Roue:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)  
   if not resetVehicles then
       self.changeWheel = Utils.getNoNil(getXMLFloat(xmlFile, key.."#steermode"),0);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Roue:getSaveAttributesAndNodes(nodeIdent)
   local attributes = ' steermode="'..tonumber(self.changeWheel)..'"';
   return attributes, nil;
end;

function Roue:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Roue:keyEvent(unicode, sym, modifier, isDown)
end;

function Roue:update(dt)
	if not self.init and self.lastValidChangeWheel == 0 and self.wheels[1].realRotMinSpeed ~= nil then		
		self.init = true;
		local invert = 1;
		if self.invertedDrivingDirection then
			invert = -1;
		end;
		self.w1RotMin      = math.min( invert * self.wheels[1].rotMin, invert * self.wheels[1].rotMax );
		self.w1RotMax      = math.max( invert * self.wheels[1].rotMin, invert * self.wheels[1].rotMax );
		self.w1RotSpeed    = invert * self.wheels[1].rotSpeed;
		self.w1RotMinSpeed = math.min( invert * self.wheels[1].realRotMinSpeed, invert * self.wheels[1].realRotMaxSpeed );
		self.w1RotMaxSpeed = math.max( invert * self.wheels[1].realRotMinSpeed, invert * self.wheels[1].realRotMaxSpeed );
		self.w2RotMin      = math.min( invert * self.wheels[2].rotMin, invert * self.wheels[2].rotMax );
		self.w2RotMax      = math.max( invert * self.wheels[2].rotMin, invert * self.wheels[2].rotMax );
		self.w2RotSpeed    = invert * self.wheels[2].rotSpeed;
		self.w2RotMinSpeed = math.min( invert * self.wheels[2].realRotMinSpeed, invert * self.wheels[2].realRotMaxSpeed );
		self.w2RotMaxSpeed = math.max( invert * self.wheels[2].realRotMinSpeed, invert * self.wheels[2].realRotMaxSpeed );
		self.w3RotMin      = math.min( invert * self.wheels[3].rotMin, invert * self.wheels[3].rotMax );
		self.w3RotMax      = math.max( invert * self.wheels[3].rotMin, invert * self.wheels[3].rotMax );
		self.w3RotSpeed    = invert * self.wheels[3].rotSpeed;
		self.w3RotMinSpeed = math.min( invert * self.wheels[3].realRotMinSpeed, invert * self.wheels[3].realRotMaxSpeed );
		self.w3RotMaxSpeed = math.max( invert * self.wheels[3].realRotMinSpeed, invert * self.wheels[3].realRotMaxSpeed );
		self.w4RotMin      = math.min( invert * self.wheels[4].rotMin, invert * self.wheels[4].rotMax );
		self.w4RotMax      = math.max( invert * self.wheels[4].rotMin, invert * self.wheels[4].rotMax );
		self.w4RotSpeed    = invert * self.wheels[4].rotSpeed;
		self.w4RotMinSpeed = math.min( invert * self.wheels[4].realRotMinSpeed, invert * self.wheels[4].realRotMaxSpeed );
		self.w4RotMaxSpeed = math.max( invert * self.wheels[4].realRotMinSpeed, invert * self.wheels[4].realRotMaxSpeed );
		--print("Roue initialized for " .. self.name .. " values={" .. self.w1RotMin .." ,".. self.w1RotMax .." ,".. self.w1RotMaxSpeed .. "}");
	end;	
	if InputBinding.hasEvent(InputBinding.cw_for_xerion) and self:getIsActiveForInput() then
	   self.changeWheel = self.changeWheel +1 ;
	end; 
	if self.init and self.lastValidChangeWheel ~= self.changeWheel then
		if self.invertedDrivingDirection then
			if self.changeWheel == 1 then
				self:changeSteer(-1,-1,0,0,1.5)
			elseif self.changeWheel == 2 then
				self:changeSteer(0,0,-1,-1,1.5)
			elseif self.changeWheel == 3 then
				self:changeSteer(-1,-1,1,1,1)
			else
				self:changeSteer(-1,-1,-1,-1,1)
				self.changeWheel = 0;
			end;
		else
			if self.changeWheel == 1 then
				self:changeSteer(1,1,0,0,1.5)
			elseif self.changeWheel == 2 then
				self:changeSteer(0,0,1,1,1.5)
			elseif self.changeWheel == 3 then
				self:changeSteer(1,1,-1,-1,1)
			else
				self:changeSteer(1,1,1,1,1)
				self.changeWheel = 0;
			end;
		end;
		--print("Changed steering: values={" .. self.wheels[1].rotMin .." ,".. self.wheels[1].rotMax .." ,".. self.wheels[1].realRotMaxSpeed .. "}");
		self.lastValidChangeWheel = self.changeWheel;
	end;
end;

function Roue:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("cw_for_xerion"), InputBinding.cw_for_xerion); 
end;

function Roue:changeSteer(w1,w2,w3,w4,speed)
	self.wheels[1].rotMax           = math.max(self.w1RotMax      * w1,self.w1RotMin      * w1);
	self.wheels[1].rotMin           = math.min(self.w1RotMax      * w1,self.w1RotMin      * w1);
	self.wheels[1].rotSpeed         = self.w1RotSpeed    * w1 * speed;
	self.wheels[1].realRotMinSpeed  = math.min(self.w1RotMinSpeed * w1,self.w1RotMaxSpeed * w1) * speed;
	self.wheels[1].realRotMaxSpeed  = math.max(self.w1RotMinSpeed * w1,self.w1RotMaxSpeed * w1) * speed;
	self.wheels[2].rotMax           = math.max(self.w2RotMax      * w2,self.w2RotMin      * w2); 
	self.wheels[2].rotMin           = math.min(self.w2RotMax      * w2,self.w2RotMin      * w2); 
	self.wheels[2].rotSpeed         = self.w2RotSpeed    * w2 * speed; 
	self.wheels[2].realRotMinSpeed  = math.min(self.w2RotMinSpeed * w2,self.w2RotMaxSpeed * w2) * speed;
	self.wheels[2].realRotMaxSpeed  = math.max(self.w2RotMinSpeed * w2,self.w2RotMaxSpeed * w2) * speed;
	self.wheels[3].rotMax           = math.max(self.w3RotMax      * w3,self.w3RotMin      * w3); 
	self.wheels[3].rotMin           = math.min(self.w3RotMax      * w3,self.w3RotMin      * w3); 
	self.wheels[3].rotSpeed         = self.w3RotSpeed    * w3 * speed; 
	self.wheels[3].realRotMinSpeed  = math.min(self.w3RotMinSpeed * w3,self.w3RotMaxSpeed * w3) * speed;
	self.wheels[3].realRotMaxSpeed  = math.max(self.w3RotMinSpeed * w3,self.w3RotMaxSpeed * w3) * speed;
	self.wheels[4].rotMax           = math.max(self.w4RotMax      * w4,self.w4RotMin      * w4); 
	self.wheels[4].rotMin           = math.min(self.w4RotMax      * w4,self.w4RotMin      * w4); 
	self.wheels[4].rotSpeed         = self.w4RotSpeed    * w4 * speed; 
	self.wheels[4].realRotMinSpeed  = math.min(self.w4RotMinSpeed * w4,self.w4RotMaxSpeed * w4) * speed;
	self.wheels[4].realRotMaxSpeed  = math.max(self.w4RotMinSpeed * w4,self.w4RotMaxSpeed * w4) * speed;
end;

function Roue:delete()
end;