-- Fendt611LSA
-- Specialisation for the Fendt 611 LSA
--
-- by fruktor
-- www.eifok-team.de
-- 

Fendt611LSA = {};

function Fendt611LSA.initSpecialization()
	Vehicle.registerJointType("fendt611fl");
end;

function Fendt611LSA.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;


function Fendt611LSA:load(xmlFile)	

	self.trailerAttacherRotateNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherRotateNode#index") );
	
	
	--###
	self.hoses = {};
	local hose = getXMLString(xmlFile, string.format("vehicle.hoses.hose(%d)#mesh",0));
	local run = 0;
	while hose ~= nil do
		local e = {};
		e.mesh = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.hoses.hose(%d)#mesh",run)));
		e.ref  = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.hoses.hose(%d)#ref", run)));
		if e.ref == nil or e.mesh == nil then
			--print("Fendt611LSA:load() :: hose == nil "..tostring(run).."th entry" );
			break;
		end	

		setClipDistance(e.mesh, 450);
		
		link( getRootNode(), e.mesh );
		
		setTranslation( e.mesh, 0,0,0 );
		setRotation( e.mesh, 0,0,0 );
		
		table.insert(self.hoses, e);
		run = run + 1;
	end

		
	--###
	
	self.lastRotXArm1 = 0;
	self.lastRotXArm2 = 0;
	self.arm1 = {};
	self.arm1.idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontlader.hauptarm#index"));
	self.arm1.charset = getAnimCharacterSet(self.arm1.idx);
	self.arm1.clipIdx = getAnimClipIndex(self.arm1.charset, getXMLString(xmlFile, "vehicle.frontlader.hauptarm#clip"));	
	assignAnimTrackClip(self.arm1.charset, 0, self.arm1.clipIdx);
	setAnimTrackLoopState(self.arm1.charset, 0, false);
	self.arm1.duration = getAnimClipDuration(self.arm1.charset, self.arm1.clipIdx);	
	
	self.arm2 = {};
	self.arm2.idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontlader.schwinge#index"));
	self.arm2.charset = getAnimCharacterSet(self.arm2.idx);
	self.arm2.clipIdx = getAnimClipIndex(self.arm2.charset, getXMLString(xmlFile, "vehicle.frontlader.schwinge#clip"));	
	assignAnimTrackClip(self.arm2.charset, 0, self.arm2.clipIdx);
	setAnimTrackLoopState(self.arm2.charset, 0, false);
	self.arm2.duration = getAnimClipDuration(self.arm2.charset, self.arm2.clipIdx);	
	
	-- 
	local x1,y1,z1 = getRotation(self.movingTools[1].node);
	local prct = (x1 - self.movingTools[1].rotMin) / (self.movingTools[1].rotMax - self.movingTools[1].rotMin);
	self.lastRotXArm1 = x1;
	enableAnimTrack(self.arm1.charset, 0);
	setAnimTrackTime(self.arm1.charset, 0, prct*self.arm1.duration, true);
	disableAnimTrack(self.arm1.charset, 0);			

	-- local x2,y2,z2 = getRotation(self.movingTools[2].node);
	-- local prct = (x2 - self.movingTools[2].rotMin) / (self.movingTools[2].rotMax - self.movingTools[2].rotMin);
	-- self.lastRotXArm2 = x2;		
	-- enableAnimTrack(self.arm2.charset, 0);
	-- setAnimTrackTime(self.arm2.charset, 0, prct*self.arm2.duration, true);
	-- disableAnimTrack(self.arm2.charset, 0);			

	--#
    self.setIncreaseRpm = SpecializationUtil.callSpecializationsFunction("setIncreaseRpm");
    self.saveMinimumRpm = self.motor.minRpm;	
	
	--###
	-- for i,j in pairs(self.mc[2]) do
		-- local x,y,z = getTranslation(self.movingTools[j].node);
		-- self.movingTools[j].origPos = {x,y,z};		
	-- end;	

end;


function Fendt611LSA:postLoad(xmlFile)

end;


function Fendt611LSA:delete()
	for i,j in pairs(self.hoses) do
		if j.mesh ~= nil then
			delete(j.mesh);
		end;
	end;
end;

function Fendt611LSA:readStream(streamId, connection)
end;

function Fendt611LSA:writeStream(streamId, connection)	
end;

function Fendt611LSA:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fendt611LSA:keyEvent(unicode, sym, modifier, isDown)

end;

function Fendt611LSA:update(dt)
	
	--###
	if Vehicle.debugRendering then
	end;	
	
	-- if self:getIsActive() then
		-- if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			-- if InputBinding.hasEvent(InputBinding.RESET_MOVEABLE_SEAT_MC) then							-- 
				-- for i,j in pairs(self.mc[1]) do
					-- setTranslation(self.movingTools[j].node, unpack(self.movingTools[j].origPos));
					-- self.movingTools[j].curTrans = { unpack(self.movingTools[j].origPos) };
					-- Cylindered.setDirty(self, self.movingTools[j]);
				-- end;
			-- end;		
		-- end;
	-- end;
	
	--#
	-- if self:getIsActive() then
		-- if self.isMotorStarted ~= self.isMotorStarted_old or self.activeMC ~= self.activeMC_old then
			-- self.activeMC_old = self.activeMC;
			-- self.isMotorStarted_old = self.isMotorStarted;
			-- if not self.isMotorStarted then
				-- if self.activeMC == 1 then
					-- for k,l in pairs(self.mc[self.activeMC]) do 
						-- self.movingTools[l].rotSpeed = nil;
						-- self.movingTools[l].transSpeed = nil;
					-- end;								
				-- end;
			-- else
				-- if self.activeMC == 1 then
					-- for k,l in pairs(self.mc[self.activeMC]) do 
						-- self.movingTools[l].rotSpeed = self.movingTools[l].rotSpeedBackup;
						-- self.movingTools[l].transSpeed = self.movingTools[l].transSpeedBackup;
					-- end;								
				-- end;
			-- end;
		-- end;
	-- end;
	
	
	if self.isClient then
	
		if self.checkTrailerAttacherRot == true then 
			if self.attacherJoints[1].jointIndex ~= 0 or
				self.attacherJoints[1].jointIndex ~= 0 then
				setRotation(self.trailerAttacherRotateNode, 0, Utils.degToRad(-180), 0);
			else
				setRotation(self.trailerAttacherRotateNode, 0, 0, 0);
			end;	
			checkTrailerAttacherRot = false;
		end;	
		
		--###
		if self:getIsActive() then
			local rpmInc = 0;
			
			local x1,y1,z1 = getRotation(self.movingTools[1].node);
			if x1 ~= self.lastRotXArm1 then
				local prct = (x1 - self.movingTools[1].rotMin) / (self.movingTools[1].rotMax - self.movingTools[1].rotMin);
				self.lastRotXArm1 = x1;
				enableAnimTrack(self.arm1.charset, 0);
				setAnimTrackTime(self.arm1.charset, 0, prct*self.arm1.duration, true);
				disableAnimTrack(self.arm1.charset, 0);	
				rpmInc = rpmInc + 180;
			end
			-- local x2,y2,z2 = getRotation(self.movingTools[2].node);
			-- --local x3,y3,z3 = getRotation(getParent(self.movingTools[2].node));
			-- --local t2 = (x2 - x3);
			-- if x2 ~= self.lastRotXArm2 then
				-- local prct = (x2 - self.movingTools[2].rotMin) / (self.movingTools[2].rotMax - self.movingTools[2].rotMin);
				-- --local prct = (t2) / (self.movingTools[2].rotMax - self.movingTools[2].rotMin);
				-- self.lastRotXArm2 = x2;		
				-- enableAnimTrack(self.arm2.charset, 0);
				-- setAnimTrackTime(self.arm2.charset, 0, prct*self.arm2.duration, true);
				-- disableAnimTrack(self.arm2.charset, 0);			
				-- rpmInc = rpmInc + 110;
			-- end	
			
			if rpmInc ~= 0 then
				self:setIncreaseRpm(dt, rpmInc, true);
			else
				self:setIncreaseRpm(dt, rpmInc, false);
			end;
		end
		
	end;
	
	--#
	--[[
	if self:getIsActive() then
		if self.isServer then
			if not self:getIsHired() and self.isMotorStarted then
				if self.tmpFuel == nil then
					self.tmpFuel = 0;
				end;
				if self.tmpFuel ~= self.fuelFillLevel then
					print("self.fuelFillLevel-self.tmpFuel="..self.fuelFillLevel-self.tmpFuel);
					self.tmpFuel = self.fuelFillLevel;
				end;			
			end;
		end;
	end;
	]]--
end;

function Fendt611LSA:updateTick(dt)
end;

function Fendt611LSA:draw()
	-- g_currentMission:addHelpButtonText(g_i18n:getText("RESET_MOVEABLE_SEAT_MC"), InputBinding.RESET_MOVEABLE_SEAT_MC);
end;

function Fendt611LSA:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Fendt611LSA:getSaveAttributesAndNodes(nodeIdent)
end;

function Fendt611LSA:attachImplement(implement)	
	self.checkTrailerAttacherRot = true;
end;

function Fendt611LSA:detachImplement(implementIndex)
	self.checkTrailerAttacherRot = true;

end;

function Fendt611LSA:setIncreaseRpm(dt, increase, isActive)

	if self.saveMinimumRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-(dt*2), -increase);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+(dt*5), self.saveMinimumRpm);
			end;
		else
			self.motor.minRpm = self.saveMinimumRpm;
		end;
		if self.isMotorStarted then
			local fuelUsed = 0.00000004*math.abs(self.motor.minRpm);
			--print("fuelUsed="..fuelUsed);
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;
