--
-- GMLMap
--

GMLMap = {}

local GMLMap_mt = Class(GMLMap, Mission00);


function GMLMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = GMLMap_mt;
    end;
    local self = GMLMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function GMLMap:delete()
    GMLMap:superClass().delete(self);
end;

function GMLMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function GMLMap:loadMap01Finished(node, arguments)

	self.terrainDetailAngleNumChannels = 8; -- replace with the desired number of channels
	
	self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("GMLMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -31.9, -276.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -527.3, -826.1, iconSize, iconSize * (4 / 3), false, false, false, 0, true);    

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -127.9, -321.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
 
    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), -35, -26, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -101, -93, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 296.8, -7.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -47.8, -272.4, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), -97.5, 623.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    GMLMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function GMLMap:onStartMission()
    GMLMap:superClass().onStartMission(self);
end;

function GMLMap:mouseEvent(posX, posY, isDown, isUp, button)
    GMLMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function GMLMap:keyEvent(unicode, sym, modifier, isDown)
    GMLMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function GMLMap:update(dt)
    GMLMap:superClass().update(self, dt);
end;

function GMLMap:draw()
    GMLMap:superClass().draw(self);
end;