-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- edit ls-for-ever, "unntige" Funktionen rausgelscht

Fendt310Animations = {};

function Fendt310Animations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Fendt310Animations:load(xmlFile)
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	self.blinkerLeuchte1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.BlinkerLeuchten#leuchte1"));
	self.blinkerLeuchte2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Fendt310Animations.BlinkerLeuchten#leuchte2"));
	self.hasAttachedTrailers = 0;
	setVisibility(self.blinkerLeuchte1, false);
	setVisibility(self.blinkerLeuchte2, false);
end;
function Fendt310Animations:delete()
end;
function Fendt310Animations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Fendt310Animations:keyEvent(unicode, sym, modifier, isDown)
end;

function Fendt310Animations:updateTick(dt)
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.lastFillDelta ~= nil then -- "catch" all trailers 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			elseif self.attachedImplements[i].object.isSprayerFilling ~= nil and self.attachedImplements[i].object.wheels[1] ~= nil then -- "catch" manure and dung spreader with wheels --> "trailers", too
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then -- maybe the trailer has also attached a trailer.. 
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.lastFillDelta ~= nil then -- "catch" attached trailer at the trailer here
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
		if self.hasAttachedTrailers == 0 then
			setVisibility(self.blinkerLeuchte1, false);
			setVisibility(self.blinkerLeuchte2, false);
		elseif self.hasAttachedTrailers == 1 then
			setVisibility(self.blinkerLeuchte1, true);
			setVisibility(self.blinkerLeuchte2, false);			
		elseif self.hasAttachedTrailers == 2 then
			setVisibility(self.blinkerLeuchte1, true);
			setVisibility(self.blinkerLeuchte2, true);			
		end;
	end;
end;
function Fendt310Animations:update(dt)
end;
function Fendt310Animations:draw()
end;
function Fendt310Animations:onEnter()
end;
function Fendt310Animations:onLeave()
end;

