-- LUA fr realistisches Partikelsystem am Auspuff
-- basiert im Grundsatz dynamicExhaustSystem.lua von Face bzw. dessen Shader ausm dem Kirovets K 700A
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net


realExhaustParticleSystem = {};

function realExhaustParticleSystem.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function realExhaustParticleSystem:load(xmlFile)
	self.reps = {};
	
	self.reps.minAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#minAlpha"), 0.1);
	self.reps.maxAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#maxAlpha"), 1);
	self.reps.parameter = getXMLString(xmlFile, "vehicle.realExhaustParticleSystem#parameter");

	self.reps.realAlpha = self.reps.minAlpha;
	
	setShaderParameter(self.exhaustParticleSystems[1].shape, self.reps.parameter, 0, 0, 0, self.reps.realAlpha, false);
	
end;

function realExhaustParticleSystem:delete()
end;

function realExhaustParticleSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

function realExhaustParticleSystem:keyEvent(unicode, sym, modifier, isDown)
end;

function realExhaustParticleSystem:update(dt)
	
	if self:getIsActiveForInput() or self.isServer and self:getIsActive() then			
		
		-- alpha function of engine load on moreRealistic vehicles
		local alpha = 1;
		if self.isServer then
			alpha = ((self.reps.maxAlpha-self.reps.minAlpha) * self.realMotorLoadS)+self.reps.minAlpha;
		else
			alpha = ((self.reps.maxAlpha-self.reps.minAlpha) * self.realSoundMotorFx)+self.reps.minAlpha;
		end;
		if math.abs(self.reps.realAlpha - alpha) > 0.01 then			
			setShaderParameter(self.exhaustParticleSystems[1].shape, self.reps.parameter, 0, 0, 0, alpha, false);
			self.reps.realAlpha = alpha;
		end;
		
	end;

end;

function realExhaustParticleSystem:draw()
end;