RealisticDLCBaleLoader = {};

function RealisticDLCBaleLoader.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(RealisticVehicle, specializations) and SpecializationUtil.hasSpecialization(DLCBaleloaderFixed, specializations);
end;


function RealisticDLCBaleLoader:load(xmlFile)

    self.isRealistic = true;
    self.isRealisticDLCBaleLoader = true;

    self.realOnDesactivatePS = SpecializationUtil.callSpecializationsFunction("realOnDesactivatePS");

    self.realBaleLoaderFoldingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBaleLoaderFoldingPowerConsumption"), 0);

    self.realBaleLoaderWorkingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBaleLoaderWorkingPowerConsumption"), 0);
    self.realBaleLoaderWorkingPowerConsumptionInc = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBaleLoaderWorkingPowerConsumptionInc"), 0);

    self.realBaleLoaderUnloadingPowerConsumption = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realBaleLoaderUnloadingPowerConsumption"), 0);
    self.realCurrentPowerConsumption = 0;

    self.updateLoadedBalesMass = SpecializationUtil.callSpecializationsFunction("updateLoadedBalesMass");
    self.realBaleLoaderLastFillLevel = 0;
    self.realBalesMass = 0;

end;

function RealisticDLCBaleLoader:delete()
end;

function RealisticDLCBaleLoader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RealisticDLCBaleLoader:keyEvent(unicode, sym, modifier, isDown)
end;

function RealisticDLCBaleLoader:updateTick(dt)

    if self.isServer and self.isActive then

        -----------------------------------
        -- Calculate Power Consumption
        -----------------------------------
        local PowerConsumption = 0;

        if self.isInWorkPosition and not self.grabberIsMoving then
            PowerConsumption = PowerConsumption + self.realBaleLoaderWorkingPowerConsumption;

            if self.baleSliderNumber > 0 then
                PowerConsumption = PowerConsumption + (self.baleSliderNumber * self.realBaleLoaderWorkingPowerConsumptionInc);
            end;
        end

        if self.grabberIsMoving then
            PowerConsumption = PowerConsumption + self.realBaleLoaderFoldingPowerConsumption;
        end

        if self.emptyState == DLCBaleloaderFixed.EMPTY_IN_PROCESS then
            PowerConsumption = PowerConsumption + self.realBaleLoaderUnloadingPowerConsumption;
        end

        self.realCurrentPowerConsumption = PowerConsumption;

        -----------------------------------
        -- Update Bale Loader Mass on fill level change
        -----------------------------------
        if self.fillLevel ~= self.realBaleLoaderLastFillLevel then
            self:updateLoadedBalesMass();
            self.realBaleLoaderLastFillLevel = self.fillLevel;
        end;
    end;

end;


function RealisticDLCBaleLoader:update(dt)
end;

function RealisticDLCBaleLoader:draw()
end;

function RealisticDLCBaleLoader:updateLoadedBalesMass()


    local balesMass = 0;

    for _, Id in pairs(self.loadedBales) do
        local bale = Id.object;
        if bale ~= nil and bale.isRealistic then
            balesMass = balesMass + bale.realCurrentMass;
        end;
    end;
    --print("Total bale weight: " .. string.format("%dkg", balesMass * 1000));

    self.realFillableFillMass = balesMass;
end;


function RealisticDLCBaleLoader:realOnDesactivatePS()

    if self.baleGrabParticleSystems~=nil then
        Utils.setEmittingState(self.baleGrabParticleSystems, false);
    end;

end;
