-- LUA fr realistisches Partikelsystem am Auspuff
-- basiert im Grundsatz dynamicExhaustSystem.lua von Face bzw. dessen Shader ausm dem Kirovets K 700A
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- V3 konvertiert zum LS13, Performanceoptimierung und Code aufgerumt
-- Kommentare in Englisch
-- LUA for realistic exhaust particles. Based on the DynamicExhaustingSystemShader.xml from Face
-- V3 converted to FS13, performance optimized and cleaned the code, also added english comments

-- Version "MR" -- edited to use with More Realistic Mod

realExhaustParticleSystemVMR = {};

function realExhaustParticleSystemVMR.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function realExhaustParticleSystemVMR:load(xmlFile)
	self.reps = {}; -- real exhaust particle system table.
	self.reps.minAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#minAlpha"), 0.1);
	self.reps.maxAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#maxAlpha"), 1);
	self.reps.parameter = Utils.getNoNil(getXMLString(xmlFile, "vehicle.realExhaustParticleSystem#parameter"), "exhaustingSystem");
	self.reps.realAlpha = self.reps.minAlpha; -- current alpha value
	
	self.secondPsTimer = 0;
	self.secondPSOnAfterLoadTime = 5400;  -- time how long tractor must be at full (at least 90% of load) until second ps kicks in
	
	-- new in V3, optional second particleSystem for better looking, but lower performance
	self.reps.hasSecondPS = getXMLBool(xmlFile, "vehicle.realExhaustParticleSystem#hasSecondPS");
	if self.reps.hasSecondPS == true then
		self.reps.secondPS = {};
		self.reps.secondPSIsOn = false;
		Utils.loadParticleSystem(xmlFile, self.reps.secondPS, "vehicle.realExhaustParticleSystem.SecondParticleSystem", self.components, false, nil, self.baseDirectory)
	end;	
	
	self.reps.flap = getXMLString(xmlFile, "vehicle.realExhaustParticleSystem#flap");
	if self.reps.flap ~= "" and self.reps.flap ~= nil then
		self.reps.flap = Utils.indexToObject(self.components, self.reps.flap);
		self.reps.flapMaxRot = getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#flapMaxRot");
	end;
end;

function realExhaustParticleSystemVMR:delete()
	if self.reps.secondPS ~= nil then
		Utils.deleteParticleSystem(self.reps.secondPS);
	end;
end;
function realExhaustParticleSystemVMR:mouseEvent(posX, posY, isDown, isUp, button)
end;
function realExhaustParticleSystemVMR:keyEvent(unicode, sym, modifier, isDown)
end;
function realExhaustParticleSystemVMR:update(dt)
	if self:getIsActiveForInput() and self.isMotorStarted or self.isServer and self:getIsActive() and self.isMotorStarted then	
		-- do flap animation flap is there
		if self.reps.flap ~= "" and self.reps.flap ~= nil then
			setRotation(self.reps.flap, Utils.degToRad(math.min(self.reps.flapMaxRot, self.reps.flapMaxRot*(math.max(self.realMotorLoad, 0.1)))));
		end;
		
		self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.maxAlpha * self.realMotorLoad)
			
		if self.reps.hasSecondPS then
			if self.reps.realAlpha > (self.reps.maxAlpha * 0.9) then
				if self.secondPsTimer > 0 and self.secondPsTimer + self.secondPSOnAfterLoadTime < self.time then
					self.reps.secondPSIsOn = true;
				elseif self.secondPsTimer == 0 then
					self.secondPsTimer = self.time;
				end;
			else
				self.secondPsTimer = 0;
				self.reps.secondPSIsOn = false;
			end;
			
			if self.reps.secondPSIsOn then
				Utils.setEmittingState(self.reps.secondPS, true);		
			else
				Utils.setEmittingState(self.reps.secondPS, false)
			end;
		end;
		-- set new alpha value to the shader
		setShaderParameter(self.exhaustParticleSystems[1].shape, self.reps.parameter, 0, 0, 0, self.reps.realAlpha, false);		
	else
		if self.reps.flap ~= "" and self.reps.flap ~= nil then
			setRotation(self.reps.flap, 0, 0, 0);
		end;
	end;
end;
function realExhaustParticleSystemVMR:onLeave()
	if self.reps.hasSecondPS then
		Utils.setEmittingState(self.reps.secondPS, false);
	end;
end;
function realExhaustParticleSystemVMR:draw()
end;
