-- by modelleicher
-- www.schwabenmodding.bplaced.net

SchlueterAnimations = {};

function SchlueterAnimations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function SchlueterAnimations:load(xmlFile)

	-- Tachozeiger / Speedometer animation
	self.tachoZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.TachoZeiger#zeigerIndex"));
	self.tachoZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.TachoZeiger#multiplicator"), 10);
	self.tachoZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.TachoZeiger#maxRotation"), 245);
	
	-- Temperaturzeiger / temperature Display animation
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.TemperaturZeiger#maxRotation"));
	self.tempCnt = 0;

	-- Temperaturzeiger2 / temperature Display animation
	self.temperaturZeiger2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.TemperaturZeiger2#zeigerIndex"));
	self.temperaturZeigerMaxRot2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.SchlueterAnimations.TemperaturZeiger2#maxRotation"));
	self.tempCnt2 = 0;
	
	-- Ladekontrollleuchte / Batterie load light
	self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.SchlueterAnimations.LadeKontrollLeuchte#index"));
	setVisibility(self.ladeLeuchte, false);
	self.ladeLeuchteOn = 0;
	self.ladeTimer = 50;
	
end;
function SchlueterAnimations:delete()
end;
function SchlueterAnimations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function SchlueterAnimations:keyEvent(unicode, sym, modifier, isDown)
end;

function SchlueterAnimations:update(dt)
	if self:getIsActive() then
		if self.isMotorStarted then
			-- Ladekontrollleuchte / Batterie load light
			if self.ladeLeuchteOn == 1 then
				setVisibility(self.ladeLeuchte, true);
				if self.movingDirection ~= 0 then
					self.timerTrue = true;
				end;
				if self.timerTrue then
					self.ladeTimer = math.max(self.ladeTimer - 0.1, 0);
				end;
				if self.ladeTimer == 0 then
					setVisibility(self.ladeLeuchte, false);
					self.timerTrue = nil;
					self.ladeLeuchteOn = 0;
					self.ladeTimer = 50;
				end;
			end;
						
			-- Tachozeiger / speedometer animation
			self.kmhMath = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
			local zeigerRotation = self.kmhMath * self.tachoZeigerMultiplicator;
			if zeigerRotation <= self.tachoZeigerMaxRotation then
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(zeigerRotation), 0);
			else
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(self.tachoZeigerMaxRotation), 0);	
			end;
			
			-- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = self.tempCnt + 0.5;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.2, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
			end;
			if self.tempCnt2 < 3000 then
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = self.tempCnt2 + 0.8;
			elseif self.tempCnt2 > 3000 and self.tempCnt2 < 6000 then
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = math.min(self.tempCnt2 + 0.3, 10000);			
			else
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = math.min(self.tempCnt2 + 0.04, 10000);
			end;			
		end;
	else
		self.tempCnt = math.max(self.tempCnt - 0.08, 0);
		self.tempCnt2 = math.max(self.tempCnt2 - 0.1, 0);
	end;
end;
function SchlueterAnimations:draw()
end;

function SchlueterAnimations:onEnter()
	self.ladeLeuchteOn = 1;
end;
function SchlueterAnimations:onLeave()
	self.ladeLeuchteOn = 0;
end;

