--
-- manualPipe Specialization for Combines
--
-- @author  Knagsted
-- @date  16/07/10



manualPipe = {};

function manualPipe.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function manualPipe:load(xmlFile)
    self.myPipe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myPipe#index"));
	self.pipeMaxX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#maxRotX"), 10);
	self.pipeMaxY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#maxRotY"), -90);
	self.pipeRotationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pipe#pipeRotationSpeed"), 0.0006);
    self.pipeFlapLid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeFlapLid#index"));
	
	self.pipeOutLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeOutLight#index"));
	self.showPipeOutLight = false;

	self.pipeOnLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeOnLight#index"));
	self.showPipeOnLight = false;
	
	self.tankFullLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tankFullLight#index"));
	self.showTankFullLight = false;
	
	--Sounds
	UnloadSoundFile = Utils.getFilename("Sounds/unload.wav", self.baseDirectory);
    self.UnloadSoundId = createSample("unload");
    loadSample(self.UnloadSoundId, UnloadSoundFile, false);
    self.UnloadPlaying = false;
	self.UnloadSoundOffset = getSampleDuration(self.UnloadSoundId);
	
	GrainTankFullSoundFile = Utils.getFilename("Sounds/actionSound.wav", self.baseDirectory);
    self.GrainTankFullSoundId = createSample("actionSound");
    loadSample(self.GrainTankFullSoundId, GrainTankFullSoundFile, false);
    self.GrainTankFullPlaying = false;
	self.GrainTankFullSoundOffset = getSampleDuration(self.GrainTankFullSoundId);
	self.playGrainTankFull = false;
	
	self.manualUnloading = false;
	self.wasThreshing = false;
end;

function manualPipe:delete()
	if self.UnloadPlaying ~= nil then
		stopSample(self.UnloadSoundId);
	end;
	
	if self.GrainTankFullPlaying ~= nil then
		stopSample(self.GrainTankFullSoundId);
	end;
end;

function manualPipe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualPipe:keyEvent(unicode, sym, modifier, isDown)
end;

function manualPipe:update(dt)
	if self.isEntered and self.isMotorStarted then
		if self.pipeOpen then
			if InputBinding.hasEvent(InputBinding.ACTIVATE_UNLOADING) then
				self.manualUnloading = not self.manualUnloading;
				if self.UnloadSoundId ~= nil then
					playSample(self.UnloadSoundId, 1, 0.7, 0);
				end;
			end;
		else
			self.manualUnloading = false;
		end;
		
		if self.grainTankFillLevel >= self.grainTankCapacity * 0.8 then
			if not self.GrainTankFullPlaying then
				self.playGrainTankFull = true;
			elseif not self.wasThreshing and self.isThreshing then
				self.GrainTankFullPlaying = false;
				self.playGrainTankFull = true;
			end;
			self.showTankFullLight = true;
		else
			self.GrainTankFullPlaying = false;
			self.playGrainTankFull = false;
			self.showTankFullLight = false;
		end;
	end;
	if self.tankFullLight ~= nil then
		setVisibility(self.tankFullLight, self.showTankFullLight);
	end;
	
	if self.playGrainTankFull then
		if self.GrainTankFullSoundId ~= nil and not self.GrainTankFullPlaying then
			playSample(self.GrainTankFullSoundId, 1, 0.9, 0);
			self.GrainTankFullPlaying = true;
			self.playGrainTankFull = false;
		end;
	end;
	
	if self.manualUnloading then
		self.showPipeOnLight = true;
	else
		self.showPipeOnLight = false;
	end;
	if self.pipeOnLight ~= nil then
		setVisibility(self.pipeOnLight, self.showPipeOnLight);
	end;
	
	if not self.isAIThreshing and not self.isAutopilotActivated then
		if self.manualUnloading and self.pipeOpen then
			if self.grainTankFillLevel > 0 then
				local deltaLevel = 0;
				
				if self.trailerFound == 0 then
					deltaLevel = self.grainTankUnloadingCapacity*dt/1000.0
					self.myPipeParticleActivated = true;
				else
					self.myPipeParticleActivated = false
				end;

				self.grainTankFillLevel = self.grainTankFillLevel-deltaLevel;
				if self.grainTankFillLevel <= 0.0 then
					deltaLevel = deltaLevel+self.grainTankFillLevel;
					self.grainTankFillLevel = 0.0;
					self.myPipeParticleActivated = false;
				end;
				if deltaLevel == 0 then
					self.myPipeParticleActivated = false;
				end;

				self:setGrainTankFillLevel(self.grainTankFillLevel, self.currentGrainTankFruitType);
			else
				self.myPipeParticleActivated = false;
				self.manualUnloading = false;
				--To override the emtying alogitm in the base Combine script
				self.grainTankUnloadingCapacity = 0;
			end;
		else
			self.myPipeParticleActivated = false;
			self.grainTankUnloadingCapacity = 0;
			self.manualUnloading = false;
		end;
		
		if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			if self.currentManualPipeParticleSystem ~= nil then
				Utils.setEmittingState(self.currentManualPipeParticleSystem, false);
			end;
			if self.myPipeParticleActivated and self.currentGrainTankFruitType ~= nil then
				self.currentManualPipeParticleSystem = self.pipeParticleSystems[self.currentGrainTankFruitType];
				if self.currentManualPipeParticleSystem == nil then
					self.currentManualPipeParticleSystem = self.defaultPipeParticleSystem;
				end;
				Utils.setEmittingState(self.currentManualPipeParticleSystem, true);
			end;
		else
			if self.currentManualPipeParticleSystem ~= nil then
				Utils.setEmittingState(self.currentManualPipeParticleSystem, false);
			end;
		end;
	else
		self.manualUnloading = false;
	end;
		
	local x,y,z = getRotation(self.myPipe);
	if y < 0 and y > Utils.degToRad(-99) then
		self.pipeOpening = true;
	elseif y < Utils.degToRad(-99) then
		self.pipeOpen = true;
	else
		self.pipeOpen = false
		self.pipeOpening = false;
	end;
	
	if not self.pipeOpening then
		self.showPipeOutLight = false;
	else
		self.showPipeOutLight = true;
	end;
	if self.pipeOutLight ~= nil then
		setVisibility(self.pipeOutLight, self.showPipeOutLight);
	end;
	
	self.wasThreshing = self.isThreshing;
end;

function manualPipe:draw()
	if self.pipeOpen and self.manualUnloading then
        g_currentMission:addExtraPrintText("Stop dumping grain: ", InputBinding.ACTIVATE_UNLOADING);
    elseif self.pipeOpen then
        g_currentMission:addExtraPrintText("Start dumping grain: ", InputBinding.ACTIVATE_UNLOADING);
    end;
end;
