--
-- adjustabelSpeedCutter
-- Implementation of reel and roll speeds
--
-- @author  Knagsted
-- @date  16/7/10
--
-- Do not edit without my permission
--

advancedCornHeader = {};

function advancedCornHeader.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function advancedCornHeader:load(xmlFile)
	self.rotateChain = SpecializationUtil.callSpecializationsFunction("rotateChain");

    self.myRollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myRoll#index"));	
	
	--feeder chain teeth1
	self.feederChain1TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain1#teethCount"),0);
    self.feederChain1 = {};
	self.feederChain1.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain1#startTranslation"),0);
	self.feederChain1.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain1#endTranslation"),-0.813);

    for i=1, self.feederChain1TeethCount do
        local objname = string.format("vehicle.feederChain1.tooth" .. "%d",i);
        self.feederChain1[i] = {};
        self.feederChain1[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain1[i].rotNode);
		self.feederChain1[i].startPositionX = x;
		self.feederChain1[i].startPositionY = y;
		self.feederChain1[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain1[i].rotNode);
		self.feederChain1[i].startRotationX = xRot;
		self.feederChain1[i].startRotationY = yRot;
		self.feederChain1[i].startRotationZ = zRot;
    end;
	
	--feeder chain teeth2
	self.feederChain2TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain2#teethCount"),0);
    self.feederChain2 = {};
	self.feederChain2.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain2#startTranslation"),0);
	self.feederChain2.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain2#endTranslation"),-0.813);

    for i=1, self.feederChain2TeethCount do
        local objname = string.format("vehicle.feederChain2.tooth" .. "%d",i);
        self.feederChain2[i] = {};
        self.feederChain2[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain2[i].rotNode);
		self.feederChain2[i].startPositionX = x;
		self.feederChain2[i].startPositionY = y;
		self.feederChain2[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain2[i].rotNode);
		self.feederChain2[i].startRotationX = xRot;
		self.feederChain2[i].startRotationY = yRot;
		self.feederChain2[i].startRotationZ = zRot;
    end;
	
	--feeder chain teeth3
	self.feederChain3TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain3#teethCount"),0);
    self.feederChain3 = {};
	self.feederChain3.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain3#startTranslation"),0);
	self.feederChain3.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain3#endTranslation"),-0.813);

    for i=1, self.feederChain3TeethCount do
        local objname = string.format("vehicle.feederChain3.tooth" .. "%d",i);
        self.feederChain3[i] = {};
        self.feederChain3[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain3[i].rotNode);
		self.feederChain3[i].startPositionX = x;
		self.feederChain3[i].startPositionY = y;
		self.feederChain3[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain3[i].rotNode);
		self.feederChain3[i].startRotationX = xRot;
		self.feederChain3[i].startRotationY = yRot;
		self.feederChain3[i].startRotationZ = zRot;
    end;
	
	--feeder chain teeth4
	self.feederChain4TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain4#teethCount"),0);
    self.feederChain4 = {};
	self.feederChain4.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain4#startTranslation"),0);
	self.feederChain4.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain4#endTranslation"),-0.813);

    for i=1, self.feederChain4TeethCount do
        local objname = string.format("vehicle.feederChain4.tooth" .. "%d",i);
        self.feederChain4[i] = {};
        self.feederChain4[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain4[i].rotNode);
		self.feederChain4[i].startPositionX = x;
		self.feederChain4[i].startPositionY = y;
		self.feederChain4[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain4[i].rotNode);
		self.feederChain4[i].startRotationX = xRot;
		self.feederChain4[i].startRotationY = yRot;
		self.feederChain4[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth5
	self.feederChain5TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain5#teethCount"),0);
    self.feederChain5 = {};
	self.feederChain5.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain5#startTranslation"),0);
	self.feederChain5.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain5#endTranslation"),-0.813);

    for i=1, self.feederChain5TeethCount do
        local objname = string.format("vehicle.feederChain5.tooth" .. "%d",i);
        self.feederChain5[i] = {};
        self.feederChain5[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain5[i].rotNode);
		self.feederChain5[i].startPositionX = x;
		self.feederChain5[i].startPositionY = y;
		self.feederChain5[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain5[i].rotNode);
		self.feederChain5[i].startRotationX = xRot;
		self.feederChain5[i].startRotationY = yRot;
		self.feederChain5[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth6
	self.feederChain6TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain6#teethCount"),0);
    self.feederChain6 = {};
	self.feederChain6.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain6#startTranslation"),0);
	self.feederChain6.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain6#endTranslation"),-0.813);

    for i=1, self.feederChain6TeethCount do
        local objname = string.format("vehicle.feederChain6.tooth" .. "%d",i);
        self.feederChain6[i] = {};
        self.feederChain6[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain6[i].rotNode);
		self.feederChain6[i].startPositionX = x;
		self.feederChain6[i].startPositionY = y;
		self.feederChain6[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain6[i].rotNode);
		self.feederChain6[i].startRotationX = xRot;
		self.feederChain6[i].startRotationY = yRot;
		self.feederChain6[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth7
	self.feederChain7TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain7#teethCount"),0);
    self.feederChain7 = {};
	self.feederChain7.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain7#startTranslation"),0);
	self.feederChain7.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain7#endTranslation"),-0.813);

    for i=1, self.feederChain7TeethCount do
        local objname = string.format("vehicle.feederChain7.tooth" .. "%d",i);
        self.feederChain7[i] = {};
        self.feederChain7[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain7[i].rotNode);
		self.feederChain7[i].startPositionX = x;
		self.feederChain7[i].startPositionY = y;
		self.feederChain7[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain7[i].rotNode);
		self.feederChain7[i].startRotationX = xRot;
		self.feederChain7[i].startRotationY = yRot;
		self.feederChain7[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth8
	self.feederChain8TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain8#teethCount"),0);
    self.feederChain8 = {};
	self.feederChain8.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain8#startTranslation"),0);
	self.feederChain8.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain8#endTranslation"),-0.813);

    for i=1, self.feederChain8TeethCount do
        local objname = string.format("vehicle.feederChain8.tooth" .. "%d",i);
        self.feederChain8[i] = {};
        self.feederChain8[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain8[i].rotNode);
		self.feederChain8[i].startPositionX = x;
		self.feederChain8[i].startPositionY = y;
		self.feederChain8[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain8[i].rotNode);
		self.feederChain8[i].startRotationX = xRot;
		self.feederChain8[i].startRotationY = yRot;
		self.feederChain8[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth9
	self.feederChain9TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain9#teethCount"),0);
    self.feederChain9 = {};
	self.feederChain9.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain9#startTranslation"),0);
	self.feederChain9.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain9#endTranslation"),-0.813);

    for i=1, self.feederChain9TeethCount do
        local objname = string.format("vehicle.feederChain9.tooth" .. "%d",i);
        self.feederChain9[i] = {};
        self.feederChain9[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain9[i].rotNode);
		self.feederChain9[i].startPositionX = x;
		self.feederChain9[i].startPositionY = y;
		self.feederChain9[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain9[i].rotNode);
		self.feederChain9[i].startRotationX = xRot;
		self.feederChain9[i].startRotationY = yRot;
		self.feederChain9[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth10
	self.feederChain10TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain10#teethCount"),0);
    self.feederChain10 = {};
	self.feederChain10.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain10#startTranslation"),0);
	self.feederChain10.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain10#endTranslation"),-0.813);

    for i=1, self.feederChain10TeethCount do
        local objname = string.format("vehicle.feederChain10.tooth" .. "%d",i);
        self.feederChain10[i] = {};
        self.feederChain10[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain10[i].rotNode);
		self.feederChain10[i].startPositionX = x;
		self.feederChain10[i].startPositionY = y;
		self.feederChain10[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain10[i].rotNode);
		self.feederChain10[i].startRotationX = xRot;
		self.feederChain10[i].startRotationY = yRot;
		self.feederChain10[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth11
	self.feederChain11TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain11#teethCount"),0);
    self.feederChain11 = {};
	self.feederChain11.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain11#startTranslation"),0);
	self.feederChain11.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain11#endTranslation"),-0.813);

    for i=1, self.feederChain11TeethCount do
        local objname = string.format("vehicle.feederChain11.tooth" .. "%d",i);
        self.feederChain11[i] = {};
        self.feederChain11[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain11[i].rotNode);
		self.feederChain11[i].startPositionX = x;
		self.feederChain11[i].startPositionY = y;
		self.feederChain11[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain11[i].rotNode);
		self.feederChain11[i].startRotationX = xRot;
		self.feederChain11[i].startRotationY = yRot;
		self.feederChain11[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth12
	self.feederChain12TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain12#teethCount"),0);
    self.feederChain12 = {};
	self.feederChain12.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain12#startTranslation"),0);
	self.feederChain12.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain12#endTranslation"),-0.813);

    for i=1, self.feederChain12TeethCount do
        local objname = string.format("vehicle.feederChain12.tooth" .. "%d",i);
        self.feederChain12[i] = {};
        self.feederChain12[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain12[i].rotNode);
		self.feederChain12[i].startPositionX = x;
		self.feederChain12[i].startPositionY = y;
		self.feederChain12[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain12[i].rotNode);
		self.feederChain12[i].startRotationX = xRot;
		self.feederChain12[i].startRotationY = yRot;
		self.feederChain12[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth13
	self.feederChain13TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain13#teethCount"),0);
    self.feederChain13 = {};
	self.feederChain13.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain13#startTranslation"),0);
	self.feederChain13.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain13#endTranslation"),-0.813);

    for i=1, self.feederChain13TeethCount do
        local objname = string.format("vehicle.feederChain13.tooth" .. "%d",i);
        self.feederChain13[i] = {};
        self.feederChain13[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain13[i].rotNode);
		self.feederChain13[i].startPositionX = x;
		self.feederChain13[i].startPositionY = y;
		self.feederChain13[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain13[i].rotNode);
		self.feederChain13[i].startRotationX = xRot;
		self.feederChain13[i].startRotationY = yRot;
		self.feederChain13[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth14
	self.feederChain14TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain14#teethCount"),0);
    self.feederChain14 = {};
	self.feederChain14.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain14#startTranslation"),0);
	self.feederChain14.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain14#endTranslation"),-0.813);

    for i=1, self.feederChain14TeethCount do
        local objname = string.format("vehicle.feederChain14.tooth" .. "%d",i);
        self.feederChain14[i] = {};
        self.feederChain14[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain14[i].rotNode);
		self.feederChain14[i].startPositionX = x;
		self.feederChain14[i].startPositionY = y;
		self.feederChain14[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain14[i].rotNode);
		self.feederChain14[i].startRotationX = xRot;
		self.feederChain14[i].startRotationY = yRot;
		self.feederChain14[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth15
	self.feederChain15TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain15#teethCount"),0);
    self.feederChain15 = {};
	self.feederChain15.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain15#startTranslation"),0);
	self.feederChain15.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain15#endTranslation"),-0.813);

    for i=1, self.feederChain15TeethCount do
        local objname = string.format("vehicle.feederChain15.tooth" .. "%d",i);
        self.feederChain15[i] = {};
        self.feederChain15[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain15[i].rotNode);
		self.feederChain15[i].startPositionX = x;
		self.feederChain15[i].startPositionY = y;
		self.feederChain15[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain15[i].rotNode);
		self.feederChain15[i].startRotationX = xRot;
		self.feederChain15[i].startRotationY = yRot;
		self.feederChain15[i].startRotationZ = zRot;
    end;
	
		--feeder chain teeth16
	self.feederChain16TeethCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.feederChain16#teethCount"),0);
    self.feederChain16 = {};
	self.feederChain16.startTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain16#startTranslation"),0);
	self.feederChain16.endTranslation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.feederChain16#endTranslation"),-0.813);

    for i=1, self.feederChain16TeethCount do
        local objname = string.format("vehicle.feederChain16.tooth" .. "%d",i);
        self.feederChain16[i] = {};
        self.feederChain16[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		local x,y,z = getTranslation(self.feederChain16[i].rotNode);
		self.feederChain16[i].startPositionX = x;
		self.feederChain16[i].startPositionY = y;
		self.feederChain16[i].startPositionZ = z;
		local xRot,yRot,zRot = getRotation(self.feederChain16[i].rotNode);
		self.feederChain16[i].startRotationX = xRot;
		self.feederChain16[i].startRotationY = yRot;
		self.feederChain16[i].startRotationZ = zRot;
    end;
	
	self.myRollSpeed = 0;
	self.averageLengthTime = 0;
	self.averageRotationTime = 0;
	self.resetChains = false;
end;

function advancedCornHeader:delete()
end;

function advancedCornHeader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function advancedCornHeader:keyEvent(unicode, sym, modifier, isDown)
end;

function advancedCornHeader:update(dt)
	

	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isMotorStarted then
			if self.reelStarted or self.attacherVehicle.timeoutCutterShutdown then
				if self.myRollNode ~= nil then
					rotate(self.myRollNode, self.myRollSpeed, 0, 0);
				end;		
				
				--Do the rotation of chain 1
				for i=1, self.feederChain1TeethCount do
					self:rotateChain(self.feederChain1[i], self.feederChain1.startTranslation, self.feederChain1.endTranslation, dt, i, self.feederChain1TeethCount);
				end;
				
				for i=1, self.feederChain2TeethCount do
					self:rotateChain(self.feederChain2[i], self.feederChain2.startTranslation, self.feederChain2.endTranslation, dt, i, self.feederChain2TeethCount);
				end;
				
				for i=1, self.feederChain3TeethCount do
					self:rotateChain(self.feederChain3[i], self.feederChain3.startTranslation, self.feederChain3.endTranslation, dt, i, self.feederChain3TeethCount);
				end;
				
				for i=1, self.feederChain4TeethCount do
					self:rotateChain(self.feederChain4[i], self.feederChain4.startTranslation, self.feederChain4.endTranslation, dt, i, self.feederChain4TeethCount);
				end;
				
				for i=1, self.feederChain5TeethCount do
					self:rotateChain(self.feederChain5[i], self.feederChain5.startTranslation, self.feederChain5.endTranslation, dt, i, self.feederChain5TeethCount);
				end;
				
				for i=1, self.feederChain6TeethCount do
					self:rotateChain(self.feederChain6[i], self.feederChain6.startTranslation, self.feederChain6.endTranslation, dt, i, self.feederChain6TeethCount);
				end;
				
				for i=1, self.feederChain7TeethCount do
					self:rotateChain(self.feederChain7[i], self.feederChain7.startTranslation, self.feederChain7.endTranslation, dt, i, self.feederChain7TeethCount);
				end;
				
				for i=1, self.feederChain8TeethCount do
					self:rotateChain(self.feederChain8[i], self.feederChain8.startTranslation, self.feederChain8.endTranslation, dt, i, self.feederChain8TeethCount);
				end;
				
				for i=1, self.feederChain9TeethCount do
					self:rotateChain(self.feederChain9[i], self.feederChain9.startTranslation, self.feederChain9.endTranslation, dt, i, self.feederChain9TeethCount);
				end;
				
				for i=1, self.feederChain10TeethCount do
					self:rotateChain(self.feederChain10[i], self.feederChain10.startTranslation, self.feederChain10.endTranslation, dt, i, self.feederChain10TeethCount);
				end;
				
				for i=1, self.feederChain11TeethCount do
					self:rotateChain(self.feederChain11[i], self.feederChain11.startTranslation, self.feederChain11.endTranslation, dt, i, self.feederChain11TeethCount);
				end;
				
				for i=1, self.feederChain12TeethCount do
					self:rotateChain(self.feederChain12[i], self.feederChain12.startTranslation, self.feederChain12.endTranslation, dt, i, self.feederChain12TeethCount);
				end;
				
				for i=1, self.feederChain13TeethCount do
					self:rotateChain(self.feederChain13[i], self.feederChain13.startTranslation, self.feederChain13.endTranslation, dt, i, self.feederChain13TeethCount);
				end;				
				
				for i=1, self.feederChain14TeethCount do
					self:rotateChain(self.feederChain14[i], self.feederChain14.startTranslation, self.feederChain14.endTranslation, dt, i, self.feederChain14TeethCount);
				end;				
								
				for i=1, self.feederChain15TeethCount do
					self:rotateChain(self.feederChain15[i], self.feederChain15.startTranslation, self.feederChain15.endTranslation, dt, i, self.feederChain15TeethCount);
				end;
								
				for i=1, self.feederChain16TeethCount do
					self:rotateChain(self.feederChain16[i], self.feederChain16.startTranslation, self.feederChain16.endTranslation, dt, i, self.feederChain16TeethCount);
				end;
			end;
		end;
	end;
end;

function advancedCornHeader:draw()
end;


function advancedCornHeader:rotateChain(node, startTranslation, endTranslation, dt, i, teethCount)
	local cycleTranslation = self.attacherVehicle.feedSpeed * 0.00015 * dt / self.attacherVehicle.threasherActivationTime * self.attacherVehicle.reelTime;
	local cycleRotation = cycleTranslation * 11.75;
	local x,y,z = getTranslation(node.rotNode);
	local xRot,yRot,zRot = getRotation(node.rotNode);	
	
	local newZ = z;
	local newYRot = yRot;
	
	if yRot <= 0 then
		newYRot = 0;
		newZ = z - cycleTranslation;						
		if newZ < endTranslation then
			newZ = endTranslation;
		end;
	elseif yRot >= 3.14 then
		newYRot = 3.14;
		newZ = z + cycleTranslation;
		if newZ > startTranslation then
			newZ = startTranslation;
		end;
	end;
						
	if newZ <= endTranslation or newZ >= startTranslation then
		newYRot = yRot + cycleRotation;
		if newYRot > 6.28 then
			newYRot = 0;
		end;
	end;

	--Due to changing dt based on varous loads and the way Windows allocated ressourced and other factors 
	--we reset the start position for all teeth once the first tooth has completed one full revolution on the chain
	if self.resetChains then
		newZ = node.startPositionZ;
		newYRot = node.startRotationY;
		--We are done reseting the chain when we reach the last tooth
		if i == teethCount then
			self.resetChains = false;
		end;
	end;

	if i == 1 then
		if newZ >= startTranslation and newYRot <= 0 then
			--We have done one full revolution so reset the chain
			self.resetChains = true;
		end;
	end;
	
	setRotation(node.rotNode, 0,newYRot,0);
	setTranslation(node.rotNode, x, y, newZ);
end;
