

ClaasC660 = {};

function ClaasC660.initSpecialization()
    Vehicle.registerJointType("ClaasC660");
end;

function ClaasC660.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function ClaasC660:load(xmlFile)
	
	self.ClaasC660 = {};
	
	self.ClaasC660.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.vario#speed"), 11);
	self.ClaasC660.speedScaleTime = 5000;
	self.ClaasC660.speedScaleBackup = self.reelSpeedScale;
	self.ClaasC660.rollSpeedBackup = self.rollNodes[1].speed;
	
	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;
end;

function ClaasC660:delete()
end;

function ClaasC660:readStream(streamId, connection)
end;

function ClaasC660:writeStream(streamId, connection)
end;

function ClaasC660:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ClaasC660:keyEvent(unicode, sym, modifier, isDown)
end;

function ClaasC660:update(dt)
	if self:getIsActive() and self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.ClaasC660.speed, 1.3));
	
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.ClaasC660.speedScaleBackup * percent}, {0}, 1, self.ClaasC660.speedScaleTime, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.ClaasC660.rollSpeedBackup * percent}, {0}, 1, self.ClaasC660.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		
		
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.ClaasC660.speed, 1.5));
			
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.ClaasC660.speedScaleBackup * percent}, {0}, 1, self.ClaasC660.speedScaleTime*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.ClaasC660.rollSpeedBackup * percent}, {0}, 1, self.ClaasC660.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
	end;
end;

function ClaasC660:updateTick(dt)
	
end;

function ClaasC660:draw()	
end;

function ClaasC660:onAttach(attacherVehicle)
	
end;

function ClaasC660:onDetach()
	Cutter.updateExtraObjects(self);
end;

