

Agromet_H_152 = {};

function Agromet_H_152.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations)
end;

function Agromet_H_152:load(xmlFile)
	self.animation = {};
	self.animation.animCharSet = 0;
	self.animationEnabled = false;

	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));

	if rootNode ~= nil then
		self.animation.animCharSet = getAnimCharacterSet(rootNode);
		if self.animation.animCharSet ~= 0 then
			self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			if self.animation.clip >= 0 then
				assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
				self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
				setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
				setAnimTrackLoopState(self.animation.animCharSet, 0, true);
			end;
		end;
	end;
	
	self.newParticleSystems = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.newParticleSystems.newParticleSystem(%d)", i);

        if not hasXMLProperty(xmlFile, key) then
            break;
        end;

        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.newParticleSystems, {node=node, speed=speed});
        end;
		i = i +1;
    end;
	self.PS1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.newParticleSystems#straw"));
	self.PS2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.newParticleSystems#hay"));
	setVisibility(self.PS1, false)
	setVisibility(self.PS2, false)
end;

function Agromet_H_152:delete()
end;

function Agromet_H_152:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Agromet_H_152:keyEvent(unicode, sym, modifier, isDown)
end;

function Agromet_H_152:update(dt)
end;

function Agromet_H_152:updateTick(dt)
	if self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN then
		if self.currentFillType == Fillable.FILLTYPE_WHEAT_WINDROW or self.currentFillType == Fillable.FILLTYPE_BARLEY_WINDROW then
			setVisibility(self.PS1, true)
		else
			setVisibility(self.PS2, true)
		end;
		if not self.animationEnabled then
			enableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = true;
		end;
		for _, part in pairs(self.newParticleSystems) do
			setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
		end;
	else
		if self.animationEnabled then
			disableAnimTrack(self.animation.animCharSet, 0);
			self.animationEnabled = false;
		end;
		for _, part in pairs(self.newParticleSystems) do
			setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
		setVisibility(self.PS1, false)
		setVisibility(self.PS2, false)
	end;
end;

function Agromet_H_152:draw()
end;

function Agromet_H_152:onDetach()
end;