StrawSpecEvent = {};
StrawSpecEvent_mt = Class(StrawSpecEvent, Event);

InitEventClass(StrawSpecEvent, "StrawSpecEvent");

function StrawSpecEvent:emptyNew()
    local self = Event:new(StrawSpecEvent_mt);
    self.className="StrawSpecEvent";
    return self;
end;

function StrawSpecEvent:new(vehicle, isActive)
    local self = StrawSpecEvent:emptyNew()
    self.vehicle = vehicle;
	self.isActive = isActive;
    return self;
end;

function StrawSpecEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isActive = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function StrawSpecEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isActive);
end;

function StrawSpecEvent:run(connection)
	self.vehicle:setStrawSpecActive(self.isActive, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(StrawSpecEvent:new(self.vehicle, self.isActive), nil, connection, self.vehicle);
    end;	
end;

function StrawSpecEvent.sendEvent(strawSpec, isActive)
	if g_server ~= nil then
		g_server:broadcastEvent(StrawSpecEvent:new(strawSpec, isActive), nil, nil, strawSpec);
	else
		g_client:getServerConnection():sendEvent(StrawSpecEvent:new(strawSpec, isActive));
	end;
end;

