--@Author: Alex2009, Sven777b
--@Web: www.ls-landtechnik.de, www.alex2009.de

seedPalletsPlaceable = {};
seedPalletsPlaceable_mt = Class(seedPalletsPlaceable, Placeable);
InitObjectClass(seedPalletsPlaceable, "seedPalletsPlaceable");

function seedPalletsPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, seedPalletsPlaceable_mt);
    registerObjectClassName(self, "seedPalletsPlaceable");
    return self;
end;

function seedPalletsPlaceable:delete()
    removeTrigger(self.SowingMachineFillTriggerId);
    unregisterObjectClassName(self);
    seedPalletsPlaceable:superClass().delete(self);
end;

function seedPalletsPlaceable:deleteFinal()
    seedPalletsPlaceable:superClass().deleteFinal(self);
end;

function seedPalletsPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not seedPalletsPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.SowingMachineFillTriggerId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.seedTrigger#index"));
    SowingMachineFillTrigger:onCreate(self.SowingMachineFillTriggerId);
    delete(xmlFile);
    return true;
end;

function seedPalletsPlaceable:update(dt)
end;
registerPlaceableType("seedPalletsPlaceable", seedPalletsPlaceable);