
---xyzspain 2014




kuhn_sw_4004 = {};

function kuhn_sw_4004.prerequisitesPresent(specializations)
    return true;
end;

function kuhn_sw_4004:load(xmlFile)


-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
---emision de particulas ruedas

self.wheelParticleSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticleSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;
	

end;

function kuhn_sw_4004:delete()
	
	
	for i=1, table.getn(self.wheelParticleSystems) do
		Utils.deleteParticleSystem(self.wheelParticleSystems[i].particleSystems);
	end;
	
	
			
end;



function kuhn_sw_4004:mouseEvent(posX, posY, isDown, isUp, button)
end;

function kuhn_sw_4004:keyEvent(unicode, sym, modifier, isDown)

end;



function kuhn_sw_4004:getSaveAttributesAndNodes(nodeIdent)

end;

function kuhn_sw_4004:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	
end;

function kuhn_sw_4004:update(dt)
	if self.attacherVehicle ~= nil then
	
	
	---emision de particulas-----------
	local dens = 0; local dens1; local dens2; local dens3;
	 local x,y,z = getWorldTranslation(self.wheels[1].repr);
	 local x1,y1,z1 = getWorldTranslation(self.wheels[2].repr);
	 local x2,y2,z2 = getWorldTranslation(self.wheels[1].repr);
	local id = g_currentMission.terrainDetailId;
	local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
	dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
	dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
	dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
	if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
		dens = dens1+dens2+dens3;
	end;
	if  self.lastSpeed*self.speedDisplayScale*3600 > 4 then
		if dens > 0 then
				for k=1,  table.getn(self.wheelParticleSystems) do
				Utils.setEmittingState(self.wheelParticleSystems[k].particleSystems, self.wheels[k].hasGroundContact);
			end;
		elseif dens <=0 then
			for i=1, table.getn(self.wheelParticleSystems) do
				Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
			end;
		
		end;
	else
		for i=1, table.getn(self.wheelParticleSystems) do
				Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
			end;
	end;	
		
	
	end	
	
	
	if self:getIsActiveForInput() then
	
		if InputBinding.isPressed(InputBinding.KUHN_SW_4004_3) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.KUHN_SW_4004_4) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet*(dt/10)));
		end;
		
			if self.animationParts[3].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("KUHN_SW_4004_4")), InputBinding.KUHN_SW_4004_4);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("KUHN_SW_4004_3")), InputBinding.KUHN_SW_4004_3);
					
			end;
		
			
	end;
		

	
	
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
		
		
		
		self:setHydraulicDirection();	
	
end;



	
function kuhn_sw_4004:updateTick(dt)	
	
end;

function kuhn_sw_4004:draw()
	
	
	
end;

function kuhn_sw_4004:onAttach(attacherVehicle)
	
end;

function kuhn_sw_4004:onDetach()
	
end;


function kuhn_sw_4004:readStream(streamId, connection)  
	
	
end;

function kuhn_sw_4004:writeStream(streamId, connection)
	
	
	
end;

function kuhn_sw_4004:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end; 