WrappingEvent = {};
WrappingEvent_mt = Class(WrappingEvent, Event);

InitEventClass(WrappingEvent, "WrappingEvent");

function WrappingEvent:emptyNew()
    local self = Event:new(WrappingEvent_mt);
    self.className="WrappingEvent";
    return self;
end;

function WrappingEvent:new(object, wrappingMode)
    local self = WrappingEvent:emptyNew()
    self.object = object;
	self.wrappingMode = wrappingMode;
    return self;
end;

function WrappingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.wrappingMode = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function WrappingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.wrappingMode);
end;

function WrappingEvent:run(connection)
	self.object:setWrappingMode(self.wrappingMode);
    if not connection:getIsServer() then
        g_server:broadcastEvent(WrappingEvent:new(self.object, self.wrappingMode), nil, connection, self.object);
    end;	
end;

function WrappingEvent.sendEvent(vehicle, wrappingMode, noEventSend)
	if wrappingMode ~= vehicle.wrappingMode then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(WrappingEvent:new(vehicle, wrappingMode), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(WrappingEvent:new(vehicle, wrappingMode));
			end;
		end;
	end;
end;

