ManualMixEvent = {}; -- wird einfach gebraucht, eher weniger interessant
ManualMixEvent_mt = Class(ManualMixEvent, Event);
InitEventClass(ManualMixEvent, "ManualMixEvent");
function ManualMixEvent:emptyNew()
    local self = Event:new(ManualMixEvent_mt);
    self.className="ManualMixEvent";
    return self;
end;

function ManualMixEvent:new(object, mixeron) 
    local self = ManualMixEvent:emptyNew(); 
    self.object = object; 
	self.mixeron = mixeron;
    return self;
end;

function ManualMixEvent:writeStream(streamId, connection) 
    streamWriteInt32(streamId, networkGetObjectId(self.object)); 
    streamWriteBool(streamId, self.mixeron); 
end;

function ManualMixEvent:readStream(streamId, connection) 
    self.object = networkGetObject(streamReadInt32(streamId)); 
    self.mixeron = streamReadBool(streamId);
    self:run(connection);
end;

function ManualMixEvent:run(connection)
	self.object:setMixeron(self.mixeron, true); 
	
	if not connection:getIsServer() then 
		g_server:broadcastEvent(ManualMixEvent:new(self.object, self.mixeron), nil, connection, self.object);
	end; 
end;

function ManualMixEvent.sendEvent(object, mixeron, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(ManualMixEvent:new(object, mixeron), nil, nil, object);
		else  
			g_client:getServerConnection():sendEvent(ManualMixEvent:new(object, mixeron));
		end;
	end;
end;