-- ManualMix
-- Specialization for start Mixer Manual
--
-- Ersteller Brndi, network support added by rafftnix
-- Datum 26/12/12

ManualMix = {};

function ManualMix.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations) and
		   SpecializationUtil.hasSpecialization(Attachable, specializations);
end;


function ManualMix:load(xmlFile)
	self.setMixeron = SpecializationUtil.callSpecializationsFunction("setMixeron");
   
	self.MixerObjekt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.mixerWagonMixRotatingParts.mixerWagonMixRotatingPart(0)#index"));
	self.MixerSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mixerWagonMixRotatingParts.mixerWagonMixRotatingPart(0)#speed"), 10);

end;

function ManualMix:delete()
end;

function ManualMix:writeStream(streamId, connection)
    streamWriteBool(streamId, self.mixeron);
end;

function ManualMix:readStream(streamId, connection)
    local mixeron = streamReadBool(streamId);
	self:setMixeron(mixeron, true);
end;

function ManualMix:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManualMix:keyEvent(unicode, sym, modifier, isDown)
end;

function ManualMix:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.ManualMixer) and self.attacherVehicle then
			self:setMixeron(not self.mixeron);
		end;
	end;	
  
	if self.mixeron then
		rotate(self.MixerObjekt, 0, self.MixerSpeed/1000, 0);
	end;
end;

function ManualMix:updateTick(dt)
end;

function ManualMix:draw()   
	if self.mixeron then
		g_currentMission:addHelpButtonText(g_i18n:getText("deactivateMixer"), InputBinding.ManualMixer);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("activateMixer"), InputBinding.ManualMixer);
	end;
end;

function ManualMix:setMixeron(mixeron, noEventSend)
	self.mixeron = mixeron;
	if noEventSend == nil then 
		ManualMixEvent.sendEvent(self, mixeron, noEventSend);
	end;
end;

function ManualMix:onDetach()
	self.mixeron = false;
end;