--
-- Specialisation for Kuhn Euromix 870L 
--
-- Dumping the RPM by outtipping or mix
-- Author: Mofi (BM-Modding) Edit by: Brndi


KuhnEuromix870L = {};

function KuhnEuromix870L.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(ManualMix, specializations);
end;

function KuhnEuromix870L:load(xmlFile)
    self.setVehicleIncreaseRpm = SpecializationUtil.callSpecializationsFunction("setVehicleIncreaseRpm");
    self.saveMinimumRpm = 0;
end;

function KuhnEuromix870L:delete()
end;

function KuhnEuromix870L:readStream(streamId, connection)
end;

function KuhnEuromix870L:writeStream(streamId, connection)
end;

function KuhnEuromix870L:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KuhnEuromix870L:keyEvent(unicode, sym, modifier, isDown)
end;

function KuhnEuromix870L:update(dt)
	if self.tipState == Trailer.TIPSTATE_OPENING or self.mixeron or self.tipState == Trailer.TIPSTATE_OPEN then
	    if self.attacherVehicle  ~= nil then
            if self.attacherVehicle.motor ~= nil then
                self:setVehicleIncreaseRpm(dt, true);
            end;
        end;
	elseif (self.tipState == Trailer.TIPSTATE_CLOSING or self.tipState == Trailer.TIPSTATE_CLOSED) then
		self:setVehicleIncreaseRpm(nil, false);
    end;
end;

function KuhnEuromix870L:updateTick(dt)
end;

function KuhnEuromix870L:draw()
end;

function KuhnEuromix870L:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy1 == nil then
		self.attacherVehicleCopy1 = self.attacherVehicle;
	end;
	if self.attacherVehicle.motor ~= nil then
		self.saveMinimumRpm = self.attacherVehicle.motor.minRpm;
	else
		if self.attacherVehicle.saveMinRpm ~= nil then
			self.saveMinimumRpm = self.attacherVehicle.saveMinimumRpm;
		else
			self.attacherVehicle.saveMinimumRpm  = 100;
		end;
	end;
end;

function KuhnEuromix870L:onDetach()
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy1 == steerable then
			steerable.motor.minRpm = self.saveMinimumRpm;
			self.attacherVehicleCopy1 = nil;
		end;
	end;
end;

function KuhnEuromix870L:setVehicleIncreaseRpm(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinimumRpm ~= 0 and
		self.attacherVehicle.motor ~= nil then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -1200);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinimumRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinimumRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000012*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;