--
-- ks85dn
-- Specialization for ks85dn
--
-- @author  mx270
-- @author  fruktor
-- @date  14/06/2011
--
-- > Copyright (C)  www.modding-society.de < -- 

ks85dn = {};

function ks85dn.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Windrower, specializations);
end;

function ks85dn:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.setSchwadtuchDir = SpecializationUtil.callSpecializationsFunction("setSchwadtuchDir");

	self.saveMinRpm = 0;
	self.curRotLimit = Utils.degToRad(30);
end;

function ks85dn:delete()
    removeTrigger(self.trigger);
end;

function ks85dn:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ks85dn:keyEvent(unicode, sym, modifier, isDown)
end;

function ks85dn:update(dt)
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.SCHWADTUCH) then
				self:setSchwadtuchDir(not self.schwadtuchDir);
			end;
		end;		
end;

function ks85dn:updateTick(dt)	

	if self.schwadtuchDirHasChanged then
		if self.schwadtuchDir then
			self:playAnimation("Schwadtuch", 1, self:getAnimationTime("Schwadtuch"));
		else
			self:playAnimation("Schwadtuch", -1, self:getAnimationTime("Schwadtuch"));				
		end;
	end;

	if self.isTurnedOn then 
		self:setVehicleRpmUp(dt, true);
	else
		self:setVehicleRpmUp(dt, false);
	end;
	
	if self:getIsActive() then
	
		local setDown = false;
		if self.doJointOrientation == true and self.attacherVehicle ~= nil then
			for k,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.attacherJointCopy = joint;	
					setDown = joint.moveDown;
				end;
			end;
			self.doJointOrientation = false;
		end;	
	
		if self.attacherJointCopy ~= nil then 
			local newRot = Utils.getMovedLimitedValues({self.curRotLimit}, {Utils.degToRad(0)}, {Utils.degToRad(30)}, 1, 2000, dt, self.attacherJointCopy.moveDown);
			self.curRotLimit = newRot[1];
			setJointRotationLimit(self.componentJoints[1].jointIndex, 1, true, -newRot[1], newRot[1]);
		end;
	end;
	
end;

function ks85dn:draw()
	if self.schwadtuchDir then
		g_currentMission:addHelpButtonText(g_i18n:getText("Schwadtuch_rein"), InputBinding.SCHWADTUCH);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Schwadtuch_raus"), InputBinding.SCHWADTUCH);		
	end;	
end;

function ks85dn:onAttach(attacherVehicle)
	self.doJointOrientation = true;
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;	
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function ks85dn:onDetach()
	self.attacherJointCopy = nil;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;	
end;

function ks85dn:setSchwadtuchDir(state, noEventSend)
	self.schwadtuchDir = state;
	self.schwadtuchDirHasChanged = true;
end;

function ks85dn:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
			else
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;