--
-- Liftachse
-- Specialization for Liftaxle
-- Spezialisierung fr Liftachse
--
-- @author fruktor
-- Copyright (C) fruktor, All Rights Reserved. 
-- 
-- frei verwendbar - keine erlaubnis ntig  |  free for use - no permission needed.
-- Modifikationen erst nach Rcksprache!    |  modifications only with my permission.
--

liftachse = {};

function liftachse.prerequisitesPresent(specializations)
    return true;
end;

function liftachse:load(xmlFile)
	self.isActor = false;
	self.setLiftachse = SpecializationUtil.callSpecializationsFunction("setLiftachse");
	local achse = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.achse#index"));
	if achse ~= nil then
		self.achse = {};
		self.achse.node = achse;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.achse#minRot"));
		self.achse.minRot = {};
		self.achse.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.achse.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.achse.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.achse#maxRot"));
		self.achse.maxRot = {};
		self.achse.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.achse.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.achse.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		self.achse.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.achse#rotTime"), 1)*1000;
		self.supportTrans1 = {};
		self.supportTrans1.node = achse;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.achse#minTrans"));
		self.supportTrans1.minRot = {};
		self.supportTrans1.minRot[1] = x;
		self.supportTrans1.minRot[2] = y;
		self.supportTrans1.minRot[3] = z;
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.achse#maxTrans"));
		self.supportTrans1.maxRot = {};
		self.supportTrans1.maxRot[1] = x;
		self.supportTrans1.maxRot[2] = y;
		self.supportTrans1.maxRot[3] = z;
		self.supportTrans1.rotTime = self.achse.rotTime;
	end;
	self.Liftachsedown = false;
    self.inTriggerL = false;
    self.steeringTriggerL = liftachse.steeringTriggerL;
    self.TriggerL = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steeringTrigger#index1"));
    addTrigger(self.TriggerL,"steeringTriggerL",self);
    
    self.OwnattacherJointIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint#index"));
    local x,y,z = getTranslation(self.OwnattacherJointIndex);
    self.JointTransBackup = {};
    self.JointTransBackup.x=x;
    self.JointTransBackup.y=y;
    self.JointTransBackup.z=z;
end;

function liftachse:steeringTriggerL(triggerId,otherId,onEnter,onLeave,onStay)
    if (onEnter) and (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) then
        self.inTriggerL = true;
    elseif (onLeave) and (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) then
        self.inTriggerL = false;
    end;
end;

function liftachse:keyEvent(unicode, sym, modifier, isDown)
end;

function liftachse:update(dt)
    if self.inTriggerL and self.attacherVehicle == nil then
        if InputBinding.hasEvent(InputBinding.liftachse) then
            if self.Liftachsedown then
                self.Liftachsedown = false;
                liftachseEvent.sendEvent(self, self.Liftachsedown);
                if self.supportAnimation ~= nil and self.playAnimation ~= nil then
                    self:playAnimation(self.supportAnimation, 0.08, nil, true);
                end;
            else
                if self.supportAnimation ~= nil and self.playAnimation ~= nil then
                    self:playAnimation(self.supportAnimation, -0.08, nil, true);
                end;
                self.Liftachsedown = true;
                liftachseEvent.sendEvent(self, self.Liftachsedown);
            end;
        end;
        if self.Liftachsedown then
        	g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.liftachse))..":                      " .."Container heben");
        else
        	g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.liftachse))..":                      " .."Container senken");
        end;
    end;
end;

function liftachse:updateTick(dt)
	if self.Liftachsedown ~= nil then	
		if self.Liftachsedown then
			local x, y, z = getTranslation(self.supportTrans1.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans1.maxRot, self.supportTrans1.minRot, 3, self.supportTrans1.rotTime, dt, true);
			setTranslation(self.supportTrans1.node, unpack(newTrans));
			if math.abs(self.supportTrans1.minRot[1]-newTrans[1]) < 0.001 then
                if self.attacherVehicle == nil then
                    setTranslation(self.OwnattacherJointIndex,0,-500,0);
                end;
				local x, y, z = getRotation(self.achse.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.achse.maxRot, self.achse.minRot, 3, self.achse.rotTime, dt, true);
				setRotation(self.achse.node, unpack(newRot));
			end;
		else
			local x, y, z = getRotation(self.achse.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.achse.maxRot, self.achse.minRot, 3, self.achse.rotTime, dt, false);
			setRotation(self.achse.node, unpack(newRot));
			if math.abs(self.achse.maxRot[1]-newRot[1]) < 0.001 then
                if self.attacherVehicle == nil then
                    setTranslation(self.OwnattacherJointIndex,self.JointTransBackup.x,self.JointTransBackup.y,self.JointTransBackup.z);
                end;
				local x, y, z = getTranslation(self.supportTrans1.node);
				local trans = {x,y,z};
				local newTrans = Utils.getMovedLimitedValues(trans, self.supportTrans1.maxRot, self.supportTrans1.minRot, 3, self.supportTrans1.rotTime, dt, false);
				setTranslation(self.supportTrans1.node, unpack(newTrans));
			end;
		end;
		for i, jointDesc in pairs(self.componentJoints) do
			setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
	end;
end;

function liftachse:draw()
end;
function liftachse:readStream(streamId, connection)
	self.Liftachsedown = streamReadBool(streamId);
    if self.Liftachsedown then
        if self.supportAnimation ~= nil and self.playAnimation ~= nil then
            self:playAnimation(self.supportAnimation,0.08, nil, true);
        end;
    else
        if self.supportAnimation ~= nil and self.playAnimation ~= nil then
            self:playAnimation(self.supportAnimation,-0.08, nil, true);
        end;
    end;
end;

function liftachse:writeStream(streamId, connection)
	streamWriteBool(streamId, self.Liftachsedown);
end;
function liftachse:mouseEvent(posX, posY, isDown, isUp, button)
end;

function liftachse:delete()
    removeTrigger(self.TriggerL);
end;

function liftachse:onDetach()
end;


liftachseEvent = {};
liftachseEvent_mt = Class(liftachseEvent, Event);

InitEventClass(liftachseEvent, "liftachseEvent");

function liftachseEvent:emptyNew()
    local self = Event:new(liftachseEvent_mt);
    self.className="liftachseEvent";
    return self;
end;

function liftachseEvent:new(object, data)
    local self = liftachseEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function liftachseEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.data = streamReadBool(streamId);
	self.object.Liftachsedown = self.data;
    if self.object.Liftachsedown then
        if self.object.supportAnimation ~= nil and self.object.playAnimation ~= nil then
            self.object:playAnimation(self.object.supportAnimation,0.08, nil, true);
        end;
    else
        if self.object.supportAnimation ~= nil and self.object.playAnimation ~= nil then
            self.object:playAnimation(self.object.supportAnimation,-0.08, nil, true);
        end;
    end;
	if not connection:getIsServer() then
        g_server:broadcastEvent(liftachseEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function liftachseEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.data);
end;

function liftachseEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(liftachseEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(liftachseEvent:new(vehicle, data));
	end;
end;