-- John Deere 8350
-- extends vehicle.lua
-- for Mod-Contest
-- by yekk1
-- Special Thanks to: Face, Sven777b, Acid_Burn84, Speedy11, MxY.rlp
-- Adapted for LS 09 by Bayn

JD_8530 = {};

function JD_8530.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JD_8530:load(xmlFile)
            print("'lua loaded '" );
	self.controlpath = Utils.getFilename("johndeere_control.png", self.baseDirectory);
	self.hudjohndeerePoxX = 0.01;
    self.hudjohndeerePoxY = 1-0.204;
    self.hudjohndeereWidth = 0.270;
    self.hudjohndeereHeight = 0.270;
	self.hudjohndeerePoxX = 0.48;
    self.hudjohndeerePoxY = 0.8
    self.hudjohndeereOverlay = Overlay:new("hudjohndeereControl", self.controlpath, self.hudjohndeerePoxX, self.hudjohndeerePoxY, self.hudjohndeereWidth, self.hudjohndeereHeight);


    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

	self.fuellight50l = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fuellight50l#index"));
	self.fuellight100l = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fuellight100l#index"));
	self.rullight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rullight#index"));
	self.light_display = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.light_display#index"));
	self.bar_display = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bar_display#index"));

    
	self.exhaustParticleSystems2 = {};
    local psName = "vehicle.exhaustParticleSystemExtra1";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems2, psName, self.rootNode, false)
	
	self.exhaustParticleSystems3 = {};
    local psName = "vehicle.exhaustParticleSystemExtra2";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems3, psName, self.rootNode, false)
	
	self.exhaustParticleSystems4 = {};
    local psName = "vehicle.exhaustParticleSystemExtra3";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems4, psName, self.rootNode, false)
	
	self.exhaustParticleSystems5 = {};
    local psName = "vehicle.exhaustParticleSystemExtra4";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems5, psName, self.rootNode, false)


	
	self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);
    end;

	local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;


	local rotationPartNodepanelright = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.panelright#index"));
    if rotationPartNodepanelright ~= nil then
        self.rotationPartpanelright = {};
        self.rotationPartpanelright.node = rotationPartNodepanelright;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.panelright#minRot"));
        self.rotationPartpanelright.minRot = {};
        self.rotationPartpanelright.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpanelright.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpanelright.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.panelright#maxRot"));
        self.rotationPartpanelright.maxRot = {};
        self.rotationPartpanelright.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpanelright.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpanelright.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpanelright.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.panelright#rotTime"), 2)*1000;
        self.rotationPartpanelright.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.panelright#touchRotLimit"), 10));
    end;
		local rotationPartNodepanelleft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.panelleft#index"));
    if rotationPartNodepanelleft ~= nil then
        self.rotationPartpanelleft = {};
        self.rotationPartpanelleft.node = rotationPartNodepanelleft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.panelleft#minRot"));
        self.rotationPartpanelleft.minRot = {};
        self.rotationPartpanelleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpanelleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpanelleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.panelleft#maxRot"));
        self.rotationPartpanelleft.maxRot = {};
        self.rotationPartpanelleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpanelleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpanelleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpanelleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.panelleft#rotTime"), 2)*1000;
        self.rotationPartpanelleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.panelleft#touchRotLimit"), 10));
    end;


	local rotationPartNodeBaranzeige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Baranzeige#index"));
    if rotationPartNodeBaranzeige ~= nil then
        self.rotationBaranzeige = {};
        self.rotationBaranzeige.node = rotationPartNodeBaranzeige;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Baranzeige#minRot"));
        self.rotationBaranzeige.minRot = {};
        self.rotationBaranzeige.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationBaranzeige.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationBaranzeige.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Baranzeige#maxRot"));
        self.rotationBaranzeige.maxRot = {};
        self.rotationBaranzeige.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationBaranzeige.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationBaranzeige.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationBaranzeige.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Baranzeige#rotTime"), 2)*1000;
        self.rotationBaranzeige.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Baranzeige#touchRotLimit"), 10));
    end;

	self.tankanzeigeIndex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tankanzeige#index")); 
	self.tankanzeigeMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tankanzeige#maxRot") , 10); 
	


	self.trailerAttacherJoint1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacherJoint#index"));
        self.trailerAttacherJoint2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontAttacherJoint#index"));

        self.rotationPartpanelleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	self.reversierer = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reversierer#index")); 
	self.gaspedal = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gaspedal#index")); 
	self.brake = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.brake#index")); 


	

      self.twinWheelsActive= true;
	self.bcActive = false;




end;

function JD_8530:delete()
end;

function JD_8530:mouseEvent(posX, posY, isDown, isUp, button)
end;


function JD_8530:keyEvent(unicode, sym, modifier, isDown)
	--JD_8530:superClass().keyEvent(self, unicode, sym, modifier, isDown);



if isDown and sym == Input.KEY_6 then 
		self.twinWheelsActive = not self.twinWheelsActive;
	end;

	if isDown and sym == Input.KEY_4 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end;

	if isDown and sym == Input.KEY_5 then
		self.rotationMaxpanelright = not self.rotationMaxpanelright;
self.rotationMaxpanelleft = not self.rotationMaxpanelleft;

	end;
		if isDown and sym == 48 then -- Key: 0
			self.bcActive = not self.bcActive;
		end;

    if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;
end;

function JD_8530:update(dt)

	--if self.isEntered then
		--if self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 20 then
			--Utils.setEmittingState(self.exhaustParticleSystems2, true);
	--	end;
	--	if not self.attachedTrailer or not self.motor.speedLevel == 0 or self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 20 then
	--		Utils.setEmittingState(self.exhaustParticleSystems2, false);
	--	end;
	--	if self.attachedTrailer and self.lastSpeed*3600 > 20 then
	--		Utils.setEmittingState(self.exhaustParticleSystems3, true);
	--	end;
	--	if not self.attachedTrailer or self.lastSpeed*3600 < 20 then
	--		Utils.setEmittingState(self.exhaustParticleSystems3, false);
	--	end;
	--	if not self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 20 then
	--		Utils.setEmittingState(self.exhaustParticleSystems4, true);
	--	end;
	--	if not self.attachedTrailer and self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 20 then
	--		Utils.setEmittingState(self.exhaustParticleSystems4, false);
	--	end;
		
	--	if not self.attachedTrailer and self.lastSpeed*3600 > 20 then
	--		Utils.setEmittingState(self.exhaustParticleSystems5, true);
	--	end;
	--	if not self.attachedTrailer and self.lastSpeed*3600 < 20 then
	--		Utils.setEmittingState(self.exhaustParticleSystems5, false);
	--	end;
	--end;
	


	if self.isEntered then
		if self.fuelFillLevel < 101 then
		setVisibility(self.fuellight100l, true);
	else
		setVisibility(self.fuellight100l, false);
	    end;
	end;

	if self.isEntered then
		if self.fuelFillLevel < 51 then
		setVisibility(self.fuellight100l, false);
	    end;
	end;

	if self.isEntered then
		if self.fuelFillLevel < 51 then
		setVisibility(self.fuellight50l, true);
	else
		setVisibility(self.fuellight50l, false);
	    end;
    	end;

	if self.isEntered then
		if self.rundumleuchtenAn == true then
		setVisibility(self.rullight, true);
	else
		setVisibility(self.rullight, false);
	    end;
    	end;

	if self.isEntered then
		if self.lightsActive == true then
		setVisibility(self.light_display, true);
	else
		setVisibility(self.light_display, false);
	    end;
    	end;

if self.rotationBaranzeige ~= nil then 
local x, y, z = getRotation(self.rotationBaranzeige.node); 
local rot = {x,y,z}; 
local newRot = Utils.getMovedLimitedValues(rot, self.rotationBaranzeige.maxRot, self.rotationBaranzeige.minRot, 3, self.rotationBaranzeige.rotTime, dt, not self.rotationMaxBaranzeige); 
setRotation(self.rotationBaranzeige.node, unpack(newRot)); 

setVisibility(self.bar_display , newRot[3] < self.rotationBaranzeige.minRot[3]);

end; 


  if self.isEntered then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
  end;



if g_currentMission.currentVehicle ~= nil and g_currentMission.currentVehicle == self then
  if getInputAxis(Input.AXIS_Y) < 0 or self.motor.speedLevel ~= 0 then
setRotation(self.reversierer, 0, 0, Utils.degToRad(45));
     elseif getInputAxis(Input.AXIS_Y) > 0 then 
setRotation(self.reversierer, 0, 0, Utils.degToRad(-45));
     else
     setRotation(self.reversierer,0,0,0);
  end;




  if getInputAxis(Input.AXIS_Y) < 0 or self.motor.speedLevel ~= 0 then
setRotation(self.gaspedal,Utils.degToRad(19), 0, 0);
     elseif getInputAxis(Input.AXIS_Y) > 0 then 
setRotation(self.gaspedal,Utils.degToRad(19), 0, 0);
     else
     setRotation(self.gaspedal,0,0,0);
  end;

  if getInputAxis(Input.AXIS_Y) == 0 then
setRotation(self.brake,Utils.degToRad(-10), 0, 0);
     else
     setRotation(self.brake,0,0,0);
  end;
	end;


 

	if self.twinWheelsActive then
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive);
		end;
	else
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive, false);
		end;
	end;


		if self.rotationBaranzeige ~= nil then
			local x, y, z = getRotation(self.rotationBaranzeige.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationBaranzeige.maxRot, self.rotationBaranzeige.minRot, 3, self.rotationBaranzeige.rotTime, dt, not self.rotationMaxBaranzeige);
			setRotation(self.rotationBaranzeige.node, unpack(newRot));
		end;


local tankanzeige = self.fuelFillLevel/self.fuelCapacity*100;
local zeigerposition = tankanzeige*self.tankanzeigeMaxRot/100;
	setRotation(self.tankanzeigeIndex , 0 , 0 , Utils.degToRad(zeigerposition) )

	
	
	if self.translationMax ~= nil then
		local x, y, z = getTranslation(self.translationPart.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart.node, unpack(newTrans));
	end;




	
	       if self.rotationPartpanelright ~= nil then
		local x, y, z = getRotation(self.rotationPartpanelright.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpanelright.maxRot, self.rotationPartpanelright.minRot, 3, self.rotationPartpanelright.rotTime, dt, not self.rotationMaxpanelright);
		setRotation(self.rotationPartpanelright.node, unpack(newRot));
	end;
	       if self.rotationPartbackwindow ~= nil then
		local x, y, z = getRotation(self.rotationPartbackwindow.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		setRotation(self.rotationPartbackwindow.node, unpack(newRot));
	end;
	       if self.rotationPartpanelleft ~= nil then
		local x, y, z = getRotation(self.rotationPartpanelleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpanelleft.maxRot, self.rotationPartpanelleft.minRot, 3, self.rotationPartpanelleft.rotTime, dt, not self.rotationMaxpanelleft);
		setRotation(self.rotationPartpanelleft.node, unpack(newRot));
	end;
		--if self.attachedTrailer == nil and self.trailerAttacherJoint2 ~= nil then
	    --local px1, py1, pz1 = getWorldTranslation(self.trailerAttacherJoint1);
		--local px2, py2, pz2 = getWorldTranslation(self.trailerAttacherJoint2);
        --local nearestTrailer = nil
		--local nearestDistance = 0.4;
		--for i=1, table.getn(g_currentMission.trailers) do
			--local vx, vy, vz = getWorldTranslation(g_currentMission.trailers[i].attacherJoint);
	       -- local distance1 = Utils.vector2Length(px1-vx, pz1-vz);
			--local distance2 = Utils.vector2Length(px2-vx, pz2-vz);
			--if distance1 < nearestDistance then
			--	self.trailerAttacherJoint = self.trailerAttacherJoint1;
	       -- end;
           -- if distance2 < nearestDistance then
	       --     self.trailerAttacherJoint = self.trailerAttacherJoint2;
			--end;
        --end;
	--end;

 
end;

function JD_8530:onLeave()
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
	Steerable.onLeave(self);
	end;
self.rotationMaxpanelright = false;
self.rotationMaxpanelleft = false;
self.rotationMaxbackwindow = false;

	Utils.setEmittingState(self.exhaustParticleSystems2, false);
	Utils.setEmittingState(self.exhaustParticleSystems3, false);
	Utils.setEmittingState(self.exhaustParticleSystems4, false);
	Utils.setEmittingState(self.exhaustParticleSystems5, false);

end;


function JD_8530:draw()
  if self.isEntered then
    if self.rundumleuchtenKey ~= nil then
      if self.rundumleuchtenAn then
        --g_currentMission:addExtraPrintText("Taste "..string.upper(string.char(Input[self.rundumleuchtenKey]))..": Rundumleuchte aus");
      else
        --g_currentMission:addExtraPrintText("Taste "..string.upper(string.char(Input[self.rundumleuchtenKey]))..": Rundumleuchte ein");
      end;
    end;
  end;
if self.hudjohndeereOverlay ~= nil then
  if self.bcActive then
    self.hudjohndeereOverlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Taste 0: Controlpanel aus");
		else
			g_currentMission:addExtraPrintText("Taste 0: Controlpanel ein");
		end;

end;

