--
-- Powershift
-- Specialization class for Powershifts
--
-- @author  Hitman
-- @date  28/10/09
--
-- Copyright (C) Hitman, All Rights Reserved.

Powershift = {};

function Powershift.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Powershift:load(xmlFile)
   
   
		
			 
	self.controlpath = Utils.getFilename("Rpm_base.png", self.baseDirectory);
	self.RpmBasePoxX = 0.70;
    self.RpmBasePoxY = 0.114;
    self.RpmBaseWidth = 0.130;
    self.RpmBaseHeight = 0.04;
    self.RpmBaseOverlay = Overlay:new("RpmBaseControl", self.controlpath, self.RpmBasePoxX, self.RpmBasePoxY, self.RpmBaseWidth, self.RpmBaseHeight);
	
	self.controlpath = Utils.getFilename("Rpm_base.png", self.baseDirectory);
	self.HandbrakePoxX = 0.3;
    self.HandbrakePoxY = 0.3;
    self.HandbrakeWidth = 0.400;
    self.HandbrakeHeight = 0.05;
    self.HandbrakeOverlay = Overlay:new("HandbrakeControl", self.controlpath, self.HandbrakePoxX, self.HandbrakePoxY, self.HandbrakeWidth, self.HandbrakeHeight);
	
	self.controlpath = Utils.getFilename("Rpm_base.png", self.baseDirectory);
	self.HandbrakewarningPoxX = 0.25;
    self.HandbrakewarningPoxY = 0.6;
    self.HandbrakewarningWidth = 0.500;
    self.HandbrakewarningHeight = 0.03;
    self.HandbrakewarningOverlay = Overlay:new("HandbrakewarningControl", self.controlpath, self.HandbrakewarningPoxX, self.HandbrakewarningPoxY, self.HandbrakewarningWidth, self.HandbrakewarningHeight);
	
	self.controlpath = Utils.getFilename("PowershiftHud.png", self.baseDirectory);
    self.PowershiftWidth = 0.130;
    self.PowershiftHeight = 0.100;
	self.PowershiftPoxX = 0.70;
    self.PowershiftPoxY = 0.01;
    self.PowershiftOverlay = Overlay:new("PowershiftControl", self.controlpath, self.PowershiftPoxX, self.PowershiftPoxY, self.PowershiftWidth, self.PowershiftHeight);
	self.isAutomatic = false;
	self.gear0 = true;
	self.handbrake = true;
	self.druckLevel = 0;
	self.tankwarn = 100;
	self.groupA = false;
	self.groupB = false;
	self.groupR = false;
	self.groupN = true;	
		
	self.fuelUsage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fuelUsage"), 0.01);
	local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
	local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;



    self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
    self.brakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.brakelight#index"));
	self.reverselight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reverselight#index"));
	
			
	
	handbrakeSoundFile = Utils.getFilename("handbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	brakeSoundFile = Utils.getFilename("brake2.wav", self.baseDirectory);
    self.brakeSoundId = createSample("brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("brake.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    self.brakereleasePlaying = false;
	
	fuelwarningSoundFile = Utils.getFilename("fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	compressorSoundFile = Utils.getFilename("compressor.wav", self.baseDirectory);
    self.compressorSoundId = createSample("compressorSound");
    loadSample(self.compressorSoundId, compressorSoundFile, false);
    self.compressorPlaying = false;
	
	compressorstopSoundFile = Utils.getFilename("compressorstop.wav", self.baseDirectory);
    self.compressorstopSoundId = createSample("compressorstopSound");
    loadSample(self.compressorstopSoundId, compressorstopSoundFile, false);
    self.compressorstopPlaying = false;
	
	PowershiftchangeSoundFile = Utils.getFilename("Powershiftchange.wav", self.baseDirectory);
    self.PowershiftchangeSoundId = createSample("Powershiftchange");
    loadSample(self.PowershiftchangeSoundId, PowershiftchangeSoundFile, false);
    self.PowershiftchangePlaying = false;
end;

function Powershift:delete()

if self.RpmBaseOverlay then
        self.RpmBaseOverlay:delete();
    end;

end;

function Powershift:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Powershift:keyEvent(unicode, sym, modifier, isDown)
	
				
	if self.isAutomatic then
		if isDown and sym == Input.KEY_pageup then
			if self.reverseGear then
				self.neutral = true;
				self.reverseGear = false;
			elseif self.neutral then
				self.forward = true;
				self.neutral = false;
				self.gear1 = true;
			end;
		end;
		if isDown and sym == Input.KEY_pagedown then
			if self.forward then
				self.neutral = true;
				self.forward = false;
			elseif self.neutral then
				self.reverseGear = true;
				self.neutral = false;
				self.gearR1 = true;
			end;
		end;
	end;
	
	
	
	if isDown and sym == Input.KEY_space then
		self.handbrake = not self.handbrake;
		if self.handbrake then
			playSample(self.handbrakeSoundId,1,1,0);
		end;
			end;
	

	
	if isDown and sym == Input.KEY_return then
		self.isAutomatic = not self.isAutomatic;
		self.neutral = true;
		self.reverseGear = false;
		self.forward = false;
	end;
	
	if not self.isAutomatic then
	
				
		if isDown and sym == Input.KEY_pageup then
		
			if self.gearR2 == true then
				self.gearR1 = true;
				self.gearR2 = false;
												
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gearR1 == true then
				self.gear0 = true;
				self.gearR1 = false;
				self.groupA = false;
				self.groupB = false;
				self.groupR = false;
				self.groupN = true;
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);								
			elseif self.gear0 == true then
				self.reverse = false;
				self.gear1 = true;
				self.gear0 = false;
				self.groupN = false;
				self.groupA = true;
				self.groupB = false;
				self.groupR = false;
												
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear1 == true then
				self.gear2 = true;
				self.gear1 = false;
												
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear2 == true then
				self.gear3 = true;
				self.gear2 = false;
												
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear3 == true then
				self.gear4 = true;
				self.gear3 = false;
											
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear4 == true then
				self.gear5 = true;
				self.gear4 = false;
											
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear5 == true then
				self.gear6 = true;
				self.gear5 = false;
												
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear6 == true then
				self.gear6 = false;
				self.gear01 = true;
				self.groupA = false;
				self.groupB = true;
				self.groupR = false;
				self.groupN = false;
				
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear01 == true then
				self.gear02 = true;
				self.gear01 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear02 == true then
				self.gear03 = true;
				self.gear02 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear03 == true then
				self.gear04 = true;
				self.gear03 = false;
				
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear04 == true then
				self.gear05 = true;
				self.gear04 = false;
				
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear05 == true then
				self.gear06 = true;
				self.gear05 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			end;
		end;
	
			
		if isDown and sym == Input.KEY_pagedown then
			
				
			if  self.gear06 == true then
				self.gear05 = true;
				self.gear06 = false;
				
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear05 == true then
				self.gear04 = true;
				self.gear05 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear04 == true then
				self.gear03 = true;
				self.gear04 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear03 == true then
				self.gear02 = true;
				self.gear03 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear02 == true then
				self.gear01 = true;
				self.gear02 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear01 == true then
				  self.gear6 = true;
				  self.gear01 = false;
				  self.groupB = false;
				  self.groupA = true;
				  self.groupN = false;
				  self.groupR = false;
							 
				  playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear6 == true then
				self.gear5 = true;
				self.gear6 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear5 == true then
				self.gear4 = true;
				self.gear5 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear4 == true then
				self.gear3 = true;
				self.gear4 = false;
							
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear3 == true then
				self.gear2 = true;
				self.gear3 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear2 == true then
				self.gear1 = true;
				self.gear2 = false;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear1 == true then
				self.gear0 = true;
				self.gear1 = false;
				self.groupA = false;
				self.groupN = true;
								
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			elseif self.gear0 == true then
				self.gearR1 = true;
				self.reverse = true;
				self.gear0 = false;
				self.groupR = true;
				self.groupA = false;
				self.groupB = false;
				self.groupN = false;
				
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);		
			elseif self.gearR1 == true then
				self.gearR2 = true;
				self.reverse = true;
				self.gearR1 = false;
				
				playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			end;
		end;
		
		
		if not self.isAutomatic then
				
		if isDown and sym == Input.KEY_home then
			
			if self.groupA == true then
		
		self.groupA = false;
		self.groupB = true;
		self.groupR = false;
		self.groupN = false;
				
		playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			
			
			self.gear2 = false;
			self.gearR1 = false;
			self.gear0 = false;
			self.gear1 = false;
			self.gearR2 = false;
			self.gear3 = false;
			self.gear4 = false;
			self.gear5 = false;
			self.gear6 = false;
			self.gear01 = true;
			self.gear02 = false;
			self.gear03 = false;
			self.gear04 = false;
			self.gear05 = false;
			self.gear06 = false;
			self.reverse = false;
		
		
			
		elseif self.groupR == true then
		self.groupA = false;
		self.groupB = false;
		self.groupR = false;
		self.groupN = true;
		
			self.gear2 = false;
			self.gearR1 = false;
			self.gear0 = true;
			self.gear1 = false;
			self.gearR2 = false;
			self.gear3 = false;
			self.gear4 = false;
			self.gear5 = false;
			self.gear6 = false;
			self.gear01 = false;
			self.gear02 = false;
			self.gear03 = false;
			self.gear04 = false;
			self.gear05 = false;
			self.gear06 = false;
			self.reverse = false;
			
			playSample(self.PowershiftchangeSoundId, 1, 1, 0);
			
		elseif self.groupN == true then
		self.groupA = true;
		self.groupB = false;
		self.groupR = false;
		self.groupN = false;
		
			self.gear2 = false;
			self.gearR1 = false;
			self.gear0 = false;
			self.gear1 = true;
			self.gearR2 = false;
			self.gear3 = false;
			self.gear4 = false;
			self.gear5 = false;
			self.gear6 = false;
			self.gear01 = false;
			self.gear02 = false;
			self.gear03 = false;
			self.gear04 = false;
			self.gear05 = false;
			self.gear06 = false;
			self.reverse = false;
			
			playSample(self.PowershiftchangeSoundId, 1, 1, 0);	
			
		elseif self.groupB == true then

		self.groupA = false;
		self.groupB = true;
		self.groupR = false;
		self.groupN = false;
				
		end;
	end;
	
		if isDown and sym == Input.KEY_end then
						
			if self.groupA == true then
			
			self.groupA = false;
			self.groupB = false;
			self.groupR = false;
			self.groupN = true;
			
			self.gearR2 = false;
			self.gearR1 = false;
			self.gear0 = true;
			self.gear1 = false;
			self.gear2 = false;
			self.gear3 = false;
			self.gear4 = false;
			self.gear5 = false;
			self.gear6 = false;
			self.gear01 = false;
			self.gear02 = false;
			self.gear03 = false;
			self.gear04 = false;
			self.gear05 = false;
			self.gear06 = false;
			self.reverse = false;
			
			playSample(self.PowershiftchangeSoundId, 1, 1, 0);
		
		elseif self.groupN == true then
		
			self.groupA = false;
			self.groupB = false;
			self.groupR = true;
			self.groupN = false;
			
			self.gearR2 = false;
			self.gearR1 = true;
			self.gear0 = false;
			self.gear1 = false;
			self.gear2 = false;
			self.gear3 = false;
			self.gear4 = false;
			self.gear5 = false;
			self.gear6 = false;
			self.gear01 = false;
			self.gear02 = false;
			self.gear03 = false;
			self.gear04 = false;
			self.gear05 = false;
			self.gear06 = false;
			self.reverse = true;
			
			playSample(self.PowershiftchangeSoundId, 1, 1, 0);
		
		elseif self.groupR == true then
			
			self.groupA = false;
			self.groupB = false;
			self.groupR = true;
			self.groupN = false;
			
					
			elseif self.groupB == true then
			
			self.groupA = true;
			self.groupB = false;
			self.groupR = false;
			self.groupN = false;
			
			self.gearR2 = false;
			self.gearR1 = false;
			self.gear0 = false;
			self.gear1 = false;
			self.gear2 = false;
			self.gear3 = false;
			self.gear4 = false;
			self.gear5 = false;
			self.gear6 = true;
			self.gear01 = false;
			self.gear02 = false;
			self.gear03 = false;
			self.gear04 = false;
			self.gear05 = false;
			self.gear06 = false;
			self.reverse = false;
			
			playSample(self.PowershiftchangeSoundId, 1, 1, 0);
					
				end;
	
			end;
		end;
	end;
end;

function Powershift:update(dt)


		if self.isMotorStarted then
						
			local fuelUsed = self.motor.lastMotorRpm/1000*self.fuelUsage;
            
			self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);

            g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
            g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		
		end;
	
	
	  if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
			  
			  		  
			self.RpmBaseOverlay:render();
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
			
	    end;
		
	end;
	
	
   	if self.isMotorStarted and not self.isHired  then
	
	    local acceleration = 0;
		local brakeTorque;
        if g_currentMission.allowSteerableMoving and not self.playMotorSound then
           
			if self.reverse then
				if self.gearR1 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = -0.06;
					end;
				elseif self.gearR2 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = -0.2;
					end;
				end;
			else
				if self.gear0 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0;
					end;
				elseif self.gear1 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.05;
					end;
				elseif self.gear2 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.1;
					end;
				elseif self.gear3 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.15;
					end;
				elseif self.gear4 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.19;
					end;
				elseif self.gear5 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.22;
					end;
				elseif self.gear6 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.3;
					end;
					elseif self.gear01 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.3;
					end;
				elseif self.gear02 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.35;
					end;
				elseif self.gear03 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.35;
					end;
				elseif self.gear04 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 0.45;
					end;
				elseif self.gear05 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
					 	acceleration = 0.75;
						end;
				elseif self.gear06 then
					if Input.isKeyPressed(Input.KEY_w) or self.motor.speedLevel ~= 0 then
						acceleration = 1;
					end;
			    end;
			end;
			
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0, true)
			end;
						
        
		if self.isEntered then
		if self.fuelFillLevel < 50 then
			self.tankwarn = self.tankwarn - dt;
			if self.tankwarn <= 0 then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.tankwarn = 30000;
			end;
		else
			self.tankwarn = 30000;
			
		end;
	end;
		
		if self.fuelFillLevel == 0 then
            acceleration = 0;
        end;
			
		if self.isAutomatic then
			if self.forward then
				self.reverse = false;
				
				if self.gear06 then
				if self.motor.lastMotorRpm < 1000 then
						self.gear05 = true;
						self.gear06 = false;
						
				end;				
				elseif self.gear05 then				
				if self.motor.lastMotorRpm < 1000 then
						self.gear04 = true;
						self.gear05 = false;
						
				    elseif self.motor.lastMotorRpm > 1785 then
						self.gear06 = true;
						self.gear05 = false;
						
					end;
				elseif self.gear04 then
				if self.motor.lastMotorRpm < 1000 then
						self.gear03 = true;
						self.gear04 = false;
						
				    elseif self.motor.lastMotorRpm > 1785 then
						self.gear05 = true;
						self.gear04 = false;
						
					end;
				elseif self.gear03 then
				if self.motor.lastMotorRpm < 1000 then
						self.gear02 = true;
						self.gear03 = false;
						
				    elseif self.motor.lastMotorRpm > 1785 then
						self.gear04 = true;
						self.gear03 = false;
						
					end;
				elseif self.gear02 then
				if self.motor.lastMotorRpm < 1000 then
						self.gear01 = true;
						self.gear02 = false;
						
				    elseif self.motor.lastMotorRpm > 1785 then
						self.gear03 = true;
						self.gear02 = false;
						
					end;
				elseif self.gear01 then
				if self.motor.lastMotorRpm < 1000 then
						self.gear6 = true;
						self.gear01 = false;
						self.groupA = true;
						self.groupB = false;
						self.groupN = false;
						
				    elseif self.motor.lastMotorRpm > 1785 then
						self.gear02 = true;
						self.gear01 = false;
						
					end;
				
				elseif self.gear6 then
					if self.motor.lastMotorRpm < 1000 then
						self.gear5 = true;
						self.gear6 = false;
						
				    elseif self.motor.lastMotorRpm > 1785 then
						self.gear01 = true;
						self.gear6 = false;
						self.groupA = false;
						self.groupB = true;
						self.groupN = false;
						
					end;
				elseif self.gear5 then
					if self.motor.lastMotorRpm < 950 then
						self.gear4 = true;
						self.gear5 = false;
						
					elseif self.motor.lastMotorRpm > 1785 then
						self.gear6 = true;
						self.gear5 = false;
						
					end;
				elseif self.gear4 then
					if self.motor.lastMotorRpm < 950 then
						self.gear3 = true;
						self.gear4 = false;
						
					elseif self.motor.lastMotorRpm > 1750 then
						self.gear5 = true;
						self.gear4 = false;
						
					end;
				elseif self.gear3 then
					if self.motor.lastMotorRpm < 950 then
						self.gear2 = true;
						self.gear3 = false;
						
					elseif self.motor.lastMotorRpm > 1700 then
						self.gear4 = true;
						self.gear3 = false;
						
					end;
				elseif self.gear2 then
					if self.motor.lastMotorRpm < 950 then
						self.gear1 = true;
						self.gear2 = false;
						
					elseif self.motor.lastMotorRpm > 1700 then
						self.gear3 = true;
						self.gear2 = false;
						
					end;
				elseif self.gear1 then
					if self.motor.lastMotorRpm > 1700 then
						self.gear2 = true;
						self.gear1 = false;
						
					end;
				end;
				self.gear0 = false;			
			end;
			if self.neutral then
				self.gear0 = true;
				self.gearR1 = false;
				self.gearR2 = false;
				self.gear1 = false;
				self.gear2 = false;
				self.gear3 = false;
				self.gear4 = false;
				self.gear5 = false;
				self.gear6 = false;
				self.gear01 = false;
				self.gear02 = false;
				self.gear03 = false;
				self.gear04 = false;
				self.gear05 = false;
				self.gear06 = false;
				self.reverse = false;
				self.groupA = false;
				self.groupN = true;
				self.groupB = false;
				self.groupR = false;
			end;
			if self.reverseGear then
				self.reverse = true;
				self.gruppaR = true;
				self.groupA = false;
				self.gruppaB = false;
				self.groupN = false;
				if self.gearR2 then
					if self.motor.lastMotorRpm < 600 then
						self.gearR1 = true;
						self.gearR2 = false;
						
					end;
				elseif self.gearR1 then
					if self.motor.lastMotorRpm > 1750 then
						self.gearR2 = true;
						self.gearR1 = false;
						
					end;
				end;
				self.gear0 = false;
			end;
		end;
		
			
			
        end;
		if not self.handbrake then
			brakeTorque = 0.00001;
			self.motor.brakeForce = brakeTorque;
			setVisibility(self.handbrakelight, false);
		else
			if not Input.isKeyPressed(Input.KEY_s) then
				brakeTorque = 50;
				self.motor.brakeForce = brakeTorque;
				acceleration = 0;
				setVisibility(self.reverselight, true);
			end;
		end;		
		if Input.isKeyPressed(Input.KEY_s) then
			if not self.druckWarning then
				if not self.braking then
					if self.attachedTrailer then
						self.druckLevel = self.druckLevel -450;
					else
						self.druckLevel = self.druckLevel -250;
					end;
					self.braking = true;
				end;
				brakeTorque = 20;
				setVisibility(self.brakelight, true);
				self.motor.brakeForce = brakeTorque;
				acceleration = 0;
				if not self.brakePlaying then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;				
			end;
		else
			self.brakePlaying = false;
			setVisibility(self.brakelight, false);
			self.braking = false;
			if not self.handbrake then
				brakeTorque = 0.00001;
				self.motor.brakeForce = brakeTorque;
			end;
			if not self.brakereleasePlaying then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;

        if self.firstTimeRun then
            WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
        end;
		
		
		
		local ratio = 0;
		local rpmRange = 0;
		if self.gearR2 then
			ratio = 6.5;
			rpmRange = 140;
			setVisibility(self.reverselight, true);
		elseif self.gearR1 then
			ratio = 14;
			rpmRange = 130;
			setVisibility(self.reverselight, true);
		elseif self.gear0 then
			ratio = 0;
			setVisibility(self.reverselight, false);
		elseif self.gear1 then
			ratio = 28;
			rpmRange = 120;
			setVisibility(self.reverselight, false);
		elseif self.gear2 then
			ratio = 24;
			rpmRange = 110;
			setVisibility(self.reverselight, false);
		elseif self.gear3 then
			ratio = 20;
			rpmRange = 100;
			setVisibility(self.reverselight, false);
		elseif self.gear4 then
			ratio = 17;
			rpmRange = 90;
			setVisibility(self.reverselight, false);
		elseif self.gear5 then
			ratio = 15;
			rpmRange = 80;
			setVisibility(self.reverselight, false);
		elseif self.gear6 then
			ratio = 9;
			rpmRange = 70;
			setVisibility(self.reverselight, false);
		elseif self.gear01 then
			ratio = 7;
			rpmRange = 60;
			setVisibility(self.reverselight, false);
		elseif self.gear02 then
			ratio = 6.5;
			rpmRange = 50;
			setVisibility(self.reverselight, false);
		elseif self.gear03 then
			ratio = 5.4;
			rpmRange = 40;
			setVisibility(self.reverselight, false);
		elseif self.gear04 then
			ratio = 4.0;
			rpmRange = 15;
			setVisibility(self.reverselight, false);
		elseif self.gear05 then
			ratio = 3.0;
			rpmRange = 10;
			setVisibility(self.reverselight, false);
		elseif self.gear06 then
			ratio = 2.27;
			rpmRange = 1;
			setVisibility(self.reverselight, false);
		end;
		
		self.motor.backwardGearRatio = ratio;
		self.motor.forwardGearRatios = {ratio/2,ratio/1.5,ratio};
		self.motor.rpmFadeOutRange = rpmRange;				
		
		if self.druckLevel >= -1 and self.druckLevel <= 6100 then
			self.compressorStart = true;
		end;
		if self.druckLevel >= 9999 then
			self.compressorStart = false;
		end;
		if self.compressorStart == true then
			if not self.compressorSoundRunning then
				playSample(self.compressorSoundId, 0, 1, 0);
				self.compressorSoundRunning = true;
			end;
			self.compressorstopSoundRunning = false;
			if self.druckLevel <= 10000 then
				self.druckLevel = self.druckLevel +(dt/3);
			end;
		end;
	
		if not self.isMotorStarted then
		
			stopSample(self.compressorSoundId, 0, 1, 0);
			end;
		
		if self.compressorStart == false then
			stopSample(self.compressorSoundId, 0, 1, 0);
			self.compressorSoundRunning = false;
			if not self.compressorstopSoundRunning then
				playSample(self.compressorStopSoundId, 1, 1, 0);
				self.compressorstopSoundRunning = true;
			end;
			if self.druckLevel >= 6099 then
				self.druckLevel = self.druckLevel -(dt/40);
			end;
		end;
		if self.druckLevel <= 6000 then
			self.druckWarning = true;
			self.drucklightActive = true;
		else
			self.druckWarning = false;
			self.drucklightActive = false;
				end;
		
		
		
		end;							
		
		if self.isHired then
		
		 local acceleration = 0;
            if g_currentMission.allowSteerableMoving and not self.playMotorSound then
                acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
                if InputBinding.isAxisZero(acceleration) then
                    acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
                end;
                if math.abs(acceleration) > 0.8 then
                    self.motor:setSpeedLevel(0, true)
                end;
                if self.motor.speedLevel ~= 0 then
                    acceleration = 1.0;
                end;
             
          end;
		
		
			end;
	end;
	


function Powershift:draw()

	
	if self.isMotorStarted then	
			
			self.RpmBaseOverlay:render();
			
        if self.motor.speedLevel ~= 0 then
				setTextBold(true);
				setTextColor(0,1,0,1);
				renderText(self.RpmBasePoxX+0.0, self.RpmBasePoxY+0.0, 0.03,string.format("%d U/min",self.motor.maxRpm[self.motor.speedLevel]*2));
        else
			setTextBold(true);
			renderText(self.RpmBasePoxX+0.0, self.RpmBasePoxY+0.0, 0.03,string.format("%d U/min",self.motor.lastMotorRpm *2));
             end;
	end;



	if self.isEntered then
		if self.PowershiftOverlay ~= nil then
			self.PowershiftOverlay:render();
		end;
		if self.handbrake then
			setTextBold(true);
			setTextColor(1,0,0,1);
			if Input.isKeyPressed(Input.KEY_w) then
				self.HandbrakeOverlay:render();
				setTextBold(true);
				setTextColor(1,0,0,1);
				renderText(self.HandbrakePoxX + 0.0,self.HandbrakePoxY + 0.0, 0.05, string.format("%s", g_i18n:getText("Handbrake warning")));
			end;
			renderText(self.PowershiftPoxX+0.0, self.PowershiftPoxY+0.0, 0.019, string.format("%s", g_i18n:getText("Handbrake activ")));	
			
		end;
		
		setTextBold(true);
		if not self.isAutomatic then
			if self.gearR2 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.045, self.PowershiftPoxY+0.08, 0.018, "R2");
				else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.045, self.PowershiftPoxY+0.08, 0.018, "R2");
			end;
			if self.gearR1 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.045, self.PowershiftPoxY+0.035, 0.018, "R1");
			else 
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.045, self.PowershiftPoxY+0.035, 0.018, "R1");
			end;
			if self.gear0 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.064, self.PowershiftPoxY+0.035, 0.018, "N");
			else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.064, self.PowershiftPoxY+0.035, 0.018, "N");
			end;
			if self.gear1 or self.gear01 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.005, self.PowershiftPoxY+0.08, 0.018, "1");
			else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.005, self.PowershiftPoxY+0.08, 0.018, "1");
			end;
			if self.gear2 or self.gear02 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.005, self.PowershiftPoxY+0.035, 0.018, "2");
			else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.005, self.PowershiftPoxY+0.035, 0.018, "2");
			end;
			if self.gear3 or self.gear03 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.017, self.PowershiftPoxY+0.08, 0.018, "3");
			else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.017, self.PowershiftPoxY+0.08, 0.018, "3");
			end;
			if self.gear4 or self.gear04 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.017, self.PowershiftPoxY+0.035, 0.018, "4");
			else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.017, self.PowershiftPoxY+0.035, 0.018, "4");
			end;
			if self.gear5 or self.gear05 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.0293, self.PowershiftPoxY+0.08, 0.018, "5");
			else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.0293, self.PowershiftPoxY+0.08, 0.018, "5");
			end;
			if self.gear6 or self.gear06 then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.0293, self.PowershiftPoxY+0.035, 0.018, "6");
			else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.0293, self.PowershiftPoxY+0.035, 0.018,"6");
			end;
			if self.groupA == true then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.089, self.PowershiftPoxY+0.035, 0.018, "A");
			else 
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.089, self.PowershiftPoxY+0.035, 0.018, "A");
				end;
			if self.groupB == true then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.089, self.PowershiftPoxY+0.08, 0.018, "B");
			else 
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.089, self.PowershiftPoxY+0.08, 0.018, "B");
				end;
			end;
		if self.isAutomatic then
				setTextColor(1,1,1,1);
			renderText(self.PowershiftPoxX+0.02, self.PowershiftPoxY+0.015, 0.02, "Automatik");
			if self.forward then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.02, self.PowershiftPoxY+0.03, 0.02, "V");
			else
				setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.02, self.PowershiftPoxY+0.03, 0.02, "V");
			end;
			
			if self.neutral then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.045, self.PowershiftPoxY+0.03, 0.02, "N");
		else
			setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.045, self.PowershiftPoxY+0.03, 0.02, "N");
			end;
		if self.reversePowershift then
				setTextColor(0,1,0,1);
				renderText(self.PowershiftPoxX+0.07, self.PowershiftPoxY+0.03, 0.02, "R");
		else
			setTextColor(1,1,1,1);
				renderText(self.PowershiftPoxX+0.07, self.PowershiftPoxY+0.03, 0.02, "R");
			end;
		end;
		if self.druckWarning then
			self.HandbrakewarningOverlay:render();
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(self.HandbrakewarningPoxX + 0.0, self.HandbrakewarningPoxY + 0.0, 0.03,string.format("%s", g_i18n:getText("Air warning")));
		end;
	end;
end;

function Powershift:onEnter()
	
end;

function Powershift:onLeave()
	
	if not self.isAITractorActivated then
		
	self.gear0 = true;
	self.neutral = true;
	self.groupN = true;
	self.groupA = false;
	self.groupB = false;
	self.groupR = false;
	self.isAutomatic = false;
	self.gearR2 = false;
	self.gearR1 = false;
	self.gear1 = false;
	self.gear2 = false;
	self.gear3 = false;
	self.gear4 = false;
	self.gear5 = false;
	self.gear6 = false;
	self.gear01 = false;
	self.gear02 = false;
	self.gear03 = false;
	self.gear04 = false;
	self.gear05 = false;
	self.gear06 = false;
	self.forward = false;
	self.reverseGear = false;
	self.handbrake = true;
	stopSample(self.compressorSoundId, 0, 1, 0);
	stopSample(self.fuelwarningSoundId,1,1,0);
else
	stopSample(self.compressorSoundId, 0, 1, 0);
	stopSample(self.fuelwarningSoundId,1,1,0);
end;

end;

function Powershift:drawGrainLevel(level, capacity, warnPercent)

end;
