--
-- johnDeereHud
-- HUD script for the 8530
--
-- @author  Templaer
-- @date  12/06/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

johnDeereHud = {};

function johnDeereHud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function johnDeereHud:load(xmlFile)
    -- Information Hud Dimensions
	self.hudInfoBasePosX = 0.012;
    self.hudInfoBaseWidth = 0.4-0.012;
    self.hudInfoBasePosY = 1-0.99;
    self.hudInfoBaseHeight = 0.3;
	
	-- The actual overlay
	self.infoPanelPath = Utils.getFilename("hud_info_base.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
		
	-- Boolean to show or hide the 
	self.showHudInfoBase = true;
end;

function johnDeereHud:delete()
    if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
end;

function johnDeereHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function johnDeereHud:keyEvent(unicode, sym, modifier, isDown)
end;

function johnDeereHud:update(dt)
    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.TOGGLEHUD) then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;
end;
	
function johnDeereHud:draw()
	if self.showHudInfoBase and self.isEntered then
		self.hudInfoBaseOverlay:render();
	end;
end;

