--
-- 
-- Forklift Script by Zippo
--
--

Forklift = {}

function Forklift.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Forklift:load(xmlFile)        
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
    local translationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;
    local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;

hydraFL1SoundFile = Utils.getFilename("hydraFL1.wav", self.baseDirectory);
    self.hydraFL1SoundId = createSample("HYDFL1_hydraFL1");
    loadSample(self.hydraFL1SoundId, hydraFL1SoundFile, false);
    self.hydraFL1Playing = false;
    
hydraFL2SoundFile = Utils.getFilename("hydraFL2.wav", self.baseDirectory);
    self.hydraFL2SoundId = createSample("HYDFL2_hydraFL2");
    loadSample(self.hydraFL2SoundId, hydraFL2SoundFile, false);
    self.hydraFL2Playing = false;

end;
      
function Forklift:delete()    
end;

function Forklift:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Forklift:keyEvent(unicode, sym, modifier, isDown)

    if sym == Input.KEY_KP_7 then
		self.translationMax = isDown;
		self.translationMax2 = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.translationMin = isDown;
		self.translationMin2 = isDown;
	end;
	if sym == Input.KEY_KP_9 then
		self.rotation1Max = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.rotation1Min = isDown;
	end;
end;

function Forklift:update(dt)
	
	local doTranslate = self.translationMax or self.translationMin 
	if self.translationPart ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationPart.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax); 
		setTranslation(self.translationPart.node, unpack(newTrans));
		if not self.hydraFL1Playing then
            playSample(self.hydraFL1SoundId, 0, 1, 0);
            self.hydraFL1Playing = true;
        end;
    else
        if self.hydraFL1Playing then
            stopSample(self.hydraFL1SoundId);
            self.hydraFL1Playing = false;
        end; 
	end; 
	local doTranslate = self.translationMax2 or self.translationMin2 
	if self.translationPart2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationPart2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2); 
		setTranslation(self.translationPart2.node, unpack(newTrans)); 
	end;
	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
		if not self.hydraFL2Playing then
            playSample(self.hydraFL2SoundId, 0, 1, 0);
            self.hydraFL2Playing = true;
        end;
    else
        if self.hydraFL2Playing then
            stopSample(self.hydraFL2SoundId);
            self.hydraFL2Playing = false;
        end;
    end;
end;

function Forklift:draw()
end;

function Forklift:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
