
--
-- rpmRange
-- Specialization for a rpm range limiter
--
-- @author  Templaer
-- @date  01/05/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

rpmRange = {};

function rpmRange.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function rpmRange:load(xmlFile)
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    self.motorMaxRpmLimit = motorMaxRpm3;
end;

function rpmRange:delete()
end;

function rpmRange:mouseEvent(posX, posY, isDown, isUp, button)
end;

function rpmRange:keyEvent(unicode, sym, modifier, isDown)
end;

function rpmRange:update(dt)
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	    if self.motor.speedLevel ~= 0 then
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
		else
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			        self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;	
	    end;
	end;
end;

function rpmRange:draw()
    if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
			g_currentMission:addExtraPrintText(string.format("Taste %s/%s: %d RPM", InputBinding.getButtonKeyName(InputBinding.ACCELERATE), InputBinding.getButtonKeyName(InputBinding.DECELERATE), self.motor.maxRpm[self.motor.speedLevel]));
	    else
			g_currentMission:addExtraPrintText(string.format("Taste %s/%s: %d RPM", InputBinding.getButtonKeyName(InputBinding.ACCELERATE), InputBinding.getButtonKeyName(InputBinding.DECELERATE), self.motor.maxRpm[3]));
	    end;
	end;
end;

