
--
-- infoHud
-- Specialization for hand throttle on steerables
--
-- @author  Templaer
-- @date  12/06/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

infoHud = {};

function infoHud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function infoHud:load(xmlFile)
    -- Information Hud Dimensions
	self.hudInfoBasePosX = 0.012;
    self.hudInfoBaseWidth = 0.437-0.012;
    self.hudInfoBasePosY = 1-0.99;
    self.hudInfoBaseHeight = 0.22;
	
	-- The actual overlay
	self.infoPanelPath = Utils.getFilename("hud_info_base.png", self.baseDirectory);
	self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
	
	-- Array for the HUD texts
	self.infoButtonTexts = {};
	
	-- Boolean to show or hide the 
	self.showHudInfoBase = true;
end;

function infoHud:delete()
    if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
end;

function infoHud:mouseEvent(posX, posY, isDown, isUp, button)
end;

function infoHud:keyEvent(unicode, sym, modifier, isDown)
end;

function infoHud:update(dt)
    if self.isEntered then
		if InputBinding.hasEvent(InputBinding.TOGGLEHUD) then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;
end;
	
function infoHud:draw()
	if self.showHudInfoBase and self.isEntered then
	
		local renderTextsLeft = {};
		local renderTextsRight = {};

		local printText;
		local printButton;
		
		if not self.isMotorStarted then	
		    if self.ignitionKey ~= nil then
			    printText = g_i18n:getText("Start");
				printButton = InputBinding.IGNITION;
			end;
		else
		    if self.accDirection ~= nil then
			    if self.accDirection == -1 then
					table.insert(self.infoButtonTexts, {text=g_i18n:getText("Shuttle1"), button=InputBinding.REVERSE});
				else
				    table.insert(self.infoButtonTexts, {text=g_i18n:getText("Shuttle2"), button=InputBinding.REVERSE});
				end;
			end;
						
			if self.handThrottleEnabled ~= nil then
			    if self.handThrottleEnabled then
				    if self.backupMinRpm ~= nil then
						table.insert(self.infoButtonTexts, {text=g_i18n:getText("EngineManagement1"), button=InputBinding.RESETRPM});
					else
					    table.insert(self.infoButtonTexts, {text=g_i18n:getText("HandThrottle1"), button=InputBinding.RESETRPM});
					end;
				end;
			end;
						
			if self.cruiseControl ~= nil then
			    if self.cruiseControl then
				    table.insert(self.infoButtonTexts, {text=g_i18n:getText("CruiseControl2"), button=InputBinding.CRUISECONTROL});
				else
					table.insert(self.infoButtonTexts, {text=g_i18n:getText("CruiseControl1"), button=InputBinding.CRUISECONTROL});
				end;
			end;
			
			if self.workLightsActive ~= nil then
				table.insert(self.infoButtonTexts, {text=g_i18n:getText("Worklights"), button=InputBinding.WORKLIGHTS});
			end;
			
			if self.backupChopperBlind ~= nil then
				if self.strawActive then
					table.insert(self.infoButtonTexts, {text=g_i18n:getText("strawCutOn"), button=InputBinding.STRAW_TOGGLE});
				else
					table.insert(self.infoButtonTexts, {text=g_i18n:getText("strawCutOff"), button=InputBinding.STRAW_TOGGLE});
				end;
			end;
			
		    if self.ignitionKey ~= nil then
			    printText = g_i18n:getText("Stop");
				printButton = InputBinding.IGNITION;
			end;
			
			table.insert(self.infoButtonTexts, {text=g_i18n:getText("ToggleHud"), button=InputBinding.TOGGLEHUD});
		end;

		if printText ~= nil and printButton ~= nil then
			if InputBinding.getButtonName(printButton) ~= nil then
				table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " .. InputBinding.getButtonKeyName(printButton).." " .. g_i18n:getText("or") .. " " .. g_i18n:getText("Button") .. " "..InputBinding.getButtonName(printButton)..":"));
			else
				table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " .. InputBinding.getButtonKeyName(printButton)..":"));
			end;
			table.insert(renderTextsRight, (printText));
		end;
				
		for i=1, table.getn(self.infoButtonTexts) do
			local button = self.infoButtonTexts[i].button;
			
			if InputBinding.getButtonName(button) ~= nil then
				table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " ..InputBinding.getButtonKeyName(button).." " .. g_i18n:getText("or") .. " " .. g_i18n:getText("Button") .. " "..InputBinding.getButtonName(button)..":"));
			else	
				table.insert(renderTextsLeft, (g_i18n:getText("Key") .. " " ..InputBinding.getButtonKeyName(button)..":"));
			end;
			
			table.insert(renderTextsRight, self.infoButtonTexts[i].text);
		end;
		self.infoButtonTexts = {};
		
		if table.getn(renderTextsLeft) >= 1 then
			self.hudInfoBaseOverlay:render();
		end;
		
		local num = math.min(6, table.getn(renderTextsLeft));
		
		for i=1, num do
			local left = renderTextsLeft[i];
			local right = renderTextsRight[i];
			renderText(0.03, (6-i)*0.03+(1-0.97), 0.025, left);
			renderText(0.221, (6-i)*0.03+(1-0.97), 0.025, right);
		end;
	end;
end;

