AnimatedParts = {};

function AnimatedParts.prerequisitesPresent(specializations)
    return true;
end;

function AnimatedParts:load(xmlFile)
	self.SetGrainFlap = SpecializationUtil.callSpecializationsFunction("SetGrainFlap");
	self.SetEngineFlap = SpecializationUtil.callSpecializationsFunction("SetEngineFlap");
	
	-- Animations --
	self.GrainFlapAnimation = getXMLString(xmlFile, "vehicle.GrainFlap#animationName");
	self.EngineFlapAnimation = getXMLString(xmlFile, "vehicle.EngineFlap#animationName");
	
	self.grainFlap = true;
	self.engineFlap = true;
end;

function AnimatedParts:delete()
end;

function AnimatedParts:readStream(streamId, connection)
	self:SetGrainFlap(streamReadBool(streamId), true);
	self:SetEngineFlap(streamReadBool(streamId), true);
end;

function AnimatedParts:writeStream(streamId, connection)
	streamWriteBool(streamId, self.grainFlap);
    streamWriteBool(streamId, self.engineFlap);
end;

function AnimatedParts:readUpdateStream(streamId, timestamp, connection)
end;

function AnimatedParts:writeUpdateStream(streamId, connection, dirtyMask)
end;

function AnimatedParts:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimatedParts:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimatedParts:update(dt)	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.AnimatedParts_ToggleGrainFlap) then
			self:SetGrainFlap(not self.grainFlap);
		end;
		if InputBinding.hasEvent(InputBinding.AnimatedParts_ToggleEngineFlap) then
			self:SetEngineFlap(not self.engineFlap);
		end;
	end;
end;

function AnimatedParts:updateTick(dt)	
end;

function AnimatedParts:SetGrainFlap(grainFlapState,noEventSend)
	SetGrainFlapEvent.sendEvent(self, grainFlapState, noEventSend);
	if grainFlapState then
		if self.GrainFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.GrainFlapAnimation, -1, nil, true);
			self.grainFlap = true;
		end;
	else
		if self.GrainFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.GrainFlapAnimation, 1, nil, true);
			self.grainFlap = false;
		end;
	end;
end;

function AnimatedParts:SetEngineFlap(engineFlapState,noEventSend)
	SetEngineFlapEvent.sendEvent(self, engineFlapState, noEventSend);
	if engineFlapState then
		if self.EngineFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.EngineFlapAnimation, -1, nil, true);
			self.engineFlap = true;
		end;
	else
		if self.EngineFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.EngineFlapAnimation, 1, nil, true);
			self.engineFlap = false;
		end;
	end;
end;

function AnimatedParts:draw()
	if self.grainFlap then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("AnimatedParts_OpenGrainFlap"), self.typeDesc), InputBinding.AnimatedParts_ToggleGrainFlap);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("AnimatedParts_CloseGrainFlap"), self.typeDesc), InputBinding.AnimatedParts_ToggleGrainFlap);
	end;
	if self.engineFlap then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("AnimatedParts_OpenEngineFlap"), self.typeDesc), InputBinding.AnimatedParts_ToggleEngineFlap);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("AnimatedParts_CloseEngineFlap"), self.typeDesc), InputBinding.AnimatedParts_ToggleEngineFlap);
	end;
end;