--
-- loaderLevers
-- This is the specialization for vehicles which have movable parts
--
-- @author  PeterJ - euroDZN
-- @date  02/04/2012
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.
  
loaderLevers = {};
  
function loaderLevers.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;
  
function loaderLevers:load(xmlFile)
  
	--- increase rpm ---
 	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.saveMinRpm = self.motor.minRpm;
	
	--- move levers ---
	self.lastArmAngle = 0;
	self.mainArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.mainArmLever#mainArm"));
	self.mainArmLever = {};
	self.mainArmLever.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.mainArmLever#index"));
	if self.mainArmLever.node ~= nil then
		self.mainArmLever.minRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.mainArmLever#minRot"))};
		self.mainArmLever.maxRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.mainArmLever#maxRot"))};
		self.mainArmLever.Rot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.mainArmLever#Rot"))};
		self.mainArmLever.rotTime = getXMLFloat(xmlFile, "vehicle.mainArmLever#rotTime")*1000;
		self.mainArmLever.posX = true;
		self.mainArmLever.posZ = true;
	end;
	
	self.lastToolAngle = 0;
	self.toolReference = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.toolArmLever#toolFrame"));
	self.toolArmLever = {};
	self.toolArmLever.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.toolArmLever#index"));
	if self.toolArmLever.node ~= nil then
		self.toolArmLever.minRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.toolArmLever#minRot"))};
		self.toolArmLever.maxRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.toolArmLever#maxRot"))};
		self.toolArmLever.Rot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.toolArmLever#Rot"))};
		self.toolArmLever.rotTime = getXMLFloat(xmlFile, "vehicle.toolArmLever#rotTime")*1000;
		self.toolArmLever.posX = true;
		self.toolArmLever.posZ = true;
	end;
end;
  
function loaderLevers:delete()
end;
  
function loaderLevers:readStream(streamId, connection)
end;
  
function loaderLevers:writeStream(streamId, connection)
end;
  
function loaderLevers:readUpdateStream(streamId, timestamp, connection)
end;
  
function loaderLevers:writeUpdateStream(streamId, connection, dirtyMask)
end;

function loaderLevers:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function loaderLevers:keyEvent(unicode, sym, modifier, isDown)
end;
 
function loaderLevers:update(dt)
end;
  
function loaderLevers:updateTick(dt)
	if self:getIsActive() then	
		local revUp = false;
		if self.mainArm ~= nil then
			--- arm lever ---
			local x,_,_ = getRotation(self.mainArm);
			self.armMoveAngle = x;
			if self.lastArmAngle > self.armMoveAngle then
				self.mainArmLever.posX = true;
				x,y,z = getRotation(self.mainArmLever.node);	
				local newRot = Utils.getMovedLimitedValues({x}, self.mainArmLever.maxRot, self.mainArmLever.minRot, 1, self.mainArmLever.rotTime, dt, true);
				setRotation(self.mainArmLever.node, newRot[1],y,z);
				revUp = true;
			elseif self.lastArmAngle < self.armMoveAngle then
				self.mainArmLever.posX = false;
				x,y,z = getRotation(self.mainArmLever.node);	
				local newRot = Utils.getMovedLimitedValues({x}, self.mainArmLever.maxRot, self.mainArmLever.minRot, 1, self.mainArmLever.rotTime, dt, false );
				setRotation(self.mainArmLever.node, newRot[1],y,z);
				revUp = true;	
			end;
			if self.lastArmAngle == self.armMoveAngle then
				if self.mainArmLever.posX then
					x,y,z = getRotation(self.mainArmLever.node);	
					local newRot = Utils.getMovedLimitedValues({x}, self.mainArmLever.minRot, self.mainArmLever.Rot, 1, self.mainArmLever.rotTime/2, dt, true);
					setRotation(self.mainArmLever.node, newRot[1],y,z);
				else
					x,y,z = getRotation(self.mainArmLever.node);	
					local newRot = Utils.getMovedLimitedValues({x}, self.mainArmLever.maxRot, self.mainArmLever.Rot, 1, self.mainArmLever.rotTime/2, dt, true);
					setRotation(self.mainArmLever.node, newRot[1],y,z);		
				end;
			end;
			self.lastArmAngle = self.armMoveAngle;
		end;
		if self.toolReference ~= nil then
			--- tool lever ---
			local x,_,_ = getRotation(self.toolReference);
			self.toolMoveAngle = x;
			if self.lastToolAngle > self.toolMoveAngle then
				self.toolArmLever.posX = true;
				x,y,z = getRotation(self.toolArmLever.node);	
				local newRot = Utils.getMovedLimitedValues({x}, self.toolArmLever.maxRot, self.toolArmLever.minRot, 1, self.toolArmLever.rotTime, dt, true);
				setRotation(self.toolArmLever.node, newRot[1],y,z);
				revUp = true;
			elseif self.lastToolAngle < self.toolMoveAngle then
				self.toolArmLever.posX = false;
				x,y,z = getRotation(self.toolArmLever.node);	
				local newRot = Utils.getMovedLimitedValues({x}, self.toolArmLever.maxRot, self.toolArmLever.minRot, 1, self.toolArmLever.rotTime, dt, false );
				setRotation(self.toolArmLever.node, newRot[1],y,z);	
				revUp = true;	
			end;
			if self.lastToolAngle == self.toolMoveAngle then
				if self.toolArmLever.posX then
					x,y,z = getRotation(self.toolArmLever.node);	
					local newRot = Utils.getMovedLimitedValues({x}, self.toolArmLever.minRot, self.toolArmLever.Rot, 1, self.toolArmLever.rotTime/2, dt, true);
					setRotation(self.toolArmLever.node, newRot[1],y,z);
				else
					x,y,z = getRotation(self.toolArmLever.node);	
					local newRot = Utils.getMovedLimitedValues({x}, self.toolArmLever.maxRot, self.toolArmLever.Rot, 1, self.toolArmLever.rotTime/2, dt, true);
					setRotation(self.toolArmLever.node, newRot[1],y,z);		
				end;
			end;
			self.lastToolAngle = self.toolMoveAngle;
		end;
		self:setVehicleRpmUp(dt, revUp);
	end;
end;
  
function loaderLevers:draw()
end;

function loaderLevers:setVehicleRpmUp(dt, isActive)
	if self.isMotorStarted and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.motor.minRpm = math.max(self.motor.minRpm-dt, -1000);
			else
				self.motor.minRpm = math.min(self.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.motor.minRpm = self.saveMinRpm;
		end;
		local fuelUsed = 0.0000011*math.abs(self.motor.minRpm);
		self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);
		g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
		g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
	end;
end;