-- MapDoorTrigger
-- Script for MapDoorTriggers
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ web http://www.vertexdezign.net/
-- @ Last Edit  19/08/2013

MapDoorTrigger = {};
MapDoorTrigger.doorTriggers = {};
MapDoorTrigger.nodeToDoorTrigger = {};
MapDoorTrigger.nameToDoorTrigger = {};
MapDoorTrigger.saveTable = {};
MapDoorTrigger.baseDirectory = g_currentModDirectory;

-- saveSelectedGame Wrapper
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	MapDoorTrigger:saveDoorTriggerStates();
end;

local Server_sendObjects_old = Server.sendObjects;
function Server:sendObjects(connection, x,y,z, viewDistanceCoeff)
	for _,doorTrigger in pairs(MapDoorTrigger.doorTriggers) do
		connection:sendEvent(SetDoorStateEvent:new(doorTrigger, doorTrigger.doorIsOpened));
	end;
    Server_sendObjects_old(self, connection, x,y,z, viewDistanceCoeff);
end;

--Fixing Steerable
SteerableDoorTrigger = {}
function SteerableDoorTrigger:load(configFile, positionX, offsetY, positionZ, yRot, typeName)
	self.onEnteredMapDoorTrigger = SteerableDoorTrigger.onEnteredMapDoorTrigger;
	self.onLeavedMapDoorTrigger = SteerableDoorTrigger.onLeavedMapDoorTrigger;
	self.activeMapDoorTriggers = {};
end;

function SteerableDoorTrigger:onEnteredMapDoorTrigger(trigger)
	table.insert(self.activeMapDoorTriggers, 1, trigger);
end;

function SteerableDoorTrigger:onLeavedMapDoorTrigger(trigger)
	for k,v in pairs(self.activeMapDoorTriggers) do
		if v == trigger then
			table.remove(self.activeMapDoorTriggers, k);
			break;
		end;
	end;
end;

function SteerableDoorTrigger:update(dt)
	if table.getn(self.activeMapDoorTriggers) > 0 and self:getIsActiveForInput() then
		local trigger = self.activeMapDoorTriggers[1];
		if trigger.isEnabled then
			if InputBinding.hasEvent(trigger.inputKey)and trigger.isEnabled then
				trigger:setDoorState(not trigger.doorIsOpened);
			end;
		end;
	end;
end;

function SteerableDoorTrigger:draw()
	if table.getn(self.activeMapDoorTriggers) > 0 then
		local trigger = self.activeMapDoorTriggers[1];
		if trigger.isEnabled then
			if trigger.doorIsOpened then
				g_currentMission:addHelpButtonText(g_i18n:getText(trigger.negText), trigger.inputKey);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText(trigger.posText), trigger.inputKey);
			end;
			if MapDoorTrigger.hudDoorTriggerOverlay ~= nil then
				MapDoorTrigger.hudDoorTriggerOverlay:render();
			end;
		end;
	end;
end;
Steerable.load   = Utils.appendedFunction(Steerable.load, SteerableDoorTrigger.load);
Steerable.update   = Utils.appendedFunction(Steerable.update, SteerableDoorTrigger.update);
Steerable.draw   = Utils.appendedFunction(Steerable.draw, SteerableDoorTrigger.draw);
	
function MapDoorTrigger:loadMap(name)	
	local x = g_currentMission.hudAttachmentOverlay.x;
	local y = g_currentMission.hudAttachmentOverlay.y;
	local width = g_currentMission.hudAttachmentOverlay.width;
	local height = g_currentMission.hudAttachmentOverlay.height;
	local filename = Utils.getFilename("OpenDoorTrigger_hud.png", self.baseDirectory);
	self.hudDoorTriggerOverlay = Overlay:new("hudDoorTriggerOverlay", filename, x, y, width, height);
	
	self.updateIntervallTimeOut = 0;
	
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	self.mapDoorTriggers_xml = dir.."/mapDoorTriggers.xml"; 
	self.fileFound = false;
	
	getFiles(dir, "getFilesCallback", self);
	
	if self.fileFound then
		self:loadDoorTriggerStates();
	end;
end;

function MapDoorTrigger:getFilesCallback(filename)
	if filename == "mapDoorTriggers.xml" then
		self.fileFound = true;
	end;
end;

function MapDoorTrigger:deleteMap()
end;

function MapDoorTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapDoorTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapDoorTrigger:update(dt)
	if self.updateIntervallTimeOut < g_currentMission.time then
		if self.hudDoorTriggerOverlay ~= nil then
			if g_currentMission.hudAttachmentOverlay.x ~= self.hudDoorTriggerOverlay.x or g_currentMission.hudAttachmentOverlay.y ~= self.hudDoorTriggerOverlay.y then
				self.hudDoorTriggerOverlay:setPosition(g_currentMission.hudAttachmentOverlay.x, g_currentMission.hudAttachmentOverlay.y);
			end;
		end;
		self.updateIntervallTimeOut = g_currentMission.time+300000;
	end;
	
	--fixing player
	if not self.fixedPlayer then
		if g_currentMission ~= nil then
			if g_currentMission.player ~= nil then
				g_currentMission.player.activeMapDoorTriggers = {};
				self.fixedPlayer = true;
			end;
		end;
	end;
end;

function MapDoorTrigger:draw()
	for _, doorTrigger in pairs(self.doorTriggers) do
		doorTrigger:draw();
	end;
end;

function MapDoorTrigger:addDoorTrigger(doorTrigger)
	table.insert(self.doorTriggers, doorTrigger)
	self.nodeToDoorTrigger[doorTrigger.triggerId] = doorTrigger;
	self.nameToDoorTrigger[doorTrigger.savingName] = doorTrigger;
end;

function MapDoorTrigger:saveDoorTriggerStates()
	local xml = createXMLFile("mapDoorTriggers", self.mapDoorTriggers_xml, "mapDoorTriggers");
	for i,doorTrigger in pairs(self.doorTriggers) do
		setXMLString(xml, string.format("mapDoorTriggers.doorTrigger%d#savingName", i), doorTrigger.savingName);
		setXMLFloat(xml, string.format("mapDoorTriggers.doorTrigger%d#trackTime", i), doorTrigger.trackTime);
	end;
	saveXMLFile(xml);
	delete(xml);
end;

function MapDoorTrigger:loadDoorTriggerStates()
	local xmlFile = loadXMLFile("mapDoorTriggers", self.mapDoorTriggers_xml);
	local i = 1;
	while true do
		local key = string.format("mapDoorTriggers.doorTrigger%d", i);
		local savingName = getXMLString(xmlFile, key.."#savingName");
		local trackTime = getXMLFloat(xmlFile, key.."#trackTime");
		if (savingName or trackTime) == nil then
			break;
		end;
		local entry = {};
		entry.savingName = savingName;
		entry.trackTime = trackTime;
		self.saveTable[i] = entry;
		i = i + 1;
	end;
	delete(xmlFile);
	
	if table.getn(self.saveTable) > 0 then
		for _, doorTrigger in pairs(self.doorTriggers) do
			for _,save in pairs(self.saveTable) do
				if doorTrigger.savingName == save.savingName then
					if save.trackTime > 0 then
						doorTrigger.doorIsOpened = true;
					else
						doorTrigger.doorIsOpened = false;
					end;
					doorTrigger.trackTime = save.trackTime;
				end;
			end;
		end;
		self.saveTable = {};
	end;
end;
addModEventListener(MapDoorTrigger);

-- DoorTrigger
-- Script for DoorTrigger
--
-- @ Autor  Tobias F. (John Deere 6930)
-- @ Last Edit  20/01/2013


function onCreate(self, id)
	local instance = DoorTrigger:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

DoorTrigger = {};

local DoorTrigger_mt = Class(DoorTrigger, Object);

function DoorTrigger:new(isServer, isClient)
	local self = Object:new(isServer, isClient, DoorTrigger_mt);
	self.className = "DoorTrigger";
	return self;
end;

function DoorTrigger:load(name)
	self.triggerId = name;
	addTrigger(name, "triggerCallback", self);
	self.isEnabled = true;
	for i=0, getNumOfChildren(name)-1 do
		local child = getChildAt(name, i);
		setCollisionMask(child, 0);
	end;
	self.assignRigidType = true;
	self.assignRigidTypeTimeOut = g_currentMission.time+4000;
	local inputKey = getUserAttribute(name, "inputKey");--string
	self.inputKey = InputBinding[inputKey];
	self.posText = getUserAttribute(name, "posText");--string
	self.negText =  getUserAttribute(name, "negText");--string
	self.savingName =  getUserAttribute(name, "savingName");--string			
	self.trackTime = 0;				
	self.lastTrackTime = 0;		
	self.doorIsOpened = false;
	local rootNodeName = getUserAttribute(name, "rootNodeName");--string
	if rootNodeName ~= nil then
		local rootNode = getChild(name, rootNodeName)
		self.animCharSet = 0;
		if rootNode ~= nil then	
			self.animCharSet = getAnimCharacterSet(rootNode);
			if self.animCharSet ~= 0 then					
				local clipSource = getUserAttribute(name, "animationClip");--string
				if clipSource ~= nil then
					self.clip = getAnimClipIndex(self.animCharSet, clipSource);
					if self.clip ~= nil then
						if self.clip >= 0 then
							assignAnimTrackClip(self.animCharSet, 0, self.clip);
							setAnimTrackLoopState(self.animCharSet, 0, false);
							self.speedScale = Utils.getNoNil(getUserAttribute(name, "animSpeedScale"), 1.0);--float
							self.animDuration = getAnimClipDuration(self.animCharSet, self.clip);
							MapDoorTrigger:addDoorTrigger(self)
						else
							print("Error: Can't find animationClip in MapDoorTrigger: "..getName(name).." with clipSource: "..clipSource);
						end;
					else
						print("Error: Can't find animationClip in MapDoorTrigger: "..getName(name).." with clipSource: "..clipSource);
					end;
				else
					print("Error: Can't find clipSource in MapDoorTrigger: "..getName(name));
				end;
			else
				print("Error: Can't find animationCharacterSet in MapDoorTrigger: "..getName(name).." on rootNode: "..rootNodeName.."\n       Sure that thats part of the animation?");
			end;
		else
			print("Error: Can't find rootNode in MapDoorTrigger: "..getName(name).." with rootNodeName: "..rootNodeName);
		end;
	else
		print("Error: Can't find rootNodeName in MapDoorTrigger: "..getName(name));
	end;
end;

function DoorTrigger:delete()
	removeTrigger(self.triggerId);
end;

function DoorTrigger:update()
	if self.assignRigidType and self.assignRigidTypeTimeOut <= g_currentMission.time then
		for i=0, getNumOfChildren(self.triggerId)-1 do
			local child = getChildAt(self.triggerId, i)
			setCollisionMask(child, 2102);
		end;
		self.assignRigidType = false;
	end;
	if self.isEnabled then
		if g_currentMission ~= nil and g_currentMission.player ~= nil and g_currentMission.player.activeMapDoorTriggers ~= nil then
			if table.getn(g_currentMission.player.activeMapDoorTriggers) > 0 then
				if g_currentMission.player.activeMapDoorTriggers[1] == self.triggerId then
					if InputBinding.hasEvent(self.inputKey) then
						self:setDoorState(not self.doorIsOpened);
					end;
					if not self.doorIsOpened then
						g_currentMission:addHelpButtonText(g_i18n:getText(self.posText), self.inputKey);
					else
						g_currentMission:addHelpButtonText(g_i18n:getText(self.negText), self.inputKey);
					end;
				end;
			end;
		end;
	end;
end;

function DoorTrigger:draw()
	if self.isEnabled then
		if g_currentMission ~= nil and g_currentMission.player ~= nil and g_currentMission.player.activeMapDoorTriggers ~= nil then
			if table.getn(g_currentMission.player.activeMapDoorTriggers) > 0 then
				if g_currentMission.player.activeMapDoorTriggers[1] == self.triggerId then
					if MapDoorTrigger.hudDoorTriggerOverlay ~= nil then
						MapDoorTrigger.hudDoorTriggerOverlay:render();
					end;
				end;
			end;
		end;
	end;
end;

function DoorTrigger:updateTick()
	if self.animDuration ~= nil then
		if self.trackTime < 1 then 
			self.trackTime = 0;
		end;
		if self.trackTime > self.animDuration then
			self.trackTime = self.animDuration;
		end;
		if self.doorIsOpened then
			if self.trackTime < self.animDuration then
				self.trackTime = self.trackTime +10*self.speedScale;
			end;
		else
			if self.trackTime > 0 then
				self.trackTime = self.trackTime -10*self.speedScale;
			end;
		end;	
		if self.lastTrackTime ~= self.trackTime then
			enableAnimTrack(self.animCharSet, self.clip);
			setAnimTrackTime(self.animCharSet, self.clip, self.trackTime, true);
			disableAnimTrack(self.animCharSet, self.clip);
			self.lastTrackTime = self.trackTime;
		end;
	end;
end;

function DoorTrigger:setDoorState(state, noEventSend)
	SetDoorStateEvent.sendEvent(self, state, noEventSend);
	self.doorIsOpened = state;
end;

function DoorTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled and (onEnter or onLeave) then
		local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
		if vehicle ~= nil and vehicle.onEnteredMapDoorTrigger ~= nil then
			if onEnter then
				vehicle:onEnteredMapDoorTrigger(self);
			else
				vehicle:onLeavedMapDoorTrigger(self);
			end;
		end;
		if g_currentMission.player ~= nil and g_currentMission.player.activeMapDoorTriggers ~= nil then
			if g_currentMission.controlPlayer and otherId == g_currentMission.player.rootNode then
				if onEnter then
					table.insert(g_currentMission.player.activeMapDoorTriggers, triggerId);
				else
					for k,v in pairs(g_currentMission.player.activeMapDoorTriggers) do
						if v == triggerId then
							table.remove(g_currentMission.player.activeMapDoorTriggers, k);
							break;
						end;
					end;
				end;
			else
				for k,v in pairs(g_currentMission.player.activeMapDoorTriggers) do
					if v == triggerId then
						table.remove(g_currentMission.player.activeMapDoorTriggers, k);
						break;
					end;
				end;
			end;
		end;
	end;
end;