WarfamaT350 = {};

function WarfamaT350.prerequisitesPresent(specializations)
    return true;
end;

function WarfamaT350:load(xmlFile)
	
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.setGripperCameraState = SpecializationUtil.callSpecializationsFunction("setGripperCameraState");
	
	self.characterNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#index"));
	setVisibility(self.characterNode, false);
	
	self.hydraulics = {};
	local i = 0;
	while true do
		local nameStr = string.format("vehicle.hydraulics.hydraulik(%d)", i);
        local hydraulic = {};
        local hydraulicStr = getXMLString(xmlFile, nameStr .. "#index");
        if hydraulicStr == nil then
            break;
        end;
        hydraulic.index = Utils.indexToObject(self.components, hydraulicStr);
		hydraulic.minRot = {};
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, nameStr .. "#minRot"));
        hydraulic.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        hydraulic.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        hydraulic.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		hydraulic.maxRot = {};
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, nameStr .. "#maxRot"));
        hydraulic.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        hydraulic.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        hydraulic.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		hydraulic.middleRot = {};
		local x, y, z = getRotation(hydraulic.index);
		hydraulic.middleRot[1] = x;
		hydraulic.middleRot[2] = y;
		hydraulic.middleRot[3] = z;
		hydraulic.clipIndex = getXMLInt(xmlFile, nameStr .. "#clipIndex");
		table.insert(self.hydraulics, hydraulic);
		i = i + 1;
	end;
	
	self.numCameras = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cameras#count"), 0);
    self.cameras = {};
	for i=1, self.numCameras do
		local cameranamei = string.format("vehicle.cameras.camera%d", i);
		local camera = VehicleCamera:new(self);
		if camera:loadFromXML(xmlFile, cameranamei) then
			table.insert(self.cameras, camera);
		end;
	end;
	
	self.animParts = {};
	for i=1, table.getn(self.animationParts) do
		self.animParts[i] = {};
		self.animParts[i].lastTime = 0;
	end;
	
	local path = Utils.getFilename("helpHud.png", self.baseDirectory);
	self.keyHelpHud = Overlay:new("keyHelpHud", path, 0.232, 0, 0.512, 0.082);
	
	self.saveMinRpm = 0;
	self.cameraInsertNum = nil;
	self.saveMinCameraDistance = nil;
	self.attacherVehicleCopy = nil;
	self.gripperCameraActive = false;
	self:setGripperCameraState(self.gripperCameraActive);

end;

function WarfamaT350:delete()
	self.keyHelpHud:delete();
end;

function WarfamaT350:readStream(streamId, connection)	
end;

function WarfamaT350:writeStream(streamId, connection)
end;

function WarfamaT350:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WarfamaT350:keyEvent(unicode, sym, modifier, isDown)
end;

function WarfamaT350:setGripperCameraState(cameraState, noEventSend)
	GripperCameraActivState.sendEvent(self, cameraState, noEventSend);
	self.gripperCameraActive = cameraState;
	setVisibility(self.characterNode, cameraState);
end;

function WarfamaT350:update(dt)

	if self.attacherVehicle ~= nil and (self.attacherVehicle.isControlled or self.attacherVehicle.isEntered) then
		if self.gripperCameraActive and self.saveMinCameraDistance ~= nil then
			self.attacherVehicle.characterCameraMinDistance = 20;
		else
			self.attacherVehicle.characterCameraMinDistance = self.saveMinCameraDistance;
		end;
	end;

	if self:getIsActiveForInput() then
		if self.cameraInsertNum ~= nil and self.attacherVehicle ~= nil then
			if (self.attacherVehicle.camIndex == self.cameraInsertNum) and not self.gripperCameraActive then
				self:setGripperCameraState(true);
			elseif self.gripperCameraActive and (self.attacherVehicle.camIndex ~= self.cameraInsertNum) then
				self:setGripperCameraState(false);
			end;
		end;
	end;
	
	if self.gripperCameraActive then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				if self.animationParts[1].clipEndTime then
					self:setAnimationTime(1, self.animationParts[1].startPosition);
				elseif not self.liftAxisAutoDown then
					self:setAnimationTime(1, self.animationParts[1].animDuration);
				end;
			end;
			local sideAxis = 0;
			if InputBinding.isPressed(InputBinding.T274_ROTATE_LEFT) then
				sideAxis = 1;
			elseif InputBinding.isPressed(InputBinding.T274_ROTATE_RIGHT) then
				sideAxis = -1;
			end;
			local forwardAxis = 0;
			if InputBinding.isPressed(InputBinding.T274_FOLDARM1_UP) then
				forwardAxis = -1;
			elseif InputBinding.isPressed(InputBinding.T274_FOLDARM1_DOWN) then
				forwardAxis = 1;
			end;
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet*(dt/5)*sideAxis));
			self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet*(dt/5)*forwardAxis));
			
			if InputBinding.isPressed(InputBinding.T274_FOLDARM2_DOWN) then
				self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet*(dt/5)));
			elseif InputBinding.isPressed(InputBinding.T274_FOLDARM2_UP) and self:getIsActiveForInput() then
				self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet*(dt/5)));
			end;
			if InputBinding.isPressed(InputBinding.T274_GRIPPER_OPEN) then
				self:setAnimationTime(5, self.animationParts[5].currentPosition+(self.animationParts[5].offSet*(dt/5)));
			elseif InputBinding.isPressed(InputBinding.T274_GRIPPER_CLOSE) then
				self:setAnimationTime(5, self.animationParts[5].currentPosition-(self.animationParts[5].offSet*(dt/5)));
			end;
		end;
	end;
	
	self:setVehicleRpmUp(dt, self.gripperCameraActive);
end;

function WarfamaT350:updateTick(dt)
	for k=1, table.getn(self.animationParts) do
		local animationPart = self.animationParts[k];
		for j, hydraulic in pairs(self.hydraulics) do
			if hydraulic.clipIndex == k then
				local xRot, yRot, zRot = unpack(hydraulic.middleRot);
				if animationPart.currentPosition < self.animParts[k].lastTime then
					xRot, yRot, zRot = unpack(hydraulic.maxRot);
				elseif animationPart.currentPosition > self.animParts[k].lastTime then
					xRot, yRot, zRot = unpack(hydraulic.minRot);
				end;
				setRotation(hydraulic.index, xRot, yRot, zRot);
				self.animParts[k].lastTime = animationPart.currentPosition;
			end;
		end;
	end;
end;

function WarfamaT350:draw()
	if self.gripperCameraActive then
		if g_currentMission.showHelpText then
			self.keyHelpHud:render();
			renderText(0.236, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.T274_ROTATE_LEFT), "Klawisz", "Num")));
			renderText(0.293, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.T274_ROTATE_RIGHT), "Klawisz", "Num")));
			renderText(0.350, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.T274_FOLDARM1_DOWN), "Klawisz", "Num")));
			renderText(0.407, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.T274_FOLDARM1_UP), "Klawisz", "Num")));
			renderText(0.464, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.T274_FOLDARM2_DOWN), "Klawisz", "Num")));
			renderText(0.521, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.T274_FOLDARM2_UP), "Klawisz", "Num")));
			renderText(0.578, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.T274_GRIPPER_OPEN), "Klawisz", "Num")));
			renderText(0.635, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.T274_GRIPPER_CLOSE), "Klawisz", "Num")));
			renderText(0.692, 0.06, 0.0195, string.format("%s", string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMPLEMENT_EXTRA2), "Klawisz", "Num")));
		end;
	else
		g_currentMission:addExtraPrintText(g_i18n:getText("SelectCorrectCamera"));
	end;
end;

function WarfamaT350:onDeactivate()
	self:setGripperCameraState(false);
end;

function WarfamaT350:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy == nil then
		self.attacherVehicleCopy = self.attacherVehicle;
	end;
	table.insert(self.attacherVehicle.cameras, self.cameras[1]);
	self.attacherVehicle.numCameras = self.attacherVehicle.numCameras+1;
	self.cameraInsertNum = table.getn(self.attacherVehicle.cameras);
	self.saveMinRpm = self.attacherVehicle.motor.minRpm;
	self.saveMinCameraDistance = self.attacherVehicle.characterCameraMinDistance;
end;

function WarfamaT350:onDetach()
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			steerable.steeringEnabled = true;
			steerable.characterCameraMinDistance = self.saveMinCameraDistance;
			self.saveMinCameraDistance = nil;
			if self.gripperCameraActive then
				steerable.cameras[self.cameraInsertNum]:onDeactivate();
				steerable.camIndex = 1;
			end;
			table.remove(steerable.cameras, self.cameraInsertNum);
			steerable.numCameras = steerable.numCameras-1;
			self.cameraInsertNum = nil;
			if self.gripperCameraActive then
				steerable.cameras[steerable.camIndex]:onActivate();
				self:setGripperCameraState(false);
			end;
			if steerable.characterNode ~= nil and steerable.isControlled then
				setVisibility(steerable.characterNode, true);
			end;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function WarfamaT350:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicle.steeringEnabled = false;
				self.attacherVehicle.lastAcceleration = 0;
				if self.isServer then
					for k, wheel in pairs(self.attacherVehicle.wheels) do
						setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.attacherVehicle.motor.brakeForce, 0);
					end;
				end;
				self.attacherVehicle.motor:setSpeedLevel(0, false);
				self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -550);
			else
				self.attacherVehicle.steeringEnabled = true;
				self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
			end;
		else
			self.attacherVehicle.motor.minRpm = self.saveMinRpm;
			self.attacherVehicle.steeringEnabled = true;
		end;
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000008*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;