
 ------Kverneland_Exacta_HL_saugarm
 ------Grundscript traillingTruck @author Outlaw
 ------Scriptumbau_daniel11
 
 
saugarm = {};
 
function saugarm.prerequisitesPresent(specializations)
    return true;
end;


function saugarm:load(xmlFile)

   local rotationPartNodesaugarm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartsaugarm#index"));
    if rotationPartNodesaugarm ~= nil then
        self.rotationPartsaugarm = {};
        self.rotationPartsaugarm.node = rotationPartNodesaugarm;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartsaugarm#minRot"));
        self.rotationPartsaugarm.minRot = {};
        self.rotationPartsaugarm.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsaugarm.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsaugarm.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartsaugarm#maxRot"));
        self.rotationPartsaugarm.maxRot = {};
        self.rotationPartsaugarm.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsaugarm.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsaugarm.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartsaugarm.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartsaugarm#rotTime"), 2)*1000;
        self.rotationPartsaugarm.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartsaugarm#touchRotLimit"), 10));
    end;
	self.rotatesaugarm = false;
end;

function saugarm:delete()
    
end;

function saugarm:mouseEvent(posX, posY, isDown, isUp, button)
    
end;

function saugarm:keyEvent(unicode, sym, modifier, isDown)
    
end;

function saugarm:update(dt)
	
	if InputBinding.hasEvent(InputBinding.Saugarm) then
		self.rotatesaugarm = not self.rotatesaugarm;
	end;
	  
	if self.rotationPartsaugarm ~= nil then
        local x, y, z = getRotation(self.rotationPartsaugarm.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartsaugarm.maxRot, self.rotationPartsaugarm.minRot, 3, self.rotationPartsaugarm.rotTime, dt, not self.rotatesaugarm);
		setRotation(self.rotationPartsaugarm.node, unpack(newRot));
    end;
	
end;

function saugarm:draw()
	if self.rotatesaugarm then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Saugarm1"), self.typeDesc), InputBinding.Saugarm);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Saugarm2"), self.typeDesc), InputBinding.Saugarm);
	end;
end;