--
-- Orginal Author:?
-- Modyfikacja: Grzegorz056
-- date: 28.02.2014r.

WPM = {};

function WPM.prerequisitesPresent(specializations)
      return true;
end;

function WPM:load(xmlFile)

	self.WPMruch = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.WPMruch.node(%d)", i);
		local index = getXMLString(xmlFile, baseName.. "#index");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.. "#rotationSpeed"));
		local rotationSpeed = {x,y,z};
		local ruchOpoznienie = Utils.getNoNil(getXMLFloat(xmlFile, baseName.. "#ruchOpoznienie"), 2)*1000;
		if index == nil or rotationSpeed == nil or ruchOpoznienie == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.ruchOpoznienie = ruchOpoznienie;
			entry.rotationSpeedMax = rotationSpeed;
			entry.rotationSpeedMin = {0,0,0};
			entry.rotationSpeedCurrent = {0,0,0};
			table.insert(self.WPMruch, entry);
		end;
		i = i+1;
	end;

end;

function WPM:delete()
end;

function WPM:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WPM:keyEvent(unicode, sym, modifier, isDown)
end;

function WPM:update(dt)
end;

function WPM:updateTick(dt)
	if self:getIsActive() then
			for k, spinner in pairs(self.WPMruch) do
			local values = Utils.getMovedLimitedValues(spinner.rotationSpeedCurrent, spinner.rotationSpeedMax, spinner.rotationSpeedMin, 3, spinner.ruchOpoznienie, dt, not self.isTurnedOn);
			spinner.rotationSpeedCurrent = values;
			rotate(spinner.node, unpack(spinner.rotationSpeedCurrent));
		end;
	end;
end;

function WPM:draw()
end;

function WPM:onDetach()
end;

function WPM:onLeave()
end;

function WPM:onDeactivate()
end;