-------------------------------------------------------------------------------
--
--  Mod Name:		fieldStatus
--
--  Description:	Show status of all fields on a map (cultivated, plowed,
--					etc).  Also show crops on the field, their growth states,
--					and if the field is fertilized.
--
--  Author:			Alan R. (fs-uk.com: thebadtouch)
--
--  License:		http://creativecommons.org/licenses/by-nc-sa/3.0/
--
--  Release History:
--  2013-11-18		v5.4	Fixed mapnames for DLC packs; do not freeze
--							player when enabling mouse; go back to using
--							field defs to calc field area.
--  2013-08-28		v5.1	Re-work Field Def. issue; Major Enhancements;
--							MP code for bales; Bug fixes.
--  2013-06-22		v4.1	for FS2013
--  2011-10-06		v3.0
--  2011-09-06		v2.0
--  2011-07-24		v1.0	Initial release
--
--------------------------------------------------------------------------------

fieldStatus={};

fieldStatus.moddir = g_currentModDirectory;
fieldStatus.version = "5.4";
fieldStatus.versionSuffix = "";
fieldStatus.author = "Alan R. [fs-uk.com:thebadtouch]";
fieldStatus.initialized = false;

print("Field Status v"..fieldStatus.version..fieldStatus.versionSuffix.." by "..fieldStatus.author);

addModEventListener(fieldStatus);


function fieldStatus:loadMap(name)

	print("fieldStatus: loading Map: "..name);

	if not fieldStatus.initialized then
		fieldStatus:initVars();
	end;

	if g_server ~= nil and g_server.netIsRunning then
		isMultiPlayerGame = true;
	end;

	if not mapLoaded then
		local lenBasePath = string.len(getAppBasePath());
		local lenUserPath = string.len(getUserProfileAppPath());
		if string.sub(name, 1, 10) == "data/maps/" or string.sub(name, 1, lenBasePath+10) == getAppBasePath().."data/maps/" then
			thisMap = "Default";
		elseif string.sub(name, 1, lenUserPath+5) == getUserProfileAppPath().."mods/" then
			thisMap = string.sub(name, lenUserPath+6);
			thisMap,_ = string.gsub(thisMap, "/.*", "");
		else
			thisMap,_ = string.gsub(name, ".i3d", "");
			addOnPath = thisMap.."/";
			thisMap,_ = string.gsub(thisMap, ".*/", "");
		end;
		fsMap = g_currentMission.missionInfo.map.title;
		print("fieldStatus: thisMap >"..tostring(thisMap).."<");
		print("fieldStatus:   fsMap >"..tostring(fsMap).."<");
		mapLoaded = true;
		loadSuccess = true;
	end;

	if not initHUDDone then
		fieldStatus:initHUD();
	end;

end;


function fieldStatus:deleteMap()

	fieldStatus.initialized = false;

end;


function fieldStatus:mouseEvent(posX, posY, isDown, isUp, button)

	if isDown and button == 3 then
		if fsMouseEnabled then
			InputBinding.setShowMouseCursor(true);
		end;
	end;

	if fsMouseEnabled then
		if hudIsMoving then
			fsHud.CurrPos = 3;
			fsHud.PosX[fsHud.CurrPos] = posX;
			fsHud.PosY[fsHud.CurrPos] = posY - fsHud.Height;
			if (posX + fsHud.Width) > 1.0 then
				fsHud.PosX[fsHud.CurrPos] = 1.0 - fsHud.Width;
			end;
			if (posY - fsHud.Height) < 0.0 then
				fsHud.PosY[fsHud.CurrPos] = 0.0001;
			end;
			fieldStatus:calcHUDLines();
			if isUp and button == 1 then
				upCount = upCount + 1;
				if upCount > 1 then
					hudIsMoving = false;
				end;
			end;
		elseif isDown and button == 1 then
			if fsButton ~= nil then
				for i=1,#fsButton do
					if fsButton[i] ~= nil then
						if posX > fsButton[i].PosX and posX < fsButton[i].PosXw and posY > fsButton[i].PosY and posY < fsButton[i].PosYh then
							fsButton[i].isClicked = true;
							break;
						end;
					end;
				end;
			end;
		end;
	end;

end;


function fieldStatus:keyEvent(unicode, sym, modifier, isDown)

	if isDown then
		if bitAND(modifier,Input.MOD_CTRL) > 0 and (sym == Input.KEY_d) then
			if fsActive["HUD"] and ctrlDOK then
				msgTxt = "";  msgTxtColor = "";
				debug = not debug;
					print('fieldStatus: CTRL-D pressed: debug = '..tostring(debug));
			end;
		elseif bitAND(modifier,Input.MOD_CTRL) > 0 and (sym == Input.KEY_p) then
			if fsActive["HUD"] and ctrlPOK then
				msgTxt = "";  msgTxtColor = "";
				fieldStatus:process_fieldData("display");
			end;
		elseif bitAND(modifier,Input.MOD_CTRL) > 0 and (sym == Input.KEY_x) then
			if fsActive["HUD"] and ctrlXOK then
				msgTxt = "";  msgTxtColor = "";
				fieldStatus:process_fieldData("savexml");
			end;
		end;
		if fsActive["HUD"] and fsActive["EDIT"] and fsActive["userInput"] then
			if sym == 8 then														--  BACKSPACE
				if string.len(scanField) > 1 then
					scanField = string.sub(scanField, 1, -2);
				else
					scanField = "";
				end;
			elseif (sym >= 256) and (sym <= 265) then								--  NUMPAD Keys 0 - 9
				scanField = scanField .. string.char(sym - 208);
			elseif (sym >= 65) and (sym <= 90) then									--  A - Z
				scanField = scanField .. string.char(sym);
			elseif (sym >= 97) and (sym <= 122) then								--  a - z
				scanField = scanField .. string.char(sym - 32);
			elseif sym == 32 or sym == 44 then										--  space or comma
				scanField = scanField .. string.char(sym);
			elseif bitAND(modifier,Input.MOD_SHIFT) > 0 and (sym == 59) then		--  colon character
				scanField = scanField .. ":";
			end;
		end;
	end;
end;


function fieldStatus:update(dt)

	scanTimer = scanTimer + dt;

	if not fieldStatus.initialized then

		if not loadSuccess then
			return;
		end;

		if not initFruitsDone then
			fieldStatus:initFruitData();
			fieldStatus:updateConfigScreen();
			terrainSize = g_currentMission.terrainSize - 2;
			mapOffset = terrainSize / 2;
			print(string.rep("-", 75));
			print("fieldStatus: terrainDetailId:                  "..string.format("%8d", g_currentMission.terrainDetailId));
			print("fieldStatus: terrainDetailMapSize:             "..string.format("%8d", g_currentMission.terrainDetailMapSize));
			print("fieldStatus: terrainDetailTypeNumChannels:     "..string.format("%8d", g_currentMission.terrainDetailTypeNumChannels));
			print("fieldStatus: terrainSize:                      "..string.format("%8d", terrainSize));
			print("fieldStatus: mapOffset:                        "..string.format("%8d", mapOffset));
			print("fieldStatus: densityMapPercentageFraction:     "..string.format("%8.4f", g_currentMission.densityMapPercentageFraction));
			print(string.rep("-", 75));
			print("fieldStatus: numFRUITTYPES:                    "..string.format("%8d", FruitUtil.NUM_FRUITTYPES));
			print("fieldStatus: numFruits:                        "..string.format("%8d", numFruits));
			print("fieldStatus: fruitMapSize:                     "..string.format("%8d", g_currentMission.fruitMapSize));
			print("fieldStatus: numFruitStateChannels:            "..string.format("%8d", g_currentMission.numFruitStateChannels));
			print("fieldStatus: numFruitDensityMapChannels:       "..string.format("%8d", g_currentMission.numFruitDensityMapChannels));
			print(string.rep("-", 75));
		end;

		if not configLoaded then
			fieldStatus:loadConfigData();
		end;

		if not fieldDefsLoaded then
			fieldStatus:getFieldDefinitions("init");
		end;

		fieldStatus:getPDAMapImage();

		fieldStatus.initialized = true;
		return;
	end;

	fsActiveTimer = fsActiveTimer + dt;
	fsBaleEventTimer = fsBaleEventTimer + dt;

	if fsActive["BaleScan"] and isMultiPlayerGame then
		baleScanDone = false;
		if fsConfig["BaleScan"].freq > 0 then
			if ((fsBaleEventTimer - fsBaleLastScanTime) > (fsConfig["BaleScan"].freq * 1000)) then
				baleScanStart = true;
				fieldStatus:findBales(1);
				fieldStatusBaleEvent.sendEvent();
				fsBaleLastScanTime = g_currentMission.time;
				fsBaleEventTimer = fsBaleLastScanTime;
				baleScanDone = true;
			end;
		end;
		if not baleScanDone then
			if fsConfig["BaleScan"].eachBale then
				numItemsToSave = 0;
				numBales = 0;
				maxBaleId = 0;
				for key,value in pairs(g_currentMission.itemsToSave) do
					numItemsToSave = numItemsToSave + 1;
					if value.item.className ~= nil and value.item.className == "Bale" then
						numBales = numBales + 1;
						if value.item.id > maxBaleId then
							maxBaleId = value.item.id;
						end;
					end;
				end;
				if (numBales ~= saveNumBales) or (maxBaleId ~= saveMaxBaleId) then
					saveNumBales = numBales;
					saveMaxBaleId = maxBaleId;
					baleScanStart = true;
					fieldStatus:findBales(1);
					fieldStatusBaleEvent.sendEvent();
					fsBaleLastScanTime = g_currentMission.time;
					fsBaleEventTimer = fsBaleLastScanTime;
					baleScanDone = true;
				end;
			end;
		end;
		if not baleScanDone then
			if fsConfig["BaleScan"].playerJoin then
				local fsPlayers = {};
				for key,value in pairs(g_currentMission.players) do
					table.insert(fsPlayers, value);
				end;
				if numPlayers ~= #fsPlayers then
						print('fieldStatus: numPlayers was '..numPlayers..'; now is '..#fsPlayers);
					numPlayers = #fsPlayers;
					baleScanStart = true;
					fieldStatus:findBales(1);
					fieldStatusBaleEvent.sendEvent();
					fsBaleLastScanTime = g_currentMission.time;
					fsBaleEventTimer = fsBaleLastScanTime;
					baleScanDone = true;
				end;
			end;
		end;
	end;

	if fsActive["AutoScan"] and fsActive["HUD"] and ((fsActiveTimer - fsLastScanTime) > (fsConfig["AutoScan"].freq * 60000)) then
		if (not fsActive["EDIT"]) and (not fsActive["CONF"]) and (not fsActive["MPLA"]) then
			weAreScanning = true;
			scanSource = "auto";
			scanType = fsConfig["AutoScan"].type;
			if scanType == "All" then
				scanIdx = 1;
			else
				searchIdx = 1;  scanErrList = "";  anyFieldsScanned = false;
			end;
			if scanType == "Custom" then
				if fsConfig["AutoScan"].customFieldList ~= nil then
					scanField = fsConfig["AutoScan"].customFieldList;
					fieldStatus:checkInput();
				end;
				if fsConfig["AutoScan"].customFieldList == nil or fsConfig["AutoScan"].customFieldList == "" or numScanFields == 0 or scanField == "" then
					msgTxt = "AutoScan: Field list ERR";  msgTxtColor = "brightred";
					weAreScanning = false;
					fsLastScanTime = g_currentMission.time;
					fsActiveTimer = fsLastScanTime;
					return;
				end;
			end;
			scanTimer = 0;
			fsActiveTimer = 0;
			baleScanStart = true;
			numOwned = fieldStatus:checkOwned();
			if fsConfig["AutoScan"].fruit ~= "All" then
				fruitScanSelected = true;
				fruitToScan = fsConfig["AutoScan"].fruit;
			else
				fruitScanSelected = false;
			end;
		end;
	end;

	fieldStatus:checkHUDInput();

end;


function fieldStatus:draw()

	if not loadSuccess then
		if (InputBinding.hasEvent(InputBinding.fs_ACTIVATE_HUD)) then
			errMsgEnabled = not errMsgEnabled;
		end;
		if errMsgEnabled then
			if scanTimer <= scanTimerWait2 then
				setTextAlignment(RenderText.ALIGN_CENTER);
				setTextBold(true);
				setTextColor(fsColor.brightred.r, fsColor.brightred.g, fsColor.brightred.b, overlayTransLevel);
				renderText(0.5, 0.5, textHeaderSize, errMsgTxt);
				renderText(0.5, 0.5 - textHeaderSize, textNormalSize, "("..fskeyActivateHUD.." to remove message)");
				setTextAlignment(RenderText.ALIGN_LEFT);
			elseif scanTimer > scanTimerWait2 * 2 then
				scanTimer = 0;
			end;
		end;
		return;
	end;

if fsActive["HUD"] then

	fsButton = {};
	local rowTxt = "";

	if fsActive["mapOverlay"] then
		if fsPdaMapAvail then
			setOverlayColor(fsImg["pdaMap"].id, fsImg["pdaMap"].color.r, fsImg["pdaMap"].color.g, fsImg["pdaMap"].color.b, overlayTransLevel);
			renderOverlay(fsImg["pdaMap"].id, 0, 0, 1, 1);
		end;
		local textOffset = 0.009;
		local fn = 1;
		while true do
			thisField=g_currentMission.fieldDefinitionBase.fieldDefs[fn];
			if thisField ~= nil then
				local thisHotspot = thisField.fieldMapHotspot;
				local vvx = (thisHotspot.xMapPos + mapOffset) / (mapOffset * 2);
				local vvy = 1 - ((thisHotspot.yMapPos + mapOffset) / (mapOffset * 2));
				setTextBold(true);
				if thisField.ownedByPlayer then
					setTextColor(fsColor.green.r, fsColor.green.g, fsColor.green.b, overlayTransLevel);
				else
					setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
				end;
				renderText(vvx-textOffset, vvy-textOffset, textNormalSize, thisHotspot.name);
			else
				break;
			end;
			fn = fn + 1;
		end;

		local x, px, py, pz, ppx, ppz = nil, nil, nil, nil, nil, nil;
		local vx, vy, vz, vvx, vvz = nil, nil, nil, nil, nil;
		for x=1, table.getn(g_currentMission.steerables) do
			if not g_currentMission.steerables[x].isBroken then
				if g_currentMission.steerables[x].isControlled then
					vx, vy, vz = getWorldTranslation(g_currentMission.steerables[x].rootNode);
					vvx = (vx + mapOffset) / (mapOffset * 2);
					vvz = 1 - ((vz + mapOffset) / (mapOffset * 2));
					break;
				end;
			end;
		end;
		if vvx ~= nil and vvz ~= nil then
			setOverlayColor(fsImg["pdaPos"].id, fsImg["pdaPos"].color.r, fsImg["pdaPos"].color.g, fsImg["pdaPos"].color.b, overlayTransLevel);
			renderOverlay(fsImg["pdaPos"].id, vvx-0.0078, vvz-0.0078, 0.0156, 0.0156);
		else
			px, py, pz = getWorldTranslation(g_currentMission.player.rootNode);
			ppx = (px + mapOffset) / (mapOffset * 2);
			ppz = 1 - ((pz + mapOffset) / (mapOffset * 2));
			setOverlayColor(fsImg["pdaPos"].id, fsImg["pdaPos"].color.r, fsImg["pdaPos"].color.g, fsImg["pdaPos"].color.b, overlayTransLevel);
			renderOverlay(fsImg["pdaPos"].id, ppx-0.0078, ppz-0.0078, 0.0156, 0.0156);
		end;
	end;

	if fsActive["CONF"] or fsActive["MPLA"] or fsActive["HELP"] or fsActive["SCAN"] or fsActive["DISP"] then
		fieldStatus:showSubHUD();
	end;

	if fsActive["EDIT"] then
		fieldStatus:showMiniHUD();
	end;

-- Display HUD

	setOverlayColor(fsImg["HUD"].id, fsImg["HUD"].color.r, fsImg["HUD"].color.g, fsImg["HUD"].color.b, overlayTransLevel);
	renderOverlay(fsImg["HUD"].id, fsHud.PosX[fsHud.CurrPos], fsHud.PosY[fsHud.CurrPos], fsHud.Width, fsHud.Height);

	setTextAlignment(RenderText.ALIGN_CENTER);
	setTextBold(true);
	setTextColor(fsColor.red.r, fsColor.red.g, fsColor.red.b, overlayTransLevel);
	renderText(fsPrintPosXCenter, fsPrintPosY, textHeaderSize, "Field Status");
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);
	setTextColor(fsColor.red.r, fsColor.red.g, fsColor.red.b, overlayTransLevel);
	renderText(fsPrintPosXRight, fsPrintPosY-(lineSpacing / 2)+0.0025, textVersionSize, "v" .. fieldStatus.version .. fieldStatus.versionSuffix);

	if debug then
		if (scanTimer <= scanTimerWait2) or weAreScanning or showingAll or showingOwned or showingUnowned or showingCustom then
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextBold(false);
			setTextColor(fsColor.brightred.r, fsColor.brightred.g, fsColor.brightred.b, overlayTransLevel);
			renderText(fsPrintPosX-0.001, fsPrintPosY+lineSpacing-0.005, textVersionSize, "DEBUG");
			renderText(fsPrintPosX+0.008, fsPrintPosY+(lineSpacing / 2)-0.01, textVersionSize, "ON");
		elseif scanTimer > scanTimerWait2 * 2 then
			scanTimer = 0;
		end;
	end;

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(true);
	setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
	thisTextSize = fieldStatus:getTextSize(fsMap,textNormalSize,"hud");
	renderText(fsPrintPosX, fsPrintPosY-lineSpacing, thisTextSize, fsMap);

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(true);
	setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
	renderText(fsPrintPosX, fsPrintPosY-(lineSpacing*2), textNormalSize, string.format("%d Fields  (%d Owned)", numFields, numOwned));

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(true);
	setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
	renderText(fsPrintPosX, fsPrintPosY-(lineSpacing*3), textNormalSize, string.format("%1.2f ha / %1.2f ac", mapHectares, mapAcres));

	local showFields;
	if fruitScanSelected then
		showFields = "[" .. string.sub(scanType, 1, 1) .. "]: " .. fruitToScan;
	else
		showFields = scanType.." Fields";
	end;

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(true);
	setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
	renderText(fsPrintPosX, fsPrintPosY-(lineSpacing*4), textSmallSize, showFields);
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);
	setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
	renderText(fsPrintPosXRight-0.02, fsPrintPosY-(lineSpacing*4), textSmallSize, "AutoScan:");
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);
	if fsActive["AutoScan"] then
		rowTxt = "On";
		setTextColor(fsColor.green.r, fsColor.green.g, fsColor.green.b, overlayTransLevel);
	else
		rowTxt = "Off";
		setTextColor(fsColor.red.r, fsColor.red.g, fsColor.red.b, overlayTransLevel);
	end;
	iconPosY = fsPrintPosY - (lineSpacing*4) - 0.001;
	iconPosX = fsPrintPosXRight;
	renderText(iconPosX, iconPosY, textSmallSize, rowTxt);
	if (not weAreScanning) and (not fsActive["CONF"]) and (not fsActive["MPLA"]) and (not fsActive["EDIT"]) and (not hudIsMoving) then
		fieldStatus:addButton("toggleAutoScan", iconPosX - normalIconWidth, iconPosY, iconPosX + (normalIconWidth / 2), iconPosY + textSmallSize, nil, "HUD");
	end;

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);
	setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
	renderText(fsPrintPosX, fsPrintPosY-(lineSpacing*5), textNormalSize, dashLine);

	if weAreScanning then
		if scanType == "All" then
			if scanSource == "init" then
				msgTxt = "Init Field Data - "..scanIdx.." of "..numFields;  msgTxtColor = "";
			elseif scanSource == "auto" then
				msgTxt = "AutoScan Field "..scanIdx.." of "..numFields;  msgTxtColor = "";
			else
				msgTxt = "Scanning Field "..scanIdx.." of "..numFields;  msgTxtColor = "";
			end;
			if baleScanStart and g_server ~= nil then
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(true);
				setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
				renderText(fsPrintPosX, fsPrintMsgLine, textNormalSize, "Scanning for bales ...");
				fieldStatus:findBales(scanIdx);
				return;
			end;
			if scanTimer > scanTimerWait then
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(true);
				setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
				thisTextSize = fieldStatus:getTextSize(msgTxt,textNormalSize,"hud");
				renderText(fsPrintPosX, fsPrintMsgLine, thisTextSize, msgTxt);
				fieldStatus:scanFields();
				scanTimer = 0;
				scanIdx = scanIdx + 1;
				if scanIdx > numFields or fieldData[scanIdx].name == nil then
					weAreScanning = false;
					msgTxt = "";  msgTxtColor = "";
					if fsActive["BaleScan"] and isMultiPlayerGame and fsConfig["BaleScan"].eachHostScan then
						fieldStatusBaleEvent.sendEvent();
						fsBaleLastScanTime = g_currentMission.time;
						fsBaleEventTimer = fsBaleLastScanTime;
					end;
					fieldStatus:process_fieldData("savexml");
					fsLastScanTime = g_currentMission.time;
					fsActiveTimer = fsLastScanTime;
				end;
			end;
		else
			scanField = scanFieldArray[searchIdx];
			while true do
				scanIdx = 0;
				local scanStart;
				for scanStart=1, numFields do
					if fieldData[scanStart].name ~= nil and tostring(fieldData[scanStart].name) == tostring(scanField) then
						scanIdx = scanStart;
						break;
					end;
				end;
				if scanIdx == 0 then  -- Field not found
					scanErrList = scanErrList .. tostring(scanField) .. ",";
					searchIdx = searchIdx + 1;
					if searchIdx > numScanFields then
						weAreScanning = false;
						break;
					else
						return;
					end;
				else
					break;
				end;
			end;
			if weAreScanning then
				if scanSource == "auto" then
					msgTxt = "AutoScan Field "..scanIdx.." of "..numFields;  msgTxtColor = "";
				else
					msgTxt = "Scanning Field "..scanIdx.." of "..numFields;  msgTxtColor = "";
				end;
				if baleScanStart and g_server ~= nil then
					setTextAlignment(RenderText.ALIGN_LEFT);
					setTextBold(true);
					setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
					renderText(fsPrintPosX, fsPrintMsgLine, textNormalSize, "Scanning for bales ...");
					fieldStatus:findBales(scanIdx);
					return;
				end;
				if scanTimer > scanTimerWait then
					setTextAlignment(RenderText.ALIGN_LEFT);
					setTextBold(true);
					setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
					thisTextSize = fieldStatus:getTextSize(msgTxt,textNormalSize,"hud");
					renderText(fsPrintPosX, fsPrintMsgLine, thisTextSize, msgTxt);
					fieldStatus:scanFields();
					scanTimer = 0;
					searchIdx = searchIdx + 1;
					anyFieldsScanned = true;
				end;
			end;
			if searchIdx > numScanFields then
				weAreScanning = false;
				msgTxt = "";  msgTxtColor = "";
				if anyFieldsScanned then
					if fsActive["BaleScan"] and isMultiPlayerGame and fsConfig["BaleScan"].eachHostScan then
						fieldStatusBaleEvent.sendEvent();
						fsBaleLastScanTime = g_currentMission.time;
						fsBaleEventTimer = fsBaleLastScanTime;
					end;
					fieldStatus:process_fieldData("savexml");
					fsLastScanTime = g_currentMission.time;
					fsActiveTimer = fsLastScanTime;
				end;
				if scanErrList ~= "" then
					scanErrList = string.sub(scanErrList, 1, -2);
					msgTxt = "No Fields: " .. scanErrList;  msgTxtColor = "brightred";
				end;
				scanField = "";  scanFieldArray = {};  numScanFields = 0;  scanErrList = "";
			end;
		end;
		return;
	elseif showingAll then
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(true);
		setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
		renderText(fsPrintPosX, fsPrintMsgLine, textNormalSize, "Please wait ...");
		if scanTimer > scanTimerWait then
			fieldStatus:process_fieldData("display");
			showingAll = false;	scanTimer = 0;
			msgTxt = "Showing All Fields";  msgTxtColor = "";
		end;
		return;
	elseif showingOwned then
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(true);
		setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
		renderText(fsPrintPosX, fsPrintMsgLine, textNormalSize, "Please wait ...");
		if scanTimer > scanTimerWait then
			fieldStatus:process_fieldData("display");
			showingOwned = false; scanTimer = 0;
			msgTxt = "Showing Owned Fields";  msgTxtColor = "";
		end;
		return;
	elseif showingUnowned then
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(true);
		setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
		renderText(fsPrintPosX, fsPrintMsgLine, textNormalSize, "Please wait ...");
		if scanTimer > scanTimerWait then
			fieldStatus:process_fieldData("display");
			showingUnowned = false;	scanTimer = 0;
			msgTxt = "Showing Unowned Fields";  msgTxtColor = "";
		end;
		return;
	elseif showingCustom then
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(true);
		setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
		renderText(fsPrintPosX, fsPrintMsgLine, textNormalSize, "Please wait ...");
		if scanTimer > scanTimerWait then
			fieldStatus:process_fieldData("display");
			showingCustom = false;	scanTimer = 0;
			msgTxt = "Showing Custom Fields";  msgTxtColor = "";
		end;
		return;
	end;
else
	return;
end;

local screenDone = false;
local fsPrintPosCurrLine = fsPrintPosY-(lineSpacing*5);
local idxStart, idxEnd = 0, 0;
local blankTxt = " ";
local text0, text1, screenFieldName = "", "", "";

if dispDataItems == 0 then
	dispDataItems = 1;
end;

if numScreens == 0 then
	idxStart = 1;  idxEnd = 1;
elseif currScreen <= 1 then
	currScreen = 1;
	idxStart = screenList[currScreen];
	if numScreens == 1 then
		idxEnd = dispDataItems;
	else
		idxEnd = screenList[currScreen + 1] - 1;
	end;
elseif currScreen >= numScreens then
	currScreen = numScreens;
	idxStart = screenList[currScreen];
	idxEnd = dispDataItems;
else
	idxStart = screenList[currScreen];
	if numScreens == 1 then
		idxEnd = dispDataItems;
	else
		idxEnd = screenList[currScreen + 1] - 1;
	end;
end;

for dispDataIdx=idxStart,idxEnd do
	if dispData[dispDataIdx].ctrl == nil then
		screenDone = true;
		blankTxt = "* END OF DATA *";
		fsPrintPosCurrLine = fsPrintPosCurrLine - lineSpacing;
	else
		text0 = string.sub(dispData[dispDataIdx].ctrl, 4, 4);
		text1 = string.sub(dispData[dispDataIdx].ctrl, 1, 3);
		if text0 == "N" then                                                -- Unowned Field
			setTextColor(fsColor.gray.r, fsColor.gray.g, fsColor.gray.b, overlayTransLevel);
		elseif text1 == "EMP" then
			setTextColor(fsColor.brown.r, fsColor.brown.g, fsColor.brown.b, overlayTransLevel);
		elseif text1 == "STA" then
			setTextColor(fsColor.brown.r, fsColor.brown.g, fsColor.brown.b, overlayTransLevel);
		elseif text1 == "FER" then
			setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
		elseif text1 == "GRO" then
			setTextColor(fsColor.lightgreen.r, fsColor.lightgreen.g, fsColor.lightgreen.b, overlayTransLevel);
		elseif text1 == "HAR" then
			setTextColor(fsColor.green.r, fsColor.green.g, fsColor.green.b, overlayTransLevel);
		elseif text1 == "PRP" then
			setTextColor(fsColor.darkgreen.r, fsColor.darkgreen.g, fsColor.darkgreen.b, overlayTransLevel);
		elseif text1 == "CUT" or text1 == "WIN" then
			setTextColor(fsColor.yellow.r, fsColor.yellow.g, fsColor.yellow.b, overlayTransLevel);
		elseif text1 == "BAL" then
			setTextColor(fsColor.darkcyan.r, fsColor.darkcyan.g, fsColor.darkcyan.b, overlayTransLevel);
		elseif text1 == "BAD" then
			setTextColor(fsColor.brightred.r, fsColor.brightred.g, fsColor.brightred.b, overlayTransLevel);
		end;
	end;

	if screenDone then
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(true);
		setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
		renderText(fsPrintPosX, fsPrintPosCurrLine, textNormalSize, blankTxt);
		blankTxt = " ";
		break;
	elseif text1 == "FLD" then
		fsPrintPosCurrLine = fsPrintPosCurrLine - lineSpacing;
		setTextAlignment(RenderText.ALIGN_LEFT);
		if text0 == "N" then                                                -- Unowned Field
			setTextBold(false);
			setTextColor(fsColor.gray.r, fsColor.gray.g, fsColor.gray.b, overlayTransLevel);
		else
			setTextBold(true);
			setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
		end;
		screenFieldName = "Field "..dispData[dispDataIdx].a;
		renderText(fsPrintPosX, fsPrintPosCurrLine, textNormalSize, screenFieldName);
		if dispData[dispDataIdx].b ~= nil then                              -- Hectares / Acres
			setTextAlignment(RenderText.ALIGN_RIGHT);
			setTextBold(false);
			renderText(fsPrintPosXRight, fsPrintPosCurrLine, textNormalSize, dispData[dispDataIdx].b);
		end;
	else
		if showingPercent then
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextBold(false);
			renderText(fsPrintPosX, fsPrintPosCurrLine, textNormalSize, dispData[dispDataIdx].a);
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(fsPrintPosXRight, fsPrintPosCurrLine, textNormalSize, dispData[dispDataIdx].b);
		else
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextBold(false);
			if dispData[dispDataIdx].c ~= nil then								-- Abbreviated fruit name/status
				renderText(fsPrintPosX, fsPrintPosCurrLine, textNormalSize, dispData[dispDataIdx].c);
			else
				renderText(fsPrintPosX, fsPrintPosCurrLine, textNormalSize, dispData[dispDataIdx].a);
			end;
			setTextAlignment(RenderText.ALIGN_RIGHT);
			if dispData[dispDataIdx].d ~= nil then                              -- Hectares / Acres
				renderText(fsPrintPosXRight, fsPrintPosCurrLine, textNormalSize, dispData[dispDataIdx].d);
			else
				renderText(fsPrintPosXRight, fsPrintPosCurrLine, textNormalSize, dispData[dispDataIdx].b);
			end;
		end;
	end;
	fsPrintPosCurrLine = fsPrintPosCurrLine - lineSpacing;
	if dispDataIdx == dispDataItems then
		blankTxt = "* END OF DATA *";
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(true);
		setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
		renderText(fsPrintPosX, fsPrintPosCurrLine, textNormalSize, blankTxt);
		blankTxt = " ";
	end;
end;

-- Display Info lines and icons

		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(false);
		setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
		renderText(fsPrintPosX, fsPrintInfoStart, textNormalSize, shortDashLine);
		setTextAlignment(RenderText.ALIGN_RIGHT);
		setTextBold(false);
		renderText(fsPrintPosXRight, fsPrintInfoStart, textSmallSize, string.format("%d/%d", currScreen, numScreens));

	if (not weAreScanning) and (not fsActive["CONF"]) and (not fsActive["MPLA"]) and (not fsActive["EDIT"]) then
		iconPosY = fsPrintInfoLine2 + 0.0018;
		iconPosX = fsPrintPosX + fsHud.Margin;
		fieldStatus:showImage("scan", "normal");
		fieldStatus:addButton("scanFields", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "HUD");
	end;

	if (not weAreScanning) and (not fsActive["CONF"]) and (not fsActive["MPLA"]) and (not fsActive["EDIT"]) then
		iconPosY = fsPrintInfoLine2 + 0.0018;
		iconPosX = fsPrintPosX + fsHud.Margin + (normalIconWidth * 2);
		fieldStatus:showImage("display", "normal");
		fieldStatus:addButton("displayFields", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "HUD");
	end;

	if not hudIsMoving and (not fsActive["EDIT"]) then
		iconPosY = fsPrintInfoLine2 + 0.0018;
		iconPosX = fsPrintPosX + fsHud.Margin + (normalIconWidth * 4);
		fieldStatus:showImage("moveHUD", "normal");
		fieldStatus:addButton("moveHUD", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "HUD");
	end;

	if not fsActive["CONF"] and (not fsActive["EDIT"]) then
		iconPosY = fsPrintInfoLine2 + 0.0018;
		iconPosX = fsPrintPosX + fsHud.Margin + (normalIconWidth * 6);
		fieldStatus:showImage("config", "normal");
		fieldStatus:addButton("configScreen", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "HUD");
	end;

	if not fsActive["HELP"] then
		iconPosY = fsPrintInfoLine2 + 0.0018;
		iconPosX = fsPrintPosX + fsHud.Margin + (normalIconWidth * 8);
		fieldStatus:showImage("help", "normal");
		fieldStatus:addButton("helpScreen", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "HUD");
	end;

		iconPosY = fsPrintInfoLine2;
		iconPosX = fsPrintPosXRight - fsHud.Margin - (normalIconWidth / 3);
		fieldStatus:showImage("close", "normal");
		fieldStatus:addButton("closeScreen", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "HUD");

		if msgTxtColor == "brightred" then
			if scanTimer <= scanTimerWait2 then
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(true);
				setTextColor(fsColor.brightred.r, fsColor.brightred.g, fsColor.brightred.b, overlayTransLevel);
				thisTextSize = fieldStatus:getTextSize(msgTxt,textNormalSize,"hud");
				renderText(fsPrintPosX, fsPrintMsgLine, thisTextSize, msgTxt);
			elseif scanTimer > scanTimerWait2 * 2 then
				scanTimer = 0;
			end;
		else
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextBold(true);
			setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
			thisTextSize = fieldStatus:getTextSize(msgTxt,textNormalSize,"hud");
			renderText(fsPrintPosX, fsPrintMsgLine, thisTextSize, msgTxt);
		end;

end;


function fieldStatus:showSubHUD()

	setOverlayColor(fsImg["HUD"].id, fsImg["HUD"].color.r, fsImg["HUD"].color.g, fsImg["HUD"].color.b, overlayTransLevel);
	renderOverlay(fsImg["HUD"].id, fsSubHudPosX, fsHud.PosY[fsHud.CurrPos], fsSubHudWidth, fsHud.Height);

	local fsSubPrintPosCurrLine = fsPrintPosY;
	local lineCount = 0;
	local showThisHeader, showThisLine = false, false;
	local thisMenu, rowTxt = "", "";
	local tw, tw1, strSplit, fieldStr, saveStr;
	local screen = fsSubHud.screen[fsSubHud.currScreen];

	setTextAlignment(RenderText.ALIGN_CENTER);
	setTextBold(true);
	setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
	if fsActive["CONF"] then
		thisMenu = "CONF";
		renderText(fsSubPrintPosXCenter, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textHeaderSize, "Config Menu");
	elseif fsActive["MPLA"] then
		thisMenu = "MPLA";
		renderText(fsSubPrintPosXCenter, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textSubHeaderSize, "Multiplayer Config");
	elseif fsActive["HELP"] then
		thisMenu = "HELP";
		renderText(fsSubPrintPosXCenter, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textHeaderSize, "Help Menu");
	elseif fsActive["SCAN"] then
		thisMenu = "SCAN";
		renderText(fsSubPrintPosXCenter, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textHeaderSize, "Scan Menu");
	elseif fsActive["DISP"] then
		thisMenu = "DISP";
		renderText(fsSubPrintPosXCenter, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textHeaderSize, "Display Menu");
	end;
	lineCount = lineCount + 1;

	for i=1,screen.numRows do
		if screen.desc[i] == "HDR" then
			showThisHeader = true;
			if fsActive["CONF"] or fsActive["MPLA"] then
				rowTxt = screen.value[i][1];
			elseif fsActive["SCAN"] then
				if screen.value[i][1] == "Default Scan" then
					rowTxt = screen.value[i][1];
				else
					showThisHeader = false;
				end;
			elseif fsActive["DISP"] then
				if screen.value[i][1] == "Default Display" then
					rowTxt = screen.value[i][1];
				else
					showThisHeader = false;
				end;
			elseif fsActive["HELP"] then
				rowTxt = screen.value[i];
			end;
			if showThisHeader then
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(false);
				setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
				renderText(fsSubPrintPosX, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, dashLine);
				lineCount = lineCount + 1;
				setTextAlignment(RenderText.ALIGN_CENTER);
				setTextBold(true);
				renderText(fsSubPrintPosXCenter, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, rowTxt);
				lineCount = lineCount + 1;
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(false);
				renderText(fsSubPrintPosX, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, dashLine);
				lineCount = lineCount + 1;
			end;
		elseif showThisHeader and fsActive["MPLA"] then
			showThisLine = true;
			rowTxt = string.format("%s", tostring(screen.value[i][screen.currOpt[i]]));
			if screen.desc[i] == "Frequency" then
				local freqNum = tonumber(rowTxt);
				if freqNum > 3600 then
					rowTxt = string.format("%d %s", freqNum / 3600, "hours");
				elseif freqNum == 3600 then
					rowTxt = string.format("%s", "1 hour");
				elseif freqNum > 60 then
					rowTxt = string.format("%d %s", freqNum / 60, "mins");
				elseif freqNum == 60 then
					rowTxt = string.format("%s", "1 min");
				elseif freqNum > 0 then
					rowTxt = string.format("%d %s", freqNum, "secs");
				elseif freqNum == 0 then
					rowTxt = "OFF";
				end;
			end;
			if showThisLine then
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(false);
				setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
				renderText(fsSubPrintPosX, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, screen.desc[i]);
				setTextAlignment(RenderText.ALIGN_RIGHT);
				setTextBold(false);
				renderText(fsSubPrintPosXRight - (smallIconWidth * 3.5), fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, rowTxt);
				if screen.numOpts[i] > 1 then
					iconPosY = fsSubPrintPosCurrLine - (lineSpacing * lineCount) + 0.003;
					iconPosX = fsSubPrintPosXRight - fsHud.Margin;
					fieldStatus:showImage("rightArrow", "small");
					fieldStatus:addButton("nextInList", iconPosX, iconPosY, iconPosX + smallIconWidth, iconPosY + smallIconHeight, i, thisMenu);
					iconPosX = iconPosX - smallIconWidth - 0.005;
					fieldStatus:showImage("leftArrow", "small");
					fieldStatus:addButton("prevInList", iconPosX, iconPosY, iconPosX + smallIconWidth, iconPosY + smallIconHeight, i, thisMenu);
				end;
				lineCount = lineCount + 1;
			end;
		elseif showThisHeader and (not fsActive["HELP"]) then
			showThisLine = true;
			rowTxt = string.format("%s", tostring(screen.value[i][screen.currOpt[i]]));
			if screen.desc[i] == "Frequency" then
				local freqNum = tonumber(rowTxt);
				if freqNum > 60 then
					rowTxt = string.format("%d %s", freqNum / 60, "hours");
				elseif freqNum == 60 then
					rowTxt = string.format("%s", "1 hour");
				elseif freqNum > 1 then
					rowTxt = string.format("%d %s", freqNum, "mins");
				elseif freqNum == 1 then
					rowTxt = string.format("%s", "1 min");
				end;
			end;
			if screen.desc[i] == "Scan Type" then
				showConfigFieldList = false;
				if rowTxt == "Custom" then
					showConfigFieldList = true;
				end;
			end;
			if screen.desc[i] == "Field List" then
				if showConfigFieldList then
					fieldStr = "";
					strSplit = Utils.splitString(" ", rowTxt);
					for tw = 1,#strSplit do
						saveStr = fieldStr;
						fieldStr = fieldStr .. strSplit[tw] .. " ";
						tw1=getTextWidth(1,fieldStr);
						if tw1 > 4.05 then
							rowTxt = string.gsub(saveStr, " $", "") .. "...";
							break;
						end;
					end;
					iconPosY = fsSubPrintPosCurrLine - (lineSpacing * lineCount);
					iconPosX = fsSubPrintPosXRight - fsHud.Margin - (smallIconWidth / 2);
					fieldStatus:showImage("edit", "normal");
					fieldStatus:addButton("editFieldList", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, i, thisMenu);
				else
					showThisLine = false;
				end;
			end;
			if showThisLine then
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(false);
				setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
				renderText(fsSubPrintPosX, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, screen.desc[i]);
				setTextAlignment(RenderText.ALIGN_RIGHT);
				setTextBold(false);
				renderText(fsSubPrintPosXRight - (smallIconWidth * 3.5), fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, rowTxt);
				if screen.numOpts[i] > 1 then
					iconPosY = fsSubPrintPosCurrLine - (lineSpacing * lineCount) + 0.003;
					iconPosX = fsSubPrintPosXRight - fsHud.Margin;
					fieldStatus:showImage("rightArrow", "small");
					fieldStatus:addButton("nextInList", iconPosX, iconPosY, iconPosX + smallIconWidth, iconPosY + smallIconHeight, i, thisMenu);
					iconPosX = iconPosX - smallIconWidth - 0.005;
					fieldStatus:showImage("leftArrow", "small");
					fieldStatus:addButton("prevInList", iconPosX, iconPosY, iconPosX + smallIconWidth, iconPosY + smallIconHeight, i, thisMenu);
				end;
				lineCount = lineCount + 1;
			end;
		elseif showThisHeader then
			showThisLine = true;
			if (screen.desc[i] == "MP Config:") and (not isMultiPlayerGame) then
				showThisLine = false;
			end;
			if showThisLine then
				if string.sub(screen.value[i], 1, 4) == "img=" then
					setTextAlignment(RenderText.ALIGN_LEFT);
					setTextBold(false);
					setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
					renderText(fsSubPrintPosX, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, screen.desc[i]);

					iconPosY = fsSubPrintPosCurrLine - (lineSpacing * lineCount) + 0.002;
					iconPosX = fsSubPrintPosXRight - fsHud.Margin;
					fieldStatus:showImage(string.sub(screen.value[i], 5), "normal");
					lineCount = lineCount + 1;
				else
					rowTxt = string.format("%s %s", screen.desc[i], screen.value[i]);
					thisTextSize = fieldStatus:getTextSize(rowTxt,textNormalSize,"subhud");
					if thisTextSize == textNormalSize then
						setTextAlignment(RenderText.ALIGN_LEFT);
						setTextBold(false);
						setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
						renderText(fsSubPrintPosX, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, screen.desc[i]);
						setTextAlignment(RenderText.ALIGN_RIGHT);
						setTextBold(false);
						renderText(fsSubPrintPosXRight, fsSubPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, screen.value[i]);
						lineCount = lineCount + 1;
					else
						setTextAlignment(RenderText.ALIGN_LEFT);
						setTextBold(false);
						renderText(fsSubPrintPosX, fsSubPrintPosCurrLine - (lineSpacing * lineCount), thisTextSize, rowTxt);
						lineCount = lineCount + 1;
					end;
				end;
			end;
		end;
	end;

	if fsActive["CONF"] or fsActive["MPLA"] or fsActive["SCAN"] or fsActive["DISP"] then
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextBold(false);
		setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
		rowTxt = "HUD position will also be saved";
		thisTextSize = fieldStatus:getTextSize(rowTxt,textNormalSize,"subhud");
		renderText(fsSubPrintPosX, fsPrintInfoStart + lineSpacing, thisTextSize, rowTxt);

		iconPosY = fsPrintInfoLine2 + 0.0018;
		iconPosX = fsSubPrintPosX + fsHud.Margin;
		fieldStatus:showImage("save", "normal");
		fieldStatus:addButton("saveConfig", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, thisMenu);
	end;

	if fsActive["CONF"] then
		if isMultiPlayerGame then
			iconPosY = fsPrintInfoLine2 + 0.0018;
			iconPosX = fsSubPrintPosX + fsHud.Margin + (normalIconWidth * 4);
			fieldStatus:showImage("bale", "normal");
			fieldStatus:addButton("MPConfig", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, thisMenu);
		end;
	end;

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);
	setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
	renderText(fsSubPrintPosX, fsPrintInfoStart, textNormalSize, shortDashLine);
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(false);
	local thisScreen, totScreens = 0, 0;
	if fsActive["CONF"] then
		totScreens = fsSubHud.numConfigScreens;
		for i=1,totScreens do
			if fsSubHud.currScreen == fsSubHud.configScreens[i] then
				thisScreen = i;
			end;
		end;
	elseif fsActive["MPLA"] then
		totScreens = fsSubHud.numMPConfigScreens;
		for i=1,totScreens do
			if fsSubHud.currScreen == fsSubHud.MPConfigScreens[i] then
				thisScreen = i;
			end;
		end;
	elseif fsActive["HELP"] then
		totScreens = fsSubHud.numHelpScreens;
		for i=1,totScreens do
			if fsSubHud.currScreen == fsSubHud.helpScreens[i] then
				thisScreen = i;
			end;
		end;
	else
		thisScreen, totScreens = 1, 1;
	end;
	renderText(fsSubPrintPosXRight, fsPrintInfoStart, textSmallSize, string.format("%d/%d", thisScreen, totScreens));
	setTextAlignment(RenderText.ALIGN_LEFT);

	iconPosY = fsPrintInfoLine2;
	iconPosX = fsSubPrintPosXRight - fsHud.Margin - (normalIconWidth / 3);
	fieldStatus:showImage("close", "normal");
	fieldStatus:addButton("closeScreen", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, thisMenu);

	if configTxt ~= "" then
		if configTxtColor == "brightred" then
			if scanTimer <= scanTimerWait2 then
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(true);
				setTextColor(fsColor.brightred.r, fsColor.brightred.g, fsColor.brightred.b, overlayTransLevel);
				thisTextSize = fieldStatus:getTextSize(configTxt,textNormalSize,"subhud");
				renderText(fsSubPrintPosX, fsPrintMsgLine, thisTextSize, configTxt);
			elseif scanTimer > scanTimerWait2 * 2 then
				scanTimer = 0;
			end;
		else
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextBold(true);
			setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
			thisTextSize = fieldStatus:getTextSize(configTxt,textNormalSize,"subhud");
			renderText(fsSubPrintPosX, fsPrintMsgLine, thisTextSize, configTxt);
			setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
		end;
	end;

end;


function fieldStatus:showMiniHUD()

	setOverlayColor(fsImg["HUD"].id, fsImg["HUD"].color.r, fsImg["HUD"].color.g, fsImg["HUD"].color.b, overlayTransLevel);
	renderOverlay(fsImg["HUD"].id, fsMiniPosX, fsMiniPosY, fsHud.Width, fsMiniHudHeight);

	fsMiniPrintPosCurrLine	= fsMiniPrintPosY;
	local lineCount = 0;

	setTextAlignment(RenderText.ALIGN_CENTER);
	setTextBold(true);
	setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
	renderText(fsMiniPrintPosXCenter, fsMiniPrintPosCurrLine - (lineSpacing * lineCount), textHeaderSize, "Edit Field List");
	lineCount = lineCount + 2;

	local editString = "Field(s) >"..scanField.."<";
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(true);
	setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
	setTextWrapWidth(fsHudPrintWidth);
	renderText(fsMiniPrintPosX, fsMiniPrintPosCurrLine - (lineSpacing * lineCount), textNormalSize, editString);
	setTextWrapWidth(0);

	iconPosY = fsMiniPrintInfoLine2;
	iconPosX = fsMiniPrintPosX + (normalIconWidth / 3);
	fieldStatus:showImage("accept", "normal");
	fieldStatus:addButton("acceptEntry", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "EDIT");

	iconPosX = fsMiniPrintPosX + (normalIconWidth * 6);
	fieldStatus:showImage("erase", "normal");
	fieldStatus:addButton("eraseEntry", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "EDIT");

	iconPosX = fsMiniPrintPosXRight - fsHud.Margin - (normalIconWidth / 3);
	fieldStatus:showImage("close", "normal");
	fieldStatus:addButton("closeScreen", iconPosX, iconPosY, iconPosX + normalIconWidth, iconPosY + normalIconHeight, nil, "EDIT");

	if scanField ~= saveScanField then				-- Input list is changing, so erase any error message
		editTxt = ""; editTxtColor = "";
	end;

	if editTxt ~= "" then
		if editTxtColor == "brightred" then
			if scanTimer <= scanTimerWait2 then
				setTextAlignment(RenderText.ALIGN_LEFT);
				setTextBold(true);
				setTextColor(fsColor.brightred.r, fsColor.brightred.g, fsColor.brightred.b, overlayTransLevel);
				thisTextSize = fieldStatus:getTextSize(editTxt,textNormalSize,"subhud");
				renderText(fsMiniPrintPosX, fsMiniPrintMsgLine, thisTextSize, editTxt);
			elseif scanTimer > scanTimerWait2 * 2 then
				scanTimer = 0;
			end;
		else
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextBold(true);
			setTextColor(fsColor.blue.r, fsColor.blue.g, fsColor.blue.b, overlayTransLevel);
			thisTextSize = fieldStatus:getTextSize(editTxt,textNormalSize,"subhud");
			renderText(fsMiniPrintPosX, fsMiniPrintMsgLine, thisTextSize, editTxt);
			setTextColor(fsColor.white.r, fsColor.white.g, fsColor.white.b, overlayTransLevel);
		end;
	end;

	saveScanField = scanField;

end;


function fieldStatus:getFieldDefinitions(arg)

	numFieldDefs = g_currentMission.fieldDefinitionBase.numberOfFields;
	print('fieldStatus: numFieldDefs:         '..numFieldDefs);

	if arg == nil then arg = "reload"; end;

	if arg == "init" then
		thisXMLFile = Utils.getFilename(fieldDataFile, g_currentMission.missionInfo.savegameDirectory.."/");
		xmlFile = loadXMLFile("xmlFile", thisXMLFile);
		fieldStatus:loadFieldData();
		if xmlFileFound and loadSuccess and (numFieldDefs == numFields) then
			print("fieldStatus: Field Data loaded from XML file.");
			msgTxt = "Field Data loaded from XML.";  msgTxtColor = "";
			fieldDefsLoaded = true;
			fieldStatus:process_fieldData("display");
			return;
		elseif fixedXML then													-- FIXFLDDEF
			if numFields > 0 and maxCoords > 0 then								-- FIXFLDDEF
			end;																-- FIXFLDDEF
		end;
	end;

	loadSuccess = true;
	numFields = numFieldDefs;
	fieldStatus:get_maxCoords();

	fieldStatus:initFieldData();

	fieldStatus:readFieldDefs();

	if not loadSuccess then
		errMsgEnabled = true;
		errMsgTxt = "fieldStatus: Field Definition Error: Check log";
	else
		print("fieldStatus: Field Definitions being loaded from map.");
		weAreScanning = true;  scanType = "All"; scanSource = "init"; scanTimer = 0;  scanIdx = 1;
		baleScanStart = true;
		numOwned = fieldStatus:checkOwned();
	end;

	fieldDefsLoaded = true;
	currScreen = 1;

end;


function fieldStatus:loadConfigData()

	fsConfig = {};
	local xmlTag = {};
	local tagname, xmltag1, xmltag2, xmltag3, thisHeader;
	local fsConfigTag = "fieldStatusConfig";
	local xmlFile = loadXMLFile(fsConfigTag, fsConfigFile);

	if xmlFile ~= nil then
		for i=1,#fsConfigHeader do
			fsConfig[fsConfigHeader[i]] = {};
			fsConfig[fsConfigHeader[i]].fieldList = {};
			tagname = string.format("%s."..fsConfigHeader[i], fsConfigTag);
			if fsConfigHeader[i] == "AutoScan" or fsConfigHeader[i] == "BaleScan" then
				xmltag1 = getXMLBool(xmlFile, tagname.."#active");
				xmltag2 = getXMLInt(xmlFile, tagname.."#freq");
				if xmltag1 ~= nil then
					fsConfig[fsConfigHeader[i]].active = xmltag1;
					fsActive[fsConfigHeader[i]] = xmltag1;
				end;
				if xmltag2 ~= nil then
					fsConfig[fsConfigHeader[i]].freq = xmltag2;
				end;
			end;

			if fsConfigHeader[i] == "BaleScan" then
				xmltag1 = getXMLBool(xmlFile, tagname.."#eachhostscan");
				xmltag2 = getXMLBool(xmlFile, tagname.."#eachbale");
				xmltag3 = getXMLBool(xmlFile, tagname.."#playerjoin");
				if xmltag1 ~= nil then
					fsConfig[fsConfigHeader[i]].eachHostScan = xmltag1;
				end;
				if xmltag2 ~= nil then
					fsConfig[fsConfigHeader[i]].eachBale = xmltag2;
				end;
				if xmltag3 ~= nil then
					fsConfig[fsConfigHeader[i]].playerJoin = xmltag3;
				end;
			else
				xmltag1 = getXMLString(xmlFile, tagname.."#type");
				xmltag2 = getXMLString(xmlFile, tagname.."#fruit");
				if xmltag1 ~= nil then
					fsConfig[fsConfigHeader[i]].type = xmltag1;
				end;
				if xmltag2 ~= nil then
					fsConfig[fsConfigHeader[i]].fruit = xmltag2;
				end;
			end;

			n=0;
			if fsConfigHeader[i] ~= "BaleScan" then
				while true do
					tagname = string.format("%s."..fsConfigHeader[i]..".fieldList(%d)", fsConfigTag, n);
					xmltag1 = getXMLString(xmlFile, tagname.."#map");
					xmltag2 = getXMLString(xmlFile, tagname.."#fields");
					if xmltag1 == nil or xmltag2 == nil then
						break;
					else
						xmlTag = {};
						xmlTag.map = xmltag1; xmlTag.fields = xmltag2;
						table.insert(fsConfig[fsConfigHeader[i]].fieldList, xmlTag);
						if xmltag1 == thisMap then
							fsConfig[fsConfigHeader[i]].customFieldList = xmltag2;
						end;
					end;
					n=n+1;
				end;
			end;
		end;

		tagname = string.format("%s.HudPosition", fsConfigTag);
		xmltag3 = getXMLInt(xmlFile, tagname.."#currPos");

		if fsHud.PosX[3] == 0 and fsHud.PosY[3] == 0 then
			xmltag1 = getXMLFloat(xmlFile, tagname.."#posX");
			xmltag2 = getXMLFloat(xmlFile, tagname.."#posY");
			if xmltag1 ~= nil and xmltag2 ~= nil then
				fsHud.PosX[3] = xmltag1;
				fsHud.PosY[3] = xmltag2;
			end;
		end;
		if xmltag3 ~= nil then
			fsHud.CurrPos = xmltag3;				-- Use the last saved current HUD position
			if fsHud.PosX[fsHud.CurrPos] == 0 or fsHud.PosY[fsHud.CurrPos] == 0 then
				fsHud.CurrPos = 1;
			end;
			fieldStatus:calcHUDLines();
		end;

	end;

	needToSaveConfig = false;
	for i=1,#fsConfigHeader do
		if fsConfigHeader[i] == "BaleScan" then
			if fsConfig[fsConfigHeader[i]].active == nil then
				needToSaveConfig = true;
			end;
		else
			if fsConfig[fsConfigHeader[i]].type == nil then
				needToSaveConfig = true;
			end;
		end;
	end;

	if needToSaveConfig then
		fieldStatus:saveConfigData();
	end;

	if not needToSaveConfig then
		if fsSubHud.numMPConfigScreens > 0 and fsSubHud.MPConfigScreens[1] ~= nil then
			local d,x;
			local screen = fsSubHud.screen[fsSubHud.MPConfigScreens[1]];
			for d=1,screen.numRows do
				if screen.desc[d] == "HDR" then thisHeader = string.gsub(screen.value[d][1], " ", ""); end;
				if screen.desc[d] == "Active" then
					if thisHeader == "BaleScan" then
						if fsConfig[thisHeader].active ~= nil then
							for x=1,screen.numOpts[d] do
								if fsConfig[thisHeader].active == screen.value[d][x] then
									screen.currOpt[d] = x;
									break;
								end;
							end;
						end;
					end;
				elseif screen.desc[d] == "Frequency" then
					if thisHeader == "BaleScan" then
						if fsConfig[thisHeader].freq ~= nil then
							for x=1,screen.numOpts[d] do
								if fsConfig[thisHeader].freq == screen.value[d][x] then
									screen.currOpt[d] = x;
									break;
								end;
							end;
						end;
					end;
				elseif screen.desc[d] == "Each host scan" then
					if fsConfig[thisHeader].eachHostScan ~= nil then
						for x=1,screen.numOpts[d] do
							if fsConfig[thisHeader].eachHostScan == screen.value[d][x] then
								screen.currOpt[d] = x;
								break;
							end;
						end;
					end;
				elseif screen.desc[d] == "Bale created /" then
					if fsConfig[thisHeader].eachBale ~= nil then
						for x=1,screen.numOpts[d] do
							if fsConfig[thisHeader].eachBale == screen.value[d][x] then
								screen.currOpt[d] = x;
								break;
							end;
						end;
					end;
				elseif screen.desc[d] == "Player join" then
					if fsConfig[thisHeader].playerJoin ~= nil then
						for x=1,screen.numOpts[d] do
							if fsConfig[thisHeader].playerJoin == screen.value[d][x] then
								screen.currOpt[d] = x;
								break;
							end;
						end;
					end;
				end;
			end;
		else
			loadSuccess = false;
			errMsgEnabled = true;
			errMsgTxt = "fieldStatus: Missing MP Config Screen";
			return;
		end;

		if fsSubHud.numConfigScreens > 0 and fsSubHud.configScreens[1] ~= nil then
			local d,x;
			local screen = fsSubHud.screen[fsSubHud.configScreens[1]];
			for d=1,screen.numRows do
				if screen.desc[d] == "HDR" then thisHeader = string.gsub(screen.value[d][1], " ", ""); end;
				if screen.desc[d] == "Active" then
					if thisHeader == "AutoScan" then
						if fsConfig[thisHeader].active ~= nil then
							for x=1,screen.numOpts[d] do
								if fsConfig[thisHeader].active == screen.value[d][x] then
									screen.currOpt[d] = x;
									break;
								end;
							end;
						end;
					end;
				elseif screen.desc[d] == "Frequency" then
					if thisHeader == "AutoScan" then
						if fsConfig[thisHeader].freq ~= nil then
							for x=1,screen.numOpts[d] do
								if fsConfig[thisHeader].freq == screen.value[d][x] then
									screen.currOpt[d] = x;
									break;
								end;
							end;
						end;
					end;
				elseif screen.desc[d] == "Scan Type" then
					if fsConfig[thisHeader].type ~= nil then
						for x=1,screen.numOpts[d] do
							if fsConfig[thisHeader].type == screen.value[d][x] then
								screen.currOpt[d] = x;
								break;
							end;
						end;
					end;
				elseif screen.desc[d] == "Field List" then
					if fsConfig[thisHeader].customFieldList ~= nil then
						screen.value[d][1] = fsConfig[thisHeader].customFieldList;
						screen.currOpt[d] = 1;
					end;
				elseif screen.desc[d] == "Fruit" then
					if fsConfig[thisHeader].fruit ~= nil then
						for x=1,screen.numOpts[d] do
							if fsConfig[thisHeader].fruit == screen.value[d][x] then
								screen.currOpt[d] = x;
								break;
							end;
						end;
					end;
				end;
			end;
		else
			loadSuccess = false;
			errMsgEnabled = true;
			errMsgTxt = "fieldStatus: Missing Config Screen";
			return;
		end;
	end;

	configLoaded = true;

end;


function fieldStatus:saveConfigData()

	if fsSubHud.numConfigScreens == 0 or fsSubHud.configScreens[1] == nil then
		loadSuccess = false;
		errMsgEnabled = true;
		errMsgTxt = "fieldStatus: Missing Config Screen";
	end;
	if fsSubHud.numMPConfigScreens == 0 or fsSubHud.MPConfigScreens[1] == nil then
		loadSuccess = false;
		errMsgEnabled = true;
		if errMsgTxt == "" then
			errMsgTxt = "fieldStatus: Missing MP Config Screen";
		else
			errMsgTxt = errMsgTxt .. " and MP Config";
		end;
	end;
	if not loadSuccess then
		return;
	end;

	local tagname, thisHeader = nil, nil;
	local fsConfigTag = "fieldStatusConfig";
	local xmlFile = createXMLFile(fsConfigTag, fsConfigFile, fsConfigTag);
	local screen,d,n,x,xx;

		if xmlFile ~= nil then
			screen = fsSubHud.screen[fsSubHud.configScreens[1]];
			for d=1,screen.numRows do
				if screen.desc[d] == "HDR" then
					thisHeader = string.gsub(screen.value[d][1], " ", "");
					xx = 0;
				end;
				tagname = string.format("%s."..thisHeader, fsConfigTag);
				if screen.desc[d] == "Active" then
					if thisHeader == "AutoScan" then
						setXMLBool(xmlFile, tagname.."#active", screen.value[d][screen.currOpt[d]]);
						fsActive[thisHeader] = screen.value[d][screen.currOpt[d]];
						fsConfig[thisHeader].active = screen.value[d][screen.currOpt[d]];
					end;
				elseif screen.desc[d] == "Frequency" then
					if thisHeader == "AutoScan" then
						setXMLInt(xmlFile, tagname.."#freq", screen.value[d][screen.currOpt[d]]);
						fsConfig[thisHeader].freq = screen.value[d][screen.currOpt[d]];
					end;
				elseif screen.desc[d] == "Scan Type" then
					setXMLString(xmlFile, tagname.."#type", screen.value[d][screen.currOpt[d]]);
					fsConfig[thisHeader].type = screen.value[d][screen.currOpt[d]];
--					if screen.value[d][screen.currOpt[d]] == "Custom" then
--						if fsConfig[thisHeader].customFieldList == nil then
--							configTxt = "Field List is Empty"; configTxtColor = "brightred";
--						end;
--					end;
				elseif screen.desc[d] == "Fruit" then
					setXMLString(xmlFile, tagname.."#fruit", screen.value[d][screen.currOpt[d]]);
					fsConfig[thisHeader].fruit = screen.value[d][screen.currOpt[d]];
				elseif screen.desc[d] == "Field List" then
					if fsConfig[thisHeader].fieldList ~= nil then
						x=1;
						while true do
							if fsConfig[thisHeader].fieldList[x] ~= nil then
								tagname = string.format("%s."..thisHeader..".fieldList(%d)", fsConfigTag, xx);
								setXMLString(xmlFile, tagname.."#map", fsConfig[thisHeader].fieldList[x].map);
								setXMLString(xmlFile, tagname.."#fields", fsConfig[thisHeader].fieldList[x].fields);
								xx = xx + 1;
							else
								break;
							end;
							x=x+1;
						end;
					end;
				end;
			end;

			screen = fsSubHud.screen[fsSubHud.MPConfigScreens[1]];
			for d=1,screen.numRows do
				if screen.desc[d] == "HDR" then
					thisHeader = string.gsub(screen.value[d][1], " ", "");
				end;
				tagname = string.format("%s."..thisHeader, fsConfigTag);
				if screen.desc[d] == "Active" then
					if thisHeader == "BaleScan" then
						setXMLBool(xmlFile, tagname.."#active", screen.value[d][screen.currOpt[d]]);
						fsActive[thisHeader] = screen.value[d][screen.currOpt[d]];
						fsConfig[thisHeader].active = screen.value[d][screen.currOpt[d]];
					end;
				elseif screen.desc[d] == "Frequency" then
					if thisHeader == "BaleScan" then
						setXMLInt(xmlFile, tagname.."#freq", screen.value[d][screen.currOpt[d]]);
						fsConfig[thisHeader].freq = screen.value[d][screen.currOpt[d]];
					end;
				elseif screen.desc[d] == "Each host scan" then
					setXMLBool(xmlFile, tagname.."#eachhostscan", screen.value[d][screen.currOpt[d]]);
					fsConfig[thisHeader].eachHostScan = screen.value[d][screen.currOpt[d]];
				elseif screen.desc[d] == "Bale created /" then
					setXMLBool(xmlFile, tagname.."#eachbale", screen.value[d][screen.currOpt[d]]);
					fsConfig[thisHeader].eachBale = screen.value[d][screen.currOpt[d]];
				elseif screen.desc[d] == "Player join" then
					setXMLBool(xmlFile, tagname.."#playerjoin", screen.value[d][screen.currOpt[d]]);
					fsConfig[thisHeader].playerJoin = screen.value[d][screen.currOpt[d]];
				end;
			end;
			if fsConfig["BaleScan"].active then
				if tonumber(fsConfig["BaleScan"].freq) == 0 and
					(not fsConfig["BaleScan"].eachHostScan) and
					(not fsConfig["BaleScan"].eachBale) and
					(not fsConfig["BaleScan"].playerJoin) then
						configTxt = "Nothing Active"; configTxtColor = "brightred";
				end;
			end;

			tagname = string.format("%s.HudPosition", fsConfigTag);
			setXMLInt(xmlFile, tagname.."#currPos", fsHud.CurrPos);
			if fsHud.PosX[3] > 0 and fsHud.PosY[3] > 0 then
				setXMLFloat(xmlFile, tagname.."#posX", fsHud.PosX[3]);
				setXMLFloat(xmlFile, tagname.."#posY", fsHud.PosY[3]);
			end;

			if configTxt == "" then
				saveXMLFile(xmlFile);
				configTxt = "Config file saved."; configTxtColor = "";
			end;
		else
			loadSuccess = false;
			errMsgEnabled = true;
			errMsgTxt = "fieldStatus: ERR Saving Config file";
			return;
		end;

end;


function fieldStatus:loadFieldData()

if debug then print("BEG func fieldStatus:loadFieldData"); end;

local k, m, n, o;

	local basename="fieldData";
	fieldDataVersion = getXMLString(xmlFile, basename.."#version");
	if fieldDataVersion == nil or (fieldDataVersion < fieldStatus.version) then
		print("fieldStatus: Found old version of fieldData.xml; will update on next save.");
		loadSuccess = false;
	end;

	if loadSuccess then
		m=0;
		while true do
			local basename=string.format("fieldData.map(%d)", m);
			mapName = getXMLString(xmlFile, basename.."#name");
			if mapName == nil then
				xmlFileFound = false;
				break;
			elseif mapName == fsMap then
				mapId=m;
				xmlFileFound = true;
				loadSuccess = true;
				numFields = getXMLInt(xmlFile, basename.."#numFields");
				maxCoords = getXMLInt(xmlFile, basename.."#maxCoords");
				fixedXML = getXMLBool(xmlFile, basename.."#fixedXML");			-- FIXFLDDEF
				if fixedXML == nil then fixedXML = false; end;					-- FIXFLDDEF
				altPDAPath = getXMLString(xmlFile, basename.."#altPDAPath");
				if numFields == nil or numFields <= 0 then
					print("fieldStatus: ERR: Missing numFields for ", mapName);
					loadSuccess = false;
				end;
				if maxCoords == nil or maxCoords <= 0 then
					print("fieldStatus: ERR: Missing maxCoords for ", mapName);
					loadSuccess = false;
				end;
				break;
			end;
			m=m+1;
		end;
	end;

	if (not loadSuccess) or (not xmlFileFound) then
		if debug then
			print("leaving function early: fieldStatus:loadFieldData");
			print("END func fieldStatus:loadFieldData");
		end;
		return;
	end;

	fieldStatus:initFieldData();
	numOwned = 0;

	k=mapId; m=0;
	while true do
		local basename=string.format("fieldData.map(%d).field(%d)", k, m);
		local fieldName = getXMLString(xmlFile, basename.."#name");
		if fieldName == nil then
			if m == 0 then
				print("fieldStatus: ERR: No Fields found for ", mapName);
				loadSuccess = false;
			end;
			break;
		else
			if debug then print("    fieldName >"..fieldName.."<"); end;
			fieldData[m+1].name = fieldName;
			local fieldOwned = getXMLString(xmlFile, basename.."#owned");
			if fieldOwned ~= nil and fieldOwned == "Y" then
				fieldData[m+1].owned = "Y";
				numOwned = numOwned + 1;
			else
				fieldData[m+1].owned = "N";
			end;
			local fieldArea = getXMLInt(xmlFile, basename.."#area");
			if fieldArea == nil or fieldArea <= 0 then
				print("fieldStatus: ERR: Missing Area for Field ", fieldName);
				loadSuccess = false;
				break;
			else
				fieldData[m+1].area = fieldArea;
				local fieldHectares = getXMLFloat(xmlFile, basename.."#hectares");
				if fieldHectares == nil or fieldHectares <= 0 then
					fieldHectares = fieldArea * areaToHectare;
				end;
				local fieldAcres = getXMLFloat(xmlFile, basename.."#acres");
				if fieldAcres == nil or fieldAcres <= 0 then
					fieldAcres = fieldHectares * hectareToAcre;
				end;
				fieldData[m+1].hectares = fieldHectares;
				fieldData[m+1].acres = fieldAcres;
				mapHectares = mapHectares + fieldHectares;
				mapAcres = mapAcres + fieldAcres;
			end;
			local fieldDensity = getXMLInt(xmlFile, basename.."#density");
			if fieldDensity == nil then
				fieldDensity = 0;
			end;
			fieldData[m+1].fieldDensity = fieldDensity;
		end;
		n=0;
		while true do
			local basename=string.format("fieldData.map(%d).field(%d).coordinates(%d)", k, m, n);
			local c1 = getXMLFloat(xmlFile, basename.."#startX");
			local c2 = getXMLFloat(xmlFile, basename.."#startZ");
			local c3 = getXMLFloat(xmlFile, basename.."#endX");
			local c4 = getXMLFloat(xmlFile, basename.."#endZ");
			if c1 == nil or c2 == nil or c3 == nil or c4 == nil then
				if n == 0 then
					print("fieldStatus: ERR: Missing Coordinates for Field ", fieldName);
					loadSuccess = false;
				end;
				break;
			else
				if debug then print("        coordinates >"..c1..", "..c2..", "..c3..", "..c4.."<"); end;
				fieldData[m+1].coord[n+1].startX = c1;
				fieldData[m+1].coord[n+1].startZ = c2;
				fieldData[m+1].coord[n+1].endX = c3;
				fieldData[m+1].coord[n+1].endZ = c4;
			end;
			n=n+1;
			if n > maxCoords then
				break;
			end;
		end;
		if loadSuccess then
			n=0;
			while true do
				local basename=string.format("fieldData.map(%d).field(%d).status(%d)", k, m, n);
				local s1 = getXMLInt(xmlFile, basename.."#num");
				local s2 = getXMLFloat(xmlFile, basename.."#density");
				if s1 == nil or s2 == nil then
					break;
				else
					if debug then print("        status >"..s1.."  density: "..string.format("%9d", s2).."<"); end;
					fieldData[m+1].status[s1].density = s2;
				end;
				n=n+1;
			end;
		end;
		if loadSuccess then
			n=0;
			while true do
				local basename=string.format("fieldData.map(%d).field(%d).fruit(%d)", k, m, n);
				local f1 = getXMLString(xmlFile, basename.."#name");
				if f1 == nil then
					break;
				else
					if debug then print("        fruit >"..f1.."<"); end;
					fieldData[m+1].fruit[n+1].name = f1;
				end;
				o=0;
				while true do
					local basename=string.format("fieldData.map(%d).field(%d).fruit(%d).growth(%d)", k, m, n, o);
					local g1 = getXMLInt(xmlFile, basename.."#num");
					local g2 = getXMLFloat(xmlFile, basename.."#density");
					if g1 == nil or g2 == nil then
						break;
					else
						if debug then print("            growth >"..g1.."  density: "..string.format("%9d", g2).."<"); end;
						fieldData[m+1].fruit[n+1].growth[g1].density = g2;
					end;
					o=o+1;
				end;
				local basename=string.format("fieldData.map(%d).field(%d).fruit(%d).windrow", k, m, n);
				local w1 = getXMLFloat(xmlFile, basename.."#density");
				if w1 ~= nil then
					if debug then print("           windrow >   density: "..string.format("%9d", w1).."<"); end;
					fieldData[m+1].fruit[n+1].windrowDensity = w1;
				end;
				n=n+1;
			end;
		end;
		if loadSuccess then
			n=0;
			while true do
				local basename=string.format("fieldData.map(%d).field(%d).bale(%d)", k, m, n);
				local b1 = getXMLInt(xmlFile, basename.."#num");
				local b2 = getXMLString(xmlFile, basename.."#type");
				if b1 == nil or b2 == nil or b1 <= 0 then
					break;
				else
					if debug then print("         bale >"..b2.."  num: "..string.format("%6d", b1).."<"); end;
					fieldData[m+1].bales[b2] = b1;
				end;
				n=n+1;
			end;
		end;
		m=m+1;
		if m > numFields then
			break;
		end;
	end;

if debug then print("END func fieldStatus:loadFieldData"); end;

end;


function fieldStatus:initFieldData()

local m, n, o;

mapHectares = 0;
mapAcres = 0;
fMapHect, fMapAcre = 0, 0;

chname[0]="0: cult";
chname[1]="1: plow";
chname[2]="2: seed";
chname[3]="3: sWid";
chname[4]="4: fert";

for m=1,numFields do
	fieldData[m] = {};
	fieldData[m].coord = {};
	fieldData[m].status = {};
	fieldData[m].fruit = {};
	fieldData[m].bales = {};
	for n=1,maxCoords do
		fieldData[m].coord[n] = {};
	end;
	for n=0,numFSChannels-1 do
		fieldData[m].status[n] = {};
		fieldData[m].status[n].density = 0;
	end;
	for n=1, FruitUtil.NUM_FRUITTYPES do
		fieldData[m].fruit[n] = {};
		fieldData[m].fruit[n].windrowDensity = 0;
		fieldData[m].fruit[n].growth = {};
		for o=0,numGrowthStates-1 do
			fieldData[m].fruit[n].growth[o] = {};
			fieldData[m].fruit[n].growth[o].density = 0;
		end;
	end;
end;

dispDataItems = 0;

end;


function fieldStatus:reset_fieldData(resIdx)

local m, n, o;
--for m=1,numFields do
	fieldData[resIdx].status = {};
	fieldData[resIdx].fruit = {};
	for n=0,numFSChannels-1 do
		fieldData[resIdx].status[n] = {};
		fieldData[resIdx].status[n].density = 0;
	end;
	for n=1,FruitUtil.NUM_FRUITTYPES do
		fieldData[resIdx].fruit[n] = {};
		fieldData[resIdx].fruit[n].windrowDensity = 0;
		fieldData[resIdx].fruit[n].growth = {};
		for o=0,numGrowthStates-1 do
			fieldData[resIdx].fruit[n].growth[o] = {};
			fieldData[resIdx].fruit[n].growth[o].density = 0;
		end;
	end;
--end;

end;


function fieldStatus:checkHUDInput()

	local xmlTag = {};
	local currFieldListSaved = false;

	if (InputBinding.hasEvent(InputBinding.fs_ACTIVATE_HUD)) then
		if not loadSuccess then
			errMsgEnabled = not errMsgEnabled;
			if fsActive["HUD"] then
				fieldStatus:activateScreen("HUD", false);
			end;
		else
			fieldStatus:activateScreen("HUD", not fsActive["HUD"]);
		end;
	end;
	if fsActive["HUD"] then
		buttonActionTaken = false;
		if fsButton ~= nil then
			for i=1,#fsButton do
				if fsButton[i] ~= nil and fsButton[i].isClicked then
					fsButton[i].isClicked = false;
					buttonActionTaken = true;
					if fsButton[i].action == "closeScreen" then
						fieldStatus:activateScreen(fsButton[i].onScreen, false);
						break;
					elseif fsButton[i].action == "configScreen" then
						fieldStatus:activateScreen("CONF", true);
						break;
					elseif fsButton[i].action == "MPConfig" then
						fieldStatus:activateScreen("MPLA", true);
						break;
					elseif fsButton[i].action == "helpScreen" then
						fieldStatus:activateScreen("HELP", true);
						break;
					elseif fsButton[i].action == "scanFields" then
						fieldStatus:prepDefaultScan();
						break;
					elseif fsButton[i].action == "displayFields" then
						fieldStatus:prepDefaultDisplay();
						break;
					elseif fsButton[i].action == "toggleAutoScan" then
						fsActive["AutoScan"] = not fsActive["AutoScan"];
						fsConfig["AutoScan"].active = fsActive["AutoScan"];
						local screen = fsSubHud.screen[fsSubHud.configScreens[1]];
						local d, thisHeader;
						thisHeader = "";
						for d=1,screen.numRows do
							if screen.desc[d] == "HDR" then thisHeader = string.gsub(screen.value[d][1], " ", ""); end;
							if screen.desc[d] == "Active" then
								if thisHeader == "AutoScan" then
									if fsConfig[thisHeader].active ~= nil then
										for x=1,screen.numOpts[d] do
											if fsConfig[thisHeader].active == screen.value[d][x] then
												screen.currOpt[d] = x;
											end;
										end;
									end;
								end;
							end;
						end;
						break;
					elseif fsButton[i].action == "editFieldList" then
						fieldStatus:activateScreen("EDIT", true);
						configTxt = ""; configTxtColor = "";
						editRow = fsButton[i].row;
						local screen = fsSubHud.screen[fsSubHud.configScreens[1]];
						local d, thisHeader;
						thisHeader = "";
						for d=1,screen.numRows do
							if screen.desc[d] == "HDR" then thisHeader = string.gsub(screen.value[d][1], " ", ""); end;
							if d == editRow then
								scanField = fsConfig[thisHeader].customFieldList or "";
								break;
							end;
						end;
						break;
					elseif fsButton[i].action == "acceptEntry" then
						fieldStatus:checkInput();
						if validInput then
							fieldStatus:activateScreen("EDIT", false);
							local screen = fsSubHud.screen[fsSubHud.configScreens[1]];
							local d, thisHeader;
							thisHeader = "";
							for d=1,screen.numRows do
								if screen.desc[d] == "HDR" then thisHeader = string.gsub(screen.value[d][1], " ", ""); end;
								if d == editRow then
									screen.value[editRow][1] = table.concat(scanFieldArray, " ");
									fsConfig[thisHeader].customFieldList = screen.value[editRow][1];
									currFieldListSaved = false;
									for y=1,#fsConfig[thisHeader].fieldList do
										if fsConfig[thisHeader].fieldList[y].map == thisMap then
											fsConfig[thisHeader].fieldList[y].fields = fsConfig[thisHeader].customFieldList;
											currFieldListSaved = true;
											break;
										end;
									end;
									if not currFieldListSaved then
										xmlTag = {};
										xmlTag.map = thisMap; xmlTag.fields = fsConfig[thisHeader].customFieldList;
										table.insert(fsConfig[thisHeader].fieldList, xmlTag);
									end;
									break;
								end;
							end;
						else
							editTxt = "Field List Error"; editTxtColor = "brightred";
						end;
						break;
					elseif fsButton[i].action == "eraseEntry" then
						scanField = "";
						editTxt = ""; editTxtColor = "";
						break;
					elseif fsButton[i].action == "moveHUD" then
						hudIsMoving = true;
						upCount = 0;
						break;
					elseif fsButton[i].action == "saveConfig" then
						if configTxt == "" then
							fieldStatus:saveConfigData();
						end;
						break;
					elseif fsButton[i].action == "nextInList" then
						screen = fsSubHud.screen[fsSubHud.currScreen];
						if screen.currOpt[fsButton[i].row] < screen.numOpts[fsButton[i].row] then
							screen.currOpt[fsButton[i].row] = screen.currOpt[fsButton[i].row] + 1;
							configTxt = ""; configTxtColor = "";
						end;
						break;
					elseif fsButton[i].action == "prevInList" then
						screen = fsSubHud.screen[fsSubHud.currScreen];
						if screen.currOpt[fsButton[i].row] > 1 then
							screen.currOpt[fsButton[i].row] = screen.currOpt[fsButton[i].row] - 1;
							configTxt = ""; configTxtColor = "";
						end;
						break;
					end;
				end;
			end;
		end;
		if not buttonActionTaken then
			if (InputBinding.hasEvent(InputBinding.fs_HUD_POS)) then
				fsHud.CurrPos = fsHud.CurrPos + 1;
				if fsHud.CurrPos > #fsHud.PosX then
					fsHud.CurrPos = 1;
				end;
				if fsHud.PosX[fsHud.CurrPos] == 0 or fsHud.PosY[fsHud.CurrPos] == 0 then
					fsHud.CurrPos = 1;
				end;
				fieldStatus:calcHUDLines();
			elseif (InputBinding.hasEvent(InputBinding.fs_OVERLAY)) then
				fieldStatus:activateScreen("mapOverlay", not fsActive["mapOverlay"]);
			elseif (InputBinding.hasEvent(InputBinding.fs_TRANS_UP)) then
				if overlayTransLevel < 1.0 then
					overlayTransLevel = overlayTransLevel + 0.1;
				end;
			elseif (InputBinding.hasEvent(InputBinding.fs_TRANS_DOWN)) then
				if overlayTransLevel >= 0.2 then
					overlayTransLevel = overlayTransLevel - 0.1;
				end;
			elseif (InputBinding.hasEvent(InputBinding.fs_RELOAD_FLDDEFS)) then
				msgTxt = "";  msgTxtColor = "";
				fieldStatus:getFieldDefinitions("reload");
			elseif (InputBinding.hasEvent(InputBinding.fs_TOGGLE_PERCENT)) then
				showingPercent = not showingPercent;
			elseif (InputBinding.hasEvent(InputBinding.fs_DEFAULT_SCAN)) then
				fieldStatus:prepDefaultScan();
			elseif (InputBinding.hasEvent(InputBinding.fs_DEFAULT_DISPLAY)) then
				fieldStatus:prepDefaultDisplay();
			elseif (InputBinding.hasEvent(InputBinding.fs_LIST_START)) then
				if not fsActive["userInput"] then
					if fsActive["CONF"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.configScreens[1];
					elseif fsActive["MPLA"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.MPConfigScreens[1];
					elseif fsActive["HELP"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.helpScreens[1];
					else
						msgTxt = "";  msgTxtColor = "";
						currScreen = 1;
					end;
				end;
			elseif (InputBinding.hasEvent(InputBinding.fs_LIST_END)) then
				if not fsActive["userInput"] then
					if fsActive["CONF"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.configScreens[1] + fsSubHud.numConfigScreens - 1;
					elseif fsActive["MPLA"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.MPConfigScreens[1] + fsSubHud.numMPConfigScreens - 1;
					elseif fsActive["HELP"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.helpScreens[1] + fsSubHud.numHelpScreens - 1;
					else
						msgTxt = "";  msgTxtColor = "";
						currScreen = numScreens;
					end;
				end;
			elseif (InputBinding.hasEvent(InputBinding.fs_LIST_PREV)) then
				if not fsActive["userInput"] then
					if fsActive["CONF"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.currScreen - 1;
						if fsSubHud.currScreen < fsSubHud.configScreens[1] then
							fsSubHud.currScreen = fsSubHud.configScreens[1];
						end;
					elseif fsActive["MPLA"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.currScreen - 1;
						if fsSubHud.currScreen < fsSubHud.MPConfigScreens[1] then
							fsSubHud.currScreen = fsSubHud.MPConfigScreens[1];
						end;
					elseif fsActive["HELP"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.currScreen - 1;
						if fsSubHud.currScreen < fsSubHud.helpScreens[1] then
							fsSubHud.currScreen = fsSubHud.helpScreens[1];
						end;
					else
						msgTxt = "";  msgTxtColor = "";
						currScreen = currScreen - 1;
						if currScreen < 1 then
							currScreen = 1;
						end;
					end;
				end;
			elseif (InputBinding.hasEvent(InputBinding.fs_LIST_NEXT)) then
				if not fsActive["userInput"] then
					if fsActive["CONF"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.currScreen + 1;
						if fsSubHud.currScreen > fsSubHud.numConfigScreens then
							fsSubHud.currScreen = fsSubHud.configScreens[1] + fsSubHud.numConfigScreens - 1;
						end;
					elseif fsActive["MPLA"] then
						configTxt = ""; configTxtColor = "";
						fsSubHud.currScreen = fsSubHud.currScreen + 1;
						if fsSubHud.currScreen > fsSubHud.numMPConfigScreens then
							fsSubHud.currScreen = fsSubHud.MPConfigScreens[1] + fsSubHud.numMPConfigScreens - 1;
						end;
					elseif fsActive["HELP"] then
						fsSubHud.currScreen = fsSubHud.currScreen + 1;
						if fsSubHud.currScreen > fsSubHud.numHelpScreens then
							fsSubHud.currScreen = fsSubHud.helpScreens[1] + fsSubHud.numHelpScreens - 1;
						end;
					else
						msgTxt = "";  msgTxtColor = "";
						currScreen = currScreen + 1;
						if currScreen > numScreens then
							currScreen = numScreens;
						end;
					end;
				end;
			end;
		end;
	end;
end;


function fieldStatus:scanFields()

if debug then print("BEG func fieldStatus:scanFields"); end;
if debug then print("scanType: "..scanType.."  scanSource: "..scanSource); end;

local r, t;
local this_row;
local thisfruit;
local startX, startZ, endX, endZ, widthX, widthZ, heightX, heightZ;
local i, m, n, o, p, k, v, x, z, xx, zz, xrem, zrem;
local chnum, growth, dFactor, totDensity, density, blockTotDensity, blockDensity, accumTotDensity, accumDensity = 0, 0, 0, 0, 0, 0, 0, 0, 0;
local densityArea, maxDensity = 0, 0;

local widthXAdj=10;			-- Scan the field 100 sq meters at a time.
local widthZAdj=0;
local heightXAdj=0;
local heightZAdj=10;

-- for m=1,numFields do

	m = scanIdx;

if fieldData[m] ~= nil and fieldData[m].name ~= nil then

	if scanType == "Owned" and fieldData[m].owned ~= "Y" then
		if debug then
			print("leaving function early: fieldStatus:scanFields");
			print("END func fieldStatus:scanFields");
		end;
		return;
	elseif scanType == "Unowned" and fieldData[m].owned ~= "N" then
		if debug then
			print("leaving function early: fieldStatus:scanFields");
			print("END func fieldStatus:scanFields");
		end;
		return;
	end;

	fieldStatus:reset_fieldData(m);

	fieldData[m].fieldDensity = 0;
	maxDensity = 0;

for n=1,maxCoords do
		if debug then print('field/coord:  m -->'..m..'<    n -->'..n..'<'); end;
	if fieldData[m].coord[n] ~= nil and fieldData[m].coord[n].startX ~= nil then
		startX=(fieldData[m].coord[n].startX - mapOffset); startZ=(fieldData[m].coord[n].startZ - mapOffset);
		endX=(fieldData[m].coord[n].endX - mapOffset); endZ=(fieldData[m].coord[n].endZ - mapOffset);

	xrem = (endX-startX) % widthXAdj;
	zrem = (endZ-startZ) % heightZAdj;

	this_row=0;
	if debug then print(string.rep("-", 100)); end;
	if debug then print('startX/startZ, endX/endZ -->'..startX..'/'..startZ..', '..endX..'/'..endZ..'<'); end;
	if debug then print("scan values:    width: "..widthXAdj..", "..widthZAdj.."  height: "..heightXAdj..", "..heightZAdj); end;
	if debug then print("estimated cols:  "..tonumber((endX-startX)/widthXAdj)); end;
	if debug then print("estimated rows:  "..tonumber((endZ-startZ)/heightZAdj)); end;
	if debug then print("remainders:      "..xrem..", "..zrem); end;

	if debug then
		print(string.rep("-", 50));
		local xxx,zzz, wX,wZ, hX,hZ = Utils.getXZWidthAndHeight(g_currentMission.terrainDetailId, startX, startZ, startX+(endX-startX), startZ, startX, startZ+(endZ-startZ));
		densityArea = getDensityParallelogramArea(g_currentMission.terrainDetailId, xxx, zzz, wX, wZ, hX, hZ);
		print("Total for Coord:    xxx,zzz: "..xxx..","..zzz.."  wX,wZ: "..wX..","..wZ.."  hX,hZ: "..hX..","..hZ.."  densityArea: "..string.format("%8d", densityArea));
		print(string.rep("-", 50));
	end;

	for z=startZ,endZ-1,heightZAdj do
		this_row=this_row+1;
		if debug then print("row: "..this_row); end;
			if z > endZ-heightZAdj then
				heightZ=z+zrem;
				if debug then print("on last row:   z,endZ: "..z..","..endZ.."  rem: "..zrem.."  heightZ: "..heightZ); end;
			else
				heightZ=z+heightZAdj;
			end;
	for x=startX,endX-1,widthXAdj do
			if x > endX-widthXAdj then
				widthX=x+xrem;
				if debug then print("on last col:   x,endX: "..x..","..endX.."  rem: "..xrem.."  widthX: "..widthX); end;
			else
				widthX=x+widthXAdj;
			end;

	widthZ=z+widthZAdj; heightX=x+heightXAdj;

		if debug then print(string.rep("-", 100)); end;
	local xxx,zzz, wX,wZ, hX,hZ = Utils.getXZWidthAndHeight(g_currentMission.terrainDetailId, x, z, widthX, widthZ, heightX, heightZ);
	densityArea = getDensityParallelogramArea(g_currentMission.terrainDetailId, xxx, zzz, wX, wZ, hX, hZ);
	fieldData[m].fieldDensity = fieldData[m].fieldDensity + densityArea;
	if debug then print('adding '..string.format("%8d", densityArea)..' to fieldDensity'); end;
	if densityArea > maxDensity then
		maxDensity = densityArea;
	end;
		if debug then print(fieldData[m].name.."    x,z: "..x..","..z.."  widthX,widthZ: "..widthX..","..widthZ.."  heightX,heightZ: "..heightX..","..heightZ.."  densityArea: "..string.format("%8d", densityArea)); end;

	for chnum=0,numFSChannels-1 do
		density = Utils.getDensity(g_currentMission.terrainDetailId, chnum, x, z, widthX, widthZ, heightX, heightZ);
		if density ~= nil and density > 0 then
			fieldData[m].status[chnum].density = fieldData[m].status[chnum].density + density;
			if debug then print("terrain: "..g_currentMission.terrainDetailId.."  chan: "..chname[chnum].."  density: "..string.format("%8d", density)); end;
		end;
	end;

	for i=1, FruitUtil.NUM_FRUITTYPES do
	if fruitData[i] ~= nil then
		if fruitData[i].index ~= nil and fruitData[i].id ~= nil then
			thisfruit = tostring(fruitData[i].name);
			accumTotDensity = 0; accumDensity = 0; blockTotDensity = 0; blockDensity = 0;
			local xxx,zzz, wX,wZ, hX,hZ = Utils.getXZWidthAndHeight(fruitData[i].id, x, z, widthX, widthZ, heightX, heightZ);
			setDensityReturnValueShift(fruitData[i].id, -1);
			setDensityCompareParams(fruitData[i].id, "greater", -1);
			blockTotDensity, blockDensity = getDensityParallelogram(fruitData[i].id, xxx, zzz, wX, wZ, hX, hZ, 0, g_currentMission.numFruitStateChannels);
			if blockDensity ~= nil and blockDensity > 0 then
					dFactor = blockTotDensity / blockDensity;
						if debug then print(string.rep("-", 75)); end;
						if debug then print(fieldData[m].name.."    xxx,zzz: "..xxx..","..zzz.."  wX,wZ: "..wX..","..wZ.."  hX,hZ: "..hX..","..hZ); end;
						if debug then print("D  "..string.format("%13s", thisfruit).."  blockTotDensity: "..string.format("%8d", blockTotDensity).."  blockDensity: "..string.format("%8d", blockDensity).."  dFactor: "..string.format("%.6f", dFactor)); end;

				if fruitData[i].preparingId ~= nil and fruitData[i].preparingId > 0 then
							for p = fruitData[i].minPrepState, fruitData[i].maxPrepState do
								setDensityCompareParams(fruitData[i].id, "equals", p+1);
								totDensity, density = getDensityParallelogram(fruitData[i].id, xxx, zzz, wX, wZ, hX, hZ, 0, g_currentMission.numFruitStateChannels);
								if density ~= nil and density > 0 then
									if totDensity % density == 0 then
										dFactor = totDensity / density;
										accumTotDensity = accumTotDensity + totDensity; accumDensity = accumDensity + density;
											if debug then print("DP"..p..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%8d", dFactor)); end;
										fieldData[m].fruit[i].name = thisfruit;
										fieldData[m].fruit[i].growth[dFactor].density = fieldData[m].fruit[i].growth[dFactor].density + density;
										if (blockTotDensity == accumTotDensity) and (blockDensity == accumDensity) then
											break;
										end;
									else
										dFactor = totDensity / density;
											if debug then print("DPX"..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%.6f", dFactor)); end;
									end;
								end;
							end;
				end;

				if (blockTotDensity ~= accumTotDensity) or (blockDensity ~= accumDensity) then
							for p = fruitData[i].minHarvState, fruitData[i].maxHarvState do
								setDensityCompareParams(fruitData[i].id, "equals", p+1);
								totDensity, density = getDensityParallelogram(fruitData[i].id, xxx, zzz, wX, wZ, hX, hZ, 0, g_currentMission.numFruitStateChannels);
								if density ~= nil and density > 0 then
									if totDensity % density == 0 then
										dFactor = totDensity / density;
										accumTotDensity = accumTotDensity + totDensity; accumDensity = accumDensity + density;
											if debug then print("DH"..p..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%8d", dFactor)); end;
										fieldData[m].fruit[i].name = thisfruit;
										fieldData[m].fruit[i].growth[dFactor].density = fieldData[m].fruit[i].growth[dFactor].density + density;
										if (blockTotDensity == accumTotDensity) and (blockDensity == accumDensity) then
											break;
										end;
									else
										dFactor = totDensity / density;
											if debug then print("DHX"..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%.6f", dFactor)); end;
									end;
								end;
							end;
				end;

				if (blockTotDensity ~= accumTotDensity) or (blockDensity ~= accumDensity) then
					setDensityCompareParams(fruitData[i].id, "equals", fruitData[i].cutState+1);
					totDensity, density = getDensityParallelogram(fruitData[i].id, xxx, zzz, wX, wZ, hX, hZ, 0, g_currentMission.numFruitStateChannels);
					if density ~= nil and density > 0 then
						if totDensity % density == 0 then
							dFactor = totDensity / density;
							accumTotDensity = accumTotDensity + totDensity; accumDensity = accumDensity + density;
								if debug then print("DC"..fruitData[i].cutState..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%8d", dFactor)); end;
							fieldData[m].fruit[i].name = thisfruit;
							fieldData[m].fruit[i].growth[dFactor].density = fieldData[m].fruit[i].growth[dFactor].density + density;
						else
							dFactor = totDensity / density;
								if debug then print("DCX"..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%.6f", dFactor)); end;
						end;
					end;
				end;

				if (blockTotDensity ~= accumTotDensity) or (blockDensity ~= accumDensity) then
					setDensityCompareParams(fruitData[i].id, "equals", 8);		-- withered state + 1
					totDensity, density = getDensityParallelogram(fruitData[i].id, xxx, zzz, wX, wZ, hX, hZ, 0, g_currentMission.numFruitStateChannels);
					if density ~= nil and density > 0 then
						if totDensity % density == 0 then
							dFactor = totDensity / density;
							accumTotDensity = accumTotDensity + totDensity; accumDensity = accumDensity + density;
								if debug then print("DW "..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%8d", dFactor)); end;
							fieldData[m].fruit[i].name = thisfruit;
							fieldData[m].fruit[i].growth[dFactor].density = fieldData[m].fruit[i].growth[dFactor].density + density;
						else
							dFactor = totDensity / density;
								if debug then print("DWX"..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%.6f", dFactor)); end;
						end;
					end;
				end;

				if (blockTotDensity ~= accumTotDensity) or (blockDensity ~= accumDensity) then
						if fruitData[i].preparingId ~= nil and fruitData[i].preparingId > 0 then
							growthState = fruitData[i].minPrepState;
						else
							growthState = fruitData[i].minHarvState;
						end;
								if debug then print("DG "..string.format("%13s", thisfruit).."      growthState: "..string.format("%8d", growthState)); end;
						for p = 0, growthState-1 do
							setDensityCompareParams(fruitData[i].id, "equals", p+1);
							totDensity, density = getDensityParallelogram(fruitData[i].id, xxx, zzz, wX, wZ, hX, hZ, 0, g_currentMission.numFruitStateChannels);
							if density ~= nil and density > 0 then
								if totDensity % density == 0 then
									dFactor = totDensity / density;
									accumTotDensity = accumTotDensity + totDensity; accumDensity = accumDensity + density;
										if debug then print("DG"..p..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%8d", dFactor)); end;
									fieldData[m].fruit[i].name = thisfruit;
									fieldData[m].fruit[i].growth[dFactor].density = fieldData[m].fruit[i].growth[dFactor].density + density;
									if (blockTotDensity == accumTotDensity) and (blockDensity == accumDensity) then
										break;
									end;
								else
									dFactor = totDensity / density;
										if debug then print("DGX"..string.format("%2d", p)..string.format("%11s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density).."  dFactor: "..string.format("%.6f", dFactor)); end;
								end;
							end;
						end;
				end;

				if (blockTotDensity ~= accumTotDensity) or (blockDensity ~= accumDensity) then
					if debug then print("DXX"..string.format("%13s", thisfruit).."  blockTotDensity: "..string.format("%.6f", blockTotDensity).."  blockDensity: "..string.format("%.6f", blockDensity).."  accumTotDensity: "..string.format("%.6f", accumTotDensity).."  accumDensity: "..string.format("%.6f", accumDensity)); end;
				end;

				if fruitData[i].windrowId ~= nil and fruitData[i].windrowId > 0 then
					totDensity, density = getDensityParallelogram(fruitData[i].windrowId, xxx, zzz, wX, wZ, hX, hZ, 0, g_currentMission.numWindrowChannels);
					if totDensity ~= nil and totDensity > 0 then
						if debug then print("W  "..string.format("%13s", thisfruit).."       totDensity: "..string.format("%8d", totDensity).."       density: "..string.format("%8d", density)); end;
						fieldData[m].fruit[i].name = thisfruit;
						fieldData[m].fruit[i].windrowDensity = fieldData[m].fruit[i].windrowDensity + totDensity;
					end;
				end;

				setDensityCompareParams(fruitData[i].id, "greater", -1);
				setDensityReturnValueShift(fruitData[i].id, 0);

			end;	-- no density found

		end;  -- fruitData index not nil
	end;  -- fruitData array not nil
	end;  -- numFruits loop
	end;  -- x (width) loop
	end;  -- z (height) loop
	else
		break;
	end;  -- coords not nil
end;  -- maxCoords loop

end;  -- fieldData name not nil

-- end;  -- numFields loop

if debug then print("END func fieldStatus:scanFields"); end;

end;


function fieldStatus:process_fieldData(arg)

if debug then print("BEG func fieldStatus:process_fieldData"); end;

display=false; savexml=false;
if arg == nil or arg == "display" then
	display=true;
elseif arg == "savexml" then
	savexml=true;
end;

local h, i, j, m, n, o, dd, f, bf, e1, e2, ff, fruitIdx;
local xmlM, xmlN, xmlO;
local gNum, gDen, gPct;
local fruitPrinted=false;
local validField, displayThisField = false, false;
local plowDensity, cultDensity, seedDensity, sWidDensity, fertDensity, fieldArea, fieldDensity, fieldVolume, volumeDiff;
local dispFieldName, fieldOwned;
local fieldHectares, fieldAcres;
local ghect, gacre;
local fixesWritten, fixIdxStart, fixIdxEnd, iii;								-- FIXFLDDEF

	if fixingXML then															-- FIXFLDDEF
		print('maxCoords: '..maxCoords);										-- FIXFLDDEF TESTING
		fieldStatus:fixCheckMaxCoords();										-- FIXFLDDEF
		print('maxCoords: '..maxCoords);										-- FIXFLDDEF TESTING
	end;																		-- FIXFLDDEF

if savexml then
	if fixingXML then															-- FIXFLDDEF
		fsXMLFile = g_currentMission.missionInfo.savegameDirectory.."/fieldData."..thisMap..".xml";		-- FIXFLDDEF
	else																		-- FIXFLDDEF
		fsXMLFile = g_currentMission.missionInfo.savegameDirectory.."/"..fieldDataFile;
	end;																		-- FIXFLDDEF
	fsXMLTag = "fieldData";
	xmlFile = createXMLFile(fsXMLTag, fsXMLFile, fsXMLTag);
	if xmlFile ~= nil then
		fsTagName = fsXMLTag;
		setXMLString(xmlFile, fsTagName.."#version", fieldStatus.version);
		fsTagName = string.format("%s.map", fsXMLTag);
		setXMLString(xmlFile, fsTagName.."#name", fsMap);
		setXMLInt(xmlFile, fsTagName.."#numFields", numFields);
		setXMLInt(xmlFile, fsTagName.."#maxCoords", maxCoords);
		if fixedXML or fixingXML then											-- FIXFLDDEF
			setXMLBool(xmlFile, fsTagName.."#fixedXML", true);					-- FIXFLDDEF
		end;																	-- FIXFLDDEF
		if altPDAPath ~= nil then
			setXMLString(xmlFile, fsTagName.."#altPDAPath", altPDAPath);
		end;
	else
		msgTxt = "ERR: can't save to " .. fieldDataFile;  msgTxtColor = "brightred";
	end;
end;

dispDataItems = 0;
dd=1; f=0; h=1;
dispData[dd] = {};
xmlM = -1;
for m=1,numFields do
	if fieldData[m] ~= nil and fieldData[m].name ~= nil then

		dispFieldName = tostring(fieldData[m].name);
		validField = false;

		if fieldData[m].owned ~= nil and fieldData[m].owned == "Y" then
			fieldOwned = "Y";
		else
			fieldOwned = "N";
		end;

		if (scanType == "Owned" and fieldOwned == "Y") then
			validField = true;
		elseif (scanType == "Unowned" and fieldOwned == "N") then
			validField = true;
		elseif (scanType == "Custom") then
			for i=1,#scanFieldArray do
				if scanFieldArray[i] ~= nil and (tostring(scanFieldArray[i]) == dispFieldName) then
					validField = true;
					break;
				end;
			end;
		elseif (scanType ~= "Owned" and scanType ~= "Unowned" and scanType ~= "Custom") then
			validField = true;
		end;

		fieldArea = fieldData[m].area or 0;
		fieldHectares = fieldData[m].hectares or 0;
		fieldAcres = fieldData[m].acres or 0;
		fieldDensity = fieldData[m].fieldDensity or 0;

		if debug then print("name: "..dispFieldName.."    area: "..fieldArea); end;
		if savexml then
			xmlM = xmlM + 1;
			fsTagName = string.format("%s.map.field(%d)", fsXMLTag, xmlM);
			setXMLString(xmlFile, fsTagName.."#name", dispFieldName);
			setXMLString(xmlFile, fsTagName.."#owned", fieldOwned);
			if not fixingXML then												-- FIXFLDDEF
				setXMLInt(xmlFile, fsTagName.."#area", fieldArea);
				setXMLFloat(xmlFile, fsTagName.."#hectares", fieldHectares);
				setXMLFloat(xmlFile, fsTagName.."#acres", fieldAcres);
				setXMLInt(xmlFile, fsTagName.."#density", fieldDensity);
			end;																-- FIXFLDDEF
		end;

		dispData[dd].ctrl = "FLD"..fieldOwned; dispData[dd].a = dispFieldName; dispData[dd].b = string.format("%1.2fh / %1.2fa", fieldHectares, fieldAcres);
		bf=dd; dd=dd+1; f=f+1;
		dispData[dd] = {};
																				-- FIXFLDDEF BEG
		if savexml then
			fixesWritten = false; fixIdxStart = 0; fixIdxEnd = 0;
			if fixingXML then
				for iii = 1,#fsFixes do
					if string.sub(fsFixes[iii], 1, 5) == "field" then
						if fixIdxStart > 0 then
							fixIdxEnd = iii - 1;
							break;
						end;
						if string.sub(fsFixes[iii], 7) == dispFieldName then
							fixIdxStart = iii + 1;
						end;
					end;
				end;
				if fixIdxStart > 0 and fixIdxEnd > 0 then
					fixesWritten = true;
					xmlN = -1;
					for iii = fixIdxStart, fixIdxEnd, 4 do
						xmlN = xmlN + 1;
						fsTagName = string.format("%s.map.field(%d).coordinates(%d)", fsXMLTag, xmlM, xmlN);
						setXMLFloat(xmlFile, fsTagName.."#startX", fsFixes[iii]);
						setXMLFloat(xmlFile, fsTagName.."#startZ", fsFixes[iii + 1]);
						setXMLFloat(xmlFile, fsTagName.."#endX", fsFixes[iii + 2]);
						setXMLFloat(xmlFile, fsTagName.."#endZ", fsFixes[iii + 3]);
					end;
				end;
			end;
		end;
		if not fixesWritten then												-- FIXFLDDEF END
			xmlN = -1;
			for n=1,maxCoords do
				if fieldData[m].coord[n] ~= nil and fieldData[m].coord[n].startX ~= nil then
					if debug then print("     startX,Z["..n.."]: "..fieldData[m].coord[n].startX..","..fieldData[m].coord[n].startZ.."  endX,Z: "..fieldData[m].coord[n].endX..","..fieldData[m].coord[n].endZ); end;
					if savexml then
						xmlN = xmlN + 1;
						fsTagName = string.format("%s.map.field(%d).coordinates(%d)", fsXMLTag, xmlM, xmlN);
						setXMLFloat(xmlFile, fsTagName.."#startX", fieldData[m].coord[n].startX);
						setXMLFloat(xmlFile, fsTagName.."#startZ", fieldData[m].coord[n].startZ);
						setXMLFloat(xmlFile, fsTagName.."#endX", fieldData[m].coord[n].endX);
						setXMLFloat(xmlFile, fsTagName.."#endZ", fieldData[m].coord[n].endZ);
					end;
				end;
			end;
		end;																	-- FIXFLDDEF

		fieldVolume = 0; cultDensity = 0; plowDensity = 0; seedDensity = 0; sWidDensity = 0; fertDensity = 0;

		xmlN = -1;
		for n=0,numFSChannels-1 do
			if fieldData[m].status[n].density > 0 then
				if debug then print("     channel["..n.."]: "..chname[n].."  density: "..fieldData[m].status[n].density); end;
				if savexml and (not fixingXML) then								-- FIXFLDDEF
					xmlN = xmlN + 1;
					fsTagName = string.format("%s.map.field(%d).status(%d)", fsXMLTag, xmlM, xmlN);
					setXMLInt(xmlFile, fsTagName.."#num", n);
					setXMLInt(xmlFile, fsTagName.."#density", fieldData[m].status[n].density);
				end;
			end;
		end;
		cultDensity=fieldData[m].status[0].density;
		plowDensity=fieldData[m].status[1].density;
		seedDensity=fieldData[m].status[2].density;
		sWidDensity=fieldData[m].status[3].density;
		fertDensity=fieldData[m].status[4].density;
		fieldVolume = cultDensity + plowDensity + seedDensity + sWidDensity;
			if debug then print(dispFieldName.."  Field Density: "..fieldDensity.."  Field Volume: "..fieldVolume);  end;

		if fieldDensity == 0 then
			dispData[dd].ctrl = "EMP"..fieldOwned; dispData[dd].a = "Empty"; dispData[dd].b = "100.00%"; dispData[dd].d = string.format("%1.2fh / %1.2fa", fieldHectares, fieldAcres);
			dd=dd+1; f=f+1;
			dispData[dd] = {};
		else
			volumeDiff = (fieldVolume / fieldDensity) * 100;
			if volumeDiff >= 0.01 then
				gPct = 100 - volumeDiff
				if gPct >= 0.01 then
					ghect = gPct/100 * fieldHectares; gacre = gPct/100 * fieldAcres;
					dispData[dd].ctrl = "EMP"..fieldOwned; dispData[dd].a = "Empty"; dispData[dd].b = string.format("%1.2f%%", gPct); dispData[dd].d = string.format("%1.2fh / %1.2fa", ghect, gacre);
					dd=dd+1; f=f+1;
					dispData[dd] = {};
				end;
			end;
			if plowDensity > 0 then
				gPct = (plowDensity / fieldDensity) * 100;
				if gPct >= 0.01 then
					ghect = gPct/100 * fieldHectares; gacre = gPct/100 * fieldAcres;
					dispData[dd].ctrl = "STA"..fieldOwned; dispData[dd].a = "Plowed"; dispData[dd].b = string.format("%1.2f%%", gPct); dispData[dd].d = string.format("%1.2fh / %1.2fa", ghect, gacre);
					dd=dd+1; f=f+1;
					dispData[dd] = {};
				end;
			end;
			if cultDensity > 0 then
				gPct = (cultDensity / fieldDensity) * 100;
				if gPct >= 0.01 then
					ghect = gPct/100 * fieldHectares; gacre = gPct/100 * fieldAcres;
					dispData[dd].ctrl = "STA"..fieldOwned; dispData[dd].a = "Cultivated"; dispData[dd].b = string.format("%1.2f%%", gPct); dispData[dd].d = string.format("%1.2fh / %1.2fa", ghect, gacre);
					dd=dd+1; f=f+1;
					dispData[dd] = {};
				end;
			end;
			if seedDensity > 0 then
				gPct = (seedDensity / fieldDensity) * 100;
				if gPct >= 0.01 then
					ghect = gPct/100 * fieldHectares; gacre = gPct/100 * fieldAcres;
					dispData[dd].ctrl = "STA"..fieldOwned; dispData[dd].a = "Seeded"; dispData[dd].b = string.format("%1.2f%%", gPct); dispData[dd].d = string.format("%1.2fh / %1.2fa", ghect, gacre);
					dd=dd+1; f=f+1;
					dispData[dd] = {};
				end;
			end;
			if sWidDensity > 0 then
				gPct = (sWidDensity / fieldDensity) * 100;
				if gPct >= 0.01 then
					ghect = gPct/100 * fieldHectares; gacre = gPct/100 * fieldAcres;
					dispData[dd].ctrl = "STA"..fieldOwned; dispData[dd].a = "Seeded (wide)"; dispData[dd].b = string.format("%1.2f%%", gPct); dispData[dd].c = "Seeded(w)"; dispData[dd].d = string.format("%1.2fh / %1.2fa", ghect, gacre);
					dd=dd+1; f=f+1;
					dispData[dd] = {};
				end;
			end;
			if fertDensity > 0 then
				gPct = (fertDensity / fieldDensity) * 100;
				if gPct >= 0.01 then
					ghect = gPct/100 * fieldHectares; gacre = gPct/100 * fieldAcres;
					dispData[dd].ctrl = "FER"..fieldOwned; dispData[dd].a = "Fertilized"; dispData[dd].b = string.format("%1.2f%%", gPct); dispData[dd].d = string.format("%1.2fh / %1.2fa", ghect, gacre);
					dd=dd+1; f=f+1;
					dispData[dd] = {};
				end;
			end;
		end;

			xmlN = -1;
			if fruitScanSelected then
				displayThisField = false;
			else
				displayThisField = true;
			end;
			for n=1,FruitUtil.NUM_FRUITTYPES do
				if fieldData[m].fruit[n] ~= nil and fieldData[m].fruit[n].name ~= nil then
					for ff=1,FruitUtil.NUM_FRUITTYPES do
						if fruitData[ff] ~= nil and fruitData[ff].name ~= nil then
							if tostring(fruitData[ff].name) == tostring(fieldData[m].fruit[n].name) then
								fruitIdx = ff;
								break;
							end;
						end;
					end;
					fruitPrinted=false;
					xmlO = -1;
					for o=0,numGrowthStates-1 do
						if fieldData[m].fruit[n].growth[o] ~= nil and fieldData[m].fruit[n].growth[o].density > 0 then
									if debug then print('fruit: '..fieldData[m].fruit[n].name); end;
							e1,_ = string.find(string.lower(fieldData[m].fruit[n].name), "manure");
							e2,_ = string.find(string.lower(fieldData[m].fruit[n].name), "fertil");
							if e1 == nil and e2 == nil then						-- No manure or other fertilizer found; continue processing
								gNum=o;
								gDen=fieldData[m].fruit[n].growth[o].density;
								gPct = (gDen / fieldDensity) * 100;
									if debug then print('gDen >'..tonumber(gDen)..'<    fieldDensity >'..tonumber(fieldDensity)..'<    gPct >'..tonumber(gPct)..'<'); end;
								if gPct >= 0.01 then
									if fruitScanSelected and (tostring(fruitToScan) == tostring(fieldData[m].fruit[n].name)) then
										displayThisField = true;
									end;
									ghect = gPct/100 * fieldHectares; gacre = gPct/100 * fieldAcres;
									if gNum == fruitData[fruitIdx].cutState then
										dispData[dd].ctrl = "CUT"..fieldOwned;
										dispData[dd].a = fieldData[m].fruit[n].name.." [cut]";
										dispData[dd].c = fieldData[m].fruit[n].name.." [c]";
									elseif gNum == 7 then
										dispData[dd].ctrl = "BAD"..fieldOwned;
										dispData[dd].a = fieldData[m].fruit[n].name.." [bad]";
										dispData[dd].c = fieldData[m].fruit[n].name.." [x]";
									elseif fruitData[fruitIdx].minPrepState > 0 and fruitData[fruitIdx].maxPrepState > 0 and
										gNum >= fruitData[fruitIdx].minPrepState and gNum <= fruitData[fruitIdx].maxPrepState then
											dispData[dd].ctrl = "PRP"..fieldOwned;
											dispData[dd].a = fieldData[m].fruit[n].name.." ["..gNum.."]";
									elseif fruitData[fruitIdx].minHarvState > 0 and fruitData[fruitIdx].maxHarvState > 0 and
										gNum >= fruitData[fruitIdx].minHarvState and gNum <= fruitData[fruitIdx].maxHarvState then
											dispData[dd].ctrl = "HAR"..fieldOwned;
											dispData[dd].a = fieldData[m].fruit[n].name.." ["..gNum.."]";
									else
										dispData[dd].ctrl = "GRO"..fieldOwned;
										dispData[dd].a = fieldData[m].fruit[n].name.." ["..gNum.."]";
									end;
									if fruitData[fruitIdx].prepGrowthState ~= nil and fruitData[fruitIdx].prepGrowthState > 0 then
										if debug then print('\tgNum: '..gNum..'\tprepGrowthState: '..fruitData[fruitIdx].prepGrowthState); end;
										if gNum == fruitData[fruitIdx].prepGrowthState then
											dispData[dd].a = fruitData[fruitIdx].preparingName;
											dispData[dd].c = fieldData[m].fruit[n].name.." [h]";
										end;
									end;
										if debug then print('\tgNum: '..gNum..'\tmin/max harv: '..fruitData[fruitIdx].minHarvState..'/'..fruitData[fruitIdx].maxHarvState..'\tmin/max prep: '..fruitData[fruitIdx].minPrepState..'/'..fruitData[fruitIdx].maxPrepState..'\tctrl: '..dispData[dd].ctrl); end;
									dispData[dd].b = string.format("%1.2f%%", gPct); dispData[dd].d = string.format("%1.2fh / %1.2fa", ghect, gacre);
									dd=dd+1; f=f+1;
									dispData[dd] = {};
								end;
								if not fruitPrinted then
									if debug then print("     fruit: "..fieldData[m].fruit[n].name); end;
									if savexml and (not fixingXML) then			-- FIXFLDDEF
										xmlN = xmlN + 1;
										fsTagName = string.format("%s.map.field(%d).fruit(%d)", fsXMLTag, xmlM, xmlN);
										setXMLString(xmlFile, fsTagName.."#name", fieldData[m].fruit[n].name);
									end;
									fruitPrinted=true;
								end;
								if debug then print("          growth ["..o.."]: "..fieldData[m].fruit[n].growth[o].density); end;
								if savexml and (not fixingXML) then				-- FIXFLDDEF
									xmlO = xmlO + 1;
									fsTagName = string.format("%s.map.field(%d).fruit(%d).growth(%d)", fsXMLTag, xmlM, xmlN, xmlO);
									setXMLInt(xmlFile, fsTagName.."#num", o);
									setXMLInt(xmlFile, fsTagName.."#density", fieldData[m].fruit[n].growth[o].density);
								end;
							end;
						end;
					end;
					if fieldData[m].fruit[n].windrowDensity ~= nil and fieldData[m].fruit[n].windrowDensity > 0 then
						gDen=fieldData[m].fruit[n].windrowDensity;
						gPct = (gDen / fieldDensity) * 100;
						if gPct >= 0.01 then
							if fruitScanSelected and (tostring(fruitToScan) == tostring(fieldData[m].fruit[n].name)) then
								displayThisField = true;
							end;
							ghect = gPct/100 * fieldHectares; gacre = gPct/100 * fieldAcres;
							dispData[dd].ctrl = "WIN"..fieldOwned;
							dispData[dd].a = fieldData[m].fruit[n].name.." [windrow]";
							dispData[dd].b = string.format("%1.2f%%", gPct);
							dispData[dd].c = fieldData[m].fruit[n].name.." [w]";
							dispData[dd].d = string.format("%1.2fh / %1.2fa", ghect, gacre);
							dd=dd+1; f=f+1;
							dispData[dd] = {};
						end;
						if not fruitPrinted then
							if debug then print("     fruit: "..fieldData[m].fruit[n].name); end;
							if savexml and (not fixingXML) then					-- FIXFLDDEF
								xmlN = xmlN + 1;
								fsTagName = string.format("%s.map.field(%d).fruit(%d)", fsXMLTag, xmlM, xmlN);
								setXMLString(xmlFile, fsTagName.."#name", fieldData[m].fruit[n].name);
							end;
							fruitPrinted=true;
						end;
						if debug then print("             windrow: "..fieldData[m].fruit[n].windrowDensity); end;
						if savexml and (not fixingXML) then						-- FIXFLDDEF
							fsTagName = string.format("%s.map.field(%d).fruit(%d).windrow", fsXMLTag, xmlM, xmlN);
							setXMLInt(xmlFile, fsTagName.."#density", fieldData[m].fruit[n].windrowDensity);
						end;
					end;
				end;
			end;

		xmlO = -1;
		for j=1,#fsBaleType do
			if fieldData[m].bales[fsBaleType[j]] ~= nil and fieldData[m].bales[fsBaleType[j]] > 0 then
				if fruitScanSelected and (fruitToScan == "Bales") then
					displayThisField = true;
				end;
				local baleName = string.sub(fsBaleType[j], 1, -4);
				local baleShape = "";
				if string.sub(fsBaleType[j], -3) == "Rnd" then
					baleShape = "round"
				else
					baleShape = "square"
				end;
				dispData[dd].ctrl = "BAL"..fieldOwned;
				dispData[dd].a = baleName .. " bales [" .. baleShape .. "]";
				dispData[dd].b = string.format("%6d", fieldData[m].bales[fsBaleType[j]]);
				dd=dd+1; f=f+1;
				dispData[dd] = {};
				if savexml and (not fixingXML) then								-- FIXFLDDEF
					xmlO = xmlO + 1;
					fsTagName = string.format("%s.map.field(%d).bale(%d)", fsXMLTag, xmlM, xmlO);
					setXMLInt(xmlFile, fsTagName.."#num", fieldData[m].bales[fsBaleType[j]]);
					setXMLString(xmlFile, fsTagName.."#type", fsBaleType[j]);
				end;
			end;
		end;

		if debug then print("f >"..f.."<");  end;
		dispData[bf].ctrl = dispData[bf].ctrl..string.format("NUM%2d", f);
		if (not validField) or (not displayThisField) then
			dd = bf;
			dispData[dd] = {};
		end;
		f=0;
	end;		-- fieldData nil
end;			-- numFields for loop

dispDataItems = dd - 1;
if debug then
	print('dispDataItems: '..dispDataItems);
	fieldStatus:print_dispData();
end;

fieldStatus:getScreens();

if savexml then
	saveXMLFile(xmlFile);
	if msgTxt == "" then
		msgTxt = "XML file saved.";  msgTxtColor = "";
	end;
end;

display=false; savexml=false;

if debug then print("END func fieldStatus:process_fieldData"); end;

end;


function fieldStatus:print_dispData()

local ddd;
print(dashLine);
	ddd=1;
	while true do
		if dispData[ddd].ctrl ~= nil then
			if dispData[ddd].a ~= nil then
				if dispData[ddd].b ~= nil then
					if dispData[ddd].c ~= nil then
						if dispData[ddd].d ~= nil then
							print("fieldStatus: dispData["..ddd.."] >"..dispData[ddd].ctrl.."|"..dispData[ddd].a.."|"..dispData[ddd].b.."|"..dispData[ddd].c.."|"..dispData[ddd].d.."<");
						else
							print("fieldStatus: dispData["..ddd.."] >"..dispData[ddd].ctrl.."|"..dispData[ddd].a.."|"..dispData[ddd].b.."|"..dispData[ddd].c.."|nil<");
						end;
					else
						print("fieldStatus: dispData["..ddd.."] >"..dispData[ddd].ctrl.."|"..dispData[ddd].a.."|"..dispData[ddd].b.."|nil<");
					end;
				else
					print("fieldStatus: dispData["..ddd.."] >"..dispData[ddd].ctrl.."|"..dispData[ddd].a.."|nil<");
				end;
			else
				print("fieldStatus: dispData["..ddd.."] >"..dispData[ddd].ctrl.."|nil<");
			end;
		else
			break;
		end;
		ddd=ddd+1;
	end;
print(dashLine);

end;


function fieldStatus:getScreens()

local i, j, linecount, screen_linecount, save_this_field = 0, 0, 0, 0, 0;

j = math.max(dispDataItems / dispLinesAvail);
for i=1,j do
	screenList[i] = 0;
end;

screenListIdx = 1;
screenList[screenListIdx] = 1;
for i=1,dispDataItems do
	if string.sub(dispData[i].ctrl, 1, 3) == "FLD" then
		screen_linecount = screen_linecount + linecount;
		if screen_linecount > dispLinesAvail + 1 then
			screenListIdx = screenListIdx + 1;
			screenList[screenListIdx] = save_this_field;
			screen_linecount = linecount;
		end;
		linecount = 2;
		save_this_field = i;
	else
		linecount = linecount + 1;
	end;
end;
screen_linecount = screen_linecount + linecount;

-- 2011-10-01 took away "dispLinesAvail +1" to force a new screen; "END OF DATA" message was displaying on top of other messages in certain situations.
if screen_linecount > dispLinesAvail then
	screenListIdx = screenListIdx + 1;
	screenList[screenListIdx] = save_this_field;
end;
numScreens = screenListIdx;

currScreen = 1;

end;


function fieldStatus:initHUD()

	fskeyActivateHUD	= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_ACTIVATE_HUD), "^[^ ]+ ", ""));
	fskeyHUDPos			= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_HUD_POS), "^[^ ]+ ", ""));
	fskeyOverlay		= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_OVERLAY), "^[^ ]+ ", ""));
	fskeyTransUp		= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_TRANS_UP), "^[^ ]+ ", ""));
	fskeyTransDown		= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_TRANS_DOWN), "^[^ ]+ ", ""));
	fskeyReloadFDefs	= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_RELOAD_FLDDEFS), "^[^ ]+ ", ""));
	fskeyTogglePercent	= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_TOGGLE_PERCENT), "^[^ ]+ ", ""));
	fskeyDefaultScan	= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_DEFAULT_SCAN), "^[^ ]+ ", ""));
	fskeyDefaultDisplay	= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_DEFAULT_DISPLAY), "^[^ ]+ ", ""));
	fskeyListStart		= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_LIST_START), "^[^ ]+ ", ""));
	fskeyListEnd		= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_LIST_END), "^[^ ]+ ", ""));
	fskeyListPrev		= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_LIST_PREV), "^[^ ]+ ", ""));
	fskeyListNext		= string.lower(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.fs_LIST_NEXT), "^[^ ]+ ", ""));

	fieldStatus:calcHUDLines();

	fieldStatus:initScreens();

	for k,v in pairs(fsImg) do
		if k ~= "pdaMap" then
			local imgPath = Utils.getFilename(v.imgFilename, fieldStatus.moddir);
			fsImg[k].id = createImageOverlay(imgPath);
			if fsImg[k].id == nil or fsImg[k].id == 0 then
				print("fieldStatus: ERR: \'"..tostring(k).."\' image missing: "..imgPath);
				loadSuccess = false;
			end;
		end;
	end;

	if not loadSuccess then
		errMsgEnabled = true;
		errMsgTxt = "fieldStatus: Image(s) missing: Check log";
	end;

	initHUDDone = true;

end;


function fieldStatus:calcHUDLines()

	fsPrintPosY	= fsHud.Height + fsHud.PosY[fsHud.CurrPos] - textHeaderSize - 0.01;
	if (fsHud.PosX[fsHud.CurrPos] - fsSubHudWidth) < 0 then
		fsSubHudPosX = fsHud.PosX[fsHud.CurrPos] + fsHud.Width - 0.002;				-- SubHUD goes on the right
	else
		fsSubHudPosX = fsHud.PosX[fsHud.CurrPos] - fsSubHudWidth + 0.002;			-- SubHUD goes on the left
	end;

	fsPrintPosX				= fsHud.PosX[fsHud.CurrPos] + fsHud.Margin;
	fsPrintPosXCenter		= fsHud.PosX[fsHud.CurrPos] + (fsHud.Width / 2) - 0.002;
	fsPrintPosXRight		= fsHud.PosX[fsHud.CurrPos] + fsHud.Width - fsHud.Margin - 0.004;

	fsSubPrintPosX			= fsSubHudPosX + fsSubHudMargin;
	fsSubPrintPosXCenter	= fsSubHudPosX + (fsSubHudWidth / 2) - 0.002;
	fsSubPrintPosXRight		= fsSubHudPosX + fsSubHudWidth - fsSubHudMargin - 0.004;

	fsPrintMsgLine			= fsPrintPosY - (lineSpacing * displayTotalLines);
	fsPrintInfoLine2		= fsPrintMsgLine + lineSpacing;
	fsPrintInfoStart		= fsPrintInfoLine2 + lineSpacing;

end;


function fieldStatus:initScreens()

	fsSubHud = {screen = {}};
	table.insert(fsSubHud.screen, {type="HELP",	desc = {"HDR", "Default Scan:", " ", " ",
														"HDR", "Default Display:", " ", " ", " ", "First Screen:", "Last Screen:", "Prev Screen:", "Next Screen:",
														" ", "Toggle Pct/Area:"},
												value = {"Scanning", "img=scan", "or", fskeyDefaultScan,
														 "Display", "img=display", "or", fskeyDefaultDisplay, " ", fskeyListStart, fskeyListEnd, fskeyListPrev, fskeyListNext,
														 " ", fskeyTogglePercent}});

	table.insert(fsSubHud.screen, {type="HELP",	desc = {"HDR", "Config Screen:", " ", "Save Config File:", " ", "Edit Field List:", " ", "Erase Input:", " ", "Accept Input:", " ", " ", "MP Config:"},
												value = {"Config / Input", "img=config", " ", "img=save", " ", "img=edit", " ", "img=erase", " ", "img=accept", " ", " ", "img=bale"}});

	table.insert(fsSubHud.screen, {type="HELP", desc = {"HDR", " ", "Hide Field Status:", " ", "Reload Field Defs:", " ", "Move HUD:", " ",
														"Toggle HUD Pos:", " ", "Transparency +", "Transparency -", " ", "Show/Hide Map:"},
												value = {"Misc Functions", " ", fskeyActivateHUD, " ", fskeyReloadFDefs, " ", "img=moveHUD", " ",
														 fskeyHUDPos, " ", fskeyTransUp, fskeyTransDown, " ", fskeyOverlay}});

	table.insert(fsSubHud.screen, {type="CONF",	desc = {"HDR", "Active", "Frequency", "Scan Type", "Field List", "Fruit",
														"HDR", "Scan Type", "Field List", "Fruit",
														"HDR", "Scan Type", "Field List", "Fruit"},
												value = {{"AutoScan"}, {false, true}, {1, 2, 3, 4, 5, 10, 15, 20, 30, 45, 60, 120, 180, 240, 300, 360}, {"All", "Owned", "Unowned", "Custom"}, {}, {"All", "Bales"},
														 {"Default Scan"}, {"All", "Owned", "Unowned", "Custom"}, {}, {"All", "Bales"},
														 {"Default Display"}, {"All", "Owned", "Unowned", "Custom"}, {}, {"All", "Bales"}},
												currOpt = {1, 1, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}});

	table.insert(fsSubHud.screen, {type="MPLA",	desc = {"HDR", "Bales will be scanned,", "and the data sent to each", "player, based on the", "following options:", " ", "Active", " ", " ", "Frequency", " ", "Each host scan", " ", "Bale created /", "removed", " ", "Player join"},
												value = {{"BaleScan"}, {""}, {""}, {""}, {""}, {""}, {false, true}, {""}, {""}, {0, 2, 5, 10, 15, 20, 30, 45, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 900, 1200, 1800, 2700, 3600}, {""}, {false, true}, {""}, {false, true}, {""}, {""}, {false, true}},
												currOpt = {1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2}});
	fsSubHud.currScreen = 1;
	fsSubHud.numTotalScreens = #fsSubHud.screen;
	fsSubHud.numHelpScreens, fsSubHud.numConfigScreens, fsSubHud.numMPConfigScreens = 0, 0, 0;
	fsSubHud.helpScreens = {};  fsSubHud.configScreens = {};  fsSubHud.MPConfigScreens = {};

	for i=1,fsSubHud.numTotalScreens do
		fsSubHud.screen[i].numRows = #fsSubHud.screen[i].desc;
		if fsSubHud.screen[i].type == "HELP" then
			table.insert(fsSubHud.helpScreens, i);
			fsSubHud.numHelpScreens = fsSubHud.numHelpScreens + 1;
		elseif fsSubHud.screen[i].type == "CONF" then
			table.insert(fsSubHud.configScreens, i);
			fsSubHud.numConfigScreens = fsSubHud.numConfigScreens + 1;
			fsSubHud.screen[i].numOpts = {};
			for j=1,fsSubHud.screen[i].numRows do
				fsSubHud.screen[i].numOpts[j] = #fsSubHud.screen[i].value[j];
			end;
		elseif fsSubHud.screen[i].type == "MPLA" then
			table.insert(fsSubHud.MPConfigScreens, i);
			fsSubHud.numMPConfigScreens = fsSubHud.numMPConfigScreens + 1;
			fsSubHud.screen[i].numOpts = {};
			for j=1,fsSubHud.screen[i].numRows do
				fsSubHud.screen[i].numOpts[j] = #fsSubHud.screen[i].value[j];
			end;
		end;
	end;
	fsSubHud.numHelpScreens = #fsSubHud.helpScreens;
	fsSubHud.numConfigScreens = #fsSubHud.configScreens;
	fsSubHud.numMPConfigScreens = #fsSubHud.MPConfigScreens;

end;


function fieldStatus:updateConfigScreen()

	if fsSubHud.numConfigScreens > 0 and fsSubHud.configScreens[1] ~= nil then
		local screen = fsSubHud.screen[fsSubHud.configScreens[1]];
		for c=1,screen.numRows do
			if screen.desc[c] == "Fruit" then
				local fruitTable = screen.value[c];
				for i=1,numFruits do
					table.insert(fruitTable, fruitData[i].name);
				end;
				screen.numOpts[c] = #fruitTable;
			end;
		end;
	else
		loadSuccess = false;
		errMsgEnabled = true;
		errMsgTxt = "fieldStatus: Missing Config Screen";
	end;

end;


function fieldStatus:initFruitData()

if debug then print("BEG func fieldStatus:initFruitData"); end;

local pstr="";

numFruits = 0;
for n=1, FruitUtil.NUM_FRUITTYPES do
	fruitData[n] = {};
	fruitData[n].index = FruitUtil.fruitIndexToDesc[n].index;
	fruitData[n].name  = FruitUtil.fruitIndexToDesc[n].name;
	if debug then
		pstr=fruitData[n].index.."  "..fruitData[n].name.."    ";
	end;
	fruitData[n].minPrepState = FruitUtil.fruitIndexToDesc[n].minPreparingGrowthState;
	fruitData[n].maxPrepState = FruitUtil.fruitIndexToDesc[n].maxPreparingGrowthState;
	fruitData[n].minHarvState = FruitUtil.fruitIndexToDesc[n].minHarvestingGrowthState;
	fruitData[n].maxHarvState = FruitUtil.fruitIndexToDesc[n].maxHarvestingGrowthState;
	fruitData[n].prepGrowthState = FruitUtil.fruitIndexToDesc[n].preparedGrowthState or nil;
	fruitData[n].preparingName  = FruitUtil.fruitIndexToDesc[n].preparingOutputName or nil;
	fruitData[n].cutState  = FruitUtil.fruitIndexToDesc[n].cutState or nil;
	local ids = g_currentMission.fruits[n];
	if ids ~= nil and ids.id > 0 then
		fruitData[n].id           = ids.id;
		fruitData[n].windrowId    = ids.windrowId or nil;
		fruitData[n].preparingId  = ids.preparingOutputId or nil;
		if debug then
			pstr=pstr.."i/w/p: "..fruitData[n].id.." "..fruitData[n].windrowId.." "..fruitData[n].preparingId;
		end;
	else
		if debug then
			print('g_cM.fruits['..n..'] is nil');
		end;
	end;
	if fruitData[n].id ~= nil then
		numFruits=numFruits+1;
		if debug then
			print("fruitdata.id >"..fruitData[n].id.."  "..fruitData[n].name);
			print(pstr);
		end;
	end;
end;
	if numFruits == 0 then
		loadSuccess = false;
		errMsgEnabled = true;
		errMsgTxt = "fieldStatus: No fruits found: Check log";
	end;

	initFruitsDone = true;

if debug then print("END func fieldStatus:initFruitData"); end;
	
end;


function fieldStatus:get_maxCoords()

	local fieldNum = 1;
	maxCoords = 0;
	while true do
		thisField=g_currentMission.fieldDefinitionBase.fieldDefs[fieldNum];
		if thisField ~= nil then
			if thisField.fieldDimensions ~= nil then
				local numchild=getNumOfChildren(thisField.fieldDimensions);
				if numchild > maxCoords then
					maxCoords = numchild;
				end;
			else
				print('fieldStatus: ERR: could not find dimensions for Field: '..thisField.fieldNumber)
				loadSuccess = false;
				break;
			end;
		else
			break;
		end;
		fieldNum = fieldNum + 1;
	end;

end;


function fieldStatus:readFieldDefs()

if debug then print("BEG func fieldStatus:readFieldDefs"); end;

	local px1, py1, pz1, px2, py2, pz2, px3, py3, pz3 = 0, 0, 0, 0, 0, 0, 0, 0, 0;
	local px, py, pz = 0, 0, 0;
	local thisCoord = 0;
	local fieldNum = 1;

	numOwned = 0;

	while true do
		thisField=g_currentMission.fieldDefinitionBase.fieldDefs[fieldNum];
		if thisField ~= nil then

				if debug then print('\n\nfield >'..thisField.fieldNumber..'<  Area >'..thisField.fieldArea..'<  Price >'..thisField.fieldPrice..'<'); end;
			fieldData[fieldNum].name = thisField.fieldNumber;
			if thisField.ownedByPlayer then
				fieldData[fieldNum].owned = "Y";
				numOwned = numOwned + 1;
			else
				fieldData[fieldNum].owned = "N";
			end;

			if thisField.fieldDimensions ~= nil then
				thisCoord = 1;
				local numchild=getNumOfChildren(thisField.fieldDimensions);
				for i=1,numchild do
					child1=getChildAt(thisField.fieldDimensions, i-1)
					local classname=getClassName(child1); local objectname=getName(child1);
						if debug then
							print('child1 -->', child1, '<--  type >', type(child1), '<  class >', classname..'<  name >'..objectname..'<');
							local xx, yy, zz = getTranslation(child1);
							if xx ~= nil and yy ~= nil and zz ~= nil then
								print('name >'..objectname..'<  xx >'..xx..'<  yy >'..yy..'<  zz >'..zz..'<');
							end;
						end;
					local wx, wy, wz = getWorldTranslation(child1);
					if wx ~= nil and wy ~= nil and wz ~= nil then
						if debug then print('name >'..objectname..'<  wx >'..wx..'<  wy >'..wy..'<  wz >'..wz..'<'); end;
						px1 = wx + mapOffset;		py1 = wy + mapOffset;		pz1 = wz + mapOffset;
						if debug then print('name >'..objectname..'<  px1 >'..px1..'<  py1 >'..py1..'<  pz1 >'..pz1..'<\n'); end;
					else
						print('fieldStatus: ERR: could not get world coordinates for '..objectname..' in Field: '..thisField.fieldNumber)
						loadSuccess = false;
						break;
					end;
					local numgrandchild=getNumOfChildren(child1);
					for j=1,numgrandchild do
						child2=getChildAt(child1, j-1)
						local classname=getClassName(child2); local objectname=getName(child2);
							if debug then
								print('child2 -->', child2, '<--  type >', type(child2), '<  class >', classname..'<  name >'..objectname..'<');
								local xx, yy, zz = getTranslation(child2);
								if xx ~= nil and yy ~= nil and zz ~= nil then
									print('\tname >'..objectname..'<  xx >'..xx..'<  yy >'..yy..'<  zz >'..zz..'<');
								end;
							end;
						local wx, wy, wz = getWorldTranslation(child2);
						if wx ~= nil and wy ~= nil and wz ~= nil then
							if debug then print('\tname >'..objectname..'<  wx >'..wx..'<  wy >'..wy..'<  wz >'..wz..'<'); end;
							px = wx + mapOffset;		py = wy + mapOffset;		pz = wz + mapOffset;
							if debug then print('\tname >'..objectname..'<  px >'..px..'<  py >'..py..'<  pz >'..pz..'<\n'); end;
							if j == 1 then
								px2 = px;	py2 = py;	pz2 = pz;
							else
								px3 = px;	py3 = py;	pz3 = pz;
							end;
						else
							print('fieldStatus: ERR: could not get world coordinates for '..objectname..' in Field: '..thisField.fieldNumber)
							loadSuccess = false;
							break;
						end;
					end;
					fieldData[fieldNum].coord[thisCoord].startX = math.min(px1, px2, px3);
					fieldData[fieldNum].coord[thisCoord].startZ = math.min(pz1, pz2, pz3);
					fieldData[fieldNum].coord[thisCoord].endX = math.max(px1, px2, px3);
					fieldData[fieldNum].coord[thisCoord].endZ = math.max(pz1, pz2, pz3);
					thisCoord = thisCoord + 1;
				end;
				fieldStatus:calcFieldArea(fieldNum, numchild);
			else
				print('fieldStatus: ERR: could not find dimensions for Field: '..thisField.fieldNumber)
				loadSuccess = false;
				break;
			end;
		else
			break;
		end;
		fieldNum = fieldNum + 1;
	end;

if debug then print("END func fieldStatus:readFieldDefs"); end;

end;


function fieldStatus:calcFieldArea(fn, coords)

if debug then print("BEG func fieldStatus:calcFieldArea"); end;

	local newcoords = 0;

	if coords == 1 then
		sX = fieldData[fn].coord[1].startX;
		eX = fieldData[fn].coord[1].endX;
		sZ = fieldData[fn].coord[1].startZ;
		eZ = fieldData[fn].coord[1].endZ;
		local fArea = (eX - sX) * (eZ - sZ);
		fieldData[fn].area = fArea;
		fieldData[fn].hectares = fArea * areaToHectare;
		fieldData[fn].acres = fieldData[fn].hectares * hectareToAcre;
		mapHectares = mapHectares + fieldData[fn].hectares;
		mapAcres = mapAcres + fieldData[fn].acres;
	else
		if debug then						-- show all coords before changes
			for i=1,coords do
				print('bef coord ['..i..']: sX/sZ eX/eZ = '..fieldData[fn].coord[i].startX..'/'..fieldData[fn].coord[i].startZ..'  '..fieldData[fn].coord[i].endX..'/'..fieldData[fn].coord[i].endZ);
			end;
		end;
		newcoords = coords;								-- 2013-09-03
		for i=coords,2,-1 do
			sX1 = fieldData[fn].coord[i-1].startX;
			eX1 = fieldData[fn].coord[i-1].endX;
			sZ1 = fieldData[fn].coord[i-1].startZ;
			eZ1 = fieldData[fn].coord[i-1].endZ;
			sX = fieldData[fn].coord[i].startX;
			eX = fieldData[fn].coord[i].endX;
			sZ = fieldData[fn].coord[i].startZ;
			eZ = fieldData[fn].coord[i].endZ;
			if debug then print('cFB: pass 1'); end;
--			newcoords = fieldStatus:checkFieldBoundaries(fn, i, coords);				-- 2013-09-03
			newcoords = fieldStatus:checkFieldBoundaries(fn, i, newcoords);				-- 2013-09-03
			if debug then print('newcoords: '..newcoords); end;
		end;
		if debug then 							-- show all coords AFTER changes
			for i=1,newcoords do
				print('aft coord ['..i..']: sX/sZ eX/eZ = '..fieldData[fn].coord[i].startX..'/'..fieldData[fn].coord[i].startZ..'  '..fieldData[fn].coord[i].endX..'/'..fieldData[fn].coord[i].endZ);
			end;
		end;

--	remove zeros entries from coords
		i = 1;
		while true do
			if fieldData[fn].coord[i] ~= nil then
				local sx = fieldData[fn].coord[i].startX;
				local ex = fieldData[fn].coord[i].endX;
				local sz = fieldData[fn].coord[i].startZ;
				local ez = fieldData[fn].coord[i].endZ;
			else
				break;
			end;
			if sx==0 and ex==0 and sz==0 and ez==0 then
				if fieldData[fn].coord[i+1] ~= nil then
					fieldData[fn].coord[i].startX = 	fieldData[fn].coord[i+1].startX;
					fieldData[fn].coord[i].endX = 		fieldData[fn].coord[i+1].endX;
					fieldData[fn].coord[i].startZ = 	fieldData[fn].coord[i+1].startZ;
					fieldData[fn].coord[i].endZ = 		fieldData[fn].coord[i+1].endZ;
					fieldData[fn].coord[i+1].startX = 0;
					fieldData[fn].coord[i+1].endX = 0;
					fieldData[fn].coord[i+1].startZ = 0;
					fieldData[fn].coord[i+1].endZ = 0;
				else
					fieldData[fn].coord[i] = nil;
					break;
				end;
			end;
			i = i + 1;
			if i > newcoords then
				break;
			end;
		end;

		local numc = 0;
		local fArea = 0;
		for i=1,newcoords do
			if fieldData[fn].coord[i] ~= nil then
				numc = numc + 1;
				local sx = fieldData[fn].coord[i].startX;
				local ex = fieldData[fn].coord[i].endX;
				local sz = fieldData[fn].coord[i].startZ;
				local ez = fieldData[fn].coord[i].endZ;
				fArea = fArea + ((ex - sx) * (ez - sz));
				if debug then				-- show FINAL coords after organizing
					print('fin coord ['..i..']: sX/sZ eX/eZ = '..fieldData[fn].coord[i].startX..'/'..fieldData[fn].coord[i].startZ..'  '..fieldData[fn].coord[i].endX..'/'..fieldData[fn].coord[i].endZ);
				end;
			else
				break;
			end;
		end;

		fieldData[fn].area = fArea;
		fieldData[fn].hectares = fArea * areaToHectare;
		fieldData[fn].acres = fieldData[fn].hectares * hectareToAcre;
		mapHectares = mapHectares + fieldData[fn].hectares;
		mapAcres = mapAcres + fieldData[fn].acres;

		if numc > maxCoords then
			maxCoords = numc;
			if debug then print('NEW maxCoords: '..maxCoords..'<'); end;
		end;
	end;

if debug then print("END func fieldStatus:calcFieldArea"); end;

end;


function fieldStatus:checkFieldBoundaries(fn, i, numcoords)

if debug then print("BEG func fieldStatus:checkFieldBoundaries"); end;

	local nsX, neX, nsZ, neZ = 0, 0, 0, 0;
	local anAction = false;

				if debug then print('fn / i: '..fn..' / '..i); end;
			if (sX >= sX1) and (eX <= eX1) and (sZ >= sZ1) and (eZ <= eZ1) then				-- eliminate coord[i] (current box is completely inside previous box)
				fieldData[fn].coord[i].startX = 0;
				fieldData[fn].coord[i].endX = 0;
				fieldData[fn].coord[i].startZ = 0;
				fieldData[fn].coord[i].endZ = 0;
					anAction = true;
					if debug then print('cFB  0: coord['..i..'] eliminated'); end;
			elseif (sX >= sX1) and (sX < eX1) and (eX > eX1) then
				if (sZ >= sZ1) and (eZ <= eZ1) then
					anAction = true;
					if debug then print('cFB  1: 1.1'); end;
					fieldData[fn].coord[i].startX = eX1;
				elseif (sZ < sZ1) and (eZ > eZ1) then
					anAction = true;
					if debug then print('cFB  1: 1.2'); end;
					nsX=sX; neX=eX1; nsZ=sZ; neZ=sZ1;
					fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
					nsX=sX; neX=eX1; nsZ=eZ1; neZ=eZ;
					fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
					fieldData[fn].coord[i].startX = eX1;
				elseif (sZ < sZ1) then
					anAction = true;
					if debug then print('cFB  1: 1.3'); end;
					nsX=sX; neX=eX1; nsZ=sZ; neZ=sZ1;
					fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
					fieldData[fn].coord[i].startX = eX1;
				elseif (eZ > eZ1) then
					anAction = true;
					if debug then print('cFB  1: 1.4'); end;
					nsX=sX; neX=eX1; nsZ=eZ1; neZ=eZ;
					fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
					fieldData[fn].coord[i].startX = eX1;
				else
					anAction = false;
					if debug then print('cFB  1: no action'); end;
				end;
			else
				anAction = false;
				if debug then print('cFB 1a: no action'); end;
			end;

			if not anAction then
				if (sZ >= sZ1) and (sZ < eZ1) and (eZ > eZ1) then
					if (sX >= sX1) and (eX <= eX1) then
						anAction = true;
						if debug then print('cFB  2: 1.1'); end;
						fieldData[fn].coord[i].startZ = eZ1;
					elseif (sX < sX1) and (eX > eX1) then
						anAction = true;
						if debug then print('cFB  2: 1.2'); end;
						nsX=sX; neX=sX1; nsZ=sZ; neZ=eZ1;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						nsX=eX1; neX=eX; nsZ=sZ; neZ=eZ1;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].startZ = eZ1;
					elseif (sX < sX1) then
						anAction = true;
						if debug then print('cFB  2: 1.3'); end;
						nsX=sX; neX=sX1; nsZ=sZ; neZ=eZ1;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].startZ = eZ1;
					elseif (eX > eX1) then
						anAction = true;
						if debug then print('cFB  2: 1.4'); end;
						nsX=eX1; neX=eX; nsZ=sZ; neZ=eZ1;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].startZ = eZ1;
					else
						anAction = false;
						if debug then print('cFB  2: no action'); end;
					end;
				else
					anAction = false;
					if debug then print('cFB 2a: no action'); end;
				end;
			end;

			if not anAction then
				if (eX > sX1) and (eX <= eX1) and (sX < sX1) then
					if (sZ >= sZ1) and (eZ <= eZ1) then
						anAction = true;
						if debug then print('cFB  3: 1.1'); end;
						fieldData[fn].coord[i].endX = sX1;
					elseif (sZ < sZ1) and (eZ > eZ1) then
						anAction = true;
						if debug then print('cFB  3: 1.2'); end;
						nsX=sX1; neX=eX; nsZ=sZ; neZ=sZ1;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						nsX=sX1; neX=eX; nsZ=eZ1; neZ=eZ;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].endX = sX1;
					elseif (sZ < sZ1) then
						anAction = true;
						if debug then print('cFB  3: 1.3'); end;
						nsX=sX1; neX=eX; nsZ=sZ; neZ=sZ1;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].endX = sX1;
					elseif (eZ > eZ1) then
						anAction = true;
						if debug then print('cFB  3: 1.4'); end;
						nsX=sX1; neX=eX; nsZ=eZ1; neZ=eZ;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].endX = sX1;
					else
						anAction = false;
						if debug then print('cFB  3: no action'); end;
					end;
				else
					anAction = false;
					if debug then print('cFB 3a: no action'); end;
				end;
			end;

			if not anAction then
				if (eZ > sZ1) and (eZ <= eZ1) and (sZ < sZ1) then
					if (sX >= sX1) and (eX <= eX1) then
						anAction = true;
						if debug then print('cFB  4: 1.1'); end;
						fieldData[fn].coord[i].endZ = sZ1;
					elseif (sX < sX1) and (eX > eX1) then
						anAction = true;
						if debug then print('cFB  4: 1.2'); end;
						nsX=sX; neX=sX1; nsZ=sZ1; neZ=eZ;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						nsX=eX1; neX=eX; nsZ=sZ1; neZ=eZ;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].endZ = sZ1;
					elseif (sX < sX1) then
						anAction = true;
						if debug then print('cFB  4: 1.3'); end;
						nsX=sX; neX=sX1; nsZ=sZ1; neZ=eZ;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].endZ = sZ1;
					elseif (eX > eX1) then
						anAction = true;
						if debug then print('cFB  4: 1.4'); end;
						nsX=eX1; neX=eX; nsZ=sZ1; neZ=eZ;
						fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ);	numcoords = numcoords + 1;
						fieldData[fn].coord[i].endZ = sZ1;
					else
						anAction = false;
						if debug then print('cFB  4: no action'); end;
					end;
				else
					anAction = false;
					if debug then print('cFB 4a: no action'); end;
				end;
			end;

if debug then print("END func fieldStatus:checkFieldBoundaries"); end;

return numcoords;

end;


function fieldStatus:createNewCoord(fn, i, numcoords, nsX, neX, nsZ, neZ)

local ii = numcoords + 1;

	fieldData[fn].coord[ii] = {};
	fieldData[fn].coord[ii].startX = nsX;
	fieldData[fn].coord[ii].endX = neX;
	fieldData[fn].coord[ii].startZ = nsZ;
	fieldData[fn].coord[ii].endZ = neZ;
			if debug then print('field '..fn..'    new coord ['..ii..']: sX/sZ eX/eZ = '..fieldData[fn].coord[ii].startX..'/'..fieldData[fn].coord[ii].startZ..'  '..fieldData[fn].coord[ii].endX..'/'..fieldData[fn].coord[ii].endZ); end;

end;


function fieldStatus:getTime(act, fname)

	print(act..' func '..fname..' time: '..g_currentMission.time);

end;

function fieldStatus:findBales(fIdx)

if debug then fieldStatus:getTime("beg", "findBales"); end;

	local validBale, baleType, balePosX, balePosZ, sIdx, eIdx, i, j, m, n, fieldFound;

	if fIdx == 0 then					-- "0" means scan all fields
		sIdx = 1; eIdx = numFields;
	else
		sIdx = fIdx; eIdx = fIdx;
	end;

	if debug then print('fIdx/sIdx/eIdx >'..fIdx..'/'..sIdx..'/'..eIdx..'<'); end;

	if baleScanStart then
		if g_server ~= nil then
			baleScanStart = false;
			numItemsToSave = 0;
			numBales = 0;
			for i=1,numFields do
				fieldData[i].bales = {};
				for j=1,#fsBaleType do
					fieldData[i].bales[fsBaleType[j]] = 0;
				end;
			end;
			for key,value in pairs(g_currentMission.itemsToSave) do
				numItemsToSave = numItemsToSave + 1;
				if value.item.className ~= nil and value.item.className == "Bale" then
					validBale = true;
					numBales = numBales + 1;
						if debug then print('nodeId/id >'..tostring(value.item.nodeId)..'/'..tostring(value.item.id)..'<'); end;
						if debug then print('filename >'..value.item.i3dFilename..'<'); end;
					baleType,_ = string.gsub(value.item.i3dFilename, ".*/", "");
					if string.find(string.lower(baleType), "straw") ~= nil then
						baleType = "straw";
					elseif string.find(string.lower(baleType), "hay") ~= nil then
						baleType = "hay";
					elseif string.find(string.lower(baleType), "drygrass") ~= nil then
						baleType = "drygrass";
					elseif string.find(string.lower(baleType), "grass") ~= nil then
						baleType = "grass";
					elseif string.find(string.lower(baleType), "silage") ~= nil then
						baleType = "silage";
					elseif string.find(string.lower(baleType), "barley") ~= nil then
						baleType = "barley";
					elseif string.find(string.lower(baleType), "wheat") ~= nil then
						baleType = "wheat";
					else
						print('fieldStatus: ERR: unknown bale type for bale id: '..value.item.id..'  >'..value.item.i3dFilename..'<');
						validBale = false;
					end;
					if validBale then
						if string.find(string.lower(value.item.i3dFilename), "round") ~= nil then
							baleType = baleType.."Rnd";
						else
							baleType = baleType.."Sqr";
						end;
								if debug then print('baleType >'..baleType..'<'); end;
						if value.item.sendPosX == nil or value.item.sendPosZ == nil then
							print('fieldStatus: ERR: invalid bale position parameters for bale id: '..value.item.id);
							validBale = false;
						else
								if debug then print('posX/posZ: '..value.item.sendPosX..' / '..value.item.sendPosZ); end;
							balePosX = value.item.sendPosX + mapOffset;
							balePosZ = value.item.sendPosZ + mapOffset;
								if debug then print('PDA posX/PDA posZ: '..balePosX..' / '..balePosZ); end;
							fieldFound = false;
							for m=1,numFields do
								if fieldData[m] ~= nil and fieldData[m].name ~= nil then
									for n=1,maxCoords do
										if fieldData[m].coord[n] ~= nil and fieldData[m].coord[n].startX ~= nil then
											if (balePosX >= fieldData[m].coord[n].startX) and (balePosX <= fieldData[m].coord[n].endX) and
											   (balePosZ >= fieldData[m].coord[n].startZ) and (balePosZ <= fieldData[m].coord[n].endZ) then
													if debug then print('found bale '..value.item.id..' ['..baleType..'] on field '..fieldData[m].name); end;
													fieldData[m].bales[baleType] = fieldData[m].bales[baleType] + 1;
													fieldFound = true; break;
											end;
										end;
									end;
								end;
								if fieldFound then break; end;
							end;
						end;
					end;
				end;
			end; -- for loop

			fsBales = {};
			for m=1,numFields do
				for n=1,#fsBaleType do
					if fieldData[m].bales[fsBaleType[n]] > 0 then
						table.insert(fsBales, { field=fieldData[m].name, type=fsBaleType[n], num=fieldData[m].bales[fsBaleType[n]] } );
					end;
				end;
			end;
			if debug then
				print('BEG print of fsBales table ... num='..#fsBales);
				if fsBales ~= nil then
					fieldStatus:print_r(fsBales,"\t");
				end;
				print('END print of fsBales table');
			end;

		end; -- g_server ~= nil
	end;

	if g_server == nil then
		if fsBales ~= nil then
			for m=sIdx,eIdx do
				fieldData[m].bales = {};
				for j=1,#fsBaleType do
					fieldData[m].bales[fsBaleType[j]] = 0;
				end;
				if fieldData[m] ~= nil and fieldData[m].name ~= nil then
					for n=1,#fsBales do
						if tostring(fsBales[n].field) == tostring(fieldData[m].name) then
							fieldData[m].bales[fsBales[n].type] = fsBales[n].num;
						end;
					end;
				end;
			end;
		else
			if debug then print('fieldStatus:findBales: fsBales table is empty'); end;
		end;
	end;

	if debug then print("fieldStatus:findBales:       numBales "..numBales); end;
	if debug then print("fieldStatus:findBales: numItemsToSave "..numItemsToSave); end;

if debug then fieldStatus:getTime("end", "findBales"); end;

end;


function fieldStatus:checkOwned()

	numOwned = 0;
	if scanType == "Owned" or scanType == "Unowned" then
		scanFieldArray = {};
		numScanFields = 0;
	end;

	for fn=1,numFields do
		thisField=g_currentMission.fieldDefinitionBase.fieldDefs[fn];
		if thisField ~= nil then
			if thisField.ownedByPlayer then
				fieldData[fn].owned = "Y";
				numOwned = numOwned + 1;
				if scanType == "Owned" then
					numScanFields = numScanFields + 1;
					scanFieldArray[numScanFields] = thisField.fieldNumber;
				end;
			else
				fieldData[fn].owned = "N";
				if scanType == "Unowned" then
					numScanFields = numScanFields + 1;
					scanFieldArray[numScanFields] = thisField.fieldNumber;
				end;
			end;
		end;
	end;
	return numOwned;
end;


function fieldStatus:addButton(act,posx,posy,posxw,posyh,thisrow,onScr)

	table.insert(fsButton, {action = act, PosX = posx, PosY = posy, PosXw = posxw, PosYh = posyh, row=thisrow, onScreen = onScr, isClicked = false});

end;


function fieldStatus:activateScreen(scrName,isActive)

	if scrName == "HUD" then
		fsActive[scrName] = isActive;
		msgTxt = "";  msgTxtColor = "";
		if fsActive["HUD"] then
				if debug then fieldStatus:getTime("beg", "activateScreen:HUD"); end;
			fsActiveTimer = fsLastScanTime;
			fsMouseEnabled = true;
			InputBinding.setShowMouseCursor(true);
			if restoreConfigActive then
				restoreConfigActive = false;
				fsActive["CONF"] = true;
				configTxt = ""; configTxtColor = "";
			elseif restoreHelpActive then
				restoreHelpActive = false;
				fsActive["HELP"] = true;
			end;
			if restoreOverlayActive then
				restoreOverlayActive = false;
				fsActive["mapOverlay"] = true;
			end;
		else
				if debug then fieldStatus:getTime("end", "activateScreen:HUD"); end;
			fsMouseEnabled = false;
			InputBinding.setShowMouseCursor(false);
			hudIsMoving = false;
			fsActive["MPLA"] = false; fsActive["userInput"] = false; fsActive["EDIT"] = false; fsActive["SCAN"] = false; fsActive["DISP"] = false;
			fsButton = {};
			if fsActive["CONF"] then
				fsActive["CONF"] = false;
				restoreConfigActive = true;
			elseif fsActive["HELP"] then
				fsActive["HELP"] = false;
				restoreHelpActive = true;
			end;
			if fsActive["mapOverlay"] then
				fsActive["mapOverlay"] = false;
				restoreOverlayActive = true;
			end;
		end;
	elseif scrName == "CONF" then
		if fsActive["HUD"] then
			fsActive[scrName] = isActive;
			configTxt = ""; configTxtColor = "";
			if fsActive["CONF"] then
				fsActive["MPLA"] = false; fsActive["HELP"] = false; fsActive["SCAN"] = false; fsActive["DISP"] = false;
				if fsSubHud.numConfigScreens > 0 and fsSubHud.configScreens[1] ~= nil then
					fsSubHud.currScreen = fsSubHud.configScreens[1];
				else
					loadSuccess = false;
					errMsgEnabled = true;
					errMsgTxt = "fieldStatus: Missing Config Screen";
				end;
			else
				fsActive["userInput"] = false; fsActive["EDIT"] = false;
			end;
		end;
	elseif scrName == "MPLA" then
		if fsActive["HUD"] then
			fsActive[scrName] = isActive;
			configTxt = ""; configTxtColor = "";
			if fsActive["MPLA"] then
				fsActive["CONF"] = false; fsActive["HELP"] = false; fsActive["SCAN"] = false; fsActive["DISP"] = false;
				if fsSubHud.numMPConfigScreens > 0 and fsSubHud.MPConfigScreens[1] ~= nil then
					fsSubHud.currScreen = fsSubHud.MPConfigScreens[1];
				else
					loadSuccess = false;
					errMsgEnabled = true;
					errMsgTxt = "fieldStatus: Missing MP Config Screen";
				end;
			else
				fsActive["userInput"] = false; fsActive["EDIT"] = false;
			end;
		end;
	elseif scrName == "HELP" then
		if fsActive["HUD"] then
			fsActive[scrName] = isActive;
			configTxt = ""; configTxtColor = "";
			if fsActive["HELP"] then
				fsActive["CONF"] = false; fsActive["MPLA"] = false; fsActive["SCAN"] = false; fsActive["DISP"] = false; fsActive["userInput"] = false; fsActive["EDIT"] = false;
				if fsSubHud.numHelpScreens > 0 and fsSubHud.helpScreens[1] ~= nil then
					fsSubHud.currScreen = fsSubHud.helpScreens[1];
				else
					loadSuccess = false;
					errMsgEnabled = true;
					errMsgTxt = "fieldStatus: Missing Help Screen";
				end;
			end;
		end;
	elseif scrName == "SCAN" then
		if fsActive["HUD"] then
			fsActive[scrName] = isActive;
			configTxt = ""; configTxtColor = "";
			if fsActive["SCAN"] then
				fsActive["HELP"] = false; fsActive["CONF"] = false; fsActive["MPLA"] = false; fsActive["DISP"] = false;
				if fsSubHud.numConfigScreens > 0 and fsSubHud.configScreens[1] ~= nil then
					fsSubHud.currScreen = fsSubHud.configScreens[1];
				else
					loadSuccess = false;
					errMsgEnabled = true;
					errMsgTxt = "fieldStatus: Missing Config Screen";
				end;
			else
				fsActive["userInput"] = false; fsActive["EDIT"] = false;
			end;
		end;
	elseif scrName == "DISP" then
		if fsActive["HUD"] then
			fsActive[scrName] = isActive;
			configTxt = ""; configTxtColor = "";
			if fsActive["DISP"] then
				fsActive["HELP"] = false; fsActive["CONF"] = false; fsActive["MPLA"] = false; fsActive["SCAN"] = false;
				if fsSubHud.numConfigScreens > 0 and fsSubHud.configScreens[1] ~= nil then
					fsSubHud.currScreen = fsSubHud.configScreens[1];
				else
					loadSuccess = false;
					errMsgEnabled = true;
					errMsgTxt = "fieldStatus: Missing Config Screen";
				end;
			else
				fsActive["userInput"] = false; fsActive["EDIT"] = false;
			end;
		end;
	elseif scrName == "EDIT" then
		if fsActive["HUD"] then
			fsActive[scrName] = isActive;
			editTxt = ""; editTxtColor = "";
			if fsActive["EDIT"] then
				fsActive["userInput"] = true;
				sym = 0;
			else
				fsActive["userInput"] = false;
				msgTxt = "";  msgTxtColor = "";
			end;
		end;
	elseif scrName == "mapOverlay" then
		if fsActive["HUD"] then
			fsActive[scrName] = isActive;
		end;
	end;

end;


function fieldStatus:prepDefaultScan()

	msgTxt = "";  msgTxtColor = "";
	if fsConfig["DefaultScan"].type == "All" then
		scanType = "All"; scanIdx = 1;
	elseif fsConfig["DefaultScan"].type == "Owned" then
		scanType = "Owned"; searchIdx = 1;  scanErrList = "";  anyFieldsScanned = false;
	elseif fsConfig["DefaultScan"].type == "Unowned" then
		scanType = "Unowned"; searchIdx = 1;  scanErrList = "";  anyFieldsScanned = false;
	elseif fsConfig["DefaultScan"].type == "Custom" then
		if fsConfig["DefaultScan"].customFieldList ~= nil then
			scanField = fsConfig["DefaultScan"].customFieldList;
			fieldStatus:checkInput();
		end;
		if fsConfig["DefaultScan"].customFieldList == nil or fsConfig["DefaultScan"].customFieldList == "" or numScanFields == 0 or scanField == "" then
			fieldStatus:activateScreen("SCAN", true);
			return;
		end;
		scanType = "Custom"; searchIdx = 1;  scanErrList = "";  anyFieldsScanned = false;
	end;
	if (scanType ~= "Custom") or (scanType == "Custom" and (not fsActive["EDIT"])) then
		weAreScanning = true; scanSource = "user"; scanTimer = 0;
		baleScanStart = true;
		numOwned = fieldStatus:checkOwned();
		if fsConfig["DefaultScan"].fruit ~= "All" then
			fruitScanSelected = true;
			fruitToScan = fsConfig["DefaultScan"].fruit;
		else
			fruitScanSelected = false;
		end;
	end;

end;


function fieldStatus:prepDefaultDisplay()

	msgTxt = "";  msgTxtColor = "";
	if fsConfig["DefaultDisplay"].type == "All" then
		showingAll = true; scanType = "All"; scanTimer = 0;
	elseif fsConfig["DefaultDisplay"].type == "Owned" then
		showingOwned = true; scanType = "Owned"; scanTimer = 0;
	elseif fsConfig["DefaultDisplay"].type == "Unowned" then
		showingUnowned = true; scanType = "Unowned"; scanTimer = 0;
	elseif fsConfig["DefaultDisplay"].type == "Custom" then
		if fsConfig["DefaultDisplay"].customFieldList ~= nil then
			scanField = fsConfig["DefaultDisplay"].customFieldList;
			fieldStatus:checkInput();
		end;
		if fsConfig["DefaultDisplay"].customFieldList == nil or fsConfig["DefaultDisplay"].customFieldList == "" or numScanFields == 0 or scanField == "" then
			fieldStatus:activateScreen("DISP", true);
			return;
		end;
		showingCustom = true; scanType = "Custom"; scanTimer = 0;
	end;
	if (scanType ~= "Custom") or (scanType == "Custom" and (not fsActive["EDIT"])) then
		if fsConfig["DefaultDisplay"].fruit ~= "All" then
			fruitScanSelected = true;
			fruitToScan = fsConfig["DefaultDisplay"].fruit;
		else
			fruitScanSelected = false;
		end;
	end;

end;


function fieldStatus:checkInput()

	local i, j, sfNew, strSplit, rangeSplit;
	validInput = true;

	numScanFields = 0;
	if scanField ~= "" then
		scanFieldArray = {};
		sfNew = string.upper(scanField);
		sfNew = string.gsub(sfNew, ":+", ":");
		sfNew = string.gsub(sfNew, ",+", " ");
		sfNew = string.gsub(sfNew, " +", " ");
		sfNew = string.gsub(sfNew, "^ ", "");
		strSplit = Utils.splitString(" ", scanField);
		for i=1,#strSplit do
			if string.find(strSplit[i], ":") ~= nil then
				rangeSplit = Utils.splitString(":", strSplit[i]);
				if	tonumber(rangeSplit[1]) == nil or tonumber(rangeSplit[2]) == nil or
					rangeSplit[2] < rangeSplit[1] then
						validInput = false;
				else
						for j=rangeSplit[1],rangeSplit[2] do
							numScanFields = numScanFields + 1;
							scanFieldArray[numScanFields] = tostring(j);
						end;
				end;
			else
				numScanFields = numScanFields + 1;
				scanFieldArray[numScanFields] = tostring(strSplit[i]);
			end;
		end;
	end;

	if numScanFields == 0 or scanField == "" then
		validInput = false;
	end;

end;


function fieldStatus:getTextSize(txtstr,whichSize,whichHUD)

	local tw1, thisSize;

	tw1=getTextWidth(1,txtstr);
	if whichHUD == "subhud" then
		if tw1 > fsSubHudPrintingArea then thisSize = whichSize * (fsSubHudPrintingArea / tw1) else thisSize = whichSize end;
	else
		if tw1 > fsHudPrintingArea then thisSize = whichSize * (fsHudPrintingArea / tw1) else thisSize = whichSize end;
	end;
	thisSize = tonumber(string.format("%.4f", thisSize));
	return thisSize;

end;


function fieldStatus:showImage(showImg, showSize)

	setOverlayColor(fsImg[showImg].id, fsImg[showImg].color.r, fsImg[showImg].color.g, fsImg[showImg].color.b, overlayTransLevel);
	if showSize == "small" then
		renderOverlay(fsImg[showImg].id, iconPosX, iconPosY, smallIconWidth, smallIconHeight);
	else
		renderOverlay(fsImg[showImg].id, iconPosX, iconPosY, normalIconWidth, normalIconHeight);
	end;

end;


fieldStatusBaleEvent = {};
fieldStatusBaleEvent_mt = Class(fieldStatusBaleEvent, Event);

InitEventClass(fieldStatusBaleEvent, "fieldStatusBaleEvent");

function fieldStatusBaleEvent:emptyNew()
	local self = Event:new(fieldStatusBaleEvent_mt);
	self.className="fieldStatusBaleEvent";
	return self;
end;

function fieldStatusBaleEvent:new()
	local self = fieldStatusBaleEvent:emptyNew();
	return self;
end;

function fieldStatusBaleEvent:writeStream(streamId, connection)

		if debug then fieldStatus:getTime("beg", "writeStream"); end;

	local i;
	local numB = 0;

	if fsBales ~= nil then
		numB = #fsBales;
		streamWriteInt16(streamId, numB);
			if debug then print('fieldStatusBaleEvent:writeStream: numB >'..tostring(numB)..'<'); end;
		for i=1,#fsBales do
			streamWriteString(streamId, tostring(fsBales[i].field));
			streamWriteString(streamId, tostring(fsBales[i].type));
			streamWriteInt16(streamId, tonumber(fsBales[i].num));
				if debug then print('fieldStatusBaleEvent:writeStream: bale >'..tostring(fsBales[i].type)..'['..tonumber(fsBales[i].num)..']< on field >'..tostring(fsBales[i].field)..'<'); end;
		end;
	else
		if debug then print('fsBales is nil -- nothing to send'); end;
	end;

		if debug then fieldStatus:getTime("end", "writeStream"); end;
end;

function fieldStatusBaleEvent:readStream(streamId, connection)

		if debug then fieldStatus:getTime("beg", "readStream"); end;

	local i;
	local numB = 0;

	numB = streamReadInt16(streamId);
				if debug then print('fieldStatusBaleEvent:readStream: numB >'..tostring(numB)..'<'); end;
	if numB ~= nil and numB > 0 then
		fsBales = {};
		for i=1,numB do
			local fsBaleField = streamReadString(streamId);
				if debug then print('fieldStatusBaleEvent:readStream: bale field >'..tostring(fsBaleField)..'<'); end;
			local fsBaleType = streamReadString(streamId);
				if debug then print('fieldStatusBaleEvent:readStream: bale  type >'..tostring(fsBaleType)..'<'); end;
			local fsBaleNum = streamReadInt16(streamId);
				if debug then print('fieldStatusBaleEvent:readStream: bale   num >'..tostring(fsBaleNum)..'<'); end;
			table.insert(fsBales, {field=fsBaleField, type=fsBaleType, num=fsBaleNum});
		end;
	end;
		if debug then
			print('fieldStatusBaleEvent:readStream: num entries in fsBales: '..#fsBales);
			print('BEG print of fsBales table');
			if fsBales ~= nil then
				fieldStatus:print_r(fsBales,"\t");
			end;
			print('END print of fsBales table');
		end;

		if debug then fieldStatus:getTime("end", "readStream"); end;
end;

function fieldStatusBaleEvent.sendEvent()

		if debug then fieldStatus:getTime("beg", "sendEvent"); end;

	if g_server ~= nil then
			if debug then print("fieldStatusBaleEvent:sendEvent: broadcast beg"); end;
		g_server:broadcastEvent(fieldStatusBaleEvent:new(), nil, nil, nil);
			if debug then print("fieldStatusBaleEvent:sendEvent: broadcast end"); end;
	end;

		if debug then fieldStatus:getTime("end", "sendEvent"); end;
end;


																				-- FIXFLDDEF BEG
function fieldStatus:fixCheckMaxCoords()
		if fsFixes ~= nil then
			ctr = 0; saveField = "";
			for kkk,vvv in pairs(fsFixes) do
--				print('fsFixes: key >'..kkk..'<    value >'..vvv..'<');				-- FIXFLDDEF TESTING
				if string.sub(vvv, 1, 5) == "field" then
					if saveField ~= "" then
						print('saveField '..saveField..' -- newMaxCoords = '..ctr / 4);				-- FIXFLDDEF TESTING
						if (ctr / 4) > maxCoords then
							maxCoords = (ctr / 4);
						end;
					end;
					ctr = 0;
					saveField = string.sub(vvv, 7);
				else
					ctr = ctr + 1;
				end;
			end;
		end;
end;
																				-- FIXFLDDEF END


function fieldStatus:getPDAMapImage()

	for k,v in pairs(fsImg) do
		if k == "pdaMap" then
			fsPdaMapAvail = false;
			local pdaPath, path2, pdaLoc;
			if altPDAPath ~= nil then
				path2,_ = string.gsub(altPDAPath:gsub("^/", ""), "/$", "");
				pdaLoc = nil;
				local s,_ = path2:find("/");
				if s ~= nil then
					pdaLoc = string.lower(path2:sub(1, s-1));
					path2 = path2:sub(s+1);
				end;
				pdaPath = altPDAPath;
				if pdaLoc ~= nil then
					if pdaLoc == "base" then
						pdaPath = getAppBasePath()..path2.."/";
					elseif pdaLoc == "user" then
						pdaPath = getUserProfileAppPath()..path2.."/";
					end;
				end;
			elseif thisMap == "Default" then
				pdaPath = getAppBasePath().."data/maps/map01/";
			elseif addOnPath ~= nil then
				pdaPath = addOnPath;
			else
				pdaPath = getUserProfileAppPath().."mods/"..thisMap.."/";
			end;
			local imgPath = Utils.getFilename(v.imgFilename, pdaPath);
			fsImg[k].id = createImageOverlay(imgPath);
			if fsImg[k].id == nil or fsImg[k].id == 0 then
				print("fieldStatus: WARN: PDA map image missing: "..imgPath);
			else
				fsPdaMapAvail = true;
			end;
		end;
	end;

end;


function fieldStatus:initVars()

fsActive = {}; fieldData = {}; fruitData = {}; dispData = {}; screenList = {}; scanFieldArray = {};
chname = {}; fsButton = {}; fsColor = {}; fsImg = {}; fsBales = {};

fsMap, mapName, thisMap, mapId, thisField, terrainSize, mapOffset = nil, nil, nil, nil, nil, nil, nil;
fileSave, xmlFile, thisXMLFile, fsXMLFile, fsXMLTag, fsTagName, fieldDataVersion = nil, nil, nil, nil, nil, nil, nil;
iconPosX, iconPosY, addOnPath, altPDAPath = nil, nil, nil, nil;

mapLoaded, loadSuccess, errMsgEnabled, xmlFileFound, fieldDefsLoaded, initHUDDone, initFruitsDone = false, false, false, false, false, false, false;
fsActive["HUD"], fsActive["CONF"], fsActive["MPLA"], fsActive["HELP"], fsActive["SCAN"], fsActive["DISP"] = false, false, false, false, false;
fsActive["AutoScan"], fsActive["mapOverlay"], fsActive["userInput"], fsActive["EDIT"] = false, false, false, false;
varPrinted, showingAll, showingOwned, showingUnowned, showingCustom = false, false, false, false, false;
debug, display, savexml, fsPdaMapAvail, configLoaded, fixedXML, fixingXML = false, false, false, false, false, false, false;
baleScanStart, anyFieldsScanned, weAreScanning, fsMouseEnabled, hudIsMoving, showConfigFieldList = false, false, false, false, false, false;
restoreHelpActive, restoreConfigActive, restoreOverlayActive = false, false, false;
fruitScanSelected, validInput, buttonActionTaken = false, false, false;
baleScanDone, isMultiPlayerGame = false, false;

showingPercent, ctrlDOK, ctrlPOK, ctrlXOK = true, true, true, true;

fskeyActivateHUD, fskeyHUDPos, fskeyOverlay, fskeyTransUp, fskeyTransDown, fskeyReloadFDefs, fskeyTogglePercent = "", "", "", "", "", "", "";
fskeyDefaultScan, fskeyDefaultDisplay, fskeyListStart, fskeyListEnd, fskeyListPrev, fskeyListNext = "", "", "", "", "", "";
msgTxt, msgTxtColor, configTxt, configTxtColor, editTxt, editTxtColor, errMsgTxt = "", "", "", "", "", "", "";
scanField, saveScanField, scanErrList, fruitToScan = "", "", "", "";

numFields, numFieldDefs, maxCoords, mapHectares, mapAcres, numFruits, totFieldDensity = 0, 0, 0, 0, 0, 0, 0;
numScanFields, scanIdx, searchIdx, scanTimer, fsActiveTimer, fsBaleEventTimer, fsBaleLastScanTime, fsLastScanTime = 0, 0, 0, 0, 0, 0, 0, 0;
dispDataItems, dispDataIdx, screenListIdx, numScreens, numOwned  = 0, 0, 0, 0, 0;
sX, eX, sZ, eZ, sX1, eX1, sZ1, eZ1 = 0, 0, 0, 0, 0, 0, 0, 0;
fsHudPrintWidth, fsHudPrintingArea, fsSubHudPrintWidth, fsSubHudPrintingArea, thisTextSize = 0, 0, 0, 0, 0;
editRow = 0;
numItemsToSave, numBales, saveNumBales, maxBaleId, saveMaxBaleId = 0, 0, 0, 0, 0;

numPlayers				= 0;
currScreen				= 1;
scanTimerWait			= 10;			-- 0.01 seconds
scanTimerWait2			= 500;			-- 0.5 seconds
areaToHectare			= 0.0001;
hectareToAcre			= 2.471;
numGrowthStates			= 10;			-- 0-9
numFSChannels			= 5;			-- 0-4
overlayTransLevel		= 1.0;
displayTotalLines		= 26;
dispLinesAvail			= 18;
lineSpacing				= 0.0175;
textHeaderSize			= 0.025;
textSubHeaderSize		= 0.0215;
textNormalSize			= 0.018;
textSmallSize			= 0.014;
textVersionSize			= 0.013;
normalIconWidth			= 0.0125;
normalIconHeight		= 0.0166;
smallIconWidth			= 0.0083;
smallIconHeight			= 0.0109;

dashLine = string.rep("-", 35);
shortDashLine = string.rep("-", 26);
scanType = "All"; scanSource = "user";
fsConfigFile = getUserProfileAppPath().."fieldStatusConfig.xml";
fieldDataFile = "fieldData.xml";
fsConfigHeader = { "AutoScan", "DefaultScan", "DefaultDisplay", "BaleScan" };

fsHud = { CurrPos = 1, Width = 0.1775, Height = 0.5, Margin = 0.0075, PosX = {0.813, 0.0075, 0}, PosY = {0.395, 0.4925, 0} };

fsSubHudWidth     = fsHud.Width;
fsSubHudMargin    = fsHud.Margin;

fsMiniPosX			= 0.4;
fsMiniPosY			= 0.5;
fsMiniHudHeight		= 0.26;

fsHudPrintWidth = fsHud.Width - (fsHud.Margin * 2);
fsHudPrintingArea = fsHudPrintWidth / textNormalSize;
fsSubHudPrintWidth = fsSubHudWidth - (fsSubHudMargin * 2);
fsSubHudPrintingArea = fsSubHudPrintWidth / textNormalSize;

fsMiniPrintPosY			= fsMiniHudHeight + fsMiniPosY - textHeaderSize - 0.01;
fsMiniPrintPosX			= fsMiniPosX + fsHud.Margin;
fsMiniPrintPosXCenter	= fsMiniPosX + (fsHud.Width / 2) - 0.002;
fsMiniPrintPosXRight	= fsMiniPosX + fsHud.Width - fsHud.Margin - 0.004;
fsMiniPrintMsgLine		= fsMiniPrintPosY - (lineSpacing * 12.5);
fsMiniPrintInfoLine2	= fsMiniPrintMsgLine + lineSpacing;
fsMiniPrintInfoStart	= fsMiniPrintInfoLine2 + lineSpacing;

fsColor.white			= { r=1, g=1, b=1 };
fsColor.brightred		= { r=1, g=0, b=0 };
fsColor.red				= { r=0.9, g=0.18, b=0.18 };
fsColor.blue			= { r=0.31, g=0.64, b=0.93 };
fsColor.yellow			= { r=0.78, g=0.76, b=0.16 };
fsColor.gray			= { r=0.55, g=0.55, b=0.55 };
fsColor.brown			= { r=0.83, g=0.74, b=0.62 };
fsColor.green			= { r=0.11, g=0.67, b=0.16 };
fsColor.lightgreen		= { r=0.61, g=0.96, b=0.68 };
fsColor.darkgreen		= { r=0.05, g=0.44, b=0.09 };
fsColor.darkcyan		= { r=0.26, g=0.76, b=0.79 };

fsImg.pdaMap			= { id=nil, imgFilename="pda_map.dds", color=fsColor.white };
fsImg.HUD 				= { id=nil, imgFilename="img/fs_hud.dds", color=fsColor.white };
fsImg.pdaPos			= { id=nil, imgFilename="img/pda_pos.dds", color=fsColor.white };
fsImg.leftArrow			= { id=nil, imgFilename="img/left_arrow.dds", color=fsColor.blue };
fsImg.rightArrow		= { id=nil, imgFilename="img/right_arrow.dds", color=fsColor.blue };
fsImg.scan 				= { id=nil, imgFilename="img/scan.dds", color=fsColor.white };
fsImg.display			= { id=nil, imgFilename="img/display.dds", color=fsColor.white };
fsImg.config			= { id=nil, imgFilename="img/config.dds", color=fsColor.gray };
fsImg.moveHUD 			= { id=nil, imgFilename="img/move_hud.dds", color=fsColor.white };
fsImg.save 				= { id=nil, imgFilename="img/save.dds", color=fsColor.blue };
fsImg.edit 				= { id=nil, imgFilename="img/edit.dds", color=fsColor.white };
fsImg.help 				= { id=nil, imgFilename="img/help.dds", color=fsColor.blue };
fsImg.close 			= { id=nil, imgFilename="img/close.dds", color=fsColor.white };
fsImg.erase 			= { id=nil, imgFilename="img/erase.dds", color=fsColor.white };
fsImg.accept 			= { id=nil, imgFilename="img/accept.dds", color=fsColor.white };
fsImg.bale 				= { id=nil, imgFilename="img/bale.dds", color=fsColor.white };

fsBaleType = { "strawSqr", "strawRnd", "haySqr", "hayRnd", "grassSqr", "grassRnd", "dryGrassSqr", "dryGrassRnd", "silageSqr", "silageRnd", "barleySqr", "barleyRnd", "wheatSqr", "wheatRnd" };

fixingXML = false;																-- FIXFLDDEF
fsFixes = {};																	-- FIXFLDDEF

end;
