verifyMovingTools = {};

function verifyMovingTools.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function verifyMovingTools:load(xmlFile)
	self.toolsToCheck = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.movingTools.movingTool(%d)", i);
		local index = getXMLString(xmlFile,baseName.."#index");
		if index ~= nil then
			if getXMLBool(xmlFile,baseName.."#verify") == true then
				local entry = {};
				entry.node = Utils.indexToObject(self.components,index);
				entry.lastRot = {getRotation(entry.node)};
				entry.lastTrans = {getTranslation(entry.node)};
				table.insert(self.toolsToCheck, entry);
			end;
			i=i+1;
		else
			break;
		end;
	end;
	self.firstRun = true;
end;

function verifyMovingTools:delete()
end;

function verifyMovingTools:mouseEvent(posX, posY, isDown, isUp, button)
end;

function verifyMovingTools:keyEvent(unicode, sym, modifier, isDown)
end;

function verifyMovingTools:update(dt)
end;

function verifyMovingTools:updateTick(dt)
	for _,tool in ipairs(self.toolsToCheck) do
		local curRot = {getRotation(tool.node)};
		local curTrans = {getTranslation(tool.node)};
		local hasChanged = false;
		if not Utils.areListsEqual(tool.lastRot,curRot) then
			tool.lastRot = curRot;
			hasChanged = true;
		end;
		if not Utils.areListsEqual(tool.lastTrans,curTrans) then
			tool.lastTrans = curTrans;
			hasChanged = true;
		end;
		if hasChanged then
			self:setMovingToolDirty(tool.node);
			self.firstRun = false;
		end;
		if self.firstRun then
		    for i, part in ipairs(self.movingParts) do
				Cylindered.updateMovingPart(self, part);
			end;
			self.firstRun = false;
		end;
	end;
end;


function verifyMovingTools:draw()
end;
