﻿--
--SearchModsScript = {}
--
--to search Mods, like MapDoorTrigger, MapBuyableObject, MapSuperSiloTrigger usw.
-- 
-- Include into the map moddesc.xml / Einbinden in die Map moddesc.xml 
-- 				between				/ 			zwischen
--	<modDesc descVersion="13"> 			and 			</modDesc>
--
--	<extraSourceFiles>
--		<sourceFile filename="scripte/SearchBuyableObjectScript.lua" />
--	</extraSourceFiles>
--
--	<SearchMods>
--		<mod zipName="MapDoorTrigger" downloadLink = "optional"/>
--		<mod zipName="MapBuyableObject"/>
--		<mod zipName="MapSuperSiloTrigger"/>
--		<mod zipName="GuelleMistMod"/>
--		<mod zipName="MapHoseRefStation"/>
--	</SearchMods>
--
--Only the Name of Mod, without ".zip"

--@date: 27/02/2014
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0	release fantasy Reloaded by tommy r
--
--
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission


	print("   SearchModsScript v1.0  by Bluebaby210 loaded!");

SearchModsScript = {}
SearchModsScript_dir = g_currentModDirectory;

function SearchModsScript:loadMap(name)

	self.nameBase = g_currentMission.missionInfo.baseDirectory;

	if self.nameBase == SearchModsScript_dir then
		self.leng = getSystemLanguage();
		self.neededMods = {};
		self.downloadLink = {};
		
		local xml = loadXMLFile("modDesc", g_currentMission.missionInfo.baseDirectory.."modDesc.xml");
		local k = 0;
			while true do
				local linesname = string.format("modDesc.SearchMods.mod(%d)", k);
					if not hasXMLProperty(xml, linesname) then
						break;
					end;
					k = k + 1;
					self.neededMods[k] = getXMLString(xml, linesname .."#zipName");
					if getXMLString(xml, linesname .."#downloadLink") ~= nil then
						self.downloadLink[k] = getXMLString(xml, linesname .."#downloadLink");
					end;
					if self.neededMods[k] == "MapBuyableObject" then
						--print("	Match: MapBuyableObject");
						self.downloadLink[k] = "https://mod-portal.com/wbb3/forum/index.php?page=DatabaseItem&id=339";
					end;
					--print(self.neededMods[k]);
			end;
		
		self.loadTextOneTime = true;
		self.failedMods = {};
		if table.getn(self.neededMods) >= 1 then
			for i=1, table.getn(self.neededMods) do
				local modName = g_modsDirectory.."/"..self.neededMods[i]..".zip";
				if not fileExists(modName) then
					table.insert(self.failedMods, self.neededMods[i]);
					--print("			Not existed Mod: ", tostring(self.neededMods[i]));
					self.modFailed = true;
					self.showMessage = true;
					if self.loadTextOneTime then
						if self.leng == 1 then
							self:readTextDE();
						elseif self.leng == 5 then
							self:readTextFR();
						else
							self:readTextEN();
						end;
						self.loadTextOneTime = false;
					end;
				end;
			end;
		end;
				
		
	end;	
		
	self.newOverlay = g_currentMission.hudWarningBaseOverlay.overlayId;
end;

function SearchModsScript:deleteMap()

	if table.getn(self.failedMods) >= 1 then
		if self.leng == 1 then
			print("Bitte lade dir folgende Mods zur vollen Funktionalitaet der Map runter.")
		else
			print("Please download the following mods for full functionality of the map.");
		end;
		for a=1, table.getn(self.failedMods) do
			for i=1, table.getn(self.neededMods) do
				if self.failedMods[a] == self.neededMods[i] then
					if self.downloadLink[i] ~= nil then
						print(self.neededMods[i].." : "..self.downloadLink[i]);
					else
						print(self.neededMods[i]..".zip");
					end;
				end;
			end;
		end;
	end;
end;

function SearchModsScript:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SearchModsScript:keyEvent(unicode, sym, modifier, isDown)
end;

function SearchModsScript:readStream(streamId, connection)
end;

function SearchModsScript:writeStream(streamId, connection)
end;

function SearchModsScript:update(dt)

	if self.modFailed then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self.modFailed = false;
			self.showMessage = false;
		end;
	end;

end;

function SearchModsScript:draw()
	if self.showMessage and self.modFailed then
		renderOverlay(self.newOverlay, -0.1, 0.23, 1.5, 0.49);
		setTextColor(1,0.80,0,1);
		setTextBold(true);
		renderText(self.textHeadPL, self.textHeadPH, self.textHeadFS, self.textHead);
		setTextBold(false);
		for k=1,table.getn(self.textName) do 
			renderText(0.06, self.textPos[k], 0.03, self.textName[k]);
		end;
		renderText(0.06, (0.62- (0.031 * (table.getn(self.textName)+1))), 0.03, self.missingText);
		for i=1,table.getn(self.failedMods) do 
			renderText(0.36, (0.62- (0.031 * ((table.getn(self.textName)+i)))), 0.03, self.failedMods[i]..".zip");
		end;
		
		renderText(0.26, (0.62- (0.031 * ((table.getn(self.textName)+table.getn(self.failedMods))+2))), 0.03, ("Close Message:"));
		renderText(0.48, (0.62- (0.031 * ((table.getn(self.textName)+table.getn(self.failedMods))+2))), 0.03, InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMPLEMENT_EXTRA));
		setTextColor(0,0,0,1);
	end;
end;

function SearchModsScript:readTextDE()
	self.textName = {};
	self.textPos = {};
	self.textHead = "Fehlen eines/mehrerer Mods zur vollen Funktionalität der Map."
	self.textHeadPL = 0.05;
	self.textHeadPH = 0.625;
	self.textHeadFS = 0.04;
	self.textName[1] = "Ihnen fehlt ein oder mehrere Mods um die volle Funktionalität der Map zu nutzen."
	self.textName[2] = "Die kann dazu führen das sie nicht alle Funktionen nutzen können, oder auch dazu"
	self.textName[3] = "das sie Fehlermeldungen in der LOG haben."
	self.textName[4] = "Wenn sie das Spiel beenden dann stehen am Ende der LOG Datei die Mods die fehlen."
	self.textName[5] = " "

		for k=1,table.getn(self.textName) do 
			self.textPos[k] = 0.62 - (0.031 * k);
		end;
		
	self.missingText="Fehlende Mods:";
end;

function SearchModsScript:readTextFR()
	self.textName = {};
	self.textPos = {};
	self.textHead = "Missing MapBuyableObject.zip"
	self.textHeadPL = 0.26;
	self.textHeadPH = 0.625;
	self.textHeadFS = 0.04;
	self.textName[1] = "You miss the MapBuyableObject.zip in the mods directory. Without this mod the "
	self.textName[2] = "map is only conditionally playable.It may have cause they are objects on the map into each other,"
	self.textName[3] = "or icons that do not turn and do not let off. The Creator has build some "
	self.textName[4] = "new Objects which must buyed before playing."
	self.textName[5] = ""
		for k=1,table.getn(self.textName) do 
			self.textPos[k] = 0.62 - (0.031 * k);
		end;
	self.missingText="Missing Mods:";
end;

function SearchModsScript:readTextEN()
	self.textName = {};
	self.textPos = {};
	self.textHead = "Missing MapBuyableObject.zip"
	self.textHeadPL = 0.26;
	self.textHeadPH = 0.625;
	self.textHeadFS = 0.04;
	self.textName[1] = "You miss the MapBuyableObject.zip in the mods directory. Without this mod the "
	self.textName[2] = "map is only conditionally playable.It may have cause they are objects on the map into each other,"
	self.textName[3] = "or icons that do not turn and do not let off. The Creator has build some "
	self.textName[4] = "new Objects which must buyed before playing."
	self.textName[5] = ""
		for k=1,table.getn(self.textName) do 
			self.textPos[k] = 0.62 - (0.031 * k);
		end;
	self.missingText="Missing Mods:";
end;
addModEventListener(SearchModsScript);