--
-- fantasy
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

fantasy = {}

local fantasy_mt = Class(fantasy, Mission00);


function fantasy:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = fantasy_mt;
    end;
    local self = fantasy:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function fantasy:delete()
    fantasy:superClass().delete(self);
end;

function fantasy:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("fantasy.i3d", self.baseDirectory), true, self.loadfantasyFinished, self);

	self.addAlternativeTippingHeaps = {};
	self.addAlternativeTippingHeaps["file"] = "scripts/AlternativeTipTrigger.xml";
	self.addAlternativeTippingHeaps["dir"] = self.baseDirectory;
end;

function fantasy:loadfantasyFinished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("fantasy.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -150, 270, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -130, 229, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -110, 305, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -100, 242, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 150, 264, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 110, 295, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -113, 130, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
   

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -92, 57, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -90, -115, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -70 , -55, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), -115, 20, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), -90, 81, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), -110, -25, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    fantasy:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function fantasy:onStartMission()
    fantasy:superClass().onStartMission(self);
end;

function fantasy:mouseEvent(posX, posY, isDown, isUp, button)
    fantasy:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function fantasy:keyEvent(unicode, sym, modifier, isDown)
    fantasy:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function fantasy:update(dt)
    fantasy:superClass().update(self, dt);
end;

function fantasy:draw()
    fantasy:superClass().draw(self);
end;