--[[************************************************************************************************************************************************************
	
	wheelParticle v2.0
	
	05/2013 by Saty / http://forum.lsczech.cz
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
	--------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	Zapis do XML souboru stroje :
	*****************************
	
	<wheels autoRotateBackSpeed="2" file="particleSystems/wheelParticleSystem.i3d">
	
	( Pouze pripsat do uvodniho radku originalnich kol [file="particleSystems/wheelParticleSystem.i3d"] , kde musi byt presna cesta k PS! )
	
	--------------------------------------------------------------------------------------------------------------------------------------------------------	
	
	Zapis do souboru modDesc.xml :
	******************************
	
	vsadit do <specializations> :
		<specialization name="wheelParticle"  className="wheelParticleV2"  filename="scripts/wheelParticleV2.lua"/>
	
	vsadit do <vehicleTypes> :
		<specialization name="wheelParticle" />
	
************************************************************************************************************************************************************]]--

wheelParticleV2 = {};

function wheelParticleV2.prerequisitesPresent(specializations)
	return true;
end;

function wheelParticleV2:load(xmlFile)

	self.wheelPS = {};
	local PSfile = getXMLString(xmlFile, "vehicle.wheels#file");
	if PSfile ~= nil then
		local i = 1;
		while true do
			local key = string.format("vehicle.wheels.wheel(%d)", i-1);
			if not hasXMLProperty(xmlFile, key) then
				break;
			end;
			local node = clone(self.wheels[i].driveNode);
			local x, y, z = getTranslation(node);
			local radius = self.wheels[i].radius;
			setVisibility(node, false);
			setTranslation(node, x, y - radius, z);
			local particle = {};
			Utils.loadParticleSystem(xmlFile, particle, "vehicle.wheels", node, false, nil, self.baseDirectory);
			table.insert(self.wheelPS, {node=node, index=i, particle=particle});
			i = i + 1;
		end;
	end;
end;

function wheelParticleV2:delete()
	for _,wheel in pairs(self.wheelPS) do
		Utils.deleteParticleSystem(wheel.particle);
	end;
end;

function wheelParticleV2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelParticleV2:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelParticleV2:update(dt)
	for _,wheel in pairs(self.wheelPS) do
		local dens = 0; local dens1; local dens2; local dens3;
		local x, y, z = getWorldTranslation(wheel.node);
		dens1 = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x + 0.3, z + 0.5, x - 0.3, z + 0.5, x + 0.3, z - 0.5);
		dens2 = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sowingChannel, x + 0.3, z + 0.5, x - 0.3, z + 0.5, x + 0.3, z - 0.5);
		dens3 = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x + 0.3, z + 0.5, x - 0.3, z + 0.5, x + 0.3, z - 0.5);
		if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
			dens = dens1 + dens2 + dens3;
		end;
		if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
			Utils.setEmittingState(wheel.particle, self.wheels[wheel.index].hasGroundContact);
		else
			Utils.setEmittingState(wheel.particle, false);
		end;
	end;
end;

function wheelParticleV2:draw()
end;