-- Disables the withering of the crops on all maps

-- @author Stegei
-- @date 15/01/14
--
-- Copyright (C) 2013 Stegei

DisableCropWithering = {};
DisableCropWithering.isApplied = false;

function DisableCropWithering:loadMap(name)
end;

function DisableCropWithering:deleteMap()
    self.isApplied = false;
end;

function DisableCropWithering:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DisableCropWithering:keyEvent(unicode, sym, modifier, isDown)
end;

function DisableCropWithering:update(dt)
    if not self.isApplied then
        self.isApplied = true;
        local disabledFruits = "";
        for fruitType, entry in pairs(g_currentMission.fruits) do
            local desc = FruitUtil.fruitIndexToDesc[fruitType];
            if desc ~= nil and entry.id ~= nil and entry.id ~= 0 then

                if desc.maxHarvestingGrowthState >= 0 then

                    local witheredState = desc.maxHarvestingGrowthState+1
                    if desc.maxPreparingGrowthState >= 0 then
                        witheredState = desc.maxPreparingGrowthState+1;
                    end
                    if witheredState ~= desc.cutState and witheredState ~= desc.preparedGrowthState and witheredState ~= desc.minPreparingGrowthState then
                        -- only disable the withering, if the currently set final growth state is the withered state
                        if getGrowthNumStates(entry.id) == witheredState+1 then
                            setGrowthNumStates(entry.id, witheredState);

                            if disabledFruits ~= "" then
                                disabledFruits = disabledFruits .. ", ";
                            end
                            disabledFruits = disabledFruits .. desc.name;
                        end
                    end
                end
            end
        end
        if disabledFruits ~= "" then
            print("Disabled withering for: "..disabledFruits);
        end
    end
end;

function DisableCropWithering:draw()
end;

if getGrowthNumStates ~= nil and setGrowthNumStates ~= nil then
    addModEventListener(DisableCropWithering);
else
    -- unfortunately getGrowthNumStates has only been added with patch 2.1
    print("Warning: disableCropWithering only works if patch 2.1 or higher is installed");
end