-- by modelleicher
-- www.schwabenmodding.bplaced.net


Cutterbar = {};

function Cutterbar.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Cutterbar:load(xmlFile)
	self.changeCutterbarState = Cutterbar.changeCutterbarState;
	self.doRot = Cutterbar.doRot;
	self.Cutterbar = {};
	self.Cutterbar.konsole = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Cutterbar.Konsole#index"));
	self.Cutterbar.konsoleUpRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Cutterbar.Konsole#upRotation"), 0);
	self.Cutterbar.konsoleDownRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Cutterbar.Konsole#downRotation"), 10);
	
	self.Cutterbar.cutter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Cutterbar.Cutter#index"));
	self.Cutterbar.cutterUpRot = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Cutterbar.Cutter#upRotation"), 0);
	self.Cutterbar.cutterDownRot = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Cutterbar.Cutter#downRotation"), 20);

	self.Cutterbar.schutz = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Cutterbar.Cutter#schutzIndex"));
	
	self.CutterbarState = false;
	self.Cutterbar.cutterCurRot = self.Cutterbar.cutterUpRot;
	self.Cutterbar.konsoleCurRot = self.Cutterbar.konsoleUpRot;	
	self.doRotate = true;
	self.doRenderCutterbarHelptext = false;
end;

function Cutterbar:delete()
end;
function Cutterbar:readStream(streamId, connection)  
     self:changeCutterbarState(streamReadBool(streamId), true);  
end;
function Cutterbar:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.CutterbarState);  
end;

function Cutterbar:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Cutterbar:keyEvent(unicode, sym, modifier, isDown)
end;

function Cutterbar:changeCutterbarState(state, noEventSend)  
    CutterbarEvent.sendEvent(self, state, noEventSend);	
    self.CutterbarState = state;
	self.doRotate = true;
end;
function Cutterbar:doRot(index, rotX, rotY, rotZ, destinationX, destinationY, destinationZ)
	setRotation(index, Utils.degToRad(rotX), Utils.degToRad(rotY), Utils.degToRad(rotZ));
	if rotX == destinationX and rotY == destinationY and rotZ == destinationZ then
		return true;
	else
		return nil;
	end;	
end;
function Cutterbar:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() and self.isTurnedOn then
			if InputBinding.hasEvent(InputBinding.Cutterbar_UpDown) then
				self:changeCutterbarState(not self.CutterbarState);
			end;
		end;	
		if self.isTurnedOn then
			setVisibility(self.Cutterbar.schutz, false);	
			self.doRenderCutterbarHelptext = true;
		else
			setVisibility(self.Cutterbar.schutz, true);		
			self.CutterbarState = false;
			self.doRenderCutterbarHelptext = false;
		end;
		if self.CutterbarState then
			if self.doRotate == true then		
				self.Cutterbar.cutterCurRot = math.min(self.Cutterbar.cutterCurRot + 1, self.Cutterbar.cutterDownRot);
				self.Cutterbar.konsoleCurRot = math.min(self.Cutterbar.konsoleCurRot + 1, self.Cutterbar.konsoleDownRot);
				local rot1 = self:doRot(self.Cutterbar.konsole, 0, 0, self.Cutterbar.konsoleCurRot, 0, 0, self.Cutterbar.konsoleDownRot);
				local rot2 = self:doRot(self.Cutterbar.cutter, 0, 0, self.Cutterbar.cutterCurRot, 0, 0, self.Cutterbar.cutterDownRot);			
				if rot1 == true and rot2 == true then
					self.doRotate = false;
				end;
			end;
		else
			if self.doRotate == true then			
				self.Cutterbar.cutterCurRot = math.max(self.Cutterbar.cutterCurRot - 0.5, self.Cutterbar.cutterUpRot);		
				self.Cutterbar.konsoleCurRot = math.max(self.Cutterbar.konsoleCurRot - 0.5, self.Cutterbar.konsoleUpRot);	
				local rot1 = self:doRot(self.Cutterbar.konsole, 0, 0, self.Cutterbar.konsoleCurRot, 0, 0, self.Cutterbar.konsoleUpRot);
				local rot2 = self:doRot(self.Cutterbar.cutter, 0, 0, self.Cutterbar.cutterCurRot, 0, 0, self.Cutterbar.cutterUpRot);			
				if rot1 == true and rot2 == true then
					self.doRotate = false;
				end;
			end;
		end;
	end;
end;

function Cutterbar:draw()
	if self.doRenderCutterbarHelptext then
		g_currentMission:addHelpButtonText(g_i18n:getText("CutterbarUpDown"), InputBinding.Cutterbar_UpDown);
	end;
end;

CutterbarEvent = {};
CutterbarEvent_mt = Class(CutterbarEvent, Event);

InitEventClass(CutterbarEvent, "CutterbarEvent");

function CutterbarEvent:emptyNew() 
    local self = Event:new(CutterbarEvent_mt );
    self.className="CutterbarEvent";
    return self;
end;

function CutterbarEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function CutterbarEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function CutterbarEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state);   
end;

function CutterbarEvent:run(connection)  
    self.vehicle:changeCutterbarState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(CutterbarEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function CutterbarEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(CutterbarEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(CutterbarEvent:new(vehicle, state));
		end;
	end;
end;

