Funk = {};

function Funk.prerequisitesPresent(specializations)
    return true;
end;

function Funk:load(xmlFile)

	local FunkSound = getXMLString(xmlFile, "vehicle.FunkSound#file");
    if FunkSound ~= nil and FunkSound ~= "" then
        FunkSound = Utils.getFilename(FunkSound, self.baseDirectory); 
        self.FunkSound = createSample("FunkSound");
        loadSample(self.FunkSound, FunkSound, false);
        self.FunkSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.FunkSound#pitchOffset"), 1);
        self.FunkSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.FunkSound#volumen"), 1);
    end;
	
	self.FunkOn = false;
	self.FunkStart = false;
	
end;

function Funk:delete()
    if self.FunkSound ~= nil then
        delete(self.FunkSound);
    end;	
end;

function Funk:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Funk:keyEvent(unicode, sym, modifier, isDown)

end;

function Funk:update(dt)

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.arbeit) then
			self.FunkOn = not self.FunkOn;
		end;		
	else
		self.FunkOn = false;
	end;

	if self:getIsActiveForSound() then
		if not self.FunkStart and self.FunkOn then
			self.FunkStart = true;
			if self.FunkSound ~= nil then
				setSamplePitch(self.FunkSound, self.FunkSoundPitchOffset);
				playSample(self.FunkSound, 1, self.FunkSoundVolume, 1);
			end;
		end;	
		if self.FunkStart and not self.FunkOn then
			self.FunkStart = false;
			if self.FunkSound ~= nil then
				stopSample(self.FunkSound);
			end;
		end;
	end;
	
	if self.FunkStart and not self.FunkOn then
		self.FunkStart = false;
		if self.FunkSound ~= nil then
			stopSample(self.FunkSound);
		end;
	end;
	
end;

function Funk:draw()
end;

function Funk:onLeave()
	stopSample(self.FunkSound);
	self.FunkOn = false;
end;