--
-- Kamerascript fuer Foederband
--
--  Anhaengerview
--
-- by M-Modding, LS 2013 Farmer
--

Cam = {};

function Cam.prerequisitesPresent(specializations)
    return true;
end;

function Cam:load()
	self.CamPosX = 0.48;
	self.CamWidth = 0.32;
	self.CamPosY = 0.74;
	self.CamHeight = 0.24;
        self.CamFrame = Utils.getFilename("textures/CamFrame1.dds", self.baseDirectory);
	self.CamFrameOverlay = Overlay:new("CamFrameOverlay", self.CamFrame, self.CamPosX, self.CamPosY, self.CamWidth, self.CamHeight);
	self.showCam = 0;
end;

function Cam:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Cam:keyEvent(unicode, sym, modifier, isDown)
end;

function Cam:update()
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.Cam) and self.isEntered then
			self.showCam = self.showCam+1;
			if self.showCam == 2 then
				self.showCam = 0;
			end;
		end;
	end;
end;
	
function Cam:draw()
	if self.showCam == 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("CamOFF"), InputBinding.Cam);
		self.Cam = 0;
		link(self.rootNode, self.Cam);
		node = getRootNode(0);
		setRootNode(node, 1);
		setViewport(1, 0.48, 0.02, 0.32, 0.24);
		setCamera(self.Cam,1);
	elseif self.showCam == 1 then
		g_currentMission:addHelpButtonText(g_i18n:getText("CamON"), InputBinding.Cam);
		self.Cam = createCamera("Cam", 90, 0.1, 100);
		link(self.rootNode, self.Cam);
		translate (self.Cam,0,8,-10);
		rotate(self.Cam,-70,0,0);
		node = getRootNode(0);
		setRootNode(node, 1);
		setViewport(1, 0.48, 0.02, 0.32, 0.24);
		setCamera(self.Cam,1);
		self.CamFrameOverlay:render();
	end;
end;

function Cam:delete()
end;

function Cam:onLeave()
		self.Cam = 0;
		link(self.rootNode, self.Cam);
		node = getRootNode(0);
		setRootNode(node, 1);
		setViewport(1, 0.48, 0.02, 0.32, 0.24);
		setCamera(self.Cam,1);
end;
