
-- by "Marhu" 
-- v 1.0
-- Date: 13.01.2012
-- Zum entladen vom "Mobiles Frderband"

Conveyorunload = {};

function Conveyorunload.prerequisitesPresent(specializations)
    return true; 
end;

function Conveyorunload:load(xmlFile)
		
	self.chargefillNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeTypes#fillNode"));
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1000);
			
	self.chargeParticle = {};
    local i = 0;
    while true do
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeParticle#index"));
        local key = string.format("vehicle.chargeParticle.chargeParticle(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
		if t == nil then
            break;
        end
        local currentPS = {};
		local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, nodei, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
		self.chargeParticle[t] = currentPS;
		i = i +1;
    end;
	
	self.Planen = {};
    local i = 0;
    while true do
		local key = string.format("vehicle.fillPlanes.fillPlane(%d)", i);
        local t = getXMLString(xmlFile, key.."#type");
		if t == nil then
            break;
        end
		self.Planen[t] = Utils.indexToObject(self.components, getXMLString(xmlFile, key..".node#index"));
		i = i +1;
    end;
	self.Belt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Belt#index"));
	
	local SoundRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workSound#node"));
	local workSound  = getXMLString(xmlFile, "vehicle.workSound#file");
	if workSound  ~= nil and workSound  ~= "" then
		workSound  = Utils.getFilename(workSound, self.baseDirectory);
		self.workSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#radius"), 50);
		self.workSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#innerRadius"), 10);
		self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), .8);
		self.workSound = createAudioSource("workSound", workSound, self.workSoundRadius, self.workSoundInnerRadius, self.workSoundVolume, 0);
		link(SoundRefNode, self.workSound);
		setVisibility(self.workSound, false);
   end;
	
	self.findTrailer = Conveyorunload.findTrailer;
	self.TrailerRaycast = Conveyorunload.TrailerRaycast;
	
end;

function Conveyorunload:readStream(streamId, connection)
end;

function Conveyorunload:writeStream(streamId, connection)	
end;

function Conveyorunload:delete()
	for k,v in pairs(self.chargeParticle) do
		Utils.deleteParticleSystem(v);
	end;
end;

function Conveyorunload:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Conveyorunload:keyEvent(unicode, sym, modifier, isDown)
end;

function Conveyorunload:update(dt)

	self.inRange = false; 
	
	if self.fillLevel > 0 then
		local trailer = self:findTrailer()
		if trailer and trailer:allowFillType(self.currentFillType, true) then
			for fruitType,v in pairs(trailer.fillTypes) do
				if fruitType == self.currentFillType then
					self.savePS = self.chargeParticle[Fillable.fillTypeIntToName[self.currentFillType]]; 
					Utils.setEmittingState(self.savePS, true);
					if not self.turnOn then
						setShaderParameter(self.Belt, "scollSpeed", 0,-0.4,0,0,false);
						setShaderParameter(self.Planen[Fillable.fillTypeIntToName[self.currentFillType]], "scollSpeed", 0,-0.4,0,0,false);
						playSample(self.workSound, 0, 1, 0);
						setVisibility(self.workSound, true);
					end
					local deltaLevel = self.literPerSecond*dt/1000.0;
					deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);
					trailer:setFillLevel(trailer.fillLevel + deltaLevel, self.currentFillType);
					self.fillLevel = self.fillLevel-deltaLevel;
					self:setFillLevel(self.fillLevel, self.currentFillType);
					self.turnOn = true;
					self.inRange = true; 
				end;
			end;
		end
		if not self.turnOn then
			setShaderParameter(self.Planen[Fillable.fillTypeIntToName[self.currentFillType]], "scollSpeed", 0,0,0,0,false);
			self.speed = 0;
		end
	end
		
	if not self.inRange and self.turnOn then 
		self.turnOn = false; 
		for fruitType,PS in pairs(self.chargeParticle) do
			Utils.setEmittingState(PS, false);
		end
		setShaderParameter(self.Belt, "scollSpeed", 0,0,0,0,false);
		setVisibility(self.workSound, false);
	end;
	
end;

function Conveyorunload:updateTick(dt)
end;

function Conveyorunload:draw()
end;

function Conveyorunload:onLeave()
end;

function Conveyorunload:findTrailer()

    local x,y,z = getWorldTranslation(self.chargefillNode);
	local ox,oy,oz = worldToLocal(self.chargefillNode, x,y-1,z);
    local dx,dy,dz = localDirectionToWorld(self.chargefillNode, ox,oy,oz);
	
	--local x2 = x + (dx * 7);
	--local y2 = y + (dy * 7);
	--local z2 = z + (dz * 7);
	--drawDebugLine(x, y, z, 1, 0, 0, x2, y2, z2, 1, 0, 0);
		
    self.trailerFound = 0;
    raycastAll(x, y, z, dx,dy,dz, "TrailerRaycast", 7, self);

    local trailer = g_currentMission.nodeToVehicle[self.trailerFound];
    if trailer == nil or trailer.setFillLevel == nil or not trailer.allowFillFromAir or trailer.fillLevel >= trailer.capacity then
        return nil;
    end;
    return trailer;
end;

function Conveyorunload:TrailerRaycast(transformId, x, y, z, distance)

    local vehicle = g_currentMission.nodeToVehicle[transformId];
    if vehicle ~= nil then
        if vehicle.exactFillRootNode == transformId then
            self.trailerFound = transformId;
            return false;
        end;
    end;

    return true;

end;