Scania = {};

function Scania.prerequisitesPresent(specializations)
    return true;
end;

function Scania:load(xmlFile)
        
	local SomCapo = getXMLString(xmlFile, "vehicle.SomCapo#file");
     if SomCapo ~= nil and SomCapo ~= "" then
	    SomCapo = Utils.getFilename(SomCapo, self.baseDirectory);
        self.SomCapo = createSample("SomCapo");
        loadSample(self.SomCapo, SomCapo, false);
end;
		self.objectInRange = Scania.objectInRange;
		self.SomCapoRunning = false;


end;

function Scania:update(dt)
		
			if self:objectInRange(self.animationParts[1].rootNode) then
			if InputBinding.hasEvent(InputBinding.sinaleiraL) then
				if self.animationParts[1].clipEndTime then
					self:setAnimationTime(1, self.animationParts[1].offSet);
					playSample(self.SomCapo, 1, 1, 0);
				elseif self.animationParts[1].clipStartTime then
					self:setAnimationTime(1, self.animationParts[1].animDuration);
				end;
			end;
			if self.animationParts[1].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("sinaleiraL_ON")), InputBinding.sinaleiraL);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("sinaleiraL_OFF")), InputBinding.sinaleiraL);				
			end;
		end;
		if self:objectInRange(self.animationParts[2].rootNode) then
			if InputBinding.hasEvent(InputBinding.sinaleiraR) then
				if self.animationParts[2].clipEndTime then
					self:setAnimationTime(2, self.animationParts[2].offSet);
					playSample(self.SomCapo, 1, 1, 0);
				elseif self.animationParts[2].clipStartTime then
					self:setAnimationTime(2, self.animationParts[2].animDuration);
				end;
			end;
			if self.animationParts[2].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("sinaleiraR_ON")), InputBinding.sinaleiraR);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("sinaleiraR_OFF")), InputBinding.sinaleiraR);				
			end;
		end;


end;

function Scania:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 3;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;
function Scania:delete()
end;

function Scania:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Scania:keyEvent(unicode, sym, modifier, isDown)
end;
function Scania:draw()
end;