--
-- Especializao para Case Magmun 340
-- Especializao retirada e editada do modelo JD7RSeries2
-- https://www.facebook.com/pages/Ls-Mods-Brasil/359436810854625 (Ls Mods Brasil)
--
-- @Authors of original scripts used: Manuel Leithner (SFM-Modding),Modelleicher (www.schwabenmodding.bplaced.net),Templaer, JoXXer, Knagsted, Mofa-Killer, Face, Heady, other do not remember!!
-- @author  Ago-Systemtech
--  https://www.facebook.com/ago.systemtech
------ free for non commercial-usage -------------

CaseMagmun = {};
function CaseMagmun.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function CaseMagmun:load(xmlFile)
    self.belts = {};
       	local i = 0;
       	while true do
        local key = string.format("vehicle.belts.belt(%d)", i);

        if not hasXMLProperty(xmlFile, key) then
           break;
        end;

        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.belts, {node=node, speed=speed});
        end;
	    i = i +1;
        end;
		
    self.fuelMeter = {};
	self.fuelMeter.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelMeter#index"));
	self.fuelMeter.fullRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.fuelMeter#fullRot"), 0));
	self.fuelMeter.modifier = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.fuelMeter#modifier"), 0);
	local fuelX, fuelY, fuelZ = getRotation(self.fuelMeter.index);
	self.fuelMeter.startRot = fuelY;
	self.fuelMeter.totalRot = (self.fuelMeter.fullRot - self.fuelMeter.startRot) * self.fuelMeter.modifier;
	if self.fuelMeter.modifier == 1 then
		self.fuelMeter.fuelPercentage = self.fuelCapacity/350;
	else
		self.fuelMeter.fuelPercentage = math.deg(self.fuelMeter.totalRot)/self.fuelCapacity;
	end;
	self.fuelMeter.hasMovedUp = false;
	
    self.handThrottle = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.handThrottle#index"));
	local ThrottleNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Throttle#index"));
    if ThrottleNode ~= nil then
        self.Throttle = {};
        self.Throttle.node = ThrottleNode;
		self.Throttle.maxSpeed = getXMLInt(xmlFile, "vehicle.Throttle#maxSpeed");
		local x1,y1,z1 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Throttle#minRot"));
		local x2,y2,z2 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Throttle#maxRot"));
		self.Throttle.rotMin = {math.rad(Utils.getNoNil(x1,0)),math.rad(Utils.getNoNil(y1,0)),math.rad(Utils.getNoNil(z1,0))};
		self.Throttle.rotMax = {math.rad(Utils.getNoNil(x2,0)),math.rad(Utils.getNoNil(y2,0)),math.rad(Utils.getNoNil(z2,0))};
    end;
   ---------------------CAM INTERNA MOBILE---------------------
	self.internalCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.internalCamera#index"));
	self.camPositionX = 0;
	self.camPositionZ = 0;
	self.camPositionY = 0;
	
	self.luzFreio = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.luzFreio#index"));
	self.ledbateria = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ledbateria#index"));
	self.chuvatrase = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chuvatrase#index"));
	self.chuvafrontal = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chuvafrontal#index"));
	self.gotas = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gotas#index"));
    self.respingo = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.respingo#index"));
    self.updateFuelIndicators = SpecializationUtil.callSpecializationsFunction("updateFuelIndicators");
    self.ledriserva = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ledriserva#index"));
	self.ledriservaActive = false;
	self.riserva = 60;
	
	-- Front wiper animation
	local wiperFrontAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperFront#rootNode"));
    self.wiperFrontAnimCharSet = 0;
    if wiperFrontAnimRootNode ~= nil and wiperFrontAnimRootNode ~= 0 then
        self.wiperFrontAnimCharSet = getAnimCharacterSet(wiperFrontAnimRootNode);
        if self.wiperFrontAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperFrontAnimCharSet, getXMLString(xmlFile, "vehicle.wiperFront#clip"));
            assignAnimTrackClip(self.wiperFrontAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperFrontAnimCharSet, 0, true);
            local wiperFrontAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperFront#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperFrontAnimCharSet, 0, wiperFrontAnimSpeedScale);
            self.wiperFrontAnimDuration = getAnimClipDuration(self.wiperFrontAnimCharSet, clip);
        end;
    end;

	self.isWiperFrontActive = false;
	self.finishWiperFront = true;
	
	-- Rear wiper animation
	local wiperBackAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperBack#rootNode"));
    self.wiperBackAnimCharSet = 0;
    if wiperBackAnimRootNode ~= nil and wiperBackAnimRootNode ~= 0 then
        self.wiperBackAnimCharSet = getAnimCharacterSet(wiperBackAnimRootNode);
        if self.wiperBackAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperBackAnimCharSet, getXMLString(xmlFile, "vehicle.wiperBack#clip"));
            assignAnimTrackClip(self.wiperBackAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperBackAnimCharSet, 0, true);
            local wiperBackAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperBack#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperBackAnimCharSet, 0, wiperBackAnimSpeedScale);
            self.wiperBackAnimDuration = getAnimClipDuration(self.wiperBackAnimCharSet, clip);
        end;
    end;
	self.isWiperBackActive = false;
	self.finishWiperBack = true;
	self.wiperFrontOn = false;
	self.wiperBackOn = false;
	--------------------------chuva----------------------
	local chuvaAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chuva#rootNode"));
	self.chuvaAnimCharSet = 0;
	if chuvaAnimRootNode ~= nil and chuvaAnimRootNode ~= 0 then
		self.chuvaAnimCharSet = getAnimCharacterSet(chuvaAnimRootNode);
		if self.chuvaAnimCharSet ~= 0 then
			local clip = getAnimClipIndex(self.chuvaAnimCharSet, getXMLString(xmlFile, "vehicle.chuva#clip"));
			assignAnimTrackClip(self.chuvaAnimCharSet, 0, clip);
			setAnimTrackLoopState(self.chuvaAnimCharSet, 0, true);
			local chuvaAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.chuva#speedScale"), 1);
			setAnimTrackSpeedScale(self.chuvaAnimCharSet, 0, chuvaAnimSpeedScale);
			self.chuvaAnimDuration = getAnimClipDuration(self.chuvaAnimCharSet, clip);
		end;
	end;
	self.ischuvaActive = false;
	self.finishchuva = true;
   ----------------- GASOLIO INDICATORI----------
	self.fuelIndicatorsGroup = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelIndicators#index"));
	self.numFuelIndicators = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fuelIndicators#count"), 0);
	self.fuelIndicators = {};
    for i=1, self.numFuelIndicators do
        local objname = string.format("vehicle.fuelIndicators.fuelIndicator" .. "%d", i);
		self.fuelIndicators[i] = {};
        self.fuelIndicators[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.fuelIndicators[i].rotNode,true);
    end;
	
	self.belts = {};
       	local i = 0;
       	while true do
        local key = string.format("vehicle.belts.belt(%d)", i);

        if not hasXMLProperty(xmlFile, key) then
           break;
        end;

        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.belts, {node=node, speed=speed});
        end;
	    i = i +1;
        end;
	-----------------SOUND RISERVA------------------
    fuelwarningSoundFile = Utils.getFilename("fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	self.playedSound = false;
end;
function CaseMagmun:delete()
end;

function CaseMagmun:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CaseMagmun:keyEvent(unicode, sym, modifier, isDown)
end;

function CaseMagmun:readStream(streamId, connection)

end;

function CaseMagmun:writeStream(streamId, connection)
end;

function CaseMagmun:update(dt)
    ---pasy---
				   
	if self.isMotorStarted then
		for _, part in pairs(self.belts) do
          	setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], 0, 0, 0, false);
    end;      	
	elseif not self.isMotorStarted then
		for _, part in pairs(self.belts) do
          	setShaderParameter(part.node, "uvScrollSpeed", 0, 0.07, 0, 0, false);
	end;
	end;
    if self.ignitionKey then
    if self.fuelMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.fuelMeter.index);
				if self.fuelMeter.modifier == 1 then
					local fuelDifference = self.fuelCapacity - self.fuelFillLevel;
					local fuelMeterRot = math.rad(fuelDifference/100)*self.fuelMeter.fuelPercentage*10;
					if rotY < -fuelMeterRot and self.fuelMeter.hasMovedUp ~= true then
						setRotation(self.fuelMeter.index, 0, rotY + dt * 0.001 , 0);
					else
						self.fuelMeter.hasMovedUp = true;
						setRotation(self.fuelMeter.index, 0, -fuelMeterRot , 0);
					end;
				elseif self.fuelMeter.modifier == -1 then
					local fuelMeterRot = math.rad(self.fuelFillLevel*self.fuelMeter.fuelPercentage);
					if rotY > -fuelMeterRot and self.fuelMeter.hasMovedUp ~= true then
						setRotation(self.fuelMeter.index, 0, rotY - dt * 0.001 , 0);
					else
						self.fuelMeter.hasMovedUp = true;
						setRotation(self.fuelMeter.index, 0, -fuelMeterRot , 0);
					end;
				end;
			end;
			if self.fuelMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.fuelMeter.index);
				if self.fuelMeter.modifier == 1 then
					local fuelDifference = self.fuelCapacity - self.fuelFillLevel;
					local fuelMeterRot = math.rad(fuelDifference/100)*self.fuelMeter.fuelPercentage*10;
					if rotY < -fuelMeterRot and self.fuelMeter.hasMovedUp ~= true then
						setRotation(self.fuelMeter.index, 0, rotY + dt * 0.001 , 0);
					else
						self.fuelMeter.hasMovedUp = true;
						setRotation(self.fuelMeter.index, 0, -fuelMeterRot , 0);
					end;
				elseif self.fuelMeter.modifier == -1 then
					local fuelMeterRot = math.rad(self.fuelFillLevel*self.fuelMeter.fuelPercentage);
					if rotY > -fuelMeterRot and self.fuelMeter.hasMovedUp ~= true then
						setRotation(self.fuelMeter.index, 0, rotY - dt * 0.001 , 0);
					else
						self.fuelMeter.hasMovedUp = true;
						setRotation(self.fuelMeter.index, 0, -fuelMeterRot , 0);
					end;
				end;
			end;
			end;
     
    ---------------------CAM INTERNA MOBILE---------------------
     if self.camIndex == 1 then
	 if self:getIsActive() then
		if InputBinding.isPressed(InputBinding.MovimentoEsquerda) then
			self.camPositionX = self.camPositionX + 0.03;
			if self.camPositionX >= 0.3 then
				self.camPositionX = 0.3;
			end;
		end;
		if InputBinding.isPressed(InputBinding.MovimentoDireita) then
			self.camPositionX = self.camPositionX - 0.03;
			if self.camPositionX <= -0.3 then
				self.camPositionX = -0.3;
			end;
		end;
		if InputBinding.isPressed(InputBinding.MoverparaFrente) then
			self.camPositionZ = self.camPositionZ + 0.03;
			if self.camPositionZ >= 0.3 then
				self.camPositionZ = 0.3;
			end;
		end;
				if InputBinding.isPressed(InputBinding.MoverParaTras) then
			self.camPositionZ = self.camPositionZ - 0.03;
			if self.camPositionZ <= -0.22 then
				self.camPositionZ = -0.22;
			end;
		end;
		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
			self.camPositionY = self.camPositionY + 0.02;
			if self.camPositionY >= 0.15 then
				self.camPositionY = 0.15;
			end;
		end;
		if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
			self.camPositionY = self.camPositionY - 0.02;
			if self.camPositionY <= -0.2 then
				self.camPositionY = -0.2;
			end;
		end;
		if Input.isKeyPressed(Input.KEY_z) then
			self.camPositionX = 0;
			self.camPositionZ = 0;
			self.camPositionY = 0;
		end;
		if self.internalCamera ~= nil then
			setTranslation(self.internalCamera, self.camPositionX, self.camPositionZ, self.camPositionY);
		end;
   	end;
	end;
	self.belts = {};
       	local i = 0;
       	while true do
        local key = string.format("vehicle.belts.belt(%d)", i);

        if not hasXMLProperty(xmlFile, key) then
           break;
        end;

        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.belts, {node=node, speed=speed});
        end;
	    i = i +1;
        end;
   
   ------------------LED RISERVA----------------------
	if self.isMotorStarted then
		if self.fuelFillLevel < 60 then
			self.riserva = self.riserva - dt;
			if self.playedSound == false then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.playedSound = true;
			end;
			self.ledriservaActive = true;
		else
			self.playedSound = false;
			self.ledriservaActive = false;
		end;
		setVisibility(self.ledriserva,self.ledriservaActive);
		self:updateFuelIndicators();
	end;
end;
function CaseMagmun:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    return BaseMission.VEHICLE_LOAD_OK;
end;
function CaseMagmun:updateTick(dt)
    -- Stop wipers in correct position
	if not self.finishWiperFront then
		if getAnimTrackTime(self.wiperFrontAnimCharSet, 0) % self.wiperFrontAnimDuration <= 100 then
			setAnimTrackTime(self.wiperFrontAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperFrontAnimCharSet, 0);
			self.finishWiperFront = true;
		end;
	end;
	-- Start front wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperFrontOn then
		if not self.isWiperFrontActive then
			enableAnimTrack(self.wiperFrontAnimCharSet, 0);
			enableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.isWiperFrontActive = true;
			self.isWiperBackActive = true;
		end;
		setRotation(self.wiperLever, 0, math.rad(-18), 0);
	else
		if self.isWiperFrontActive then
			self.isWiperFrontActive = false;
			self.finishWiperFront = false;
		end;
		setRotation(self.wiperLever, 0, 0, 0);
	end;
	if not self.finishWiperBack then
		if getAnimTrackTime(self.wiperBackAnimCharSet, 0) % self.wiperBackAnimDuration <= 100 then
			setAnimTrackTime(self.wiperBackAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.finishWiperBack = true;
		end;
	end;
	-- Start rear wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperBackOn then
		if not self.isWiperBackActive then
			enableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.isWiperBackActive = true;
		end;
	else
		if self.isWiperBackActive then
			self.isWiperBackActive = false;
			self.finishWiperBack = false;
		end;
	end;
    if self.isMotorStarted then
			setVisibility(self.ledbateria, false);
			setVisibility(self.luzFreio, false);
		else
			setVisibility(self.ledbateria, true);
			setVisibility(self.luzFreio, true);
		end;
	if self.ignitionMode == 0 and self.ignitionMode ~= nil then
			setVisibility(self.ledbateria, false)
			setVisibility(self.luzFreio, false);
		end;
    if self.handThrottle ~= nil then
		setRotation(self.handThrottle,  Utils.degToRad(self.handThrottlePercentage * -64),0,0);
	end;
	
	if self.Throttle ~= nil then
				local percent = (self.lastSpeed*self.speedDisplayScale*3600) / self.Throttle.maxSpeed;
				local minRot = self.Throttle.rotMin;
				local maxRot = self.Throttle.rotMax;
				local x = minRot[1] + (maxRot[1] - minRot[1]) * percent;
				local y = minRot[2] + (maxRot[2] - minRot[2]) * percent;
				local z = minRot[3] + (maxRot[3] - minRot[3]) * percent;
				setRotation(self.Throttle.node, x, y, z);
	end;
  ----------- WIPERS -----------------
		if not self.finishchuva then
			if getAnimTrackTime(self.chuvaAnimCharSet, 0) % self.chuvaAnimDuration <= 100 then
				setAnimTrackTime(self.chuvaAnimCharSet, 0, 0.0);
				disableAnimTrack(self.chuvaAnimCharSet, 0);
				self.finishchuva = true;
			end;
		end;
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.ischuvaActive then
				enableAnimTrack(self.chuvaAnimCharSet, 0);
				self.ischuvaActive = true;
			end;
		else
			if self.ischuvaActive then
				self.ischuvaActive = false;
				self.finishchuva = false;
			end;
		end;
  if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
   setVisibility(self.respingo, true);
   setVisibility(self.chuvafrontal, true);
   setVisibility(self.gotas, true);
   setVisibility(self.chuvatrase, true);
  else
  setVisibility(self.respingo, false);
  setVisibility(self.chuvafrontal, false);
  setVisibility(self.gotas, false);
  setVisibility(self.chuvatrase, false);
  
end;
   if self:getIsActive() then
		if self.isMotorStarted then
			setVisibility(self.fuelIndicatorsGroup, true);
		else
			setVisibility(self.fuelIndicatorsGroup, false);
		end;
	end;
end;
function CaseMagmun:updateFuelIndicators()
	local amountOfFuelPerIndicator = self.fuelCapacity/25;
	local timesToIterate = self.fuelFillLevel/amountOfFuelPerIndicator;
	timesToIterate = math.floor(timesToIterate);
	if self.oldTimesToIterate ~= timesToIterate then
		for i=1, self.numFuelIndicators do
			setVisibility(self.fuelIndicators[i].rotNode, false);
		end;
		for i=1, timesToIterate do
			setVisibility(self.fuelIndicators[i].rotNode, true);
		end;
	end;
	self.oldTimesToIterate = timesToIterate;
end;
function CaseMagmun:draw()
end;
function CaseMagmun:onAttach()
end;

function CaseMagmun:onDetach()
end;			

function CaseMagmun:onDeactivate()
end;
function CaseMagmun:onEnter()
   if self.isWiperFrontActive then
		enableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	if self.isWiperBackActive then
		enableAnimTrack(self.wiperBackAnimCharSet, 0);
	end;
   if self.isMotorStarted then
			setVisibility(self.ledbateria, false);
			setVisibility(self.luzFreio, false);
		else
			setVisibility(self.ledbateria, true);
			setVisibility(self.luzFreio, true);
		end
	if self.ischuvaActive then
		enableAnimTrack(self.chuvaAnimCharSet, 0);
	end;
   if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			setVisibility(self.respingo, true);
			setVisibility(self.chuvafrontal, true);
			setVisibility(self.gotas, true);
			setVisibility(self.chuvatrase, true);
		else
            setVisibility(self.respingo, false);
			setVisibility(self.chuvafrontal, false);
			setVisibility(self.gotas, false);
			setVisibility(self.chuvatrase, false);
		end;
	end;
function CaseMagmun:onLeave()
    if self.radioSound ~= nil then
        stopSample(self.radioSound);
    end;
    if self.isWiperFrontActive then
		disableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	if self.isWiperBackActive then
		disableAnimTrack(self.wiperBackAnimCharSet, 0);
	end;
    if self.isMotorStarted then
			setVisibility(self.ledbateria, false);
			setVisibility(self.luzFreio, false);
		else
			setVisibility(self.ledbateria, true);
			setVisibility(self.luzFreio, true);
	     end
	if self.ischuvaActive then
		disableAnimTrack(self.chuvaAnimCharSet, 0);
	end;
   if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
	   setVisibility(self.respingo, true);
	   setVisibility(self.chuvafrontal, true);
	   setVisibility(self.gotas, true);
	   setVisibility(self.chuvatrase, true);
    else
       setVisibility(self.respingo, false);
	   setVisibility(self.chuvafrontal, false);
	   setVisibility(self.gotas, false);
	   setVisibility(self.chuvatrase, false);
	end;
end;

function CaseMagmun:deactivate()

end;

function CaseMagmun:onActivate()
end;

function CaseMagmun:activate()
end;
function CaseMagmun:setState(object,state,noEventSend)
end;
