--
-- Copyright � 2013 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- BJR_MovingPartsInterior
-- Specialization for BJR_MovingPartsInterior 
--
-- @author  	JoXXer
-- @date  		27/03/13
--
-- @history	v1.0 - Initial implementation
--			v1.0.5 - 07/06/13 - All dependencies for ManualIgnition-specialization removed
--			v1.2 - 02/08/13 - General overhaul, fixed various bugs and implementation-issues. SpeedoMeter support added
--			v1.2.1 - 06/08/13 - RPMIndicator tweaked, now more configurable from the XML
--
-- <clutchPedal index="INDEX" minRot="0" maxRot="-30" movementSpeed="5"/>
-- <brakePedalLeft index="INDEX" minRot="0" maxRot="-30" movementSpeed="5"/>
-- <brakePedalRight index="INDEX" minRot="0" maxRot="-30" movementSpeed="5"/>
-- <footThrottle index="INDEX"/>
-- <RPMIndicator index=INDEX" startRot="0" idleRot="-33.5" maxRot="-170"/>
-- <speedoMeter index="INDEX" startRot="0" maxRot="-275" middleRot="-187" firstRot="-110" maxSpeed="60" middleSpeed="20" firstSpeed="10"/>
-- <fuelMeter index="INDEX" fullRot="-160" modifier="-1"/>
-- <tempMeter index="INDEX" maxRot="100" normalTemp="85" heatingUpModifier="10" modifier="-1"/>
-- <shuttleLever index="INDEX" forwardRot="-25" reverseRot="25" neutralRot="0" />
-- <gearLever index="INDEX" speed3Rot="9.16875 -0.23522 3.42534" speed2Rot="0 0 0" speed1Rot="-11.77372 -0.4457 -2.13733" />

BJR_MovingPartsInterior = {};

function BJR_MovingPartsInterior.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BJR_MovingPartsInterior:load(xmlFile)
	
	self.tempMeter = {};
	self.tempMeter.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tempMeter#index"));
	local tempX, tempY, tempZ = getRotation(self.tempMeter.index);
	self.tempMeter.startRot = tempY;
	self.tempMeter.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.tempMeter#maxRot"), 0));
	self.tempMeter.modifier = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.tempMeter#modifier"), 0);
	self.tempMeter.normalTemp = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.tempMeter#normalTemp"), 0);
	self.tempMeter.tempPercentage = math.deg(self.tempMeter.maxRot)/self.tempMeter.normalTemp;
	self.tempMeter.heatingUpModifier = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.tempMeter#heatingUpModifier"), 0)/1000000;
	self.tempMeter.hasMovedUp = false;
	self.tempMeter.motorTemp = 0;
end;

function BJR_MovingPartsInterior:delete()

end;

function BJR_MovingPartsInterior:readStream(streamId, connection)
end;

function BJR_MovingPartsInterior:writeStream(streamId, connection)
end;

function BJR_MovingPartsInterior:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_MovingPartsInterior:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_MovingPartsInterior:update(dt)

	if self.ignitionMode == nil or self.ignitionMode == 2 then
		if self.tempMeter.motorTemp < self.tempMeter.normalTemp then
			if self.motor.lastMotorRpm  == self.motor.minRpm then 
				self.tempMeter.motorTemp = self.tempMeter.motorTemp + (self.tempMeter.heatingUpModifier * 1000);
			else
				self.tempMeter.motorTemp = self.tempMeter.motorTemp + (self.motor.lastMotorRpm * self.tempMeter.heatingUpModifier);
			end;
		end;
	else
		if self.tempMeter.motorTemp > 0 then
			self.tempMeter.motorTemp = self.tempMeter.motorTemp - (self.tempMeter.heatingUpModifier * 1000);
		end;
	end;
		
		if self.ignitionMode == nil or self.ignitionMode >= 1 then
	
			if self.tempMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.tempMeter.index);
				if self.tempMeter.modifier == 1 then
					local tempMeterRot = math.rad(self.tempMeter.motorTemp/1.4);
					tempMeterRot = self.tempMeter.startRot - tempMeterRot;
					
					if rotY > tempMeterRot and self.tempMeter.hasMovedUp ~= true then
						setRotation(self.tempMeter.index, 0, rotY - dt * 0.001 , 0);
					else
						self.tempMeter.hasMovedUp = true;
						setRotation(self.tempMeter.index, 0, tempMeterRot , 0);
					end;
				else
					local tempMeterRot = math.rad(self.tempMeter.motorTemp * self.tempMeter.tempPercentage);
					if rotY < tempMeterRot and self.tempMeter.hasMovedUp ~= true then
						setRotation(self.tempMeter.index, 0, rotY + dt * 0.001 , 0);
					else
						self.tempMeter.hasMovedUp = true;
						setRotation(self.tempMeter.index, 0, tempMeterRot , 0);
					end;
				end;
			end;
	
			if self.tempMeter.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.tempMeter.index);
				if self.tempMeter.modifier == 1 then
					if rotY < self.tempMeter.startRot and self.tempMeter.hasMovedUp == true then
						setRotation(self.tempMeter.index, 0, rotY + dt * 0.001 , 0);
					else
						self.tempMeter.hasMovedUp = false;
					end;
				else
					if rotY > self.tempMeter.startRot and self.tempMeter.hasMovedUp == true then
						setRotation(self.tempMeter.index, 0, rotY - dt * 0.001 , 0);
					else
						self.tempMeter.hasMovedUp = false;
					end;
				end;
			end;
	
		end;
	end;

function BJR_MovingPartsInterior:updateTick(dt)

end;

function BJR_MovingPartsInterior:draw()

end;