--
-- WashableCW
-- Specialization for WashableCW functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - Changed xml-reading, added updateInterval to define updating interval for vehicles with many dirtComponents (performance issue)
--				v3.0 - added network support, changed update to updateTick
-----fix for Buyable CareWheels 
---- Ago-Systemtech @ TIF-http://forum.tractor-italia.net
---@ 02/02/2012
--------
WashableCW = {};

function WashableCW.prerequisitesPresent(specializations)
    return true;
end;

function WashableCW:load(xmlFile)

	self.increaseDirt = SpecializationUtil.callSpecializationsFunction("increaseDirt");
	self.decreaseDirt = SpecializationUtil.callSpecializationsFunction("decreaseDirt");
	self.unusualDirtIncrease = SpecializationUtil.callSpecializationsFunction("unusualDirtIncrease");
	
	local i = 0;
	self.dirtComponents = {};
	while true do
		local path = string.format("vehicle.dirt.dirtComponent(%d)", i);
		local component = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#index"));	
		if component == nil then
			break;
		end;
		table.insert(self.dirtComponents, component);
		i = i + 1;
	end;	
	
	self.dirtUpdateInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dirt#updateInterval"), 0.05);
	self.dirtInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dirt#dirtInterval"), 1) * 60 * 60 * 1000;
	self.cleaningInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dirt#cleaningInterval"), 30) * 1000;

	self.dirtScale = 0;
	self.oldDirtScale = self.dirtScale;
	self.timeScale = 1;

end;

function WashableCW:readStream(streamId, connection)
    local dirtScale = streamReadFloat32(streamId);
    self:unusualDirtIncrease(dirtScale);
end;

function WashableCW:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.dirtScale);
end;

function WashableCW:delete()
end;

function WashableCW:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WashableCW:keyEvent(unicode, sym, modifier, isDown)
end;

function WashableCW:update(dt)
end;

function WashableCW:updateTick(dt)
	if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
      self:increaseDirt(2*dt);
   else
      if self.twinWheelsUser ~= nil then
	        if self.twinWheelsUser.isActive then
				self:increaseDirt(dt);
			end;
	  end;
			
		
   end;	
	
	if math.abs(self.dirtScale-self.oldDirtScale) > self.dirtUpdateInterval then
		for i=1, table.getn(self.dirtComponents) do
			setShaderParameter(self.dirtComponents[i], "dirtScale", self.dirtScale, 0,0,0,false);
		end;
		self.oldDirtScale = self.dirtScale;
	end;
end;

function WashableCW:draw()
end;


function WashableCW:unusualDirtIncrease(increase)
	if self.dirtScale < 1 then
		self.dirtScale = self.dirtScale + increase;
		if self.dirtScale > 1 then
			self.dirtScale = 1;
		end;
	end;
end;

function WashableCW:increaseDirt(dt)
	if self.dirtScale > 1 then
		self.dirtScale = 1;
	end;
	if self.dirtScale < 1 then
		local scale = Utils.getMovedLimitedValues({self.dirtScale}, {1}, {0}, 1, self.dirtInterval*self.timeScale, dt, false);
		self.dirtScale = scale[1];
	end;
end;

function WashableCW:decreaseDirt(dt)
	if self.dirtScale < 0 then
		self.dirtScale = 0;
	end;
	if self.dirtScale > 0 then
		local scale = Utils.getMovedLimitedValues({self.dirtScale}, {1}, {0}, 1, self.cleaningInterval*self.timeScale, dt, true);
		self.dirtScale = scale[1];
	end;
end;

function WashableCW:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.dirtScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#dirtLevel"),0);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function WashableCW:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'dirtLevel="'.. tostring(self.dirtScale) .. '"';
    return attributes, nil;
end;