--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.82, 0.29, 0.015, "Taste Numpad 0: Info");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.82, 0.29, 0.015, "Taste Numpad 0: Info ");
		renderText(0.77, 0.86, 0.02, "- ZETOR 7745 -");			
		renderText(0.70, 0.81, 0.02, "Wcisnij Num Enter: Odpalanie silnika");
		renderText(0.70, 0.79, 0.02, "Wcisnij 7: konsola do tura");			
		renderText(0.70, 0.77, 0.02, "Wcisnij Num 7: Drzwi lewe");
		renderText(0.70, 0.75, 0.02, "Wcisnij Num 8: Szyba tyl");
		renderText(0.70, 0.73, 0.02, "Wcisnij Num 9: Drzwi prawe");
		renderText(0.70, 0.71, 0.02, "Wcisnij Num 4: Szyberdach");
		renderText(0.70, 0.69, 0.02, "Wcisnij 9: Zaloz obciaznik");
		renderText(0.70, 0.67, 0.02, "Wcisnij Num 5: Halogeny przod");
		renderText(0.70, 0.65, 0.02, "Wcisnij Num 6: Halogeny tyl");
		renderText(0.70, 0.63, 0.02, "Wcisnij Num 1: Lewy kierunkowsakz");
		renderText(0.70, 0.61, 0.02, "Wcisnij Num 2: Swiatla awaryjne");
		renderText(0.70, 0.59, 0.02, "Wcisnij Num 3: Prawy kierunkowskaz");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




