 
-- Copyright by Ufolec
-- www.landwirtschafts-simulator.pl
-- Wszelkie prawa zastrzeone

Vehicle.registerJointType("attachableFrontloader");

Z8602 = {};

function Z8602.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Z8602:load(xmlFile)
	self.controlpathgearhud1 = Utils.getFilename("hud/gearhud1.png", self.baseDirectory);

self.hudGeargearhud1Width = 0.205;
    self.hudGeargearhud1Height = 0.255;
    self.hudGeargearhud1PoxX = 0.796;
    self.hudGeargearhud1PoxY = 0.666;
    self.hudGeargearhud1Overlay = Overlay:new("hudGeargearhud1", self.controlpathgearhud1, self.hudGeargearhud1PoxX, self.hudGeargearhud1PoxY, self.hudGeargearhud1Width, self.hudGeargearhud1Height);

self.controlpath4p = Utils.getFilename("hud/4p.png", self.baseDirectory);

self.hudGear4pWidth = 0.205;
    self.hudGear4pHeight = 0.255;
    self.hudGear4pPoxX = 0.796;
    self.hudGear4pPoxY = 0.666;
    self.hudGear4pOverlay = Overlay:new("hudGear4p", self.controlpath4p, self.hudGear4pPoxX, self.hudGear4pPoxY, self.hudGear4pWidth, self.hudGear4pHeight);

self.controlpath3p = Utils.getFilename("hud/3p.png", self.baseDirectory);

self.hudGear3pWidth = 0.205;
    self.hudGear3pHeight = 0.255;
    self.hudGear3pPoxX = 0.796;
    self.hudGear3pPoxY = 0.666;
    self.hudGear3pOverlay = Overlay:new("hudGear3p", self.controlpath3p, self.hudGear3pPoxX, self.hudGear3pPoxY, self.hudGear3pWidth, self.hudGear3pHeight);

self.controlpath2p = Utils.getFilename("hud/2p.png", self.baseDirectory);

self.hudGear2pWidth = 0.205;
    self.hudGear2pHeight = 0.255;
    self.hudGear2pPoxX = 0.796;
    self.hudGear2pPoxY = 0.666;
    self.hudGear2pOverlay = Overlay:new("hudGear2p", self.controlpath2p, self.hudGear2pPoxX, self.hudGear2pPoxY, self.hudGear2pWidth, self.hudGear2pHeight);

self.controlpath1p = Utils.getFilename("hud/1p.png", self.baseDirectory);

self.hudGear1pWidth = 0.205;
    self.hudGear1pHeight = 0.255;
    self.hudGear1pPoxX = 0.796;
    self.hudGear1pPoxY = 0.666;
    self.hudGear1pOverlay = Overlay:new("hudGear1p", self.controlpath1p, self.hudGear1pPoxX, self.hudGear1pPoxY, self.hudGear1pWidth, self.hudGear1pHeight);

self.controlpathI = Utils.getFilename("hud/I.png", self.baseDirectory);

self.hudGearIWidth = 0.205;
    self.hudGearIHeight = 0.255;
    self.hudGearIPoxX = 0.796;
    self.hudGearIPoxY = 0.666;
    self.hudGearIOverlay = Overlay:new("hudGearI", self.controlpathI, self.hudGearIPoxX, self.hudGearIPoxY, self.hudGearIWidth, self.hudGearIHeight);

self.controlpathII = Utils.getFilename("hud/II.png", self.baseDirectory);

self.hudGearIIWidth = 0.205;
    self.hudGearIIHeight = 0.255;
    self.hudGearIIPoxX = 0.796;
    self.hudGearIIPoxY = 0.666;
    self.hudGearIIOverlay = Overlay:new("hudGearII", self.controlpathII, self.hudGearIIPoxX, self.hudGearIIPoxY, self.hudGearIIWidth, self.hudGearIIHeight);

self.controlpathR = Utils.getFilename("hud/R.png", self.baseDirectory);

self.hudGearRWidth = 0.205;
    self.hudGearRHeight = 0.255;
    self.hudGearRPoxX = 0.796;
    self.hudGearRPoxY = 0.666;
    self.hudGearROverlay = Overlay:new("hudGearR", self.controlpathR, self.hudGearRPoxX, self.hudGearRPoxY, self.hudGearRWidth, self.hudGearRHeight);
	
self.controlpathN = Utils.getFilename("hud/N.png", self.baseDirectory);	
	
self.hudGearNWidth = 0.205;
    self.hudGearNHeight = 0.255;
    self.hudGearNPoxX = 0.796;
    self.hudGearNPoxY = 0.666;
    self.hudGearNOverlay = Overlay:new("hudGearN", self.controlpathN, self.hudGearNPoxX, self.hudGearNPoxY, self.hudGearNWidth, self.hudGearNHeight);
	
    self.gearShifter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearShifter#index"));
    self.gearShifter2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearShifter2#index"));
  
end;

function Z8602:delete()
    
end;


function Z8602:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z8602:keyEvent(unicode, sym, modifier, isDown)
  
end;

function Z8602:update(dt)	

	if self.isEntered then
			if InputBinding.hasEvent (InputBinding.hudgear) then
				self.hudgearactivate = not self.hudgearactivate;
			end;
	end;	

	local speed = self.lastSpeed*3600;
     if self.gearShifter2 ~= nil then
          if self.movingDirection < -0.5 then
               setRotation(self.gearShifter2, Utils.degToRad(-12), Utils.degToRad(0), Utils.degToRad(-7));
				self.bcActiveR = true;
				self.bcActiveI = false;
				self.bcActiveII = false;
				self.bcActiveN = false;
          else     
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActiveR = false;
				self.bcActiveI = false;
				self.bcActiveII = false;
				self.bcActiveN = true;
		  elseif speed >= 0.5 and speed < 8 then
               setRotation(self.gearShifter2, Utils.degToRad(12), Utils.degToRad(0), Utils.degToRad(-17));
				self.bcActiveR = false;
				self.bcActiveI = true;
				self.bcActiveII = false;
				self.bcActiveN = false
          elseif speed >= 8 then
               setRotation(self.gearShifter2, Utils.degToRad(12), Utils.degToRad(0), Utils.degToRad(7));
				self.bcActiveR = false;
				self.bcActiveI = false;
				self.bcActiveII = true;
				self.bcActiveN = false
          end;
     end;
  end;

     if self.gearShifter ~= nil then
          if speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(7), Utils.degToRad(0), Utils.degToRad(-7));
          else     
--0--
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(7), Utils.degToRad(0), Utils.degToRad(-7));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
--1---
          elseif speed >= 0.5 and speed <2 then
               setRotation(self.gearShifter, Utils.degToRad(7), Utils.degToRad(0), Utils.degToRad(-7));
				self.bcActive1p = true;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
		 elseif speed >= 8 and speed <9 then
               setRotation(self.gearShifter, Utils.degToRad(7), Utils.degToRad(0), Utils.degToRad(-7));
				self.bcActive1p = true;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
--2---
          elseif speed >= 2 and speed < 4 then
               setRotation(self.gearShifter, Utils.degToRad(-7), Utils.degToRad(0), Utils.degToRad(-7));
				self.bcActive1p = false;
				self.bcActive2p = true;
				self.bcActive3p = false;
				self.bcActive4p = false;
			elseif speed >= 9 and speed < 11 then
               setRotation(self.gearShifter, Utils.degToRad(-7), Utils.degToRad(0), Utils.degToRad(-7));
				self.bcActive1p = false;
				self.bcActive2p = true;
				self.bcActive3p = false;
				self.bcActive4p = false;
--3---	

          elseif speed >= 4 and speed < 6 then
               setRotation(self.gearShifter, Utils.degToRad(7), Utils.degToRad(0), Utils.degToRad(7));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = true;
				self.bcActive4p = false;
			elseif speed >= 11 and speed < 20 then
               setRotation(self.gearShifter, Utils.degToRad(7), Utils.degToRad(0), Utils.degToRad(7));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = true;
				self.bcActive4p = false;
--4---
          elseif speed >= 6 and speed < 8 then
               setRotation(self.gearShifter, Utils.degToRad(-7), Utils.degToRad(0), Utils.degToRad(7));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = true;
			elseif speed >= 20 then
               setRotation(self.gearShifter, Utils.degToRad(-7), Utils.degToRad(0), Utils.degToRad(7));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = true;
--Back---
          elseif speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
			   self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
-- -1---
          elseif speed <= -0.5 and speed > -3 then
               setRotation(self.gearShifter, Utils.degToRad(7), Utils.degToRad(0), Utils.degToRad(-7));
			   self.bcActive1p = true;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
-- -2---
          elseif speed <= -3 and speed > -5 then
               setRotation(self.gearShifter, Utils.degToRad(-7), Utils.degToRad(0), Utils.degToRad(-7));
			   self.bcActive1p = false;
				self.bcActive2p = true;
				self.bcActive3p = false;
				self.bcActive4p = false;
-- -3---
          elseif speed <= -5 and speed > -10 then
               setRotation(self.gearShifter, Utils.degToRad(7), Utils.degToRad(0), Utils.degToRad(7));
			   self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = true;
				self.bcActive4p = false;
-- -4---
          elseif speed <= -10 and speed > -15 then
               setRotation(self.gearShifter, Utils.degToRad(-7), Utils.degToRad(0), Utils.degToRad(7));
			   self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = true;
          end;
     end;
  end;	
	
	
	end;		
function Z8602:updateTick(dt)
	
end;	
function Z8602:onEnter()
end;
function Z8602:draw()
   if self.hudrenaultOverlay ~= nil then
       if self.bcActive then
        self.hudrenaultOverlay:render();
       end;  
   end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Przycisk NUM 0: Wylacz ekran pomocy");
		else
			g_currentMission:addExtraPrintText("Przycisk NUM 0: Wlacz ekran pomocy");
		end;
	if self.hudgearactivate then
if self.isEntered then
 	 if self.hudGeargearhud1Overlay ~= nil then
    self.hudGeargearhud1Overlay:render();
end;
end;

if self.isEntered then
 	 if self.hudGear4pOverlay ~= nil then
  if self.bcActive4p then
    self.hudGear4pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear3pOverlay ~= nil then
  if self.bcActive3p then
    self.hudGear3pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear2pOverlay ~= nil then
  if self.bcActive2p then
    self.hudGear2pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear1pOverlay ~= nil then
  if self.bcActive1p then
    self.hudGear1pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGearIOverlay ~= nil then
  if self.bcActiveI then
    self.hudGearIOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGearIIOverlay ~= nil then
  if self.bcActiveII then
    self.hudGearIIOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGearROverlay ~= nil then
  if self.bcActiveR then
    self.hudGearROverlay:render();
  end;
end;
end;
if self.isEntered then
 	 if self.hudGearNOverlay ~= nil then
  if self.bcActiveN then
    self.hudGearNOverlay:render();
  end;
end;
end;
end;	
end;	
function Z8602:onLeave()
end;