-- by modelleicher
-- www.schwabenmodding.bplaced.net

TractorAnimations = {};

function TractorAnimations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function TractorAnimations:load(xmlFile)
	-- Zapfwellenstummel / Powershaft rotation
	self.stummelIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations#zapfwellenStummelIndex"));
	
	-- Tachozeiger / Speedometer animation
	self.tachoZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.TachoZeiger#zeigerIndex"));
	self.tachoZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.TachoZeiger#multiplicator"), 10);
	self.tachoZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.TachoZeiger#maxRotation"), 245);
	
	-- Tankzeiger / fuel level display
	self.tankZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.TankZeiger#zeigerIndex"));
	self.tankZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.TankZeiger#maxRotation"), 60);
	
	-- Temperaturzeiger / temperature Display animation
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.TemperaturZeiger#maxRotation"));
	self.tempCnt = 0;

	-- Temperaturzeiger2 / temperature Display animation
	self.temperaturZeiger2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.TemperaturZeiger2#zeigerIndex"));
	self.temperaturZeigerMaxRot2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.TractorAnimations.TemperaturZeiger2#maxRotation"));
	self.tempCnt2 = 0;
	
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	self.blinkerLeuchte1L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.BlinkerLeuchten#leuchte1L"));
	self.blinkerLeuchte1R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.BlinkerLeuchten#leuchte1R"));
	self.blinkerLeuchte2L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.BlinkerLeuchten#leuchte2L"));
	self.blinkerLeuchte2R = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.BlinkerLeuchten#leuchte2R"));
	self.hasAttachedTrailers = 0;
	setVisibility(self.blinkerLeuchte1L, false);
	setVisibility(self.blinkerLeuchte2L, false);
	setVisibility(self.blinkerLeuchte1R, false);
	setVisibility(self.blinkerLeuchte2R, false);
	
	
	-- Ladekontrollleuchte / Batterie load light
	self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.LadeKontrollLeuchte#index"));
	setVisibility(self.ladeLeuchte, false);
	self.ladeLeuchteOn = 0;
	self.ladeTimer = 50;

	-- Hydraulic Handle
	self.PitchArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.PitchArm#Index"));
	self.PitchArmRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TractorAnimations.PitchArm#refNode"));

end;
function TractorAnimations:delete()
end;
function TractorAnimations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function TractorAnimations:keyEvent(unicode, sym, modifier, isDown)
end;

function TractorAnimations:updateTick(dt)
	-- Zustzliche Blinkleuchten in den Armaturen bei angehngten Anhngern / additional lights for turninglights at the dashboard if trailers attached
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.lastFillDelta ~= nil then -- "catch" all trailers 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			elseif self.attachedImplements[i].object.isSprayerFilling ~= nil and self.attachedImplements[i].object.wheels[1] ~= nil then -- "catch" manure and dung spreader with wheels --> "trailers", too
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then -- maybe the trailer has also attached a trailer.. 
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.lastFillDelta ~= nil then -- "catch" attached trailer at the trailer here
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
		if self.hasAttachedTrailers == 0 then
			setVisibility(self.blinkerLeuchte1L, false);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, false);
			setVisibility(self.blinkerLeuchte2R, false);
		elseif self.hasAttachedTrailers == 1 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, false);
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, false);			
		elseif self.hasAttachedTrailers == 2 then
			setVisibility(self.blinkerLeuchte1L, true);
			setVisibility(self.blinkerLeuchte2L, true);	
			setVisibility(self.blinkerLeuchte1R, true);
			setVisibility(self.blinkerLeuchte2R, true);			
		end;
	end;
	
	if self.PitchArm ~= nil then
		-- set correct rotation on PitchArm
		local x, y, z = getRotation(self.PitchArmRefNode);
		setRotation(self.PitchArm, x * (-1.5), y, z);	
	end;
end;
function TractorAnimations:update(dt)
	if self:getIsActive() then
		if self.isMotorStarted then
			-- Ladekontrollleuchte / Batterie load light
			if self.ladeLeuchteOn == 1 then
				setVisibility(self.ladeLeuchte, true);
				if self.movingDirection ~= 0 then
					self.timerTrue = true;
				end;
				if self.timerTrue then
					self.ladeTimer = math.max(self.ladeTimer - 0.1, 0);
				end;
				if self.ladeTimer == 0 then
					setVisibility(self.ladeLeuchte, false);
					self.timerTrue = nil;
					self.ladeLeuchteOn = 0;
					self.ladeTimer = 50;
				end;
			end;
			
			-- Tankzeiger / fuel level display
			local actualTankInhalt = 0;
			if self.fuelCapacity > 0 then
				actualTankInhalt = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
			end;
			local rotValue = (self.tankZeigerMaxRot / self.fuelCapacity) * actualTankInhalt;
			setRotation(self.tankZeiger, 0, Utils.degToRad(rotValue), 0);
	
			-- Zapfwellenstummel / Powershaft rotation
			rotate(self.stummelIndex, 0,0,0.01*dt);
			
			-- Tachozeiger / speedometer animation
			self.kmhMath = math.min(50, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
			local zeigerRotation = self.kmhMath * self.tachoZeigerMultiplicator;
			if zeigerRotation <= self.tachoZeigerMaxRotation then
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(zeigerRotation), 0);
			else
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(self.tachoZeigerMaxRotation), 0);	
			end;
			
			-- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = self.tempCnt + 0.5;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.2, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
			end;
			if self.tempCnt2 < 3000 then
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = self.tempCnt2 + 0.8;
			elseif self.tempCnt2 > 3000 and self.tempCnt2 < 6000 then
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = math.min(self.tempCnt2 + 0.3, 10000);			
			else
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = math.min(self.tempCnt2 + 0.04, 10000);
			end;			
		end;
	else
		self.tempCnt = math.max(self.tempCnt - 0.08, 0);
		self.tempCnt2 = math.max(self.tempCnt2 - 0.1, 0);
	end;
end;
function TractorAnimations:draw()
end;

function TractorAnimations:onEnter()
	self.ladeLeuchteOn = 1;
end;
function TractorAnimations:onLeave()
	self.ladeLeuchteOn = 0;
end;

